/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.tftp.ui;

import java.io.File;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.soyatec.tftp.hitool.ITFTPServiceListenter;
import org.soyatec.tftp.hitool.TFTPService;
import org.soyatec.tftp.server.EventListener;
import org.soyatec.tftp.tftp4java.prefences.Messages;
import org.soyatec.tftp.tftp4java.prefences.TFTPPreferences;
import org.soyatec.tftp.utilitily.HiToolUtils;
import org.soyatec.tftp.utilitily.IPUtils;

public class TFTPView
extends ViewPart
implements EventListener,
ITFTPServiceListenter {
    public static final String ID = TFTPView.class.getName();
    private Combo pathCombo;
    private List console;
    private Button stopButton;
    private Button startButton;
    private Combo serverIpCombo;
    private Button reloadButton;
    private MenuItem removeItem;
    private String[] serverIps;
    static String TFTP_APP = "TFTP View";
    final Clipboard cb = new Clipboard(Display.getCurrent());

    public void createPartControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, true));
        this.createServerIpCom(control);
        this.createTopCom(control);
        this.createMiddleCom(control);
        this.createButtomCom(control);
    }

    public void dispose() {
        TFTPPreferences.setPRETFTPSERVERIP("");
        super.dispose();
    }

    private void createServerIpCom(Composite control) {
        Composite serverIpCom = new Composite(control, 0);
        serverIpCom.setLayout((Layout)new GridLayout(3, false));
        serverIpCom.setLayoutData((Object)new GridData(768));
        Label serverIpLabel = new Label(serverIpCom, 0);
        GridData browserData = new GridData();
        browserData.widthHint = 100;
        serverIpLabel.setLayoutData((Object)browserData);
        serverIpLabel.setText(Messages.TFTPView_ServerIP);
        this.serverIpCombo = new Combo(serverIpCom, 8);
        GridData serverIpData = new GridData();
        serverIpData.widthHint = 120;
        this.serverIpCombo.setLayoutData((Object)serverIpData);
        this.setServerIpComboItems();
        this.reloadButton = new Button(serverIpCom, 8);
        this.reloadButton.setText(Messages.TFTPView_Reload);
        this.reloadButton.setLayoutData((Object)serverIpData);
        this.reloadButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TFTPView.this.setServerIpComboItems();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void setServerIpComboItems() {
        this.serverIps = IPUtils.getServerIps();
        if (this.serverIps != null && this.serverIps.length > 0) {
            this.serverIpCombo.setItems(this.serverIps);
            this.serverIpCombo.select(0);
        } else {
            this.serverIpCombo.setItems(new String[0]);
        }
    }

    private void createButtomCom(Composite control) {
        Composite buttonCom = new Composite(control, 0);
        buttonCom.setLayout((Layout)new GridLayout(2, true));
        buttonCom.setLayoutData((Object)new GridData(768));
        this.startButton = new Button(buttonCom, 8);
        this.startButton.setText(Messages.TFTPView_Start_Button);
        GridData downloadData = new GridData(131072, 4, true, false, 1, 1);
        downloadData.minimumWidth = 100;
        this.startButton.setLayoutData((Object)downloadData);
        this.startButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TFTPView.this.handleStartTFTP();
            }
        });
        this.stopButton = new Button(buttonCom, 8);
        this.stopButton.setText(Messages.TFTPView_Stop_Button);
        this.stopButton.setEnabled(false);
        GridData stopData = new GridData(16384, 4, true, false, 1, 1);
        stopData.minimumWidth = 100;
        this.stopButton.setLayoutData((Object)stopData);
        this.stopButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TFTPView.this.handleStopTFTP();
            }
        });
    }

    protected void handleStopTFTP() {
        if (!TFTPService.TFTPSERVICE.isStart()) {
            this.console.add(Messages.TFTPView_Server_Not_Start);
            this.updateButtonEnables();
            return;
        }
        TFTPService.TFTPSERVICE.stop();
        if (!TFTPService.TFTPSERVICE.isStart()) {
            this.addMessage(Messages.TFTPView_Server_Stopped);
            TFTPPreferences.setPRETFTPSERVERIP("");
        }
        this.updateButtonEnables();
        TFTPService.TFTPSERVICE.stop();
    }

    private void updateButtonEnables() {
        boolean started = TFTPService.TFTPSERVICE.isStart();
        if (this.startButton == null) {
            return;
        }
        this.startButton.setEnabled(!started);
        this.stopButton.setEnabled(started);
    }

    protected void handleStartTFTP() {
        try {
            if (TFTPService.TFTPSERVICE.isStart()) {
                return;
            }
            try {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                File readFile = new File(this.pathCombo.getText());
                if (TFTPService.TFTPSERVICE.start(readFile, inetAddress, HiToolUtils.getPortCmd())) {
                    this.addMessage(Messages.TFTPView_Server_Success_Start);
                }
                int selectionIndex = this.serverIpCombo.getSelectionIndex();
                if (this.serverIps != null && selectionIndex > -1) {
                    TFTPPreferences.setPRETFTPSERVERIP(this.serverIps[this.serverIpCombo.getSelectionIndex()]);
                }
            }
            catch (SocketException e) {
                this.handleTftpStartFailed();
                e.printStackTrace();
            }
        }
        finally {
            this.updateButtonEnables();
        }
    }

    private void handleTftpStartFailed() {
        MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.Warning, (String)Messages.TFTPView_Server_Failed_Start);
        this.addMessage(Messages.TFTPView_Server_Failed_Start);
    }

    private void createMiddleCom(Composite control) {
        Section consoleSection = new Section(control, 4162);
        consoleSection.setLayoutData((Object)new GridData(1808));
        this.console = new List((Composite)consoleSection, 2564);
        this.console.add("\n");
        this.createContextMenu(this.console);
        consoleSection.setClient((Control)this.console);
    }

    private void createContextMenu(List list) {
        final Menu menu = new Menu((Decorations)list.getShell(), 8);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (TFTPView.this.console.getItemCount() == 1) {
                    menu.setVisible(false);
                    return;
                }
                TFTPView.this.removeItem.setEnabled(TFTPView.this.console.getSelectionIndex() > 0);
            }
        });
        list.setMenu(menu);
        this.removeItem = new MenuItem(menu, 8);
        this.removeItem.setText(Messages.TFTPView_Remove_Menu);
        this.removeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TFTPView.this.console.getSelectionIndex() < 1) {
                    return;
                }
                TFTPView.this.console.remove(TFTPView.this.console.getSelectionIndex());
                TFTPView.this.console.redraw();
            }
        });
        MenuItem removeAllItem = new MenuItem(menu, 8);
        removeAllItem.setText(Messages.TFTPView_RemoveAll_Menu);
        removeAllItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TFTPView.this.console.removeAll();
                TFTPView.this.console.add("\n");
                TFTPView.this.console.redraw();
            }
        });
    }

    private void createTopCom(Composite control) {
        Composite directoryCom = new Composite(control, 0);
        directoryCom.setLayout((Layout)new GridLayout(8, false));
        directoryCom.setLayoutData((Object)new GridData(768));
        Label directoryLable = new Label(directoryCom, 0);
        directoryLable.setText(Messages.TFTPView_Current_Directory_Label);
        directoryLable.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.pathCombo = new Combo(directoryCom, 2056);
        this.pathCombo.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        if (TFTPPreferences.getTFTPDirectory() != null) {
            File file = new File(TFTPPreferences.getTFTPDirectory());
            if (file.isDirectory() && file.exists()) {
                this.pathCombo.add(TFTPPreferences.getTFTPDirectory());
                this.setTFTPDirectory(TFTPPreferences.getTFTPDirectory());
                this.pathCombo.select(0);
            } else {
                String property = System.getProperty("user.dir");
                if (property == null) {
                    property = System.getProperty("user.home");
                }
                if (property != null) {
                    this.pathCombo.add(property);
                    this.setTFTPDirectory(property);
                    this.pathCombo.select(0);
                }
            }
        }
        this.pathCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String text = TFTPView.this.pathCombo.getText();
                if (text.trim().length() == 0) {
                    return;
                }
                TFTPView.this.setTFTPDirectory(text);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button browserButton = new Button(directoryCom, 8);
        browserButton.setText(Messages.TFTPView_Browser_Button);
        GridData browserData = new GridData();
        browserData.widthHint = 80;
        browserButton.setLayoutData((Object)browserData);
        browserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TFTPView.this.handleBroseFile();
            }
        });
        Button showFileButton = new Button(directoryCom, 8);
        showFileButton.setText(Messages.TFTPView_Show_All_Files_Button);
        GridData showFileData = new GridData();
        showFileData.widthHint = 80;
        showFileButton.setLayoutData((Object)showFileData);
        showFileButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Dialog dialog = new Dialog(Display.getDefault().getActiveShell()){
                    List fileList;

                    protected Control createDialogArea(Composite parent) {
                        File file;
                        Composite area = (Composite)super.createDialogArea(parent);
                        this.fileList = new List(area, 2816);
                        this.fileList.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                this.getButton(0).setEnabled(fileList.getSelectionCount() > 0);
                            }
                        });
                        if (TFTPView.this.pathCombo.getText() != null && (file = new File(TFTPView.this.pathCombo.getText())).exists()) {
                            File[] allFiles;
                            File[] fileArray = allFiles = file.listFiles();
                            int n = allFiles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File f = fileArray[n2];
                                if (!f.isDirectory()) {
                                    this.fileList.add(f.getName());
                                }
                                ++n2;
                            }
                        }
                        this.fileList.setLayoutData((Object)new GridData(1808));
                        return area;
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, Messages.TFTPView_Copy, false);
                        this.createButton(parent, 1, Messages.MessageDialog_Close, false);
                        this.getButton(0).setEnabled(false);
                    }

                    protected Point getInitialSize() {
                        return new Point(400, 340);
                    }

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0) {
                            String[] selection = this.fileList.getSelection();
                            if (selection.length == 0) {
                                return;
                            }
                            TextTransfer textTransfer = TextTransfer.getInstance();
                            (this).TFTPView.this.cb.setContents(new Object[]{selection[0]}, new Transfer[]{textTransfer});
                        }
                        super.buttonPressed(buttonId);
                    }
                };
                dialog.open();
            }
        });
    }

    protected void handleBroseFile() {
        String filePath;
        DirectoryDialog dialog = new DirectoryDialog(Display.getDefault().getActiveShell(), 4096);
        String tftpDirectory = TFTPPreferences.getTFTPDirectory();
        if (tftpDirectory != null && new File(tftpDirectory).isDirectory()) {
            dialog.setFilterPath(tftpDirectory);
        }
        if ((filePath = dialog.open()) == null) {
            return;
        }
        this.updateComboItems(filePath);
        this.setTFTPDirectory(filePath);
    }

    private void updateComboItems(String filePath) {
        String[] stringArray = this.pathCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(filePath)) {
                this.pathCombo.remove(filePath);
                break;
            }
            ++n2;
        }
        this.pathCombo.add(filePath, 0);
        if (this.pathCombo.getItemCount() > 6) {
            this.pathCombo.remove(6, this.pathCombo.getItemCount() - 1);
        }
        this.pathCombo.setText(filePath);
    }

    void setTFTPDirectory(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            this.addMessage(NLS.bind((String)Messages.TFTPView_Directory_Changed, (Object)filePath));
            return;
        }
        if (filePath != null && filePath.equalsIgnoreCase(TFTPPreferences.getTFTPDirectory())) {
            this.addMessage(NLS.bind((String)Messages.TFTPView_Failed_To_Change, (Object)filePath));
            return;
        }
        TFTPPreferences.setTFTPDirectory(filePath);
        TFTPService.TFTPSERVICE.setServerDirectory(new File(filePath));
        this.addMessage(NLS.bind((String)Messages.TFTPView_Directory_Changed, (Object)TFTPService.TFTPSERVICE.getServerDirectory()));
    }

    public void addMessage(String message) {
        if (message == null || this.console == null) {
            return;
        }
        this.console.add(message);
    }

    public void setFocus() {
    }

    @Override
    public void onAfterDownload(InetAddress addr, int port, String fileName, boolean ok) {
        final StringBuilder sb = new StringBuilder();
        if (ok) {
            sb.append(NLS.bind((String)Messages.TFTPView_Download_Success, (Object[])new String[]{fileName, addr.getHostAddress(), String.valueOf(port)}));
        } else {
            sb.append(NLS.bind((String)Messages.TFTPView_Download_Fail, (Object[])new String[]{fileName, addr.getHostAddress(), String.valueOf(port)}));
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TFTPView.this.addMessage(sb.toString());
            }
        });
    }

    @Override
    public void onAfterUpload(InetAddress addr, int port, String fileName, boolean ok) {
        final StringBuilder sb = new StringBuilder();
        if (ok) {
            sb.append(NLS.bind((String)Messages.TFTPView_Upload_Success, (Object[])new String[]{fileName, addr.getHostAddress(), String.valueOf(port)}));
        } else {
            sb.append(NLS.bind((String)Messages.TFTPView_Upload_Fail, (Object[])new String[]{fileName, addr.getHostAddress(), String.valueOf(port)}));
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TFTPView.this.addMessage(sb.toString());
            }
        });
    }

    @Override
    public void serviceStopped(String app) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TFTPView.this.updateButtonEnables();
            }
        });
    }
}

