/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.tftp.utilitily;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;

public class IPUtils {
    static final String KEY_INTERFACES = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces";
    static final String KEY_DHCP = "EnableDHCP";
    static final String KEY_IP = "IPAddress";
    static final String KEY_DHCP_IP = "DhcpIPAddress";
    static final String DOT = ".";
    static String MAC_START = "00";
    static String MAC_SEPARATOR = ":";

    private static List<String> loadFromWin32Registry() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            RegistryKey interfaces = Registry.HKEY_LOCAL_MACHINE.openSubKey(KEY_INTERFACES);
            Enumeration keyElements = interfaces.keyElements();
            while (keyElements.hasMoreElements()) {
                try {
                    RegistryValue ipaddr;
                    String ip;
                    String subKey = (String)keyElements.nextElement();
                    RegistryKey inter = interfaces.openSubKey(subKey);
                    RegistryValue hdcp = inter.getValue(KEY_DHCP);
                    boolean hdcpEnabled = false;
                    try {
                        int byteLength;
                        if (hdcp.getType() == 4 && (byteLength = hdcp.getByteLength()) > 0) {
                            hdcpEnabled = 1 == hdcp.getByteData()[byteLength - 1];
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    String keyIP = KEY_IP;
                    if (hdcpEnabled) {
                        keyIP = KEY_DHCP_IP;
                    }
                    if (IPUtils.isBlank(ip = new String((ipaddr = inter.getValue(keyIP)).getByteData(), System.getProperty("file.encoding")).trim()) || results.contains(ip)) continue;
                    results.add(ip);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getAllIPs() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> network = NetworkInterface.getNetworkInterfaces();
            if (network == null) {
                return null;
            }
            while (network.hasMoreElements()) {
                NetworkInterface net = network.nextElement();
                Enumeration<InetAddress> a = net.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    result.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        if ("win32".equals(Platform.getOS()) && "x86".equalsIgnoreCase(Platform.getOSArch())) {
            List<String> loadFrom = IPUtils.loadFromWin32Registry();
            for (String ip : loadFrom) {
                if (result.contains(ip) || !IPUtils.isValidIP(ip)) continue;
                result.add(ip);
            }
        }
        return result;
    }

    public static String[] getServerIps() {
        List<String> allIPs = IPUtils.getAllIPs();
        ArrayList<String> ipv4 = new ArrayList<String>();
        if (allIPs == null) {
            return null;
        }
        for (String ip : allIPs) {
            if (ip.indexOf(":") != -1 || ip.contains("127.0.0")) continue;
            ipv4.add(ip);
        }
        return ipv4.toArray(new String[ipv4.size()]);
    }

    public static boolean isOnTheSameNetIP(String ip1, String ip2, String subnetMask) {
        StringTokenizer tokenizer1 = new StringTokenizer(ip1, DOT);
        int countTokens = tokenizer1.countTokens();
        if (countTokens != 4) {
            return false;
        }
        StringTokenizer tokenizer2 = new StringTokenizer(ip2, DOT);
        countTokens = tokenizer2.countTokens();
        if (countTokens != 4) {
            return false;
        }
        StringTokenizer tokenizerSubnetMask = new StringTokenizer(subnetMask, DOT);
        countTokens = tokenizerSubnetMask.countTokens();
        if (countTokens != 4) {
            return false;
        }
        int index = 0;
        while (index < 4) {
            if (tokenizer1.hasMoreElements() && tokenizer2.hasMoreElements() && tokenizerSubnetMask.hasMoreElements()) {
                long tokenizer1L = Long.parseLong((String)tokenizer1.nextElement());
                long tokenizer2L = Long.parseLong((String)tokenizer2.nextElement());
                long tokenizerGatewayL = Long.parseLong((String)tokenizerSubnetMask.nextElement());
                if ((tokenizer1L & tokenizerGatewayL) != (tokenizer2L & tokenizerGatewayL)) {
                    return false;
                }
            } else {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static char generatorChar(Random random) {
        int ch = -1;
        while (ch == -1) {
            ch = random.nextInt(256);
            if (ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102) break;
            ch = -1;
        }
        return (char)ch;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidMac(String mac) {
        if (mac == null || mac.length() == 0) {
            return false;
        }
        sb = new StringTokenizer(mac, ":");
        if (sb.countTokens() == 6) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            nextToken = sb.nextToken();
            if (nextToken.length() != 2) {
                return false;
            }
            try {
                Integer.parseInt(nextToken, 16);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
lbl15:
            // 2 sources

            ** while (sb.hasMoreElements())
        }
lbl16:
        // 1 sources

        return true;
    }

    public static String generatorMAC() {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(MAC_START);
        int i = 0;
        while (i < 5) {
            sb.append(MAC_SEPARATOR);
            sb.append(IPUtils.generatorChar(random));
            sb.append(IPUtils.generatorChar(random));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isValidIP(String ip) {
        boolean black = IPUtils.isBlank(ip);
        if (black) {
            return false;
        }
        StringTokenizer tokenizer1 = new StringTokenizer(ip, DOT);
        int countTokens = tokenizer1.countTokens();
        if (countTokens != 4) {
            return false;
        }
        if (ip.charAt(ip.length() - 1) == '.') {
            return false;
        }
        int index = 0;
        while (index < countTokens) {
            if (tokenizer1.hasMoreElements()) {
                Object nextElement = tokenizer1.nextElement();
                if (!(nextElement instanceof String)) {
                    return false;
                }
                try {
                    int parseInt = Integer.parseInt((String)nextElement);
                    if (parseInt < 0 || parseInt > 255) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public static boolean isBlank(String ip) {
        if (ip == null || ip.trim().length() == 0) {
            return true;
        }
        return "0.0.0.0".equals(ip);
    }
}

