/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.ui.config.serial;

import org.soyatec.connector.api.serial.ISerialSettings;
import org.soyatec.connector.api.serial.SerialProperties;

public class SerialSettings
implements ISerialSettings {
    private final SerialProperties fProperties = new SerialProperties();
    protected String fSerialPort = this.fProperties.getDefaultSerialPort();
    protected String fBaudRate = this.fProperties.getDefaultBaudRate();
    protected String fDataBits = this.fProperties.getDefaultDataBits();
    protected String fStopBits = this.fProperties.getDefaultStopBits();
    protected String fParity = this.fProperties.getDefaultParity();
    protected String fFlowControl = this.fProperties.getDefaultFlowControl();
    protected String fTimeout = this.fProperties.getDefaultTimeout();

    public void update(ISerialSettings serialSetting) {
        this.fSerialPort = serialSetting.getSerialPort();
        this.fBaudRate = String.valueOf(serialSetting.getBaudRate());
        this.fDataBits = this.getDataBits(serialSetting.getDataBits());
        this.fStopBits = this.getStopBits(serialSetting.getStopBits());
        this.fParity = this.getParity(serialSetting.getParity());
        this.fFlowControl = this.getFlowControl(serialSetting.getFlowControl());
        this.fTimeout = String.valueOf(serialSetting.getTimeout());
    }

    public void update(SerialSettings serialSetting) {
        this.fSerialPort = serialSetting.getSerialPort();
        this.fBaudRate = serialSetting.getBaudRateString();
        this.fDataBits = serialSetting.getDataBitsString();
        this.fStopBits = serialSetting.getStopBitsString();
        this.fParity = serialSetting.getParityString();
        this.fFlowControl = serialSetting.getFlowControlString();
        this.fTimeout = serialSetting.getTimeoutString();
    }

    public String getSerialPort() {
        return this.fSerialPort;
    }

    public void setSerialPort(String strSerialPort) {
        this.fSerialPort = strSerialPort;
    }

    public String getBaudRateString() {
        return this.fBaudRate;
    }

    public int getBaudRate() {
        int nBaudRate;
        try {
            nBaudRate = Integer.parseInt(this.fBaudRate);
        }
        catch (NumberFormatException numberFormatException) {
            nBaudRate = 9600;
        }
        return nBaudRate;
    }

    public void setBaudRate(String strBaudRate) {
        this.fBaudRate = strBaudRate;
    }

    public String getDataBitsString() {
        return this.fDataBits;
    }

    public int getDataBits() {
        if (this.fDataBits.equals("5")) {
            return 5;
        }
        if (this.fDataBits.equals("6")) {
            return 6;
        }
        if (this.fDataBits.equals("7")) {
            return 7;
        }
        return 8;
    }

    public String getDataBits(int dataBits) {
        if (dataBits == 5) {
            return "5";
        }
        if (dataBits == 6) {
            return "6";
        }
        if (dataBits == 7) {
            return "7";
        }
        return "8";
    }

    public void setDataBits(String strDataBits) {
        this.fDataBits = strDataBits;
    }

    public String getStopBitsString() {
        return this.fStopBits;
    }

    public int getStopBits() {
        if (this.fStopBits.equals("1_5")) {
            return 3;
        }
        if (this.fStopBits.equals("2")) {
            return 2;
        }
        return 1;
    }

    public String getStopBits(int stopBits) {
        if (stopBits == 3) {
            return "1_5";
        }
        if (stopBits == 2) {
            return "2";
        }
        return "1";
    }

    public void setStopBits(String strStopBits) {
        this.fStopBits = strStopBits;
    }

    public String getParityString() {
        return this.fParity;
    }

    public int getParity() {
        if (this.fParity.equals("Even")) {
            return 2;
        }
        if (this.fParity.equals("Odd")) {
            return 1;
        }
        if (this.fParity.equals("Mark")) {
            return 3;
        }
        if (this.fParity.equals("Space")) {
            return 4;
        }
        return 0;
    }

    public String getParity(int parity) {
        if (2 == parity) {
            return "Even";
        }
        if (1 == parity) {
            return "Odd";
        }
        if (3 == parity) {
            return "Mark";
        }
        if (4 == parity) {
            return "Space";
        }
        return "None";
    }

    public void setParity(String strParity) {
        this.fParity = strParity;
    }

    public String getFlowControlString() {
        return this.fFlowControl;
    }

    public int getFlowControl() {
        if (this.fFlowControl.equals("RTS/CTS")) {
            return 1;
        }
        if (this.fFlowControl.equals("Xon/Xoff")) {
            return 4;
        }
        return 0;
    }

    private String getFlowControl(int flowControl) {
        if (1 == flowControl) {
            return "RTS/CTS";
        }
        if (4 == flowControl) {
            return "Xon/Xoff";
        }
        return "None";
    }

    public void setFlowControl(String strFlow) {
        this.fFlowControl = strFlow;
    }

    public String getSummary() {
        return String.valueOf(this.getSerialPort()) + ", " + this.getBaudRateString() + ", " + this.getDataBitsString() + ", " + this.getStopBitsString() + ", " + this.getParityString() + ", " + this.getFlowControlString() + "," + this.getTimeoutString();
    }

    public SerialProperties getProperties() {
        return this.fProperties;
    }

    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }
}

