/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.soyatec.preferences.Activator;
import org.soyatec.preferences.HiToolPreferences;
import org.soyatec.tftp.tftp4java.prefences.TFTPPreferences;

public class HiToolPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String HITOOL_PREF_DIALOG_ON_TOP = "dialog_on_top";
    private Button dialogOnTopBtn;
    private DeviceManager instance;
    private Button defaultChipBtn;
    private Text tftpTimeoutText;
    private Text KOText;

    public HiToolPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.instance = (DeviceManager)DeviceManager.getInstance();
    }

    protected Control createContents(Composite parent) {
        Group globalSettings = new Group(parent, 0);
        globalSettings.setText(Messages.HiToolPreferencePage_0);
        globalSettings.setLayout((Layout)new GridLayout(2, false));
        globalSettings.setLayoutData((Object)new GridData(768));
        this.dialogOnTopBtn = new Button((Composite)globalSettings, 32);
        this.dialogOnTopBtn.setText(Messages.AbstractUIActivator_3);
        this.dialogOnTopBtn.setSelection(Activator.getDefault().getPreferenceStore().getBoolean(HITOOL_PREF_DIALOG_ON_TOP));
        this.defaultChipBtn = new Button((Composite)globalSettings, 32);
        this.defaultChipBtn.setText(Messages.AbstractUIActivator_2);
        this.defaultChipBtn.setSelection(this.instance.needPopupDevice());
        Group netSettings = new Group(parent, 0);
        netSettings.setText(Messages.HiToolPreferencePage_1);
        netSettings.setLayout((Layout)new GridLayout(2, false));
        netSettings.setLayoutData((Object)new GridData(768));
        new Label((Composite)netSettings, 0).setText(String.valueOf(org.soyatec.tftp.tftp4java.prefences.Messages.Preferences_Timeout) + " (s)");
        this.tftpTimeoutText = new Text((Composite)netSettings, 2048);
        this.tftpTimeoutText.setText("" + TFTPPreferences.getTimeout());
        this.tftpTimeoutText.setLayoutData((Object)new GridData(768));
        this.tftpTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HiToolPreferencePage.this.validate();
            }
        });
        Group KOSettings = new Group(parent, 0);
        KOSettings.setText(org.soyatec.preferences.Messages.PreferencePage_InstallKOCommand);
        KOSettings.setLayout((Layout)new GridLayout(2, false));
        KOSettings.setLayoutData((Object)new GridData(768));
        new Label((Composite)KOSettings, 0).setText(org.soyatec.preferences.Messages.PreferencePage_InstallKOCommand);
        this.KOText = new Text((Composite)KOSettings, 2048);
        this.KOText.setText(HiToolPreferences.getPreferenceKOCommand());
        this.KOText.setLayoutData((Object)new GridData(768));
        return parent;
    }

    protected void validate() {
        String timeout = this.tftpTimeoutText.getText();
        String timeoutWarning = JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{1, 60});
        try {
            int iTimeout = Integer.parseInt(timeout);
            if (iTimeout < 1 || iTimeout > 60) {
                this.setErrorMessage(timeoutWarning);
                this.setValid(false);
                this.updateApplyButton();
                return;
            }
        }
        catch (NumberFormatException e) {
            this.setErrorMessage(timeoutWarning);
            this.setValid(false);
            this.updateApplyButton();
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        this.updateApplyButton();
    }

    public boolean performOk() {
        try {
            Activator.getDefault().getPreferenceStore().setValue(HITOOL_PREF_DIALOG_ON_TOP, this.dialogOnTopBtn.getSelection());
            this.instance.updateDevicePopup(this.defaultChipBtn.getSelection());
            TFTPPreferences.setTimeout((int)Integer.parseInt(this.tftpTimeoutText.getText()));
            HiToolPreferences.setKOCommand((String)this.KOText.getText());
        }
        catch (NumberFormatException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return super.performOk();
    }
}

