/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.log.HiLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.ui.WorkbenchEncoding;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HiLogUtils {
    public static List<HiLog> queryLogs(Map<String, Object> conditionMap) {
        ArrayList<HiLog> list = new ArrayList<HiLog>();
        try {
            String logsStr = HiLogUtils.getLogsStr();
            if (logsStr == null || logsStr.length() == 0) {
                return list;
            }
            String expression = HiLogUtils.constructQueryExpression(conditionMap);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = null;
            XPathExpression expr = null;
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new InputSource(new StringReader(logsStr)));
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xpath = xFactory.newXPath();
            expr = xpath.compile(expression);
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            if (nodes != null && nodes.getLength() > 0) {
                int i = 0;
                while (i < nodes.getLength()) {
                    HiLog hiLog = new HiLog();
                    Node item = nodes.item(i);
                    NamedNodeMap attributesNode = item.getAttributes();
                    if (attributesNode != null && attributesNode.getLength() > 0) {
                        int j = 0;
                        while (j < attributesNode.getLength()) {
                            Node attributeItem = attributesNode.item(j);
                            String nodeName = attributeItem.getNodeName();
                            String nodeValue = attributeItem.getNodeValue();
                            if (nodeName.equals("tool-symbolicName")) {
                                hiLog.setToolSymbolicName(nodeValue);
                            } else if (nodeName.equals("tool-name")) {
                                hiLog.setToolName(nodeValue);
                            } else if (nodeName.equals("level")) {
                                hiLog.setLevel(nodeValue);
                            } else if (nodeName.equals("millis") && nodeValue.length() > 0) {
                                hiLog.setMillis(Long.parseLong(nodeValue));
                            }
                            ++j;
                        }
                    }
                    NodeList childNodes = item.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Node childItem = childNodes.item(j);
                        String nodeName = childItem.getNodeName();
                        String textContent = childItem.getTextContent();
                        if (nodeName.equals("date")) {
                            hiLog.setDate(textContent);
                        } else if (nodeName.equals("message")) {
                            hiLog.setMessage(textContent);
                        } else if (nodeName.equals("exception")) {
                            hiLog.setException(textContent);
                        }
                        ++j;
                    }
                    list.add(hiLog);
                    ++i;
                }
            }
        }
        catch (DOMException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        catch (XPathExpressionException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public static String constructQueryExpression(Map<String, Object> conditionMap) {
        if (conditionMap == null || conditionMap.size() == 0) {
            return null;
        }
        List toolNames = (List)conditionMap.get("tool.name");
        if (toolNames != null && toolNames.size() > 0) {
            StringBuffer expressions = new StringBuffer();
            int i = 0;
            while (i < toolNames.size()) {
                if (i > 0) {
                    expressions.append("|");
                }
                String recordProp = "//record";
                expressions.append(HiLogUtils.appendQueryExpression(conditionMap, recordProp));
                expressions.append("[@");
                expressions.append("tool-name");
                expressions.append("='");
                expressions.append((String)toolNames.get(i));
                expressions.append("']");
                ++i;
            }
            return expressions.toString();
        }
        String expression = "//record";
        return HiLogUtils.appendQueryExpression(conditionMap, expression);
    }

    private static String appendQueryExpression(Map<String, Object> conditionMap, String expression) {
        String level = (String)conditionMap.get("log.level");
        if (level != null) {
            expression = String.valueOf(expression) + "[@" + "level" + "='" + level + "']";
        }
        if (conditionMap.get("starttime") != null) {
            String startTime = String.valueOf(conditionMap.get("starttime"));
            expression = String.valueOf(expression) + "[@" + "millis" + ">=" + startTime + "]";
        }
        if (conditionMap.get("endtime") != null) {
            String endTime = String.valueOf(conditionMap.get("endtime"));
            expression = String.valueOf(expression) + "[@" + "millis" + "<=" + endTime + "]";
        }
        return expression;
    }

    public static String getLogsStr() {
        StringBuffer logString = new StringBuffer();
        List<File> logFiles = HiLogUtils.findAllLogFiles();
        if (logFiles != null && logFiles.size() > 0) {
            String head = HiLogUtils.calculateHead();
            String tail = "</log>";
            logString.append(head);
            int i = 0;
            while (i < logFiles.size()) {
                File logFile = logFiles.get(i);
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                        String line = br.readLine();
                        while (line != null) {
                            logString.append(line);
                            line = br.readLine();
                        }
                    }
                    catch (IOException e) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        return null;
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            logString.append(tail);
        }
        return logString.toString();
    }

    public static File getLogDirectory() {
        Location location = LocationManager.getConfigurationLocation();
        File logDirectory = new File(location.getURL().getFile(), "logs");
        return logDirectory;
    }

    public static File findLogDelFile() {
        File logDirectory = HiLogUtils.getLogDirectory();
        return new File(logDirectory, "logs.del");
    }

    public static List<File> findAllLogFiles() {
        File logDirectory = HiLogUtils.getLogDirectory();
        File[] listFiles = logDirectory.listFiles(new LogFileFilter());
        if (listFiles == null) {
            return new ArrayList<File>();
        }
        List<File> files = Arrays.asList(listFiles);
        return files;
    }

    public static Calendar convertDate(DateTime dateTime, boolean isStartDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, dateTime.getYear());
        calendar.set(2, dateTime.getMonth());
        calendar.set(5, dateTime.getDay());
        if (isStartDate) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
        }
        return calendar;
    }

    public static String calculateHead() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        String encoding = Charset.defaultCharset().name();
        try {
            Charset cs = Charset.forName(encoding);
            encoding = cs.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(" encoding=\"");
        sb.append(encoding);
        sb.append("\"");
        sb.append(" standalone=\"yes\"?>\n");
        sb.append("<log>\n");
        return sb.toString();
    }

    public static void deleteLogs(ArrayList<HiLog> logs, File record) {
        block79: {
            if (record == null) {
                return;
            }
            if (logs != null && logs.size() > 0) {
                FileInputStream inputStream;
                Properties props;
                block78: {
                    Throwable throwable2;
                    block83: {
                        FileOutputStream outputStream;
                        block76: {
                            props = new Properties();
                            inputStream = null;
                            if (record.exists() || record.createNewFile()) break block76;
                            FileOutputStream outputStream2 = null;
                            try {
                                if (inputStream == null) {
                                    return;
                                }
                                inputStream.close();
                                try {
                                    int i = 0;
                                    while (i < logs.size()) {
                                        HiLog hiLog = logs.get(i);
                                        props.put(String.valueOf(hiLog.getToolSymbolicName()) + "@" + hiLog.getMillis(), HiLogUtils.constructLogPropValue(hiLog));
                                        ++i;
                                    }
                                    outputStream2 = new FileOutputStream(record);
                                    props.store(outputStream2, null);
                                }
                                catch (IOException e) {
                                    PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                }
                            }
                            finally {
                                if (outputStream2 != null) {
                                    try {
                                        outputStream2.close();
                                    }
                                    catch (IOException e) {
                                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                            return;
                        }
                        try {
                            try {
                                inputStream = new FileInputStream(record);
                                props.load(inputStream);
                                break block78;
                            }
                            catch (Exception e) {
                                PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                FileOutputStream outputStream3 = null;
                                try {
                                    if (inputStream == null) {
                                        return;
                                    }
                                    inputStream.close();
                                    try {
                                        int i = 0;
                                        while (i < logs.size()) {
                                            HiLog hiLog = logs.get(i);
                                            props.put(String.valueOf(hiLog.getToolSymbolicName()) + "@" + hiLog.getMillis(), HiLogUtils.constructLogPropValue(hiLog));
                                            ++i;
                                        }
                                        outputStream3 = new FileOutputStream(record);
                                        props.store(outputStream3, null);
                                    }
                                    catch (IOException e2) {
                                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e2.getMessage(), (Throwable)e2);
                                    }
                                    break block79;
                                }
                                finally {
                                    if (outputStream3 != null) {
                                        try {
                                            outputStream3.close();
                                        }
                                        catch (IOException e3) {
                                            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e3.getMessage(), (Throwable)e3);
                                        }
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            block80: {
                                block81: {
                                    outputStream = null;
                                    if (inputStream != null) {
                                        inputStream.close();
                                        break block80;
                                    }
                                    if (outputStream == null) break block81;
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException e) {
                                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                    }
                                }
                                return;
                            }
                            try {
                                try {
                                    int i = 0;
                                    while (i < logs.size()) {
                                        HiLog hiLog = logs.get(i);
                                        props.put(String.valueOf(hiLog.getToolSymbolicName()) + "@" + hiLog.getMillis(), HiLogUtils.constructLogPropValue(hiLog));
                                        ++i;
                                    }
                                    outputStream = new FileOutputStream(record);
                                    props.store(outputStream, null);
                                }
                                catch (IOException e) {
                                    PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                    if (outputStream != null) {
                                        try {
                                            outputStream.close();
                                        }
                                        catch (IOException e4) {
                                            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e4.getMessage(), (Throwable)e4);
                                        }
                                    }
                                    break block83;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (outputStream != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (IOException e) {
                                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                                    }
                                }
                                throw throwable3;
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    throw throwable2;
                }
                FileOutputStream outputStream = null;
                try {
                    if (inputStream == null) {
                        return;
                    }
                    inputStream.close();
                    try {
                        int i = 0;
                        while (i < logs.size()) {
                            HiLog hiLog = logs.get(i);
                            props.put(String.valueOf(hiLog.getToolSymbolicName()) + "@" + hiLog.getMillis(), HiLogUtils.constructLogPropValue(hiLog));
                            ++i;
                        }
                        outputStream = new FileOutputStream(record);
                        props.store(outputStream, null);
                    }
                    catch (IOException e) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private static String constructLogPropValue(HiLog hiLog) {
        return String.valueOf(hiLog.getToolSymbolicName()) + "@" + hiLog.getToolName() + "@" + hiLog.getLevel() + "@" + hiLog.getMillis();
    }

    private static Properties getDelLogs() {
        Properties props = new Properties();
        FileInputStream inputStream = null;
        try {
            File logDelFile = HiLogUtils.findLogDelFile();
            if (!logDelFile.exists()) {
                Properties properties = props;
                return properties;
            }
            try {
                inputStream = new FileInputStream(logDelFile);
                props.load(inputStream);
            }
            catch (Exception e) {
                PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
            }
        }
        return props;
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return !filename.endsWith(".lck") && !filename.endsWith(".del");
        }
    }

    public static class LogViewerFilter
    extends ViewerFilter {
        private Properties props;
        private Set<Object> symbolicNameAndMillis;

        public LogViewerFilter() {
            this.updateCurrentFilterLogs();
        }

        public void updateCurrentFilterLogs() {
            this.props = HiLogUtils.getDelLogs();
            this.symbolicNameAndMillis = this.props.keySet();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            HiLog log;
            return !(element instanceof HiLog) || !this.symbolicNameAndMillis.contains(String.valueOf((log = (HiLog)element).getToolSymbolicName()) + "@" + log.getMillis());
        }
    }
}

