/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.internal.PlatformStateControlUtils;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;

public class MenuUtils {
    public static void fillDeviceList(MenuManager newMenu, IDeviceManager m) {
        newMenu.add((IContributionItem)new GroupMarker("deviceGroup"));
        String current = m.getCurrentDevice();
        List devices = m.getAllDevices();
        for (String d : devices) {
            String[] split = d.split("@");
            if (split == null || split.length <= 1) continue;
            String name = split[1];
            MenuUtils.createDeviceMenu(newMenu, m, current, name, name);
        }
    }

    private static void createDeviceMenu(MenuManager newMenu, final IDeviceManager m, String current, String d, final String name) {
        final Action aDevice = new Action(d, 8){

            public void run() {
                if (this.isChecked()) {
                    m.setCurrentDevice(name);
                }
            }
        };
        if (name.equals(current)) {
            aDevice.setChecked(true);
        }
        aDevice.setId("com.soyatec.hisilicon.device." + d);
        newMenu.appendToGroup("deviceGroup", (IAction)aDevice);
        newMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                aDevice.setEnabled(PlatformStateControlUtils.isPlatformEnabled());
            }
        });
    }

    public static synchronized void refreshDeviceMenu() {
        MenuManager deviceMenu;
        IContributionItem switchDeviceItem;
        MenuManager menuManager;
        IContributionItem deviceItem;
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow && (deviceItem = (menuManager = ((WorkbenchWindow)window).getMenuManager()).find("device")) != null && deviceItem instanceof MenuManager && (switchDeviceItem = (deviceMenu = (MenuManager)deviceItem).find("switchDevice")) != null && switchDeviceItem instanceof MenuManager) {
            MenuManager switchDeviceMenu = (MenuManager)switchDeviceItem;
            switchDeviceMenu.removeAll();
            DeviceManager instance = (DeviceManager)DeviceManager.getInstance();
            MenuUtils.fillDeviceList(switchDeviceMenu, (IDeviceManager)instance);
        }
    }
}

