/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.tool;

import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Chips;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.internal.EncryptZipUtil;
import com.soyatec.hisilicon.platform.ui.internal.RegisterUtils;
import com.soyatec.hisilicon.platform.ui.internal.TestBuildUtils;
import com.soyatec.hisilicon.platform.ui.tool.InstallToolWizard;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InstallToolWizardPage
extends WizardPage {
    private static final String N_A = "N/A";
    private Text nameField;
    private Text versionField;
    private Text providerField;
    private Text releaseDateField;
    private Text privilegeTypeField;
    private Text registerCodeField;
    private Text installZipFile;
    private String[] tools;
    private String tempDecryptZipFile;
    private Group chipGroup;
    private org.eclipse.swt.widgets.List aList;

    protected InstallToolWizardPage(String pageName, String[] tools) {
        super(pageName);
        this.setTitle(Messages.InstallToolWizardPage_1);
        this.setDescription(Messages.InstallToolWizardPage_2);
        this.tools = tools;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createPageControls(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void dispose() {
        super.dispose();
    }

    public void clean() {
        EncryptZipUtil.cleanFolder(PlatformCoreActivator.getDefault().getStateLocation().append("temp").toFile());
    }

    private boolean validatePage() {
        return false;
    }

    public String getInstallZipFile() {
        if (this.tempDecryptZipFile != null) {
            return this.tempDecryptZipFile;
        }
        return this.installZipFile.getText();
    }

    public String getRegisterCode() {
        String text = this.registerCodeField.getText();
        return text.equals(N_A) ? "" : text;
    }

    private void createPageControls(Composite composite) {
        Composite comp = ControlFactory.createComposite(composite, 3);
        this.installZipFile = ControlFactory.createFileField(comp, Messages.InstallToolWizardPage_5, Messages.InstallToolWizardPage_6, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String zipFile = InstallToolWizardPage.this.installZipFile.getText();
                if (zipFile.length() == 0) {
                    return;
                }
                InstallToolWizardPage.this.checkInstallUnit(zipFile);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.installZipFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String zipFile = InstallToolWizardPage.this.installZipFile.getText();
                if (zipFile.length() == 0) {
                    return;
                }
                if (!new File(zipFile).exists()) {
                    InstallToolWizardPage.this.setErrorMessage(Messages.InstallToolWizardPage_7);
                    InstallToolWizardPage.this.clearInstallPackageInfo();
                    return;
                }
                InstallToolWizardPage.this.checkInstallUnit(zipFile);
            }
        });
        Group group = ControlFactory.createGroup(composite, Messages.InstallToolWizardPage_8, 4);
        this.nameField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_9, 2048, null);
        this.versionField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_10, 2048, null);
        this.providerField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_11, 2048, null);
        this.releaseDateField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_12, 2048, null);
        this.privilegeTypeField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_13, 2048, null);
        this.registerCodeField = ControlFactory.createLabeledText((Composite)group, Messages.InstallToolWizardPage_14, 2048, null);
        this.chipGroup = ControlFactory.createGroup(composite, Messages.InstallToolWizardPage_3, 2);
        Label label = new Label((Composite)this.chipGroup, 0);
        label.setText(Messages.InstallToolWizardPage_4);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.aList = new org.eclipse.swt.widgets.List((Composite)this.chipGroup, 2562);
        DeviceManager instance = (DeviceManager)DeviceManager.getInstance();
        Chips chips = instance.initChipsData();
        if (chips != null && chips.getChips().size() > 0) {
            ArrayList list = chips.getChips();
            int i = 0;
            while (i < list.size()) {
                Chip chip = (Chip)list.get(i);
                this.aList.add(chip.getId());
                ++i;
            }
        }
        gd = new GridData();
        gd.widthHint = 200;
        this.aList.setLayoutData((Object)gd);
        this.chipGroup.setVisible(false);
        ControlFactory.setEditable(false, this.nameField, this.versionField, this.providerField, this.releaseDateField, this.privilegeTypeField);
    }

    private void checkInstallUnit(String zipFile) {
        try {
            IInstallableUnit unit;
            IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
            this.tempDecryptZipFile = zipFile;
            if (EncryptZipUtil.isEncrypted(new File(zipFile))) {
                IPath path = PlatformCoreActivator.getDefault().getStateLocation().append("temp");
                File pathFile = new File(path.toOSString());
                if (!pathFile.exists() && !pathFile.mkdirs()) {
                    return;
                }
                this.tempDecryptZipFile = path.append(new File(zipFile).getName()).toOSString();
                File dZipFile = new File(this.tempDecryptZipFile);
                if (dZipFile.exists() && !dZipFile.delete()) {
                    return;
                }
                EncryptZipUtil.decryptZip(new File(zipFile), dZipFile);
            }
            if ((unit = m.findToolUnit(this.tempDecryptZipFile, (IProgressMonitor)new NullProgressMonitor())) == null) {
                this.setErrorMessage(Messages.InstallToolWizardPage_15);
                this.clearInstallPackageInfo();
            } else {
                ToolDescriptor toolDesc = new ToolDescriptor(unit);
                ToolDescriptor.ToolProperties props = toolDesc.props;
                this.nameField.setText(this.trim(props.getName()));
                this.versionField.setText(this.trim(props.getVersion()));
                this.providerField.setText(this.trim(props.getProvider()));
                this.releaseDateField.setText(this.trim(props.getReleaseDate()));
                if (TestBuildUtils.isTestBuild(toolDesc.getProperties())) {
                    this.privilegeTypeField.setText(Messages.InstallToolWizardPage_16_1);
                    ControlFactory.setEditable(false, this.registerCodeField);
                    this.registerCodeField.setText(this.trim(null));
                } else if (RegisterUtils.isUnlimited(props.getProperties())) {
                    this.privilegeTypeField.setText(Messages.InstallToolWizardPage_16);
                    ControlFactory.setEditable(false, this.registerCodeField);
                    this.registerCodeField.setText(this.trim(null));
                } else {
                    ControlFactory.setEditable(true, this.registerCodeField);
                    String limit = RegisterUtils.getUsageLimit(props.getProperties());
                    this.privilegeTypeField.setText(String.valueOf(Messages.InstallToolWizardPage_17) + limit);
                }
                InstallToolWizard w = (InstallToolWizard)this.getWizard();
                w.setToolDescriptor(toolDesc);
                List<String> toolList = Arrays.asList(this.tools);
                if (toolList.contains(toolDesc.getName())) {
                    this.setPageComplete(false);
                    this.setErrorMessage(Messages.InstallToolWizardPage_01);
                    return;
                }
                try {
                    if (TestBuildUtils.isTestBuild(toolDesc.getProperties())) {
                        this.chipGroup.setVisible(true);
                    } else {
                        this.chipGroup.setVisible(false);
                    }
                    this.setErrorMessage(null);
                }
                catch (IOException e) {
                    this.setErrorMessage(Messages.InstallToolWizardPage_18);
                    this.clearInstallPackageInfo();
                }
                catch (Exception e) {
                    this.setErrorMessage(Messages.InstallToolWizardPage_18);
                    this.clearInstallPackageInfo();
                }
            }
        }
        finally {
            this.updatePageComplete();
        }
    }

    private void clearInstallPackageInfo() {
        this.nameField.setText("");
        this.versionField.setText("");
        this.providerField.setText("");
        this.releaseDateField.setText("");
        this.privilegeTypeField.setText("");
        this.registerCodeField.setText("");
    }

    public String trim(String str) {
        return str == null ? N_A : str.trim();
    }

    public void updatePageComplete() {
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public String[] getSelectChips() {
        InstallToolWizard w = (InstallToolWizard)this.getWizard();
        ToolDescriptor toolDesc = w.getToolDescriptor();
        if (TestBuildUtils.isTestBuild(toolDesc.getProperties())) {
            return this.aList.getSelection();
        }
        return null;
    }
}

