/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.telnet.TelnetCodes;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnector;
import org.eclipse.tm.internal.terminal.telnet.TelnetMessages;
import org.eclipse.tm.internal.terminal.telnet.TelnetOption;

public class TelnetConnection
extends Thread
implements TelnetCodes {
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_IAC_RECEIVED = 1;
    protected static final int STATE_WILL_RECEIVED = 2;
    protected static final int STATE_WONT_RECEIVED = 3;
    protected static final int STATE_DO_RECEIVED = 4;
    protected static final int STATE_DONT_RECEIVED = 5;
    protected static final int STATE_SUBNEGOTIATION_STARTED = 6;
    protected static final int STATE_RECEIVING_SUBNEGOTIATION = 7;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] rawBytes = new byte[2048];
    protected byte[] processedBytes = new byte[2048];
    protected StringBuffer processedStringBuffer = new StringBuffer(2048);
    protected int telnetState = 0;
    protected boolean remoteIsTelnetServer = false;
    protected TelnetOption[] localOptions = new TelnetOption[256];
    protected TelnetOption[] remoteOptions = new TelnetOption[256];
    protected byte[] receivedSubnegotiation = new byte[128];
    protected int nextSubnegotiationByteIndex = 0;
    protected boolean ignoreSubnegotiation = false;
    protected int width = 0;
    protected int height = 0;
    protected TelnetConnector terminalControl;
    protected Socket socket;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected boolean localEcho = true;

    public TelnetConnection(TelnetConnector terminalControl, Socket socket) throws IOException {
        Logger.log((String)"entered");
        this.terminalControl = terminalControl;
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.initializeOptions();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public boolean isRemoteTelnetServer() {
        return this.remoteIsTelnetServer;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        Logger.log((String)("Setting new size: width = " + newWidth + ", height = " + newHeight));
        if (!this.isConnected() || !this.isRemoteTelnetServer()) {
            return;
        }
        boolean sizeChanged = false;
        if (newWidth != this.width || newHeight != this.height) {
            sizeChanged = true;
        }
        this.width = newWidth;
        this.height = newHeight;
        if (sizeChanged && this.remoteIsTelnetServer && this.localOptions[31].isEnabled()) {
            Object[] sizeData = new Integer[]{new Integer(this.width), new Integer(this.height)};
            this.localOptions[31].sendSubnegotiation(sizeData);
        }
    }

    public boolean localEcho() {
        return this.localEcho;
    }

    private void displayTextInTerminal(String string) {
        this.terminalControl.displayTextInTerminal(string);
    }

    public void run() {
        Logger.log((String)"Entered");
        try {
            try {
                while (this.socket.isConnected()) {
                    int nRawBytes = this.inputStream.read(this.rawBytes);
                    if (nRawBytes == -1) {
                        Logger.log((String)"End of input reading from socket!");
                        this.displayTextInTerminal(TelnetMessages.CONNECTION_CLOSED_BY_FOREIGN_HOST);
                        this.terminalControl.setState(TerminalState.CLOSED);
                        break;
                    }
                    int nProcessedBytes = this.processTelnetProtocol(nRawBytes);
                    if (nProcessedBytes <= 0) continue;
                    this.terminalControl.getRemoteToTerminalOutputStream().write(this.processedBytes, 0, nProcessedBytes);
                }
            }
            catch (SocketException ex) {
                String message = ex.getMessage();
                if (message != null && !message.equalsIgnoreCase("Socket closed") && !message.equalsIgnoreCase("Connection reset")) {
                    Logger.logException((Exception)ex);
                }
                this.terminalControl.setState(TerminalState.CLOSED);
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception ex) {
                Logger.logException((Exception)ex);
                this.terminalControl.setState(TerminalState.CLOSED);
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.terminalControl.setState(TerminalState.CLOSED);
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void initializeOptions() {
        int i = 0;
        while (i < this.localOptions.length) {
            this.localOptions[i] = new TelnetOption((byte)i, false, true, this.outputStream);
            ++i;
        }
        i = 0;
        while (i < this.localOptions.length) {
            this.remoteOptions[i] = new TelnetOption((byte)i, false, false, this.outputStream);
            ++i;
        }
        this.localOptions[1].setDesired(false);
        this.remoteOptions[1].setDesired(true);
        this.localOptions[3].setDesired(true);
        this.remoteOptions[3].setDesired(true);
        this.localOptions[24].setDesired(true);
        this.remoteOptions[24].setDesired(true);
        this.localOptions[31].setDesired(true);
        this.remoteOptions[31].setDesired(true);
    }

    protected int processTelnetProtocol(int count) {
        int nextProcessedByte = 0;
        int byteIndex = 0;
        while (byteIndex < count) {
            byte inputByte = this.rawBytes[byteIndex];
            block0 : switch (this.telnetState) {
                case 0: {
                    if (inputByte == -1) {
                        this.telnetState = 1;
                        break;
                    }
                    this.processedBytes[nextProcessedByte++] = this.rawBytes[byteIndex];
                    break;
                }
                case 1: {
                    switch (inputByte) {
                        case -1: {
                            this.processedBytes[nextProcessedByte++] = -1;
                            this.telnetState = 0;
                            break block0;
                        }
                        case -5: {
                            this.telnetState = 2;
                            break block0;
                        }
                        case -4: {
                            this.telnetState = 3;
                            break block0;
                        }
                        case -3: {
                            this.telnetState = 4;
                            break block0;
                        }
                        case -2: {
                            this.telnetState = 5;
                            break block0;
                        }
                        case -6: {
                            this.telnetState = 6;
                            break block0;
                        }
                        case -15: 
                        case -14: 
                        case -12: 
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -7: {
                            this.telnetState = 0;
                            break block0;
                        }
                    }
                    Logger.log((String)("processTelnetProtocol: UNRECOGNIZED TELNET PROTOCOL COMMAND: " + inputByte));
                    this.telnetState = 0;
                    break;
                }
                case 2: {
                    Logger.log((String)("Received WILL " + this.localOptions[inputByte].optionName() + "."));
                    this.remoteOptions[inputByte].handleWill();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 3: {
                    Logger.log((String)("Received WONT " + this.localOptions[inputByte].optionName() + "."));
                    this.remoteOptions[inputByte].handleWont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 4: {
                    Logger.log((String)("Received DO " + this.localOptions[inputByte].optionName() + "."));
                    this.localOptions[inputByte].handleDo();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 5: {
                    Logger.log((String)("Received DONT " + this.localOptions[inputByte].optionName() + "."));
                    this.localOptions[inputByte].handleDont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 6: {
                    Logger.log((String)("Starting subnegotiation for option " + this.localOptions[inputByte].optionName() + "."));
                    int i = 0;
                    while (i < this.receivedSubnegotiation.length) {
                        this.receivedSubnegotiation[i] = 0;
                        ++i;
                    }
                    this.ignoreSubnegotiation = false;
                    this.nextSubnegotiationByteIndex = 0;
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    this.telnetState = 7;
                    break;
                }
                case 7: {
                    if (inputByte == -1) {
                        if (this.nextSubnegotiationByteIndex > 0 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                            Logger.log((String)"Double IAC in subnegotiation translated into single IAC.");
                            break;
                        }
                        if (this.nextSubnegotiationByteIndex < this.receivedSubnegotiation.length) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                            break;
                        }
                        this.receivedSubnegotiation[this.receivedSubnegotiation.length - 1] = inputByte;
                        break;
                    }
                    if (inputByte == -16 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                        Logger.log((String)"Found SE code marking end of subnegotiation.");
                        if (!this.ignoreSubnegotiation) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] = 0;
                            byte subnegotiatedOption = this.receivedSubnegotiation[0];
                            this.localOptions[subnegotiatedOption].handleSubnegotiation(this.receivedSubnegotiation, this.nextSubnegotiationByteIndex);
                        } else {
                            Logger.log((String)"NOT CALLING handleSubnegotiation() BECAUSE OF ERRORS!");
                        }
                        this.telnetState = 0;
                    }
                    if (this.nextSubnegotiationByteIndex >= this.receivedSubnegotiation.length) {
                        Logger.log((String)"SUBNEGOTIATION BUFFER FULL!");
                        this.ignoreSubnegotiation = true;
                        break;
                    }
                    Logger.log((String)("Recording subnegotiation byte " + (inputByte & 0xFF)));
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    break;
                }
                default: {
                    Logger.log((String)("INVALID TELNET STATE: " + this.telnetState));
                    this.telnetState = 0;
                }
            }
            ++byteIndex;
        }
        return nextProcessedByte;
    }

    protected void telnetServerDetected() {
        if (!this.remoteIsTelnetServer) {
            this.localEcho = false;
            Logger.log((String)"Detected TELNET server.");
            this.remoteIsTelnetServer = true;
            int i = 0;
            while (i < this.localOptions.length) {
                if (this.localOptions[i].isDesired()) {
                    this.localOptions[i].negotiate();
                }
                ++i;
            }
            i = 0;
            while (i < this.remoteOptions.length) {
                if (this.remoteOptions[i].isDesired()) {
                    this.remoteOptions[i].negotiate();
                }
                ++i;
            }
        }
    }
}

