/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.serial;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TooManyListenersException;
import org.eclipse.ui.WorkbenchEncoding;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.IConnectionManager;
import org.soyatec.connector.api.serial.ISerialSettings;
import org.soyatec.connector.api.serial.SerialHelper;
import org.soyatec.connector.api.serial.exceptions.PortBusyException;
import org.soyatec.connector.api.serial.exceptions.PortNotFoundException;

public class SerialConnection
implements SerialPortEventListener,
IConnection<ISerialSettings> {
    private String name;
    private InputStream in = null;
    private OutputStream out = null;
    private ISerialSettings serialSettings = null;
    private SerialPort serialPort = null;
    private boolean autoReceive = false;
    private List<OutputStream> outs = new ArrayList<OutputStream>();
    private byte[] buffer = new byte[128];
    private final Object lock = new Object();

    private SerialConnection(SerialPort serialPort, ISerialSettings serialSettings) throws IOException, TooManyListenersException {
        this.init(serialPort, serialSettings);
        this.in = serialPort.getInputStream();
        this.out = serialPort.getOutputStream();
    }

    private void init(SerialPort serialPort, ISerialSettings serialSettings) throws TooManyListenersException {
        this.serialPort = serialPort;
        serialPort.addEventListener((SerialPortEventListener)this);
        serialPort.notifyOnDataAvailable(this.isAutoReceive());
        this.setSettings(serialSettings);
    }

    public boolean updateSettings(ISerialSettings settings) {
        if (!this.getSettings().getSerialPort().equals(settings.getSerialPort())) {
            return false;
        }
        try {
            SerialHelper.updateParameter(this.serialPort, settings);
        }
        catch (UnsupportedCommOperationException e) {
            return false;
        }
        return true;
    }

    public void send(String data) throws IOException {
        if (this.out != null) {
            this.out.write(data.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
        }
    }

    public void send(char data) throws IOException {
        if (this.out != null) {
            this.out.write(data);
        }
    }

    public void addOutputStream(OutputStream out) {
        if (!this.outs.contains(out)) {
            this.outs.add(out);
        }
    }

    public void removeOutputStream(OutputStream out) {
        if (this.outs.contains(out)) {
            this.outs.remove(out);
        }
    }

    public static void main(String[] args) throws IOException, PortNotFoundException, PortBusyException, UnsupportedCommOperationException {
        SerialConnection connector = SerialConnection.createConnection(new ISerialSettings(){

            @Override
            public int getTimeout() {
                return 2000;
            }

            @Override
            public int getStopBits() {
                return 1;
            }

            @Override
            public String getSerialPort() {
                return "COM1";
            }

            @Override
            public int getParity() {
                return 0;
            }

            @Override
            public int getFlowControl() {
                return 0;
            }

            @Override
            public int getDataBits() {
                return 8;
            }

            @Override
            public int getBaudRate() {
                return 115200;
            }

            @Override
            public String getSummary() {
                return null;
            }
        });
        if (connector != null) {
            connector.outs.add(System.out);
            connector.outs.add(new FileOutputStream("D://TestOUt.txt"));
            connector.setAutoReceive(true);
            connector.send("himd 0x81000000 0x1000\n");
        }
    }

    public static SerialConnection createConnection(ISerialSettings serialSettings) throws IOException, PortNotFoundException, PortBusyException, UnsupportedCommOperationException {
        SerialConnection connection = null;
        try {
            SerialPort serialPort = SerialHelper.createConnect(serialSettings);
            try {
                connection = new SerialConnection(serialPort, serialSettings);
            }
            catch (TooManyListenersException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchPortException e1) {
            throw new PortNotFoundException("'" + serialSettings.getSerialPort() + "'" + "\tnot found");
        }
        catch (PortInUseException e) {
            throw new PortBusyException(String.valueOf(serialSettings.getSerialPort()) + " is in use by the application '" + e.getMessage() + "', please stop it, then try again.");
        }
        catch (UnsupportedCommOperationException e) {
            throw new UnsupportedCommOperationException();
        }
        return connection;
    }

    public void close() {
        this.outs.clear();
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.out = null;
        }
        if (this.serialPort != null) {
            this.serialPort.close();
            this.serialPort = null;
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.onDataAvailable();
                break;
            }
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private void onDataAvailable() {
        try {
            while (this.in != null && this.in.available() > 0) {
                int read = this.in.read(this.buffer);
                this.dispatch(Arrays.copyOf(this.buffer, read));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dispatch(byte[] received) {
        Object[] array;
        Object[] objectArray = array = this.outs.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object op = objectArray[n2];
            try {
                if (op instanceof OutputStream) {
                    ((OutputStream)op).write(received);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public boolean isAutoReceive() {
        return this.autoReceive;
    }

    public void setAutoReceive(boolean autoReceive) {
        this.autoReceive = autoReceive;
        if (this.serialPort != null) {
            this.serialPort.notifyOnDataAvailable(autoReceive);
        }
    }

    public OutputStream getRemoteOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.in != null && this.out != null && this.serialPort != null;
        }
    }

    public String getName() {
        return this.name;
    }

    public ISerialSettings getSettings() {
        return this.serialSettings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSettings(ISerialSettings settings) {
        this.serialSettings = settings;
    }

    public InputStream getRemoteInputStream() {
        return this.in;
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
    }
}

