/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CrcCommand
extends SerialCommand {
    private static final String KEY_CRC32 = "crc32";
    private static final String KEY_FLAG = "==>";

    private CrcCommand(String command) {
        this.setCommand(command);
    }

    public static CrcCommand sendCRCCommand(File file, String address) {
        long fileSize = file.length();
        StringBuilder commandStr = new StringBuilder();
        commandStr.append(KEY_CRC32);
        commandStr.append(" ");
        commandStr.append(address);
        commandStr.append(" ");
        commandStr.append(Long.toHexString(fileSize));
        CrcCommand crcCommand = new CrcCommand(commandStr.toString());
        crcCommand.setTimeout(CrcCommand.calculateTimeout(file.length()));
        return crcCommand;
    }

    private static long calculateTimeout(long length) {
        int speed = FastbootPreferences.getInt("hisilicon.fastboot.tftp.speed");
        if (speed == 0) {
            speed = 1;
        }
        return (length / (long)speed + 2L) * 1000L;
    }

    public static int calculateCheckSum(File file) throws IOException {
        int checkSum = 0;
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                byte[] tempBytes = new byte[32];
                while (inputStream.read(tempBytes) != -1) {
                    int i2 = 0;
                    while (i2 < tempBytes.length) {
                        checkSum += tempBytes[i2] & 0xFF;
                        ++i2;
                    }
                }
            }
            catch (IOException e2) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return 0;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        return checkSum;
    }

    public static int calculateCRC16(File file) throws IOException {
        int crc16 = 65535;
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                byte[] tempBytes = new byte[32];
                while (inputStream.read(tempBytes) != -1) {
                    int[] dataList = new int[8];
                    byte[] bytes = null;
                    int k2 = 0;
                    while (k2 < dataList.length) {
                        bytes = new byte[4];
                        int i2 = 0;
                        while (i2 < 4) {
                            bytes[i2] = tempBytes[4 * k2 + 3 - i2];
                            ++i2;
                        }
                        dataList[k2] = be.a(bytes);
                        ++k2;
                    }
                    crc16 = be.a(crc16, 1, dataList);
                }
            }
            catch (IOException e2) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return 0;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        return crc16 & 0xFFFF;
    }

    public static long calculateCRC(File file) throws IOException {
        CRC32 crc32 = new CRC32();
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                int read = 0;
                while ((read = inputStream.read()) != -1) {
                    crc32.update(read);
                }
            }
            catch (IOException e2) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return 0L;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        return crc32.getValue();
    }

    public static long receiveCRC(String crcStr) {
        String substring = crcStr.substring(crcStr.indexOf(KEY_FLAG) + KEY_FLAG.length(), crcStr.indexOf("\r\n")).trim();
        long crcValue = Long.parseLong(substring, 16);
        return crcValue;
    }

    public static boolean compareFileCRC(long fileCrc, long receiveCrcValue) {
        return fileCrc == receiveCrcValue;
    }
}

