/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.model.FlashType;

public class EraseCommand
extends SerialCommand {
    private static final String KEY_ERASE = "erase";
    private static final String KEY_EMMC_ERASE = "mmc erase";

    public EraseCommand(String command) {
        this.setCommand(command);
    }

    public static EraseCommand erase(FlashType flashType, String address, String length) {
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.spi) {
            sb.append("sf");
        } else {
            sb.append(flashType.name());
        }
        sb.append(" ").append(KEY_ERASE).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        EraseCommand eraseCommand = new EraseCommand(sb.toString());
        eraseCommand.setTimeout(EraseCommand.calTimeout(length, flashType));
        return eraseCommand;
    }

    public static EraseCommand eraseEmmc(String startAddress, String length, String timeout) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_EMMC_ERASE);
        sb.append(" ").append(0);
        sb.append(" ").append(startAddress).append(" ");
        sb.append(length);
        EraseCommand eraseCommand = new EraseCommand(sb.toString());
        eraseCommand.setTimeout(EraseCommand.calTimeout(timeout, FlashType.emmc));
        return eraseCommand;
    }

    public static long calTimeout(String length, FlashType flashType) {
        long timeout = 30000L;
        long unit = 3000L;
        if (flashType == FlashType.spi) {
            unit = 30000L;
        } else if (flashType == FlashType.nand) {
            unit = 15000L;
        } else if (flashType == FlashType.emmc) {
            unit = 15000L;
        }
        if (length == null || length.length() == 0) {
            return timeout;
        }
        long parseLong = EraseCommand.getLength(length);
        timeout = unit * (parseLong / 0x100000L + 1L);
        return timeout;
    }
}

