/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.jna.II2cDllByJNA;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FT_STATUS;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.views.FastbootView;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class I2cCommand {
    private static int baudRate;
    private static int deviceAddress;
    private static boolean connected;
    private static final int DEFAULT_CHANNEL_ID = 0;
    private static final int I2C_BUFFER_LEN = 7;
    private static final int HI_MW_DB_CMD_TYPE_DB = 3;
    public static final int I2C_RUN_CMD_LEN = 127;
    public static final int I2C_RUN_BUFFER_LEN = 124;
    public static final int I2C_RUN_MAX_INDEX = 256;
    public static final int UPGRADE_FAIL = -1;
    public static final int UPGRADE_RUN = 0;
    public static final int UPGRADE_FINISH = 1;
    public static final int BOOTROM_ADDRESS = 52;
    private static final int BOOTROM_DELAY = 15;
    private static final int BOOTROM_DELAY_S3 = 3;
    private static final int I2C_SLOW = 0;
    private static final int I2C_QUICK = 1;
    public static final int GET_CUR_RECEIVED_LEN = 1024;
    public static final int WAIT_BOOT_RUN_RECE_LEN = 256;
    public static final String Hi3251V100_DEFAULT_BAUDRATE = "400k";

    static {
        connected = false;
    }

    public static boolean I2cOpenChannel() {
        System.setProperty("jna.encoding", "GBK");
        String baudRateStr = FastbootPreferences.getBaudRate();
        baudRate = bj.a(baudRateStr);
        deviceAddress = FastbootPreferences.getDeviceAddress();
        int mode = 0;
        String chipName = bi.b();
        if (chipName == null) {
            mode = 0;
        } else if (chipName.equalsIgnoreCase("Hi3251V500")) {
            baudRate = bj.a(Hi3251V100_DEFAULT_BAUDRATE);
            mode = 0;
        } else {
            mode = 1;
        }
        try {
            int openResult = II2cDllByJNA.instance.I2C_OpenChannel(0, baudRate, mode);
            if (bj.a(openResult)) {
                connected = true;
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            connected = false;
            e2.printStackTrace();
            return false;
        }
        catch (Error e3) {
            connected = false;
            e3.printStackTrace();
            return false;
        }
    }

    public static boolean I2cOpenChannelForBootrom(int address, IFastbootProgressMonitor fastbootMonitor) {
        System.setProperty("jna.encoding", "GBK");
        String baudRateStr = FastbootPreferences.getBaudRate();
        baudRate = bj.a(baudRateStr);
        deviceAddress = address;
        int mode = 0;
        String chipName = bi.b();
        if (chipName == null) {
            mode = 0;
        } else if (chipName.equalsIgnoreCase("Hi3251V500")) {
            baudRate = bj.a(Hi3251V100_DEFAULT_BAUDRATE);
            mode = 0;
        } else {
            mode = 1;
        }
        try {
            int openResult = II2cDllByJNA.instance.I2C_OpenChannel(0, baudRate, mode);
            if (bj.a(openResult, fastbootMonitor)) {
                connected = true;
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            connected = false;
            e2.printStackTrace();
            return false;
        }
        catch (Error e3) {
            connected = false;
            e3.printStackTrace();
            return false;
        }
    }

    public static boolean sendI2cCmd(int sizetowrite, byte[] inputbuffer, int sizetoread, byte[] outputbuffer) throws IOException {
        int setCmdResult = -1;
        int sendCount = 1;
        int i2cDelay = FastbootPreferences.getI2cDelay();
        int i2cRetryCount = FastbootPreferences.getI2cRetryCount();
        try {
            while (setCmdResult != 0) {
                try {
                    Thread.sleep(i2cDelay);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                setCmdResult = II2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, sizetowrite, inputbuffer, sizetoread, outputbuffer);
                System.out.println("setCmdResult: " + setCmdResult + "sendCount: " + sendCount);
                if (++sendCount <= i2cRetryCount) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)c.Message_FT_I2C);
                }
            });
            return false;
        }
        catch (Error e4) {
            connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)c.Message_FT_I2C);
                }
            });
            e4.printStackTrace();
            return false;
        }
        return bj.a(setCmdResult);
    }

    public static boolean sendI2cCmdForBootrom(int sizetowrite, byte[] inputbuffer, int sizetoread, byte[] outputbuffer, int i2cRetryCount, AbstractBurnerWorker worker) throws IOException {
        int setCmdResult = -1;
        int sendCount = 0;
        d sendI2cTime = null;
        if (worker != null && worker.isDebug()) {
            sendI2cTime = new d();
            if (inputbuffer != null) {
                sendI2cTime.a("Send I2C input data", inputbuffer.length);
            } else if (outputbuffer != null) {
                sendI2cTime.a("Receive I2C output data", outputbuffer.length);
            }
        }
        int sleepTime = 15;
        if (FastbootView.isHi3731Series()) {
            sleepTime = 3;
        }
        try {
            while (setCmdResult != 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                setCmdResult = II2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, sizetowrite, inputbuffer, sizetoread, outputbuffer);
                if (++sendCount <= i2cRetryCount) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return false;
        }
        catch (Error e4) {
            e4.printStackTrace();
            return false;
        }
        if (worker != null && worker.isDebug()) {
            sendI2cTime.a();
            worker.println("The retransmission times: " + sendCount);
            worker.println(sendI2cTime.a("Single I2C time statistics"));
        }
        return setCmdResult == FT_STATUS.FT_OK.ordinal();
    }

    public static void I2cCloseChannel() {
        if (connected) {
            try {
                II2cDllByJNA.instance.I2C_CloseChannel(0);
                connected = false;
            }
            catch (Exception e2) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)c.Message_FT_I2C);
                    }
                });
            }
            catch (Error e3) {
                connected = false;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)c.Message_FT_I2C);
                    }
                });
                e3.printStackTrace();
            }
        }
    }

    public static boolean sendUpgradeStart(int fileLen, boolean isCompress) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.HI_MW_DB_SET_UPGRADE_START.ordinal();
        buffer[2] = (byte)(fileLen & 0xFF);
        buffer[3] = (byte)(fileLen >> 8 & 0xFF);
        buffer[4] = (byte)(fileLen >> 16 & 0xFF);
        buffer[5] = (byte)(fileLen >> 24 & 0xFF);
        buffer[6] = (byte)I2cCommand.booleanToInt(isCompress);
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static boolean sendUpgradeRun(int index, byte[] runData) {
        byte[] buffer = new byte[127];
        buffer[1] = (byte)I2cCmd.HI_MW_DB_SET_UPGRADE_RUN.ordinal();
        buffer[2] = (byte)index;
        int i2 = 3;
        while (i2 < 127) {
            buffer[i2] = runData[i2 - 3];
            ++i2;
        }
        int checksum = I2cCommand.checksumForRun(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static boolean sendUpgradeFinish(int address, ChipID chipID) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.HI_MW_DB_SET_UPGRADE_FINISH.ordinal();
        buffer[2] = (byte)(address & 0xFF);
        buffer[3] = (byte)(address >> 8 & 0xFF);
        buffer[4] = (byte)(address >> 16 & 0xFF);
        buffer[5] = (byte)(address >> 24 & 0xFF);
        buffer[6] = (byte)chipID.ordinal();
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static int sendGetUpgradeStatus(int i2cDelay) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.HI_MW_DB_SET_UPGRADE_STATUS.ordinal();
        buffer[2] = 0;
        buffer[3] = 0;
        buffer[4] = 0;
        buffer[5] = 0;
        buffer[6] = 0;
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        II2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, buffer.length, buffer, 0, null);
        try {
            Thread.sleep(i2cDelay);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        byte[] readBuffer = new byte[1];
        II2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, 0, null, 1, readBuffer);
        return readBuffer[0];
    }

    private static int checksum(byte[] i2cWriteCmd) {
        return i2cWriteCmd[1] + i2cWriteCmd[2] + i2cWriteCmd[3] + i2cWriteCmd[4] + i2cWriteCmd[5] + i2cWriteCmd[6] & 0xF;
    }

    private static int checksumForRun(byte[] i2cWriteCmd) {
        int total = 0;
        int i2 = 0;
        while (i2 < i2cWriteCmd.length) {
            if (i2 != 0) {
                total += i2cWriteCmd[i2];
            }
            ++i2;
        }
        return total & 0xF;
    }

    public static int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public static int getBaudRate() {
        return baudRate;
    }

    public static int getDeviceAddress() {
        return deviceAddress;
    }

    public static enum I2cCmd {
        HI_MW_DB_SET_UPGRADE_START,
        HI_MW_DB_SET_UPGRADE_RUN,
        HI_MW_DB_SET_UPGRADE_FINISH,
        HI_MW_DB_SET_UPGRADE_STATUS;

    }
}

