/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;

public class MWCommand
extends SerialCommand {
    private static final String KEY_MW = "mw.b";
    protected static final String HEX_0xFF = "0xFF";
    protected static final String HEX_0x00 = "0x00";

    private MWCommand(String command, String length) {
        this.setCommand(command);
        this.init(length);
    }

    private void init(String length) {
        this.setTimeout(this.calculateTimeOut(length));
    }

    public static MWCommand mwAddress_0xFF(String startAddress, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_MW).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startAddress).append(" ").append(HEX_0xFF).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new MWCommand(sb.toString(), length);
    }

    public static MWCommand mwAddress_0x00(String startAddress, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_MW).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startAddress).append(" ").append(HEX_0x00).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new MWCommand(sb.toString(), length);
    }

    @Override
    public long calculateTimeOut(String length) {
        long parseLong = Long.parseLong(length, 16);
        return parseLong / 30L;
    }
}

