/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;

public class NetCommand
extends SerialCommand {
    private static final String KEY = "setenv";
    private static final String BLANK = " ";
    private static final String KEY_SERVER_IP = "serverip";
    private static final String KEY_CLIENT_IP = "ipaddr";
    private static final String KEY_CLIENT_MAC = "ethaddr";
    private static final String KEY_CLIENT_NETMASK = "netmask";
    private static final String KEY_CLIENT_GATEWAY = "gatewayip";
    private static final String KEY_CLIENT_ETHACT = "ethact";
    private static final String[] KEY_ETHACT = new String[]{"Auto", "ethact 0", "ethact 1", "ethact 2", "ethact 3"};

    private NetCommand(String key, String address) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY);
        sb.append(BLANK);
        sb.append(key);
        sb.append(BLANK);
        sb.append(address);
        this.setCommand(sb.toString());
        this.setTimeout(5000L);
    }

    public static NetCommand setServerIP(String serverIP) {
        return new NetCommand(KEY_SERVER_IP, serverIP);
    }

    public static NetCommand setEthact(String ethactID) {
        return new NetCommand(KEY_CLIENT_ETHACT, ethactID);
    }

    public static NetCommand setClientIP(String IP) {
        return new NetCommand(KEY_CLIENT_IP, IP);
    }

    public static NetCommand setClientMAC(String clientMac) {
        return new NetCommand(KEY_CLIENT_MAC, clientMac);
    }

    public static NetCommand setClientGateway(String cleintGateway) {
        return new NetCommand(KEY_CLIENT_GATEWAY, cleintGateway);
    }

    public static NetCommand setClientNetMask(String subnetMask) {
        return new NetCommand(KEY_CLIENT_NETMASK, subnetMask);
    }

    public static String[] getKeyEthact() {
        return (String[])KEY_ETHACT.clone();
    }
}

