/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import java.io.File;

public class TFTPCommand
extends SerialCommand {
    private static final String KEY_TFTP = "tftp";

    private TFTPCommand(String command) {
        this.setCommand(command);
    }

    public static TFTPCommand download(File file, String address) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_TFTP).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ").append(file.getName());
        TFTPCommand tftpCommand = new TFTPCommand(sb.toString());
        tftpCommand.setTimeout(TFTPCommand.calculateTimeout(file.length()));
        return tftpCommand;
    }

    private static long calculateTimeout(long length) {
        int speed = FastbootPreferences.getInt("hisilicon.fastboot.tftp.speed");
        if (speed == 0) {
            speed = 1;
        }
        return (length / (long)speed + 2L) * 1000L;
    }

    public static TFTPCommand upload(File file, String address, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_TFTP).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ").append(file.getName()).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        TFTPCommand tftpCommand = new TFTPCommand(sb.toString());
        tftpCommand.setTimeout(TFTPCommand.calculateTimeout(TFTPCommand.getLength(length)));
        return tftpCommand;
    }
}

