/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.consoles;

import com.hisilicon.fastboot.consoles.FastbootConsole;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.internal.console.ConsoleView;
import org.soyatec.console.ConsoleHelper;

public class FastbootConsoleFactory
implements IConsoleFactory {
    static String HIBURN = "HiBurn";
    static String HIBURN_DEBUG = "HiBurn-Debug";
    private static FastbootConsole fConsole = new FastbootConsole(HIBURN);
    private static FastbootConsole debugConsole = new FastbootConsole(HIBURN_DEBUG);
    private static boolean fConsoleResult = false;
    private static boolean debugConsoleResult = false;
    static IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();

    private FastbootConsoleFactory() {
        manager.addConsoleListener(new IConsoleListener(){

            public void consolesAdded(IConsole[] consoles) {
            }

            public void consolesRemoved(IConsole[] consoles) {
                int i2 = 0;
                while (i2 < consoles.length) {
                    if (consoles[i2] == fConsole) {
                        fConsole = null;
                    } else if (consoles[i2] == debugConsole) {
                        debugConsole = null;
                    }
                    ++i2;
                }
            }
        });
    }

    public static FastbootConsole getDebugConsole() {
        if (!debugConsoleResult) {
            ConsoleHelper.addConsole((IConsole)debugConsole);
            debugConsoleResult = true;
        }
        return debugConsole;
    }

    public static FastbootConsole getDefaultConsole() {
        if (!fConsoleResult) {
            ConsoleHelper.addConsole((IConsole)fConsole);
            fConsoleResult = true;
        }
        return fConsole;
    }

    public void openConsole() {
        if (fConsole == null) {
            fConsole = this.createAndShowConsole(HIBURN);
        } else {
            if (manager == null) {
                return;
            }
            manager.showConsoleView((IConsole)fConsole);
        }
    }

    private FastbootConsole createAndShowConsole(String name) {
        FastbootConsole console = new FastbootConsole(name);
        ConsoleHelper.addAndShowConsole((IConsole)console);
        return console;
    }

    public static void clearConsole() {
        ArrayList<FastbootConsole> toRemove = new ArrayList<FastbootConsole>();
        if (fConsole != null) {
            toRemove.add(fConsole);
        }
        if (debugConsole != null) {
            toRemove.add(debugConsole);
        }
        ConsoleHelper.removeConsoles(toRemove);
        fConsole = null;
        debugConsole = null;
    }

    public static void displayConsole() {
        if (fConsole == null) {
            FastbootConsoleFactory.getDefaultConsole();
        }
        List consoleViews = ConsoleHelper.getConsoleViews();
        for (ConsoleView consoleView : consoleViews) {
            IConsole console = consoleView.getConsole();
            if (console == fConsole || console == debugConsole || fConsole == null) continue;
            consoleView.display((IConsole)fConsole);
        }
    }
}

