/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model;

import com.hisilicon.fastboot.model.PCNetworkInfo;
import com.hisilicon.fastboot.model.define.IConfig;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BoardConfig
implements IConfig {
    public static final String DIVIDEE_SYMBOLS1 = ",";
    public static final String DIVIDEE_SYMBOLS2 = ";";
    public static final List<PCNetworkInfo> pcNetworkInfoList = bk.a();
    private String mac = null;
    private String ip = "192.168.1.2";
    private String subnetMask = "255.255.255.0";
    private String gateway = "192.168.1.1";

    public BoardConfig() {
        String serverIP = this.getServerIPForBoradIP();
        if (serverIP == null) {
            return;
        }
        String ip = FastbootPreferences.CONFIG.getClientIP();
        if (!bk.c(ip)) {
            this.ip = ip;
        } else if (serverIP.lastIndexOf(".") > 0) {
            String defaultIpAddress = "0.0.0.0";
            this.ip = defaultIpAddress = String.valueOf(serverIP.substring(0, serverIP.lastIndexOf("."))) + ".0";
            FastbootPreferences.CONFIG.setClientIP(defaultIpAddress);
        }
        String gateway = FastbootPreferences.CONFIG.getClientGateway();
        if (!bk.c(gateway)) {
            this.gateway = gateway;
        } else if (pcNetworkInfoList != null) {
            if (pcNetworkInfoList.size() > 0) {
                int i2 = 0;
                while (i2 < pcNetworkInfoList.size()) {
                    PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i2);
                    String localGateway = pcNetworkInfo.getGateway();
                    String localIp = pcNetworkInfo.getIp();
                    if (serverIP.equalsIgnoreCase(localIp) && localGateway.lastIndexOf(".") > 0) {
                        this.gateway = localGateway;
                        FastbootPreferences.CONFIG.setClientGateway(localGateway);
                    }
                    ++i2;
                }
            } else {
                FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
            }
        } else {
            FastbootPreferences.CONFIG.setClientGateway(this.gateway);
        }
        String subnetMask = FastbootPreferences.CONFIG.getClientNetmask();
        if (!bk.c(subnetMask)) {
            this.subnetMask = subnetMask;
        } else if (pcNetworkInfoList != null) {
            if (pcNetworkInfoList.size() > 0) {
                int i3 = 0;
                while (i3 < pcNetworkInfoList.size()) {
                    PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i3);
                    String localSubnetMask = pcNetworkInfo.getSubnetMask();
                    String localIp = pcNetworkInfo.getIp();
                    if (serverIP.equalsIgnoreCase(localIp) && localSubnetMask.lastIndexOf(".") > 0) {
                        this.subnetMask = localSubnetMask;
                        FastbootPreferences.CONFIG.setClientNetmask(localSubnetMask);
                    }
                    ++i3;
                }
            } else {
                FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
            }
        } else {
            FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
        }
        String mac = FastbootPreferences.CONFIG.getClientMac();
        this.mac = bk.a(mac) ? mac : bk.a();
    }

    private String getServerIPForBoradIP() {
        String serverIp;
        block7: {
            serverIp = null;
            String configServerIP = FastbootPreferences.CONFIG.getServerIP();
            String[] serverIps = bk.a();
            if (bk.b(configServerIP)) {
                if (Arrays.asList(serverIps).contains(configServerIP)) {
                    serverIp = configServerIP;
                } else if (serverIps.length > 0) {
                    serverIp = serverIps[0];
                }
            } else {
                try {
                    serverIp = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e2) {
                    if (serverIps.length <= 0) break block7;
                    serverIp = serverIps[0];
                }
            }
        }
        return serverIp;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getIp() {
        return this.ip;
    }

    public String getMac() {
        return this.mac;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    public static List<BoardConfig> load() {
        ArrayList<BoardConfig> boardConfigs = new ArrayList<BoardConfig>();
        String[] config = FastbootPreferences.CONFIG.getClientWholeConfig().split(DIVIDEE_SYMBOLS2);
        BoardConfig convert = null;
        String[] stringArray = config;
        int n2 = config.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            convert = BoardConfig.convert(string);
            if (convert != null) {
                boardConfigs.add(convert);
            }
            ++n3;
        }
        return boardConfigs;
    }

    public static String save(List<BoardConfig> boardConfigs) {
        StringBuilder sb = new StringBuilder();
        for (BoardConfig boardConfig : boardConfigs) {
            if (sb.length() > 0) {
                sb.append(DIVIDEE_SYMBOLS2);
            }
            sb.append(boardConfig.toString());
        }
        return sb.toString();
    }

    public static BoardConfig convert(String setting) {
        String[] value = setting.split(DIVIDEE_SYMBOLS1);
        if (value.length != 4) {
            return null;
        }
        BoardConfig boardConfig = new BoardConfig();
        boardConfig.setMac(value[0]);
        boardConfig.setIp(value[1]);
        boardConfig.setSubnetMask(value[2]);
        boardConfig.setGateway(value[3]);
        return boardConfig;
    }

    public String toString() {
        return String.valueOf(this.mac) + DIVIDEE_SYMBOLS1 + this.ip + DIVIDEE_SYMBOLS1 + this.subnetMask + DIVIDEE_SYMBOLS1 + this.gateway;
    }
}

