/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IDeviceSetting;
import com.hisilicon.fastboot.model.devices.IFileSystemSetting;
import com.hisilicon.fastboot.model.devices.burners.CommonBurner;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FileSystem {
    public static final FileSystem none = new FileSystem("none");
    public static final FileSystem yaffs = new FileSystem("yaffs");
    public static final FileSystem ext3 = new FileSystem("ext3/4");
    public static final FileSystem squashFs = new FileSystem("squashfs");
    public static final FileSystem ubiFs = new FileSystem("ubifs");
    private static FileSystem[] items = new FileSystem[]{none, yaffs, ext3, squashFs, ubiFs};
    private static final String YAFFSHEAD = "YFSS!V10";
    private String fileName;

    private FileSystem(String fileName) {
        this.fileName = fileName;
    }

    public String name() {
        return this.fileName;
    }

    public static String[] getItems() {
        return new String[]{none.name(), yaffs.name(), ext3.name(), squashFs.name()};
    }

    public static String[] getItems(IBurner burner) {
        if (burner instanceof CommonBurner) {
            return new String[]{none.name(), yaffs.name(), ubiFs.name(), ext3.name(), squashFs.name()};
        }
        if (burner instanceof EmmcBurner) {
            return new String[]{none.name(), ext3.name(), squashFs.name()};
        }
        if (burner instanceof PartitionBurner) {
            return new String[]{none.name(), yaffs.name(), ubiFs.name(), squashFs.name()};
        }
        return FileSystem.getItems();
    }

    public static boolean isYaffsFile(IBurner burner, File file) throws IOException {
        if (FileSystem.isYaffsFile(file)) {
            if (burner == null) {
                return false;
            }
            BurnContext burnContext = burner.getBurnContext();
            if (burnContext == null) {
                return false;
            }
            IDeviceSetting deviceSetting = burnContext.getDeviceSetting();
            if (deviceSetting == null) {
                return false;
            }
            IFileSystemSetting fileSystemSetting = deviceSetting.getFileSystemSetting();
            FileSystem[] fileSystems = fileSystemSetting.getFileSystems(burner);
            List<FileSystem> asList = Arrays.asList(fileSystems);
            if (asList.contains(yaffs)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isYaffsFile(File file) throws IOException {
        byte[] szYaffsMark = new byte[8];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            int read = inputStream.read(szYaffsMark);
            if (read != 8) {
                return false;
            }
            String fileHead = new String(szYaffsMark, System.getProperty("file.encoding"));
            boolean bl2 = fileHead.startsWith(YAFFSHEAD);
            return bl2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static FileSystem[] getFileSystems(Object type) {
        Class<?> class1 = type.getClass();
        return FileSystem.getFileSystems(class1);
    }

    public static FileSystem[] getFileSystems(Class<?> type) {
        if (type == CommonBurner.class) {
            return new FileSystem[]{none, yaffs, ubiFs, ext3, squashFs};
        }
        if (type == EmmcBurner.class) {
            return new FileSystem[]{none, ext3, squashFs};
        }
        if (type == PartitionBurner.class) {
            return new FileSystem[]{none, yaffs, ubiFs, squashFs};
        }
        return (FileSystem[])items.clone();
    }

    public static FileSystem valueOf(String name) {
        if (name == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (name.equalsIgnoreCase(items[i2].name())) {
                return items[i2];
            }
            ++i2;
        }
        if (name.equalsIgnoreCase("ext3") || name.equalsIgnoreCase("ext4") || name.equalsIgnoreCase("ext3/4")) {
            return ext3;
        }
        return null;
    }

    public static FileSystem[] values() {
        return (FileSystem[])items.clone();
    }
}

