/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model;

import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PartitionInfo;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.views.FastbootView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PartitionItem {
    public static final String PART = "Part";
    private static final String att_Sel = "Sel";
    private static final String att_PartitionName = "PartitionName";
    private static final String att_FlashType = "FlashType";
    private static final String att_FileSystem = "FileSystem";
    private static final String att_Start = "Start";
    private static final String att_Length = "Length";
    private static final String att_SelectFile = "SelectFile";
    private static final String BLANK = " ";
    private static final String VALUE_START = "=\"";
    private static final String VALUE_END = "\"";
    private static final String att_ChipID = "ChipID";
    private boolean checked;
    private String name;
    private FlashType flashType = FlashType.nand;
    private FileSystem fileSystem = FileSystem.none;
    private long start;
    private long length;
    private File file;
    private ChipID chipID;

    public File getFile() {
        return this.file;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public long getStart() {
        return this.start;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public ChipID getChipID() {
        return this.chipID;
    }

    public void setChipID(ChipID chipID) {
        this.chipID = chipID;
    }

    public static PartitionInfo load(File file, boolean xmlPathDefault) throws DocumentException {
        SAXReader reader;
        Document document;
        Element root;
        String programmerFileStr;
        PartitionInfo info = new PartitionInfo();
        List<PartitionItem> results = info.getChildren();
        if (!file.exists() || !file.isFile()) {
            return info;
        }
        File home = new File(file.getParent());
        File programmerFile = PartitionItem.getNewFile(home, xmlPathDefault, programmerFileStr = (root = (document = (reader = new SAXReader()).read(file)).getRootElement()).attributeValue("ProgrammerFile"));
        if (programmerFile != null) {
            info.setProgrammerFile(programmerFile);
        }
        Iterator parent = root.elementIterator();
        while (parent.hasNext()) {
            Element part = (Element)parent.next();
            PartitionItem partitionItem = PartitionItem.convert(part, home, xmlPathDefault);
            if (partitionItem == null) continue;
            results.add(partitionItem);
        }
        return info;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<Part").append(BLANK).append(att_Sel).append(VALUE_START).append(this.isChecked() ? "1" : "0").append(VALUE_END).append(BLANK).append(att_PartitionName).append(VALUE_START).append(this.getName() == null ? "" : this.getName()).append(VALUE_END).append(BLANK).append(att_FlashType).append(VALUE_START).append(this.getFlashType() == null ? "" : this.getFlashType().name()).append(VALUE_END).append(BLANK).append(att_FileSystem).append(VALUE_START).append(this.getFileSystem() == null ? "" : this.getFileSystem().name()).append(VALUE_END).append(BLANK).append(att_Start).append(VALUE_START).append(WorkerUtility.ReceiveHelper.convertUnit(this.getStart())).append(VALUE_END).append(BLANK).append(att_Length).append(VALUE_START).append(this.getLength() == -1L ? "-" : WorkerUtility.ReceiveHelper.convertUnit(this.getLength())).append(VALUE_END).append(BLANK).append(att_SelectFile).append(VALUE_START).append(this.getFile() == null ? "" : this.getFile().getAbsolutePath()).append(VALUE_END);
        if (FastbootView.isHi3231Series()) {
            sb.append(BLANK);
            sb.append(att_ChipID);
            sb.append(VALUE_START);
            sb.append(this.getChipID() == null ? "" : Integer.valueOf(this.getChipID().ordinal()));
            sb.append(VALUE_END);
        }
        sb.append("/>\n");
        return sb.toString();
    }

    public static PartitionItem convert(Element part, File home, boolean xmlPathDefault) {
        if (part == null || !part.getName().equalsIgnoreCase(PART)) {
            return null;
        }
        String sel = part.attributeValue(att_Sel);
        int parseInt = Integer.parseInt(sel);
        if (parseInt != 0 && parseInt != 1) {
            return null;
        }
        PartitionItem item = new PartitionItem();
        item.setChecked(parseInt == 1);
        String partitionName = part.attributeValue(att_PartitionName);
        item.setName(partitionName.toLowerCase());
        String strFlashType = part.attributeValue(att_FlashType);
        FlashType flashType = FlashType.valueOf(strFlashType.toLowerCase());
        item.setFlashType(flashType);
        String strFileSystem = part.attributeValue(att_FileSystem);
        FileSystem fileSystem = FileSystem.valueOf(strFileSystem.toLowerCase());
        item.setFileSystem(fileSystem);
        String strStart = part.attributeValue(att_Start);
        long convert = WorkerUtility.ReceiveHelper.convertToNumber(strStart);
        item.setStart(convert);
        String strLength = part.attributeValue(att_Length);
        if (!strLength.equals("-")) {
            long length = WorkerUtility.ReceiveHelper.convertToNumber(strLength);
            item.setLength(length);
        } else {
            item.setLength(-1L);
        }
        String strSelectFile = part.attributeValue(att_SelectFile);
        File newFile = PartitionItem.getNewFile(home, xmlPathDefault, strSelectFile);
        item.setFile(newFile);
        String strChipID = part.attributeValue(att_ChipID);
        if (strChipID != null && !strChipID.isEmpty()) {
            ChipID chipID = ChipID.valueOf("chip" + strChipID);
            item.setChipID(chipID);
        } else {
            item.setChipID(ChipID.chip0);
        }
        return item;
    }

    private static File getNewFile(File home, boolean xmlPathDefault, String strSelectFile) {
        if (strSelectFile == null) {
            return null;
        }
        int lastIndexOf = strSelectFile.lastIndexOf("\\");
        if (lastIndexOf == -1) {
            lastIndexOf = strSelectFile.lastIndexOf("/");
        }
        String newPath = null;
        File newFile = null;
        if (lastIndexOf != -1 || strSelectFile.trim().length() == 0) {
            if (strSelectFile.startsWith("./")) {
                newPath = strSelectFile = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile.substring("./".length());
                newFile = new File(newPath);
            } else {
                newPath = strSelectFile;
                if (xmlPathDefault) {
                    strSelectFile = strSelectFile.substring(lastIndexOf + 1);
                    newPath = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile;
                    newFile = new File(newPath);
                } else {
                    newFile = new File(strSelectFile);
                }
            }
        } else {
            newPath = String.valueOf(home.getAbsolutePath()) + "/" + strSelectFile;
            newFile = new File(newPath);
        }
        if (!(newFile == null || newFile.exists() && strSelectFile.length() != 0)) {
            newFile = null;
        }
        return newFile;
    }

    public boolean partitionItemEquals(PartitionItem arg) {
        if (arg == this) {
            return true;
        }
        if (this.checked != arg.isChecked()) {
            return false;
        }
        if (arg.getFlashType() != this.flashType) {
            return false;
        }
        if (arg.getFileSystem() != this.fileSystem) {
            return false;
        }
        if (arg.getStart() != this.getStart()) {
            return false;
        }
        if (arg.getLength() != this.getLength()) {
            return false;
        }
        File file1 = arg.getFile();
        if (file1 == null && this.file != null || file1 != null && this.file == null) {
            return false;
        }
        if (file1 == this.file) {
            return true;
        }
        return file1.getAbsolutePath().equalsIgnoreCase(this.file.getAbsolutePath());
    }

    public static String getFileContent(List<PartitionItem> children) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"GB2312\" ?>\n");
        sb.append("<Partition_Info>\n");
        for (PartitionItem item : children) {
            sb.append(item.toString());
        }
        sb.append("</Partition_Info>\n");
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void save(File tableFile, PartitionInfo partitionInfo) {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(tableFile);
                ((OutputStream)out).write("<?xml version=\"1.0\" encoding=\"GB2312\" ?>\n".getBytes("GB2312"));
                File programmerFile = partitionInfo.getProgrammerFile();
                String fileStr = programmerFile != null ? programmerFile.getPath() : "";
                String PartitionInfoStr = "<Partition_Info ProgrammerFile=\"" + fileStr + "\">\n";
                ((OutputStream)out).write(PartitionInfoStr.getBytes("GB2312"));
                for (PartitionItem item : partitionInfo.getChildren()) {
                    ((OutputStream)out).write(item.toString().getBytes("GB2312"));
                }
                ((OutputStream)out).write("</Partition_Info>\n".getBytes("GB2312"));
                return;
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                if (out == null) return;
                try {
                    ((OutputStream)out).close();
                    return;
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e6) {
                    e6.printStackTrace();
                }
            }
        }
    }
}

