/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.define;

import com.hisilicon.fastboot.Activator;
import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.define.ILog;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.event.IFastbootEventListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public interface IFastbootProgressMonitor
extends ILog {
    public static final IFastbootProgressMonitor NULL = new NullProgressMonitor();

    public void addListener(IFastbootEventListener var1);

    public void removeListener(IFastbootEventListener var1);

    public FastbootEvent getEvent();

    public void begin();

    public void finish();

    public void highlight(PartitionItem var1);

    public void updateLength(long var1);

    public void log(String var1);

    public static class NullProgressMonitor
    implements IFastbootProgressMonitor {
        public SimpleDateFormat dateFormat = new SimpleDateFormat();
        private FastbootEvent event = new FastbootEvent();
        private FileOutputStream LOG = null;
        private List<IFastbootEventListener> listeners = new ArrayList<IFastbootEventListener>();

        @Override
        public FastbootEvent getEvent() {
            return this.event;
        }

        @Override
        public void addListener(IFastbootEventListener l2) {
            if (l2 == null) {
                return;
            }
            if (!this.listeners.contains(l2)) {
                this.listeners.add(l2);
            }
        }

        @Override
        public void removeListener(IFastbootEventListener l2) {
            if (l2 == null) {
                return;
            }
            if (this.listeners.contains(l2)) {
                this.listeners.remove(l2);
            }
        }

        @Override
        public void print(String str) {
            if (str == null) {
                return;
            }
            FastbootConsoleFactory.getDebugConsole().getDefaultStream().print(str);
        }

        @Override
        public void println(String str) {
            if (str == null) {
                return;
            }
            FastbootConsoleFactory.getDebugConsole().getDefaultStream().print(str);
        }

        @Override
        public void error(String err) {
            if (err == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getReceivedStream().print(err);
        }

        @Override
        public void errorln(String err) {
            if (err == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getReceivedStream().println(err);
        }

        @Override
        public void warn(String warning) {
            if (warning == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getWarningStream().print(warning);
        }

        @Override
        public void warnln(String warning) {
            if (warning == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getWarningStream().println(warning);
        }

        @Override
        public void info(String info) {
            if (info == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getInfoStream().print(info);
        }

        @Override
        public void infoln(String info) {
            if (info == null) {
                return;
            }
            FastbootConsoleFactory.getDefaultConsole().getInfoStream().println(info);
        }

        @Override
        public void begin() {
            if (this.event != null) {
                Activator.a().a(this.event);
            }
            try {
                this.LOG = g.a();
                this.LOG.write((String.valueOf(this.dateFormat.format(new Date())) + "\n\r\n").getBytes(System.getProperty("file.encoding")));
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IFastbootEventListener l2 : NullProgressMonitor.this.listeners) {
                        l2.started(NullProgressMonitor.this.getEvent());
                    }
                }
            });
        }

        @Override
        public void finish() {
            try {
                Activator default1 = Activator.a();
                if (default1 == null) {
                    return;
                }
                default1.a((FastbootEvent)null);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l2 : NullProgressMonitor.this.listeners) {
                            l2.finished(NullProgressMonitor.this.getEvent());
                        }
                        NullProgressMonitor.this.getEvent().setType(null);
                    }
                });
            }
            finally {
                if (this.LOG != null) {
                    try {
                        this.LOG.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void highlight(PartitionItem part) {
            if (part == null) {
                return;
            }
            final ArrayList<PartitionItem> list = new ArrayList<PartitionItem>();
            list.add(part);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IFastbootEventListener l2 : NullProgressMonitor.this.listeners) {
                        l2.hightLight(list);
                    }
                }
            });
        }

        @Override
        public void updateLength(final long length) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IFastbootEventListener l2 : NullProgressMonitor.this.listeners) {
                        l2.updateLength(length);
                    }
                }
            });
        }

        @Override
        public void log(String log) {
            try {
                if (this.LOG != null && log != null && log.length() > 0) {
                    this.LOG.write(log.getBytes(System.getProperty("file.encoding")));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

