/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.UploadOption;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IAddressBurner;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.FastbootBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.AddressBurnerWorker;
import com.hisilicon.fastboot.ui.UploadOptionDialog;
import com.hisilicon.fastboot.ui.burners.tabs.AddressTab;
import com.hisilicon.fastboot.views.FastbootView;
import gnu.io.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.tftp.hitool.TFTPService;

public class AddressBurner
extends FastbootBurner
implements IAddressBurner {
    private UploadOption uploadOption = null;
    private String address;
    private String length;
    private ChipID chipId;
    private FileSystem fileSystem = FileSystem.none;
    protected AddressBurnerWorker worker = null;

    public AddressBurner(BurnContext burnContext) {
        super(burnContext);
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        File file;
        AddressBurnerWorker worker;
        block17: {
            boolean needOpenSerial;
            if (fastbootMonitor != null) {
                fastbootMonitor.getEvent().init(EventType.BURN);
            }
            FlashType flashType = this.getFlashType();
            LocalConfig localConfig = this.getBurnContext().getLocalConfig();
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            worker.setFlashType(flashType);
            file = new File(this.getFile());
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            boolean bl2 = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((q)this.getBurnContext().getDeviceSetting()).h();
            if (needOpenSerial) {
                SerialPort serialPort;
                if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort())) == null) {
                    return;
                }
            } else if (fastbootMonitor != null) {
                fastbootMonitor.begin();
            }
            if (worker.isNeedSetupNet(transferWay)) {
                File home = new File(file.getParent());
                boolean start = false;
                InetAddress address = null;
                try {
                    address = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException e2) {
                    e2.printStackTrace();
                }
                try {
                    try {
                        start = TFTPService.TFTPSERVICE.start(home, address, bi.c());
                        this.getTftpPreferenceValue();
                    }
                    catch (Exception e3) {
                        this.handleTftpStartFailed();
                        if (!start) {
                            fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (!start) {
                        fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    throw throwable;
                }
                if (!start) {
                    fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Burn By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean burn = worker.burn(monitor, file, AddressBurner.this.getFlashType(), AddressBurner.this.getFileSystem(), AddressBurner.this.getAddress(), AddressBurner.this.getCurrentChipId());
                            event.setSuccess(burn);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AddressBurner.this.shutDownTFTP(fastbootMonitor);
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    @Override
    protected AddressBurnerWorker getBurnerWorker() {
        if (this.worker == null) {
            this.worker = new AddressBurnerWorker(this);
        }
        return this.worker;
    }

    @Override
    public IStatus checkBeforeBurn() {
        return this.check(EventType.BURN);
    }

    protected IStatus check(EventType type) {
        if (this.getFlashType() == null) {
            return this.error(c.AddressBurner_msg_please_select_the_flash_type);
        }
        String file = this.getFile();
        if (file == null || file.trim().length() == 0) {
            return this.error(c.AbstractBurner_msg_file_path_does_not_select);
        }
        if (type != null && type.name().equalsIgnoreCase("BURN")) {
            File theFile = new File(file);
            if (!theFile.exists()) {
                return this.error(c.AbstractBurner_msg_the_file_does_not_exist);
            }
            if (file.length() == 0) {
                return this.error(c.AbstractBurner_msg_the_file_size_must_be_nonzero);
            }
        }
        if (EventType.BURN == type) {
            this.checkBurn();
        } else {
            if (EventType.UPLOAD == type) {
                return this.checkUpload();
            }
            if (EventType.ERASE == type) {
                this.checkErase();
            }
        }
        return null;
    }

    private IStatus checkErase() {
        boolean lenVaild;
        boolean addrVaild;
        IStatus validLocalConfig = this.validSerialPort();
        if (!this.isOK(validLocalConfig)) {
            return validLocalConfig;
        }
        boolean bl2 = addrVaild = this.getAddress() == null || this.getAddress().length() == 0;
        if (addrVaild) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_input_address, (Object)c.BurnComposite_Erase_Text));
        }
        boolean bl3 = lenVaild = this.getLength() == null || this.getLength().length() == 0 || Long.parseLong(this.getLength(), 16) < 1L;
        if (lenVaild) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_input_length, (Object)c.BurnComposite_Erase_Text));
        }
        if ((this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA) {
            return this.error(c.AddressBurner_No_Programmer_File);
        }
        return null;
    }

    private IStatus checkUpload() {
        boolean openConfirm;
        boolean isVaildProgrammerFile;
        boolean isVaildFile;
        boolean isVaildLen;
        boolean isVaildAddr;
        IStatus validNetConfig = this.validNetConfig();
        if (!this.isOK(validNetConfig)) {
            return validNetConfig;
        }
        boolean bl2 = isVaildAddr = this.getAddress() == null || this.getAddress().length() == 0;
        if (isVaildAddr) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_input_address, (Object)c.BurnComposite_Upload_Text));
        }
        boolean bl3 = isVaildLen = this.getLength() == null || this.getLength().length() == 0 || Long.parseLong(this.getLength(), 16) < 1L;
        if (isVaildLen) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_input_length, (Object)c.BurnComposite_Upload_Text));
        }
        boolean bl4 = isVaildFile = this.getFile() == null || this.getFile().equals("");
        if (isVaildFile) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_select_the_file_to_, (Object)c.BurnComposite_Upload_Text));
        }
        boolean bl5 = isVaildProgrammerFile = (this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA;
        if (isVaildProgrammerFile) {
            return this.error(c.AddressBurner_No_Programmer_File);
        }
        File file = new File(this.getFile());
        if (file.exists() && !(openConfirm = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_CONFIRM_Title, (String)NLS.bind((String)c.PartitionComposite_msg_file_exists_already_whether_to_overwrite_it, (Object)file.getAbsolutePath())))) {
            return Status.CANCEL_STATUS;
        }
        try {
            boolean tftpFileNameVaild;
            boolean bl6 = tftpFileNameVaild = this.getBurnContext().getTransferWay() == TransferWay.Net && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
            if (tftpFileNameVaild) {
                return this.error(c.msg_File_name_is_too_long_please_use_a_short_name_instead);
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private IStatus checkBurn() {
        boolean spiYaffs;
        boolean fileExists;
        boolean isVaildProgrammerFile;
        boolean isVaildFile;
        boolean isVaildAddr;
        IStatus validNetConfig = this.validNetConfig();
        if (!this.isOK(validNetConfig)) {
            return validNetConfig;
        }
        boolean bl2 = isVaildAddr = this.getAddress() == null || this.getAddress().length() == 0;
        if (isVaildAddr) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_input_address, (Object)c.BurnComposite_Burn_Text));
        }
        boolean bl3 = isVaildFile = this.getFile() == null || this.getFile().trim().equals("");
        if (isVaildFile) {
            return this.error(NLS.bind((String)c.AddressBurner_msg_please_select_the_file_to_, (Object)c.BurnComposite_Burn_Text));
        }
        boolean bl4 = isVaildProgrammerFile = (this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA;
        if (isVaildProgrammerFile) {
            return this.error(c.AddressBurner_No_Programmer_File);
        }
        File file = new File(this.getFile());
        boolean bl5 = fileExists = !file.exists() || file.isDirectory();
        if (fileExists) {
            return this.error(c.AddressBurner_msg_file_does_not_exist_or_is_a_directory);
        }
        boolean yaffsFile = true;
        try {
            yaffsFile = FileSystem.isYaffsFile(this, file);
        }
        catch (IOException e1) {
            return this.error(c.AddressBurner_msg_exception_occurs_while_reading_the_file_please_try_again);
        }
        FileSystem curFileSystem = yaffsFile ? FileSystem.yaffs : FileSystem.none;
        this.setFileSystem(curFileSystem);
        boolean bl6 = spiYaffs = FlashType.spi == this.getFlashType() && yaffsFile;
        if (spiYaffs) {
            return this.error(c.AddressBurner_msg_invalid_file_for_the_flash_is_SPI_but_the_file_is_a_Yaffs_type_file);
        }
        try {
            boolean tftpFileNameVaild;
            boolean bl7 = tftpFileNameVaild = (this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
            if (tftpFileNameVaild) {
                return this.error(c.msg_File_name_is_too_long_please_use_a_short_name_instead);
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    @Override
    public IStatus checkBeforeErase() {
        return this.check(EventType.ERASE);
    }

    @Override
    public IStatus checkBeforeUpload() {
        IStatus upload = this.check(EventType.UPLOAD);
        if (!this.isOK(upload)) {
            return upload;
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.error(NLS.bind((String)c.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"USB"));
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.I2CBootrom || this.getBurnContext().getTransferWay() == TransferWay.Usb2I2c) {
            return this.error(NLS.bind((String)c.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"I2C"));
        }
        FlashType flashType = this.getFlashType();
        if (FlashType.nand == flashType) {
            UploadOptionDialog optionDialog = new UploadOptionDialog(Display.getDefault().getActiveShell());
            optionDialog.setUploadOption(UploadOption.DATA_NO_OOB);
            int open = optionDialog.open();
            if (open == 0) {
                this.uploadOption = optionDialog.getUploadOption();
            } else {
                return new Status(8, "com.hisilicon.fastboot", "Upload Cancelled!");
            }
        }
        return null;
    }

    @Override
    public void erase(final IFastbootProgressMonitor fastbootMonitor) {
        FastbootEvent event;
        LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        final AddressBurnerWorker worker = this.getBurnerWorker();
        BurnContext context = this.getBurnContext();
        worker.setProgressMonitor(fastbootMonitor);
        worker.setFlashType(this.getFlashType());
        if (this.getBurnContext().getTransferWay() != TransferWay.Usb2I2c && this.getBurnContext().getTransferWay() != TransferWay.I2CBootrom && this.getBurnContext().getTransferWay() != TransferWay.USBBootrom && this.getBurnContext().getTransferWay() != TransferWay.USBNonNude && this.getBurnContext().getTransferWay() != TransferWay.JTAGAndNet && this.getBurnContext().getTransferWay() != TransferWay.JTAG && this.getBurnContext().getTransferWay() != TransferWay.JTAGAndSerial && !((q)this.getBurnContext().getDeviceSetting()).h()) {
            SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort());
            if (serialPort == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (context.getTransferWay() == TransferWay.I2CBootrom) {
            if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
            } else {
                return;
            }
        }
        if (fastbootMonitor != null && (event = fastbootMonitor.getEvent()) != null) {
            Job job = new Job("Erase By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean erase = worker.erase(monitor, AddressBurner.this.getAddress(), AddressBurner.this.getLength());
                            event.setSuccess(erase);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            event.setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    @Override
    public String getLength() {
        return this.length;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(c.AddressBurner_Step_1);
        steps.add(c.AddressBurner_Step_2);
        steps.add(c.AddressBurner_Step_3);
        steps.add(c.AddressBurner_Step_4);
        steps.add(c.AddressBurner_Step_5);
        steps.add(c.AddressBurner_Step_6);
        return steps;
    }

    @Override
    public void setLength(String length) {
        this.length = length;
    }

    @Override
    public void upload(final IFastbootProgressMonitor fastbootMonitor) {
        AddressBurnerWorker worker;
        File file;
        block17: {
            boolean needOpenSerial;
            String filePath = this.getFile();
            if (filePath == null) {
                return;
            }
            file = new File(filePath);
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            worker.setFlashType(this.getFlashType());
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            boolean bl2 = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial && !((q)this.getBurnContext().getDeviceSetting()).h();
            if (needOpenSerial) {
                SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, this.getBurnContext().getLocalConfig().getComPort());
                if (serialPort == null) {
                    return;
                }
            } else if (fastbootMonitor != null) {
                fastbootMonitor.begin();
            }
            File home = new File(file.getParent());
            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                fastbootMonitor.getEvent().setBurner(this);
            }
            boolean start = false;
            InetAddress address = null;
            try {
                address = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException e2) {
                e2.printStackTrace();
            }
            try {
                try {
                    start = TFTPService.TFTPSERVICE.start(home, address, bi.c());
                    this.getTftpPreferenceValue();
                    this.getBurnContext().setTftpOccupied(!start);
                }
                catch (Exception e3) {
                    this.getBurnContext().setTftpOccupied(true);
                    this.handleTftpStartFailed();
                    if (!start && fastbootMonitor != null) {
                        fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (!start && fastbootMonitor != null) {
                    fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
                throw throwable;
            }
            if (!start && fastbootMonitor != null) {
                fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Upload By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            FileSystem fileSystem = FileSystem.none;
                            if (AddressBurner.this.uploadOption == UploadOption.DATA_OOB) {
                                fileSystem = FileSystem.yaffs;
                            }
                            boolean upload = worker.upload(monitor, file, fileSystem, AddressBurner.this.getAddress(), AddressBurner.this.getLength(), true, AddressBurner.this.getCurrentChipId());
                            event.setSuccess(upload);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AddressBurner.this.shutDownTFTP(fastbootMonitor);
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    public ChipID getCurrentChipId() {
        ChipID id = null;
        id = FastbootView.isHi3231Series() ? this.chipId : ChipID.chip0;
        return id;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public ChipID getChipID() {
        return this.chipId;
    }

    @Override
    public void setFlashId(ChipID chipId) {
        this.chipId = chipId;
    }

    @Override
    public ITab getTab() {
        return new AddressTab();
    }

    @Override
    public void eraseAll(IFastbootProgressMonitor monitor) {
    }
}

