/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IDdrBurner;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.serial.workers.DdrBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.DdrTab;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class DdrBurner
extends PartitionBurner
implements IDdrBurner {
    public DdrBurner(BurnContext burnContext) {
        super(burnContext);
        this.getChildren().clear();
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor, final String directory) {
        final DdrBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        final FastbootEvent event = fastbootMonitor.getEvent();
        final BurnContext context = this.getBurnContext();
        Job job = new Job("Ddr Burn..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean result = worker.burn(monitor, directory);
                        event.setSuccess(result);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                boolean isUsb;
                fastbootMonitor.finish();
                TransferWay transferWay = context.getTransferWay();
                boolean bl2 = isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
                if (isUsb) {
                    CallLibUSBWorker.closeUsb();
                    worker.infoln("\nUSB channels were closed successfully.");
                }
            }
        });
        job.schedule();
    }

    @Override
    public DdrBurnerWorker getBurnerWorker() {
        return new DdrBurnerWorker(this);
    }

    @Override
    public ITab getTab() {
        return new DdrTab();
    }

    @Override
    protected IStatus checkTable(EventType event) {
        return null;
    }
}

