/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.define.IUploadable;
import com.hisilicon.fastboot.model.devices.IEmmcBurner;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.EmmcPartitionBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.EmmcTab;
import gnu.io.SerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.tftp.hitool.TFTPService;

public class EmmcBurner
extends PartitionBurner
implements IUploadable,
IEmmcBurner {
    protected static final String msg_the_partition_size_can_not_be_null_in_row_ = c.PartitionBurner_msg_the_partition_size_can_not_be_null_in_row_;
    private boolean createPartitionTable = true;
    protected final EmmcPartitionBurnerWorker worker = this.getBurnerWorker();

    public EmmcBurner(BurnContext burnContext) {
        super(burnContext);
        this.getChildren().clear();
        PartitionItem fastboot = new PartitionItem();
        fastboot.setName("fastboot");
        fastboot.setFileSystem(FileSystem.none);
        fastboot.setFlashType(FlashType.emmc);
        this.getChildren().add(fastboot);
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        EmmcPartitionBurnerWorker worker;
        block16: {
            boolean needOpenSerial;
            BurnContext context = this.getBurnContext();
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            boolean bl2 = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((q)this.getBurnContext().getDeviceSetting()).h();
            if (needOpenSerial) {
                SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort());
                if (serialPort == null) {
                    return;
                }
            } else if (fastbootMonitor != null) {
                fastbootMonitor.begin();
            }
            if (worker.isNeedSetupNet(this.getBurnContext().getTransferWay())) {
                boolean start = false;
                InetAddress address = null;
                try {
                    address = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException e2) {
                    e2.printStackTrace();
                }
                try {
                    try {
                        start = TFTPService.TFTPSERVICE.start(this.getParentFile(), address, bi.c());
                        this.getTftpPreferenceValue();
                        context.setTftpOccupied(!start);
                    }
                    catch (IOException e3) {
                        context.setTftpOccupied(true);
                        this.handleTftpStartFailed();
                        if (!start) {
                            fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (!start) {
                        fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    throw throwable;
                }
                if (!start) {
                    fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job fastbootJob = new Job("Burn By Partition"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean partBurn = worker.burn(monitor, EmmcBurner.this.children);
                            event.setSuccess(partBurn);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(fastbootJob);
            fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            TFTPService.TFTPSERVICE.stop();
                        }
                    }).start();
                    EmmcBurner.this.closeByTrans();
                }
            });
            fastbootJob.schedule();
        }
    }

    private File getParentFile() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        for (PartitionItem partition : this.children) {
            if (!partition.isChecked() || partition.getFile() == null) continue;
            return partition.getFile().getParentFile();
        }
        return null;
    }

    @Override
    public void erase(final IFastbootProgressMonitor fastbootMonitor) {
        if (fastbootMonitor != null) {
            fastbootMonitor.getEvent().init(EventType.ERASE);
        }
        BurnContext context = this.getBurnContext();
        final EmmcPartitionBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        if (this.getBurnContext().getTransferWay() != TransferWay.Usb2I2c && this.getBurnContext().getTransferWay() != TransferWay.I2CBootrom && this.getBurnContext().getTransferWay() != TransferWay.USBBootrom && this.getBurnContext().getTransferWay() != TransferWay.USBNonNude && !((q)this.getBurnContext().getDeviceSetting()).h()) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        Job fastbootJob = new Job("Erase all devices"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean erase = worker.erase(monitor, EmmcBurner.this.getChildren());
                        fastbootMonitor.getEvent().setSuccess(erase);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                EmmcBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(c.EmmcBurner_Step_1);
        steps.add(c.EmmcBurner_Step_2);
        steps.add(c.EmmcBurner_Step_3);
        steps.add(c.EmmcBurner_Step_4);
        steps.add(c.EmmcBurner_Step_5);
        steps.add(c.EmmcBurner_Step_6);
        return steps;
    }

    @Override
    protected IStatus checkOtherPart(List<PartitionItem> parts, EventType event) {
        FlashType[] flashTypes = FlashType.getFlashTypes(this);
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        boolean createTable = this.isCreatePartitionTable();
        long lastAddress = 0L;
        int size = parts.size();
        IStatus result = Status.OK_STATUS;
        int partIndex = 0;
        while (partIndex < size) {
            PartitionItem part = parts.get(partIndex);
            if (part.isChecked() || event == EventType.BURN && !createTable) {
                result = this.checkFlashAndFileSystem(flashTypes, fileSystems, partIndex, part);
                if (result != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkStartAddressAndLen(part, size, partIndex);
                if (result != Status.OK_STATUS) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    return result;
                }
                long start = part.getStart();
                if (0L == part.getLength()) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(partIndex + 1)));
                }
                if (start < lastAddress) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    return this.error(NLS.bind((String)c.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(partIndex + 1)));
                }
                lastAddress = start + (part.getLength() == -1L ? 0L : part.getLength());
                if (part.isChecked()) {
                    boolean vaildLen;
                    File file = part.getFile();
                    int alignLen = 512;
                    if (part.getFlashType() == FlashType.ufs) {
                        alignLen = 4096;
                    }
                    if (start % (long)alignLen != 0L) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(partIndex + 1)));
                    }
                    boolean bl2 = vaildLen = part.getLength() != -1L && part.getLength() % (long)alignLen != 0L;
                    if (vaildLen) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(partIndex + 1)));
                    }
                    if (EventType.BURN == event) {
                        result = this.checkBurn(size, partIndex, part, file);
                    } else if (EventType.UPLOAD == event) {
                        result = this.checkUpload(size, partIndex, part, file);
                    }
                    if (result != Status.OK_STATUS) {
                        return result;
                    }
                    try {
                        boolean checkTftpFileNameVaild;
                        boolean bl3 = checkTftpFileNameVaild = file != null && (this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
                        if (checkTftpFileNameVaild) {
                            return this.error(NLS.bind((String)c.msg_File_name_is_too_long_please_use_a_short_name_instead, (Object)(partIndex + 1)));
                        }
                    }
                    catch (UnsupportedEncodingException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            ++partIndex;
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkUpload(int size, int partIndex, PartitionItem part, File file) {
        boolean openConfirm;
        boolean checkLastPartLen;
        if (file == null) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)(partIndex + 1)));
        }
        boolean bl2 = checkLastPartLen = size - 1 != partIndex && part.getLength() == -1L;
        if (checkLastPartLen) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)msg_the_partition_size_can_not_be_null_in_row_, (Object)(partIndex + 1)));
        }
        if (file.exists() && !(openConfirm = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_CONFIRM_Title, (String)NLS.bind((String)c.PartitionComposite_msg_file_exists_already_whether_to_overwrite_it, (Object)file.getAbsolutePath())))) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(c.AbstractBurner_msg_file_exists_please_check_file);
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkBurn(int size, int partIndex, PartitionItem part, File file) {
        boolean checkLastLen;
        boolean bl2 = checkLastLen = part.getLength() == -1L && size - 1 != partIndex;
        if (checkLastLen) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)msg_the_partition_size_can_not_be_null_in_row_, (Object)(partIndex + 1)));
        }
        if (file != null) {
            boolean vaildLen;
            if (!file.exists()) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(partIndex + 1)));
            }
            if (file.isDirectory()) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(partIndex + 1)));
            }
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (Exception e2) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    IStatus iStatus = this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_opened_in_row_, (Object)(partIndex + 1)));
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return iStatus;
                }
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (0L == file.length()) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(partIndex + 1)));
            }
            boolean bl3 = vaildLen = part.getLength() != -1L && part.getLength() < file.length();
            if (vaildLen) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(partIndex + 1)));
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus checkStartAddressAndLen(PartitionItem part, int partSize, int partIndex) {
        long start = part.getStart();
        if (partIndex == 0 && start != 0L) {
            return this.error(c.PartitionBurner_msg_invalid_fastboot_start);
        }
        return super.checkStartAddressAndLen(part, partSize, partIndex);
    }

    private IStatus checkFlashAndFileSystem(FlashType[] flashTypes, FileSystem[] fileSystems, int partIndex, PartitionItem part) {
        boolean valid = false;
        Object[] objectArray = fileSystems;
        int n2 = fileSystems.length;
        int n3 = 0;
        while (n3 < n2) {
            FileSystem fileSystem = objectArray[n3];
            if (fileSystem == part.getFileSystem()) {
                valid = true;
                break;
            }
            ++n3;
        }
        if (!valid) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_file_system_in_row_, (Object)(partIndex + 1)));
        }
        valid = false;
        objectArray = flashTypes;
        n2 = flashTypes.length;
        n3 = 0;
        while (n3 < n2) {
            FileSystem flashType = objectArray[n3];
            if (flashType == part.getFlashType()) {
                valid = true;
                break;
            }
            ++n3;
        }
        if (!valid) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_flash_type_in_row_, (Object)(partIndex + 1)));
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus checkBeforeUpload() {
        IStatus validLocalConfig = this.validSerialPort();
        if (!this.isOK(validLocalConfig)) {
            return validLocalConfig;
        }
        IStatus check = this.validNetConfig();
        if (!this.isOK(check)) {
            return check;
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.error(NLS.bind((String)c.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"USB"));
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.I2CBootrom || this.getBurnContext().getTransferWay() == TransferWay.Usb2I2c) {
            return this.error(NLS.bind((String)c.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"I2C"));
        }
        check = this.checkTable(EventType.UPLOAD);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus validLocalConfig = this.validSerialPort();
        if (!this.isOK(validLocalConfig)) {
            return validLocalConfig;
        }
        IStatus check = this.validNetConfig();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.checkTable(EventType.BURN);
        if (!this.isOK(check)) {
            return check;
        }
        if (!this.isOK(this.checkHasSelectNullFile())) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus checkTable(EventType event) {
        boolean createTable = this.isCreatePartitionTable();
        List<PartitionItem> parts = this.getChildren();
        int selection = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selection;
            break;
        }
        if (selection == 0) {
            if (event == EventType.UPLOAD) {
                return this.error(c.AbstractBurner_msg_emmc_no_createTable_and_non_partition);
            }
            if (!createTable && event == EventType.BURN) {
                return this.error(c.AbstractBurner_msg_emmc_no_createTable_and_non_partition);
            }
            return this.error(c.AbstractBurner_msg_emmc_no_createTable_and_non_partition);
        }
        IStatus check = this.checkOtherPart(parts, event);
        if (!this.isOK(check)) {
            return check;
        }
        return Status.OK_STATUS;
    }

    @Override
    public EmmcPartitionBurnerWorker getBurnerWorker() {
        return new EmmcPartitionBurnerWorker(this);
    }

    @Override
    public void upload(final IFastbootProgressMonitor fastbootMonitor) {
        EmmcPartitionBurnerWorker worker;
        block16: {
            boolean needOpenSerial;
            BurnContext context = this.getBurnContext();
            LocalConfig localConfig = context.getLocalConfig();
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            boolean bl2 = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && !((q)this.getBurnContext().getDeviceSetting()).h();
            if (needOpenSerial) {
                SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort());
                if (serialPort == null) {
                    return;
                }
            } else if (fastbootMonitor != null) {
                fastbootMonitor.begin();
            }
            if (worker.isNeedSetupNet(transferWay)) {
                File home = worker.getHome(this.getChildren(), EventType.UPLOAD);
                boolean start = false;
                InetAddress address = null;
                try {
                    address = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException e2) {
                    e2.printStackTrace();
                }
                try {
                    try {
                        start = TFTPService.TFTPSERVICE.start(home, address, bi.c());
                        this.getTftpPreferenceValue();
                    }
                    catch (Exception e3) {
                        this.handleTftpStartFailed();
                        if (!start) {
                            fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (!start) {
                        fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    throw throwable;
                }
                if (!start) {
                    fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            event.setBurner(this);
            Job job = new Job("Upload By Emmc Partition"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean upload = worker.upload(monitor, EmmcBurner.this.getChildren());
                            event.setSuccess(upload);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    EmmcBurner.this.shutDownTFTP(fastbootMonitor);
                    EmmcBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    @Override
    public boolean isCreatePartitionTable() {
        return this.createPartitionTable;
    }

    @Override
    public void setCreatePartitionTable(boolean createPartitionTable) {
        this.createPartitionTable = createPartitionTable;
    }

    @Override
    public ITab getTab() {
        return new EmmcTab();
    }

    @Override
    public void createImage(final IFastbootProgressMonitor fastbootMonitor) {
        final EmmcPartitionBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        final FastbootEvent event = fastbootMonitor.getEvent();
        FileDialog d2 = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        String open = d2.open();
        if (open == null) {
            fastbootMonitor.finish();
            return;
        }
        final File file = new File(open);
        if (file.isDirectory()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)"Can not be a Directory!");
            fastbootMonitor.finish();
        }
        Job job = new Job("Making Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean upload = worker.createImage(monitor, file, EmmcBurner.this.getChildren(), false);
                        event.setSuccess(upload);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
            }
        });
        job.schedule();
    }

    @Override
    public void createHiProImage(final IFastbootProgressMonitor fastbootMonitor, final String outputPath, final List<PartitionItem> parts) {
        fastbootMonitor.getEvent().init(EventType.CREATE_USB_PACKAGE);
        Job job = new Job("Create USB package"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create HiPro package", 10);
                int result = 0;
                u packager = new u(EmmcBurner.this.worker.getBurner());
                packager.a(parts);
                result = packager.c(new SubProgressMonitor(monitor, 10, 4), outputPath);
                if (result == 0) {
                    fastbootMonitor.getEvent().setSuccess(true);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.OK_STATUS;
                }
                if (result == -1) {
                    fastbootMonitor.getEvent().setSuccess(false);
                    fastbootMonitor.getEvent().setMessage(c.BurnComposite_Usb_Pack_Canceled);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.CANCEL_STATUS;
                }
                fastbootMonitor.getEvent().setSuccess(false);
                monitor.done();
                fastbootMonitor.finish();
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @Override
    public IStatus checkCreateImage() {
        List<PartitionItem> children = this.getChildren();
        int size = children.size();
        if (children.isEmpty()) {
            return null;
        }
        long lastAddress = 0L;
        FlashType[] flashTypes = FlashType.getFlashTypes(this);
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        IStatus result = Status.OK_STATUS;
        int i2 = 0;
        while (i2 < size) {
            PartitionItem partition = children.get(i2);
            long start = partition.getStart();
            if (i2 == 0 && start != 0L) {
                this.getBurnContext().getUIAdapter().highLight(partition);
                return this.error(c.PartitionBurner_msg_invalid_fastboot_start);
            }
            if (0L == partition.getLength()) {
                this.getBurnContext().getUIAdapter().highLight(partition);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(i2 + 1)));
            }
            if (start < lastAddress) {
                this.getBurnContext().getUIAdapter().highLight(partition);
                return this.error(NLS.bind((String)c.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(i2 + 1)));
            }
            result = this.checkFlashAndFileSystem(flashTypes, fileSystems, i2, partition);
            if (result != Status.OK_STATUS) {
                return result;
            }
            lastAddress = start + (partition.getLength() == -1L ? 0L : partition.getLength());
            int alignLen = 512;
            if (partition.getFlashType() == FlashType.ufs) {
                alignLen = 4096;
            }
            if (partition.getLength() == -1L && partition.getLength() % (long)alignLen != 0L && i2 != size - 1) {
                this.getBurnContext().getUIAdapter().highLight(partition);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(i2 + 1)));
            }
            if (partition.isChecked()) {
                File file = partition.getFile();
                if (file == null) {
                    return null;
                }
                if (start % (long)alignLen != 0L) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(i2 + 1)));
                }
                if (!file.exists()) {
                    return null;
                }
                if (file.isDirectory()) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(i2 + 1)));
                }
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (Exception e2) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        IStatus iStatus = this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_opened_in_row_, (Object)(i2 + 1)));
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return iStatus;
                    }
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (0L == file.length()) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(i2 + 1)));
                }
                if (partition.getLength() != -1L && partition.getLength() < file.length()) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(i2 + 1)));
                }
            }
            ++i2;
        }
        return null;
    }

    public IStatus checkCreateHiproImage() {
        List<PartitionItem> children = this.getChildren();
        int size = children.size();
        if (children.isEmpty()) {
            return null;
        }
        int index = 0;
        int selection = 0;
        index = 0;
        while (index < size) {
            if (children.get(index).isChecked()) {
                ++selection;
                break;
            }
            ++index;
        }
        if (selection == 0) {
            return this.error(c.PartitionBurner_msg_no_burning_partition);
        }
        long lastAddress = 0L;
        FlashType[] flashTypes = FlashType.getFlashTypes(this);
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        IStatus result = Status.OK_STATUS;
        int i2 = 0;
        while (i2 < size) {
            PartitionItem partition = children.get(i2);
            long start = partition.getStart();
            if (partition.isChecked()) {
                boolean notCheck;
                boolean vaildLen;
                boolean isBoot;
                boolean bl2 = isBoot = i2 == 0 && start != 0L;
                if (isBoot) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(c.PartitionBurner_msg_invalid_fastboot_start);
                }
                if (0L == partition.getLength()) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(i2 + 1)));
                }
                if (start < lastAddress) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(i2 + 1)));
                }
                result = this.checkFlashAndFileSystem(flashTypes, fileSystems, i2, partition);
                if (result != Status.OK_STATUS) {
                    return result;
                }
                lastAddress = start + (partition.getLength() == -1L ? 0L : partition.getLength());
                int alignLen = 512;
                if (partition.getFlashType() == FlashType.ufs) {
                    alignLen = 4096;
                }
                boolean bl3 = vaildLen = partition.isChecked() && partition.getLength() == -1L && partition.getLength() % (long)alignLen != 0L && i2 != size - 1;
                if (vaildLen) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(i2 + 1)));
                }
                boolean bl4 = notCheck = !partition.isChecked() && partition.getFileSystem() != FileSystem.ext3 && i2 != 0;
                if (!notCheck) {
                    File file = partition.getFile();
                    if (file != null) {
                        boolean checkFileLen;
                        boolean bl5 = checkFileLen = (partition.getFileSystem() == FileSystem.ext3 || i2 == 0) && partition.getFile().length() > partition.getLength() && partition.getLength() != -1L;
                        if (checkFileLen) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            return this.error(NLS.bind((String)c.EmmcBurner_No_Enough_For_MBR, (Object)(i2 + 1)));
                        }
                        if (!file.exists()) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(i2 + 1)));
                        }
                        if (file.isDirectory()) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(i2 + 1)));
                        }
                        FileInputStream fileInputStream = null;
                        try {
                            try {
                                fileInputStream = new FileInputStream(file);
                            }
                            catch (Exception e2) {
                                this.getBurnContext().getUIAdapter().highLight(partition);
                                IStatus iStatus = this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_opened_in_row_, (Object)(i2 + 1)));
                                if (fileInputStream != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return iStatus;
                            }
                        }
                        finally {
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (0L == file.length()) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(i2 + 1)));
                        }
                        boolean bl6 = vaildLen = partition.getLength() != -1L && partition.getLength() < file.length();
                        if (vaildLen) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(i2 + 1)));
                        }
                    }
                    if (start % (long)alignLen != 0L) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(i2 + 1)));
                    }
                }
            }
            ++i2;
        }
        return null;
    }
}

