/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.BootTab;
import com.hisilicon.fastboot.views.FastbootView;
import gnu.io.SerialPort;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class FastbootBurner
extends AbstractBurner
implements IBootBurner {
    private FlashType flashType;
    private String file;

    public FastbootBurner(BurnContext burnContext) {
        super(burnContext);
    }

    protected IFrameSetting getFrameSetting() {
        return this.getBurnContext().getDeviceSetting().getFrameSetting();
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        boolean needOpenSerial;
        LocalConfig config = this.getBurnContext().getLocalConfig();
        final FastbootBurnerWorker worker = (FastbootBurnerWorker)this.getBurnerWorker();
        BurnContext context = this.getBurnContext();
        worker.setProgressMonitor(fastbootMonitor);
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl2 = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((q)this.getBurnContext().getDeviceSetting()).h();
        if (needOpenSerial) {
            SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, config.getComPort());
            if (serialPort == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (context.getTransferWay() == TransferWay.I2CBootrom) {
            if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(52));
            } else {
                return;
            }
        }
        Job fastbootJob = new Job("Burn Fastboot"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        worker.burn(monitor, FastbootBurner.this.getFlashType(), FastbootBurner.this.getFile());
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                FastbootBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    @Override
    public IStatus checkBeforeBurn() {
        LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        String com = localConfig.getComPort().trim();
        if (localConfig.getComPort() == null || com.length() == 0) {
            return this.error(c.AbstractBurner_msg_serialPort_is_null);
        }
        if (this.flashType == null) {
            return this.error(c.AbstractBurner_msg_falshType_is_null);
        }
        if (this.file == null || this.file.trim().length() == 0) {
            return this.error(c.AbstractBurner_msg_file_path_does_not_select);
        }
        File theFile = new File(this.file);
        if (!theFile.exists()) {
            return this.error(c.AbstractBurner_msg_the_file_does_not_exist);
        }
        if (theFile.isDirectory()) {
            return this.error(c.AbstractBurner_msg_the_file_can_not_be_a_directory);
        }
        if (this.file.length() == 0) {
            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero, (Object)1));
        }
        if (!(FastbootView.isHi3251Series() || FastbootView.isHi3731Series() || FastbootView.isHi3231Series() || theFile.length() <= 0x100000L)) {
            return this.error(c.AbstractBurner_msg_the_bootFile_size_must_be_less_than_1m);
        }
        return null;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public FlashType getFlashType() {
        return this.flashType;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(c.FastbootBurner_Step_1);
        steps.add(c.FastbootBurner_Step_2);
        steps.add(c.FastbootBurner_Step_3);
        steps.add(c.FastbootBurner_Step_4);
        return steps;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    @Override
    public ITab getTab() {
        return new BootTab();
    }

    @Override
    protected AbstractBurnerWorker getBurnerWorker() {
        return new FastbootBurnerWorker(this.getFrameSetting(), this);
    }

    @Override
    public ChipID getChipID() {
        return null;
    }

    @Override
    public void setFlashId(ChipID chipId) {
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

