/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IMergeBurner;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.MergeBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.MergeTab;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class MergeBurner
extends PartitionBurner
implements IMergeBurner {
    public MergeBurner(BurnContext burnContext) {
        super(burnContext);
        this.getChildren().clear();
    }

    @Override
    public void mergeImage(final IFastbootProgressMonitor fastbootMonitor) {
        final MergeBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        final FastbootEvent event = fastbootMonitor.getEvent();
        FileDialog d2 = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        String open = d2.open();
        if (open == null) {
            fastbootMonitor.finish();
            return;
        }
        final File file = new File(open);
        if (file.isDirectory()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)"Can not be a Directory!");
            fastbootMonitor.finish();
        }
        Job job = new Job("Merging Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean merge = worker.mergeImage(monitor, file, MergeBurner.this.getChildren(), false);
                        event.setSuccess(merge);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
            }
        });
        job.schedule();
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(c.MergeBurner_Step_1);
        steps.add(c.MergeBurner_Step_2);
        steps.add(c.MergeBurner_Step_3);
        return steps;
    }

    @Override
    public MergeBurnerWorker getBurnerWorker() {
        return new MergeBurnerWorker(this);
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus check = this.checkTable(EventType.BURN);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    @Override
    public ITab getTab() {
        return new MergeTab();
    }

    @Override
    protected IStatus checkTable(EventType event) {
        List<PartitionItem> items = this.getChildren();
        int size = items.size();
        int index = 0;
        int selection = 0;
        index = 0;
        while (index < size) {
            if (items.get(index).isChecked()) {
                ++selection;
                break;
            }
            ++index;
        }
        if (selection == 0) {
            return this.error(c.PartitionBurner_msg_no_burning_partition);
        }
        IStatus check = this.checkOtherPart(items, event);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    @Override
    protected IStatus checkOtherPart(List<PartitionItem> parts, EventType event) {
        boolean isConfirm;
        int size = parts.size();
        int index = 0;
        long spiTotalLength = 0L;
        long nandTotalLength = 0L;
        long emmcTotalLength = 0L;
        boolean isContinuous = false;
        index = 0;
        while (index < size - 1) {
            long nextStart;
            long thisLen;
            long thisStart = parts.get(index).getStart();
            if (thisStart + (thisLen = parts.get(index).getLength()) < (nextStart = parts.get(index + 1).getStart())) {
                this.getBurnContext().getUIAdapter().highLight(parts.get(index));
                isContinuous = true;
            }
            ++index;
        }
        if (isContinuous && !(isConfirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)c.MergeComposite_MergeImage_Must_Connection))) {
            return Status.CANCEL_STATUS;
        }
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        IStatus result = Status.OK_STATUS;
        index = 0;
        while (index < size) {
            PartitionItem part = parts.get(index);
            FileSystem fileSystem = part.getFileSystem();
            FlashType flashType = part.getFlashType();
            if (part.isChecked()) {
                boolean checkLen;
                long start = part.getStart();
                long length = part.getLength();
                result = this.checkAddressOverlap(parts, part, flashType, spiTotalLength, nandTotalLength, emmcTotalLength, index);
                if (result != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkFileType(index, fileSystems, part, fileSystem);
                if (result != Status.OK_STATUS) {
                    return result;
                }
                boolean bl2 = checkLen = index != size - 1 && 0L == length;
                if (checkLen) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(index + 1)));
                }
                File file = part.getFile();
                if (file != null) {
                    boolean needAlign;
                    boolean isVaildYaffs;
                    boolean fileInvild;
                    boolean bl3 = fileInvild = !file.exists() || file.isDirectory();
                    if (fileInvild) {
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(index + 1)));
                    }
                    long fileSize = file.length();
                    if (fileSize == 0L) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(index + 1)));
                    }
                    if (index != size - 1) {
                        if (length < fileSize) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(index + 1)));
                        }
                        if (0L == length) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(index + 1)));
                        }
                        if (length < 0L) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_in_row_, (Object)(index + 1)));
                        }
                        if (start < 0L) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_Less_than_zero_in_row_, (Object)(index + 1)));
                        }
                    } else {
                        if (length < -1L) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_in_row_, (Object)(index + 1)));
                        }
                        if (start < 0L) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_Less_than_zero_in_row_, (Object)(index + 1)));
                        }
                    }
                    boolean yaffsFile = false;
                    try {
                        yaffsFile = FileSystem.isYaffsFile(this, file);
                    }
                    catch (IOException e2) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_failed_to_open_the_file_in_row_, (Object)(index + 1)));
                    }
                    boolean bl4 = isVaildYaffs = yaffsFile && FileSystem.yaffs != fileSystem;
                    if (isVaildYaffs) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_file_is_yaffs_but_file_system_is_not_in_row_, (Object)(index + 1)));
                    }
                    int alignLen = 512;
                    if (flashType == FlashType.ufs) {
                        alignLen = 4096;
                    }
                    if (start % (long)alignLen != 0L) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(index + 1)));
                    }
                    boolean bl5 = needAlign = index != size - 1 && length % (long)alignLen != 0L;
                    if (needAlign) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(index + 1)));
                    }
                    try {
                        boolean checkTftpFileNameInvaild;
                        boolean bl6 = checkTftpFileNameInvaild = (this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
                        if (checkTftpFileNameInvaild) {
                            return this.error(NLS.bind((String)c.msg_File_name_is_too_long_please_use_a_short_name_instead, (Object)(index + 1)));
                        }
                    }
                    catch (UnsupportedEncodingException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            ++index;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFileType(int index, FileSystem[] fileSystems, PartitionItem part, FileSystem fileSystem) {
        boolean validFileType = false;
        FileSystem[] fileSystemArray = fileSystems;
        int n2 = fileSystems.length;
        int n3 = 0;
        while (n3 < n2) {
            FileSystem req = fileSystemArray[n3];
            if (req == fileSystem) {
                validFileType = true;
                break;
            }
            ++n3;
        }
        if (!validFileType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_file_system_in_row_, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkAddressOverlap(List<PartitionItem> parts, PartitionItem part, FlashType flashType, long spiTotalLength, long nandTotalLength, long emmcTotalLength, int index) {
        long start = part.getStart();
        PartitionItem lastPart = null;
        boolean isSelectNextPart = false;
        FlashType lastFlashType = null;
        long lastStart = 0L;
        long lastLength = 0L;
        long lastTotalLength = 0L;
        if (index - 1 >= 0) {
            lastPart = parts.get(index - 1);
            lastFlashType = lastPart.getFlashType();
            if (lastPart.isChecked() && flashType == lastFlashType) {
                isSelectNextPart = true;
                lastStart = lastPart.getStart();
                lastLength = lastPart.getLength();
                lastTotalLength = lastStart + lastLength;
            }
        }
        if (FlashType.spi == flashType) {
            if (0L == start && 0L != spiTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if (0L != spiTotalLength && start < spiTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
            if (isSelectNextPart && start < lastTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
        } else if (FlashType.nand == flashType) {
            if (0L == start && 0L != nandTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if (0L != nandTotalLength && start < nandTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
            if (isSelectNextPart && start < lastTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
        } else if (FlashType.emmc == flashType) {
            if (0L == start && 0L != emmcTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if (isSelectNextPart && start < lastTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
        } else if (FlashType.eeprom != flashType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_flash_type_in_row_, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }
}

