/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PartitionInfo;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IErasable;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IPartitionBurner;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.ui.burners.tabs.PartitionTab;
import gnu.io.SerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.tftp.hitool.TFTPService;

public class PartitionBurner
extends AbstractBurner
implements IErasable,
IPartitionBurner {
    static final String FASTBOOT = "fastboot";
    private File partitionFile;
    protected List<PartitionItem> children;
    private long lestLen = 0L;
    private final int IS_CANCEL = -10;
    private PartitionInfo info = new PartitionInfo();

    public PartitionBurner(BurnContext burnContext) {
        super(burnContext);
        PartitionItem fastboot = new PartitionItem();
        fastboot.setName(FASTBOOT);
        this.getChildren().add(fastboot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        PartitionBurnerWorker worker;
        block23: {
            boolean needOpenSerial;
            if (fastbootMonitor != null) {
                fastbootMonitor.getEvent().init(EventType.BURN);
            }
            BurnContext context = this.getBurnContext();
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            boolean bl2 = needOpenSerial = this.isOpenSerailPort(this.getBurnContext().getTransferWay()) && !((q)this.getBurnContext().getDeviceSetting()).h();
            if (needOpenSerial) {
                SerialPort serialPort;
                if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) == null) {
                    fastbootMonitor.finish();
                    return;
                }
            } else if (fastbootMonitor != null) {
                fastbootMonitor.begin();
            }
            if (transferWay == TransferWay.I2CBootrom) {
                if (this.children != null && this.children.size() > 0) {
                    if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                        worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(52));
                    } else {
                        if (fastbootMonitor != null) {
                            fastbootMonitor.finish();
                        }
                        return;
                    }
                }
            } else if (worker.isNeedSetupNet(transferWay)) {
                boolean start = false;
                InetAddress address = null;
                try {
                    address = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException e2) {
                    e2.printStackTrace();
                }
                try {
                    try {
                        if (!TFTPService.TFTPSERVICE.isStart()) {
                            start = TFTPService.TFTPSERVICE.start(this.getParentFile(), address, bi.c());
                        }
                        this.getTftpPreferenceValue();
                        context.setTftpOccupied(!start);
                    }
                    catch (Exception e3) {
                        context.setTftpOccupied(true);
                        this.handleTftpStartFailed();
                        if (!start) {
                            fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (!start) {
                        fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    throw throwable;
                }
                if (!start) {
                    fastbootMonitor.warnln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job fastbootJob = new Job("Burn By Partition"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean partBurn = worker.burn(monitor, PartitionBurner.this.children);
                            event.setSuccess(partBurn);
                        }
                        catch (Throwable e2) {
                            monitor.setCanceled(true);
                            e2.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e2.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(fastbootJob);
            fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    PartitionBurner.this.shutDownTFTP(fastbootMonitor);
                    PartitionBurner.this.closeByTrans();
                }
            });
            fastbootJob.schedule();
        }
    }

    private File getParentFile() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        for (PartitionItem partition : this.children) {
            if (!partition.isChecked() || partition.getFile() == null) continue;
            return partition.getFile().getParentFile();
        }
        return null;
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus check = super.checkBeforeBurn();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.checkTable(EventType.BURN);
        if (!this.isOK(check)) {
            return check;
        }
        if (!this.isOK(this.checkHasSelectNullFile())) {
            return Status.CANCEL_STATUS;
        }
        return null;
    }

    @Override
    public IStatus checkBeforeErase() {
        IStatus check = super.checkBeforeBurn();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.checkTable(EventType.UPLOAD);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    public IStatus checkBeforeMakeHiPro() {
        IStatus check = this.checkTable(EventType.CREATE_IMAGE);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    private boolean isOpenSerailPort(TransferWay transferWay) {
        if (transferWay == null) {
            return false;
        }
        return transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void erase(final IFastbootProgressMonitor fastbootMonitor) {
        if (fastbootMonitor != null) {
            fastbootMonitor.getEvent().init(EventType.ERASE);
        }
        BurnContext context = this.getBurnContext();
        final PartitionBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        if (this.isOpenSerailPort(this.getBurnContext().getTransferWay()) && !((q)this.getBurnContext().getDeviceSetting()).h()) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (context.getTransferWay() == TransferWay.I2CBootrom) {
            if (!I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) return;
            worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
        } else if (context.getTransferWay() == TransferWay.Usb2I2c) {
            worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
        }
        Job fastbootJob = new Job("Erase By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean erase = worker.erase(monitor, PartitionBurner.this.getChildren());
                        fastbootMonitor.getEvent().setSuccess(erase);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                PartitionBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    @Override
    public void eraseAll(final IFastbootProgressMonitor fastbootMonitor) {
        if (fastbootMonitor != null) {
            fastbootMonitor.getEvent().init(EventType.ERASE);
        }
        BurnContext context = this.getBurnContext();
        final PartitionBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        if (this.isOpenSerailPort(this.getBurnContext().getTransferWay()) && !((q)this.getBurnContext().getDeviceSetting()).h()) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (context.getTransferWay() == TransferWay.I2CBootrom) {
            if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
            } else {
                return;
            }
        }
        Job fastbootJob = new Job("Erase By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean erase = worker.eraseAll(monitor, PartitionBurner.this.children);
                        fastbootMonitor.getEvent().setSuccess(erase);
                    }
                    catch (Throwable e2) {
                        monitor.setCanceled(true);
                        e2.printStackTrace();
                        fastbootMonitor.getEvent().setMessage(e2.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                PartitionBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    protected IStatus checkTable(EventType event) {
        List<PartitionItem> items = this.getChildren();
        int size = items.size();
        int index = 0;
        int selection = 0;
        index = 0;
        while (index < size) {
            if (items.get(index).isChecked()) {
                ++selection;
                break;
            }
            ++index;
        }
        if (selection == 0) {
            return this.error(c.PartitionBurner_msg_no_burning_partition);
        }
        IStatus check = this.checkFastbootPart(items.get(0), event);
        if (!this.isOK(check)) {
            this.getBurnContext().getUIAdapter().highLight(items.get(0));
            return check;
        }
        check = this.checkOtherPart(items, event);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    protected IStatus checkOtherPart(List<PartitionItem> parts, EventType event) {
        int partSize = parts.size();
        int partIndex = 0;
        IStatus result = Status.OK_STATUS;
        PartitionItem fastboot = parts.get(partIndex++);
        long spiTotalLength = 0L;
        long nandTotalLength = 0L;
        if (fastboot.isChecked() && FASTBOOT.equalsIgnoreCase(fastboot.getName())) {
            File file = fastboot.getFile();
            if (file == null) {
                this.getBurnContext().getUIAdapter().highLight(fastboot);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)partIndex));
            }
            if (!file.exists()) {
                this.getBurnContext().getUIAdapter().highLight(fastboot);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(partIndex + 1)));
            }
            if (FlashType.spi == fastboot.getFlashType()) {
                spiTotalLength = fastboot.getLength();
            } else if (FlashType.nand == fastboot.getFlashType()) {
                nandTotalLength = fastboot.getLength();
            }
        }
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        partIndex = 1;
        while (partIndex < partSize) {
            block15: {
                File file;
                FileSystem fileSystem;
                PartitionItem part;
                block17: {
                    block16: {
                        part = parts.get(partIndex);
                        FlashType flashType = part.getFlashType();
                        fileSystem = part.getFileSystem();
                        if (!part.isChecked()) break block15;
                        result = this.checkAddressOverlap(part, flashType, spiTotalLength, nandTotalLength, partIndex);
                        if (result != Status.OK_STATUS) {
                            return result;
                        }
                        result = this.checkFlashAndFileSystem(partIndex, part, flashType, fileSystem, fileSystems);
                        if (result != Status.OK_STATUS) {
                            return result;
                        }
                        result = this.checkStartAddressAndLen(part, partSize, partIndex);
                        if (result != Status.OK_STATUS) {
                            this.getBurnContext().getUIAdapter().highLight(part);
                            return result;
                        }
                        if (EventType.ERASE == event) break block15;
                        file = part.getFile();
                        if (EventType.CREATE_IMAGE == event) break block16;
                        if (file != null) break block17;
                        break block15;
                    }
                    if (file == null) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)(partIndex + 1)));
                    }
                    if (!file.exists()) {
                        this.getBurnContext().getUIAdapter().highLight(part);
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(partIndex + 1)));
                    }
                }
                if ((result = this.checkStartAndLen(part, partIndex, partSize)) != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkYaffsFile(partIndex, part, fileSystem);
                if (result != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkNetFileNameLen(partIndex, file);
                if (result != Status.OK_STATUS) {
                    return result;
                }
            }
            ++partIndex;
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkStartAddressAndLen(PartitionItem part, int partSize, int partIndex) {
        long start = part.getStart();
        long length = part.getLength();
        if (partIndex != partSize - 1) {
            if (0L == length) {
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(partIndex + 1)));
            }
            if (length < 0L) {
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_in_row_, (Object)(partIndex + 1)));
            }
            if (start < 0L) {
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_Less_than_zero_in_row_, (Object)(partIndex + 1)));
            }
        } else {
            if (length < -1L) {
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_in_row_, (Object)(partIndex + 1)));
            }
            if (start < 0L) {
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_Less_than_zero_in_row_, (Object)(partIndex + 1)));
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkStartAndLen(PartitionItem part, int index, long size) {
        long start = part.getStart();
        long length = part.getLength();
        File file = part.getFile();
        FlashType flashType = part.getFlashType();
        if (file != null && (!file.exists() || file.isDirectory())) {
            return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(index + 1)));
        }
        if (file != null) {
            long fileSize = file.length();
            if (fileSize == 0L) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if ((long)index != size - 1L) {
                if (length < fileSize) {
                    this.getBurnContext().getUIAdapter().highLight(part);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(index + 1)));
                }
            } else if (length != -1L && length < fileSize) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(index + 1)));
            }
        }
        int alignLen = 512;
        if (flashType == FlashType.ufs) {
            alignLen = 4096;
        }
        if (start % (long)alignLen != 0L) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(index + 1)));
        }
        if ((long)index != size - 1L && length % (long)alignLen != 0L) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    private IStatus checkAddressOverlap(PartitionItem part, FlashType flashType, long spiTotalLength, long nandTotalLength, int index) {
        long start = part.getStart();
        if (FlashType.spi == flashType) {
            ChipID chipID = part.getChipID();
            if (0L == start && 0L != spiTotalLength && (chipID == null || chipID != ChipID.chip1)) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if (0L != spiTotalLength && start < spiTotalLength && (chipID == null || chipID != ChipID.chip1)) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
        } else if (FlashType.nand == flashType) {
            if (0L == start && 0L != nandTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
            }
            if (0L != nandTotalLength && start < nandTotalLength) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
            }
        } else if (FlashType.eeprom != flashType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_flash_type_in_row_, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFlashAndFileSystem(int index, PartitionItem part, FlashType flashType, FileSystem fileSystem, FileSystem[] fileSystems) {
        boolean validFileType = false;
        FileSystem[] fileSystemArray = fileSystems;
        int n2 = fileSystems.length;
        int n3 = 0;
        while (n3 < n2) {
            FileSystem req = fileSystemArray[n3];
            if (req == fileSystem) {
                validFileType = true;
            }
            ++n3;
        }
        if (!validFileType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_file_system_in_row_, (Object)(index + 1)));
        }
        if (FlashType.spi == flashType && FileSystem.yaffs == fileSystem) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_msg_flash_SPI_and_file_system_Yaffs_can_not_be_selected_at_the_same_time_in_row_, (Object)(index + 1)));
        }
        if (FileSystem.ubiFs == fileSystem && FlashType.nand != flashType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_UBI_only_support_Nand_flash, (Object)(index + 1)));
        }
        if (FileSystem.ext3 == fileSystem && FlashType.emmc != flashType) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_EXT3_only_support_Emmc_flash, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkYaffsFile(int index, PartitionItem part, FileSystem fileSystem) {
        File file = part.getFile();
        if (file == null || !file.exists() || file.isDirectory()) {
            return Status.OK_STATUS;
        }
        boolean yaffsFile = false;
        try {
            yaffsFile = FileSystem.isYaffsFile(this, file);
        }
        catch (IOException e2) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_msg_failed_to_open_the_file_in_row_, (Object)(index + 1)));
        }
        if (yaffsFile) {
            if (FileSystem.yaffs != fileSystem) {
                this.getBurnContext().getUIAdapter().highLight(part);
                return this.error(NLS.bind((String)c.PartitionBurner_msg_file_is_yaffs_but_file_system_is_not_in_row_, (Object)(index + 1)));
            }
        } else if (FileSystem.none != fileSystem && FileSystem.ubiFs != fileSystem && FileSystem.squashFs != fileSystem && FileSystem.ext3 != fileSystem) {
            this.getBurnContext().getUIAdapter().highLight(part);
            return this.error(NLS.bind((String)c.PartitionBurner_msg_file_is_not_yaffs_but_file_system_is_yaffs_in_row_, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkNetFileNameLen(int index, File file) {
        if (file == null) {
            return Status.OK_STATUS;
        }
        try {
            if ((this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100) {
                return this.error(NLS.bind((String)c.msg_File_name_is_too_long_please_use_a_short_name_instead, (Object)(index + 1)));
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    protected IStatus checkFastbootPart(PartitionItem fastboot, EventType event) {
        if (!fastboot.isChecked()) {
            return null;
        }
        File file = fastboot.getFile();
        if (!(event == EventType.BURN || file != null && file.exists())) {
            return null;
        }
        String partName = fastboot.getName();
        FileSystem fileSystem = fastboot.getFileSystem();
        long start = fastboot.getStart();
        long length = fastboot.getLength();
        if (file == null) {
            this.getBurnContext().getUIAdapter().highLight(fastboot);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)1));
        }
        if (!file.exists()) {
            this.getBurnContext().getUIAdapter().highLight(fastboot);
            return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)1));
        }
        long fileSize = file.length();
        if (!FASTBOOT.equalsIgnoreCase(partName)) {
            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_fastboot_name, (Object)1));
        }
        if (fileSystem != FileSystem.none) {
            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_fastboot_fileSystem, (Object)1));
        }
        if (start != 0L) {
            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_fastboot_start, (Object)1));
        }
        if (fileSize == 0L) {
            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)1));
        }
        if (0L == length) {
            return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)1));
        }
        if (length < fileSize) {
            return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_fastboot_length, (Object)1));
        }
        int alignLen = 1024;
        if (fastboot.getFlashType() == FlashType.ufs) {
            alignLen = 4096;
        }
        if (length % (long)alignLen != 0L) {
            return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)1));
        }
        try {
            boolean needCheckFilelen;
            boolean bl2 = needCheckFilelen = (this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
            if (needCheckFilelen) {
                return this.error(NLS.bind((String)c.msg_File_name_is_too_long_please_use_a_short_name_instead, (Object)1));
            }
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public List<PartitionItem> getChildren() {
        if (this.children == null) {
            this.children = this.info.getChildren();
        }
        return this.children;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(c.PartitionBurner_Step_1);
        steps.add(c.PartitionBurner_Step_2);
        steps.add(c.PartitionBurner_Step_3);
        steps.add(c.PartitionBurner_Step_4);
        steps.add(c.PartitionBurner_Step_5);
        steps.add(c.PartitionBurner_Step_6);
        return steps;
    }

    @Override
    public void remove(PartitionItem child) {
        this.getChildren().remove(child);
    }

    public void setChildren(List<PartitionItem> children) {
        this.children = children;
    }

    @Override
    public void setTableFile(File tableFile) {
        this.setPartitionFile(tableFile);
    }

    @Override
    public File getPartitionFile() {
        return this.partitionFile;
    }

    @Override
    public void setPartitionFile(File partitionFile) {
        this.partitionFile = partitionFile;
    }

    @Override
    public ITab getTab() {
        return new PartitionTab();
    }

    @Override
    protected PartitionBurnerWorker getBurnerWorker() {
        return new PartitionBurnerWorker(this);
    }

    @Override
    public void createImage(final IFastbootProgressMonitor fastbootMonitor) {
        final PartitionBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        FileDialog d2 = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        String open = d2.open();
        if (open == null) {
            return;
        }
        File file = new File(open);
        if (file.isDirectory()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)c.FASTBOOT_WARNING_Title, (String)"Can not be a Directory!");
            return;
        }
        Job job = new Job("Making Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                worker.close();
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
            }
        });
        job.schedule();
    }

    public void createHiProImage(final IFastbootProgressMonitor fastbootMonitor, final String outputPath, final List<PartitionItem> parts) {
        fastbootMonitor.getEvent().init(EventType.CREATE_USB_PACKAGE);
        Job job = new Job("Create USB package"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create USB package", 10);
                int result = 0;
                v packager = new v(PartitionBurner.this.getBurnerWorker().getBurner());
                packager.a(parts);
                result = packager.c(new SubProgressMonitor(monitor, 10, 4), outputPath);
                if (result == 0) {
                    fastbootMonitor.getEvent().setSuccess(true);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.OK_STATUS;
                }
                if (result == -1) {
                    fastbootMonitor.getEvent().setSuccess(false);
                    fastbootMonitor.getEvent().setMessage(c.BurnComposite_Usb_Pack_Canceled);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.CANCEL_STATUS;
                }
                fastbootMonitor.getEvent().setSuccess(false);
                monitor.done();
                fastbootMonitor.finish();
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @Override
    public IStatus checkCreateImage() {
        List<PartitionItem> children = this.getChildren();
        int size = children.size();
        if (children.isEmpty()) {
            return null;
        }
        long lastAddress = 0L;
        FlashType[] flashTypes = FlashType.getFlashTypes(this);
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        int i2 = 0;
        while (i2 < size) {
            PartitionItem partition = children.get(i2);
            long start = partition.getStart();
            if (partition.isChecked()) {
                boolean partitionFlag;
                boolean flag;
                if (partition.getFlashType() == FlashType.spi) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_flash_type, (Object)(i2 + 1)));
                }
                boolean bl2 = flag = i2 == 0 && start != 0L;
                if (flag) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(c.PartitionBurner_msg_invalid_fastboot_start);
                }
                if (0L == partition.getLength()) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(i2 + 1)));
                }
                if (start < lastAddress) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(i2 + 1)));
                }
                boolean valid = false;
                Object[] objectArray = fileSystems;
                int n2 = fileSystems.length;
                int n3 = 0;
                while (n3 < n2) {
                    FileSystem fileSystem = objectArray[n3];
                    if (fileSystem == partition.getFileSystem()) {
                        valid = true;
                        break;
                    }
                    ++n3;
                }
                if (!valid) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_file_system_in_row_, (Object)(i2 + 1)));
                }
                valid = false;
                objectArray = flashTypes;
                n2 = flashTypes.length;
                n3 = 0;
                while (n3 < n2) {
                    FileSystem flashType = objectArray[n3];
                    if (flashType == partition.getFlashType()) {
                        valid = true;
                        break;
                    }
                    ++n3;
                }
                if (!valid) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.AbstractBurner_msg_invalid_flash_type_in_row_, (Object)(i2 + 1)));
                }
                lastAddress = start + (partition.getLength() == -1L ? 0L : partition.getLength());
                int alignLen = 512;
                if (partition.getFlashType() == FlashType.ufs) {
                    alignLen = 4096;
                }
                boolean bl3 = partitionFlag = partition.getLength() == -1L && partition.getLength() % (long)alignLen != 0L && i2 != size - 1;
                if (partitionFlag) {
                    this.getBurnContext().getUIAdapter().highLight(partition);
                    return this.error(NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_, (Object)alignLen, (Object)(i2 + 1)));
                }
                if (partition.isChecked()) {
                    File file = partition.getFile();
                    if (file == null) {
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)(i2 + 1)));
                    }
                    if (start % (long)alignLen != 0L) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_partition_Start_should_be_with_unit_KorM_or_NK_times, (Object)alignLen, (Object)(i2 + 1)));
                    }
                    if (!file.exists()) {
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(i2 + 1)));
                    }
                    if (file.isDirectory()) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(i2 + 1)));
                    }
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                        }
                        catch (Exception e2) {
                            this.getBurnContext().getUIAdapter().highLight(partition);
                            IStatus iStatus = this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_can_not_be_opened_in_row_, (Object)(i2 + 1)));
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Exception e3) {
                                    e3.printStackTrace();
                                }
                            }
                            return iStatus;
                        }
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception e4) {
                                e4.printStackTrace();
                            }
                        }
                    }
                    if (0L == file.length()) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        return this.error(NLS.bind((String)c.AbstractBurner_msg_the_file_size_must_be_nonzero_in_row_, (Object)(i2 + 1)));
                    }
                    if (partition.getLength() != -1L && partition.getLength() < file.length()) {
                        this.getBurnContext().getUIAdapter().highLight(partition);
                        return this.error(NLS.bind((String)c.PartitionBurner_msg_invalid_partition_size_in_row_, (Object)(i2 + 1)));
                    }
                }
            }
            ++i2;
        }
        return null;
    }

    public boolean checkLastPartition(List<PartitionItem> parts) {
        long lastLen = this.getLastPartitionLength(parts);
        int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        long start = partition.getStart();
        if (partition.getLength() == -1L) {
            if (lastLen == -10L) {
                return false;
            }
            if (lastLen % 1024L != 0L) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_lastParitionLen, (Object)1024));
                    }
                });
                return false;
            }
            if (0L == lastLen) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_lastPartitionLength);
                    }
                });
                return false;
            }
            if (start > lastLen) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)c.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_lastPartition);
                    }
                });
                return false;
            }
            partition.setLength(lastLen);
        }
        return true;
    }

    public long getLastPartitionLength(List<PartitionItem> parts) {
        int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        long partitionLength = partition.getLength();
        final long start = partition.getStart();
        if (partitionLength == -1L) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), c.Get_LastPartition_Length_In_MakeImage, c.Set_All_board_Length, "", null);
                    int open = inputDialog.open();
                    String inputValue = null;
                    if (open == 0) {
                        inputValue = inputDialog.getValue();
                    } else if (open == 1) {
                        return;
                    }
                    long inputLen = WorkerUtility.ReceiveHelper.convertToNumber(inputValue);
                    PartitionBurner.this.lestLen = inputLen - start;
                    PartitionBurner.this.getBurnerWorker().warningln("All Parttition remain space" + PartitionBurner.this.lestLen + " Bytes allotted to last partition!");
                }
            });
        }
        if (this.lestLen == 0L) {
            return -10L;
        }
        return this.lestLen;
    }

    protected IStatus checkHasSelectNullFile() {
        boolean questionResult;
        boolean checkPartitionFileHasNull = false;
        StringBuilder nullFilePartNames = new StringBuilder();
        for (PartitionItem partitionItem : this.children) {
            File file;
            if (!partitionItem.isChecked() || (file = partitionItem.getFile()) != null) continue;
            checkPartitionFileHasNull = true;
            String partitionName = "";
            partitionName = partitionItem.getName() != null && partitionItem.getName().isEmpty() ? " " : partitionItem.getName();
            nullFilePartNames.append(String.valueOf(partitionName) + ",");
        }
        if (checkPartitionFileHasNull && !(questionResult = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)(String.valueOf(c.EmmcBurner_CheckHasSelectNullFile) + "[" + nullFilePartNames.toString() + "]")))) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    public PartitionInfo getPratitionInfo() {
        return this.info;
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

