/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners.bvt;

import com.hisilicon.fastboot.commands.NetCommand;
import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.EmmcPartitionBurnerWorker;
import java.io.IOException;

public class BVTEmmcBurnerWorker
extends EmmcPartitionBurnerWorker {
    public BVTEmmcBurnerWorker(EmmcBurner burner) {
        super(burner);
    }

    @Override
    public boolean sendStartFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        String temp = null;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.frameSetting.getSendStartFrameTimeout()) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            temp = serialReceived.toString();
            int indexOf = temp.indexOf("     ");
            if (indexOf == -1) continue;
            try {
                this.sendBytes(new byte[]{-86});
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        this.infoln("waiting phy ready, it will take 8s.");
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            NetCommand[] commands;
            String usbTransNetCmd;
            if (transferWay == TransferWay.UsbTransNet && !this.sendCommand(usbTransNetCmd = "usb start")) {
                this.returnError(c.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            NetCommand[] netCommandArray = commands = this.buildNetCommands(transferWay);
            int n2 = commands.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                NetCommand command = netCommandArray[n3];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n3;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return true;
    }
}

