/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.preferences;

import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.ProductLine;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.PreferenceConstants;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.views.FastbootView;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JTAGPreferencePage
extends FieldEditorPreferencePage
implements PreferenceConstants,
IWorkbenchPreferencePage {
    public static final String ID = "com.hisilicon.fastboot.preferences.JTAGPreferencePage";
    private static final String[][] JTAGSMALLMODELTYPELIST = new String[][]{{"HiSTBUSB2JTAG VER.B / VER.C", "HiSTBUSB2JTAG VER.B / VER.C"}, {"HiSTBUSB2JTAG VER.A", "HiSTBUSB2JTAG VER.A"}};
    private static final String[][] JTAGSMALLMODELTYPELIST_Hi3716MV430 = new String[][]{{"HiSTBUSB2JTAG VER.B / VER.C", "HiSTBUSB2JTAG VER.B / VER.C"}};
    private static final String[][] JTAGSMALLMODELTYPELIST_Hi3716MV420_CA_N = new String[][]{{"HiSTBUSB2JTAG VER.A", "HiSTBUSB2JTAG VER.A"}};
    private Button jtagSmallModelButton;

    public static String[][] getJTAGSMALLMODELTYPELIST() {
        return (String[][])JTAGSMALLMODELTYPELIST.clone();
    }

    public static String[][] getJtagSmallModelTypeList() {
        String[][] entryNamesAndValues = null;
        entryNamesAndValues = FastbootView.isHi3716MV430_CA_N_Series() ? JTAGSMALLMODELTYPELIST_Hi3716MV430 : (FastbootView.isHi3716MV420_CA_N_Series() ? JTAGSMALLMODELTYPELIST_Hi3716MV420_CA_N : JTAGSMALLMODELTYPELIST);
        return (String[][])entryNamesAndValues.clone();
    }

    public JTAGPreferencePage() {
        super(0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(FastbootPreferences.getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Group jtagCommonadGroup = new Group(parent, 0);
        jtagCommonadGroup.setLayout((Layout)new GridLayout(2, false));
        jtagCommonadGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        jtagCommonadGroup.setText(c.JTAGPreferencePage_Title);
        Label jtagSmallModellable = new Label((Composite)jtagCommonadGroup, 0);
        jtagSmallModellable.setText(c.JTAGPreferencePage_JTAGTestSignel);
        this.jtagSmallModelButton = new Button((Composite)jtagCommonadGroup, 0);
        this.jtagSmallModelButton.setText(c.JTAGPreferencePage_Start);
        this.jtagSmallModelButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e2) {
            }

            public void mouseDown(MouseEvent e2) {
                ProductLine.PRODUCTLINE productLine = bi.a();
                if (productLine == ProductLine.PRODUCTLINE.DPT) {
                    CallLibJTAGWorker.jtag_SetFT2232Chip(2);
                } else {
                    boolean isEnd;
                    if (FastbootView.isJTagTransferMode()) {
                        new CallLibJTAGWorker(null, null, null);
                        LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                        LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
                    }
                    if (JTAGPreferencePage.this.jtagSmallModelButton.getText().equals(c.JTAGPreferencePage_Start)) {
                        String jtagSmallBoradModel = FastbootPreferences.getJtagSmallBoradModel();
                        int ft2232Chip = jtagSmallBoradModel.equals(JTAGSMALLMODELTYPELIST[0][0]) ? 0 : 1;
                        CallLibJTAGWorker.jtag_SetFT2232Chip(ft2232Chip);
                        boolean isStart = CallLibJTAGWorker.jtag_StartSignalTest();
                        if (isStart) {
                            JTAGPreferencePage.this.jtagSmallModelButton.setText(c.JTAGPreferencePage_Stop);
                        }
                    } else if (JTAGPreferencePage.this.jtagSmallModelButton.getText().equals(c.JTAGPreferencePage_Stop) && (isEnd = CallLibJTAGWorker.jtag_StopSignalTest())) {
                        JTAGPreferencePage.this.jtagSmallModelButton.setText(c.JTAGPreferencePage_Start);
                    }
                }
            }

            public void mouseUp(MouseEvent e2) {
            }
        });
        ComboFieldEditor jtagSmallModelCombo = new ComboFieldEditor("hisilicon.fastboot.jtag.small.borad.model", c.JTAGPreferencePage_JtagSmallBoardModel, JTAGPreferencePage.getJtagSmallModelTypeList(), (Composite)jtagCommonadGroup);
        this.addField((FieldEditor)jtagSmallModelCombo);
    }

    public void dispose() {
        ProductLine.PRODUCTLINE productLine;
        if (this.jtagSmallModelButton.getText().equals(c.JTAGPreferencePage_Stop)) {
            CallLibJTAGWorker.jtag_StopSignalTest();
        }
        if ((productLine = bi.a()) == ProductLine.PRODUCTLINE.STB) {
            FastbootView.setJtagRate();
        }
        super.dispose();
    }
}

