/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.Activator;
import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.commands.INFOCommand;
import com.hisilicon.fastboot.commands.SFCommand;
import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.commands.TFTPCommand;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.serial.workers.IBurnerWorker;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.views.FastbootView;
import com.hisilicon.fastboot.views.LightView;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.soyatec.tftp.hitool.TFTPService;

public abstract class AbstractBurnerWorker
extends WorkerUtility
implements IBurnerWorker,
SerialPortEventListener {
    protected static final String msg_BootFileNotFound = "Boot file not found!";
    protected static final String msg_FailedToReadBootFile = "Failed to read boot file!";
    protected static final String msg_TimeoutWhileReceiveCommandExecuteResult = c.ERROR_INFO_EXECUTE_COMMAND_TIME_OUT;
    protected static final String msg_ResendCommand = "Resend command...";
    protected static final String msg_SendCommand = "Send command";
    protected static final String msg_UserCancelled = "User Cancelled!";
    protected static final String FASTBOOT_NO_CURRENT_START = "*** Not upport current start mode";
    protected static final String FASTBOOT_REG_NAME = "Reg Name:";
    protected static final String FASTBOOT_NO_NAND_FLASH = "No NAND device found!!!";
    protected static final String FASTBOOT_NO_EMMC_FLASH = "No MMC/SD card detect when read `SDIO_CARD_DETECT` pin.";
    protected static final String FASTBOOT_START_OVER = "SDK Version:";
    protected static final String FASTBOOT_HAVE_SPI_FLASH = "Check spi flash controller v350. found";
    protected static final String FASTBOOT_HAVE_NAND_FLASH_MFCV100 = "NAND Check Flash Memory Controller v100 ... Found";
    protected static final String FASTBOOT_HAVE_NAND_FLASH_OTHER = "Check nand flash controller";
    protected static final String FASTBOOT_HAVE_EMMC_FLASH = "MMC/SD Card:";
    protected static final int HEX = 16;
    protected static final int FILE_BLOCK_SIZE_32 = 0x2000000;
    protected static final int FILE_BLOCK_SIZE_128 = 0x8000000;
    protected static final int EMMC_BLOCKSZIE = 512;
    protected static final int HI3231V530_BLOCKSZIE = 4096;
    protected static final int SEPARATE_CHUNKLEN = 0x500000;
    protected static final String DDRTRINING_SWL = "SWL";
    protected static final String DDRTRINING_SGA = "SGA";
    protected static final String DDRTRINING_HGA = "HGA";
    protected static final String DDRTRINING_HRD = "HRD";
    protected static final String DDRTRINING_SRD = "SRD";
    protected static final String DDRTRINING_SWD = "SWD";
    protected static final String DDRTRINING_DDR_FAILED = "DDR training failed";
    protected static final String BOOTROM_START = "Bootrom start";
    protected static final String BOOTROM_FROM_NAND = "Boot from NAND";
    protected static final String BOOTROM_FROM_EMMC = "Boot from eMMC";
    protected static final String BOOTROM_FROM_SD = "Boot from SD";
    protected static final String BOOTROM_READ_EMMC_ERROR = "Read eMMC error";
    protected static final String BOOTROM_READ_SD_ERROR = "Read SD error";
    protected static final String BOOTROM_MEDIA_SPI = "Boot Media: SPI";
    protected static final String BOOTROM_MEDIA_NAND = "Boot Media: NAND";
    protected static final String BOOTROM_MEDIA_SD = "Boot Media: SD";
    protected static final String BOOTROM_MEDIA_EMMC = "Boot Media: EMMC";
    protected static final String EMMC_INIT_ERR = "eMMC init error";
    protected static final String EMMC_READ_ERR = "eMMC read error";
    protected static final String EMMC_NORMAL_READ_ERR = "eMMC normal read error";
    protected static final String SD_INIT_ERR = "SD init error";
    protected static final String SD_READ_ERR = "SD read error";
    protected static final String SD_NORMAL_READ_ERR = "SD normal read error";
    protected static final String HEAD_AREA_FORMAT_ERR = "Head area format error";
    protected static final String VERIFY_KEY_AREA_FAILED = "Verify Key Area failed";
    protected static final String AUX_AREA_FORMAT_ERR = "Auxiliary area format error";
    protected static final String VERIFY_AUX_CODE_FAILED = "Verify Auxiliary Code failed";
    protected static final String VERIFY_AUX_AREA_FAILED = "Verify Auxiliary Area failed";
    protected static final String VERIFY_PARAM_AREA_FAILED = "Verify Param Area failed";
    protected static final String PARAM_LEN_ERR = "Param length error";
    protected static final String AUX_CODE_EXEC_FAILED = "Auxiliary code execution failed";
    protected static final String DDR_DDRE = "DDRE";
    protected static final String DDR_DDRTR = "DDRTR";
    protected static final String DDR_Err = "Err";
    protected static final String DDR_WL_ERR = "WL Err";
    protected static final String DDR_HWG_ERR = "HWG Err";
    protected static final String DDR_GATE_ERR = "Gate Err";
    protected static final String DDR_DDRT_ERR = "DDRT Err";
    protected static final String DDR_HWRD_ERR = "HWRD Err";
    protected static final String DDR_MPR_ERR = "MPR Err";
    protected static final String DDR_DATAEYE_ERR = "Dataeye Err";
    protected static final String FASTBOOT_START = "System startup";
    protected static final String REALLY_SCRUB = "Really scrub this NAND flash?";
    protected static final Map<String, Integer> lightCurrentStateMap = new HashMap<String, Integer>();
    private static LightView lightView = null;
    protected long spiBlockSize = 0L;
    protected long nandBlockSize = 0L;
    protected long pageSize = 0L;
    protected boolean isCaChipByLibBootrom = true;
    private static IViewPart view = null;
    private static OutputStream SERIAL_OUT;
    private static InputStream SERIAL_IN;
    private static SerialPort serialPort;
    private static String OWNER;
    private static final byte[] BREAK;
    public static final int LOOP = 1000;
    protected static final int TIME_FRAME_DATA = 150;
    protected static final int TIME_WAIT_FASTBOOT_INFO = 500;
    protected static final int TIMEOUT_PING = 5000;
    static int TIMEOUT_SEND_FRAME;
    static int TIMEOUT_SEND_FRAME_BOARD;
    private long lastLen = 0L;
    protected String fastbootFromFlash;
    protected IFrameSetting frameSetting;
    static IFastbootProgressMonitor monitor;
    protected IProgressMonitor uimonitor;
    protected IBurner burner;
    protected static final StringBuilder serialReceived;
    protected static final StringBuilder i2csReceived;
    protected static final StringBuilder usbsReceived;
    protected static final StringBuilder jtagReceived;
    protected static final String NEW_LINE = "\n";
    protected FileInfo[] fileList;
    protected int RETY_TIMES = 5;
    protected int receiveTimeout = 5000;
    private FlashType flashType;

    static {
        OWNER = "JAVA_FASTBOOT";
        BREAK = new byte[]{3};
        TIMEOUT_SEND_FRAME = 10000;
        TIMEOUT_SEND_FRAME_BOARD = 15000;
        serialReceived = new StringBuilder();
        i2csReceived = new StringBuilder();
        usbsReceived = new StringBuilder();
        jtagReceived = new StringBuilder();
    }

    public static int getTimeFrameCommand() {
        return FastbootPreferences.getInt("hisilicon.fastboot.commands.serial_command_timeout");
    }

    public static int getTimeFrameHead() {
        return FastbootPreferences.getInt("hisilicon.fastboot.commands.serial_command_timeout");
    }

    public AbstractBurnerWorker(IFrameSetting frameSetting) {
        this.frameSetting = frameSetting;
        if (q.b() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID) != null) {
            AbstractBurnerWorker.setView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID));
            if (view != null) {
                AbstractBurnerWorker.setLightView((LightView)view);
            }
        }
    }

    protected String getBootFrom(String received) {
        String KEY = "Boot Media: ";
        int startIndex = received.indexOf(KEY);
        if (-1 == startIndex) {
            return null;
        }
        int endIndex = received.indexOf("\r\n", startIndex += KEY.length());
        if (-1 == endIndex) {
            return null;
        }
        String strCapacity = received.substring(startIndex, endIndex);
        return strCapacity.trim();
    }

    protected String getVersionInfo(String operation) {
        StringBuffer buffer = new StringBuffer(NEW_LINE);
        String hiToolVersion = Platform.getProduct().getDefiningBundle().getVersion().toString();
        String hiBurnVersion = Activator.a().getBundle().getVersion().toString();
        buffer.append("Platform Version: " + hiToolVersion).append(NEW_LINE);
        buffer.append("HiBurn Version: " + hiBurnVersion.substring(0, hiBurnVersion.lastIndexOf("."))).append(NEW_LINE);
        String osName = System.getProperties().getProperty("os.name");
        buffer.append("OS Name: ").append(osName).append(NEW_LINE);
        String osArch = System.getProperty("os.arch");
        buffer.append("OS Arch: ").append(osArch).append(NEW_LINE);
        String osVersion = System.getProperty("os.version").toLowerCase(Locale.US);
        buffer.append("OS Version: ").append(osVersion).append(NEW_LINE);
        buffer.append("Operation: ").append(operation).append(NEW_LINE);
        buffer.append("ChipName: ").append(this.burner.getBurnContext().getDeviceSetting().getName()).append(NEW_LINE);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        buffer.append("TransferWay: ").append(transferWay.toString()).append(NEW_LINE);
        int jtagFrequency = this.burner.getBurnContext().getJtagFrequency();
        buffer.append("JtagFrequency: ").append(jtagFrequency).append(NEW_LINE);
        return buffer.toString();
    }

    protected String getHexStartAddress() {
        if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
            if (((o)this.frameSetting).a() == 0L) {
                return Integer.toHexString(this.frameSetting.getThirdFileAddress());
            }
            return Long.toHexString(((o)this.frameSetting).a());
        }
        return Integer.toHexString(this.frameSetting.getThirdFileAddress());
    }

    protected int getHexStartAddressForInt() {
        if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
            if (((o)this.frameSetting).a() == 0L) {
                return this.frameSetting.getThirdFileAddress();
            }
            return (int)((o)this.frameSetting).a();
        }
        return this.frameSetting.getThirdFileAddress();
    }

    @Override
    public SerialPort createConnection(String portName) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        boolean needInfoSerial;
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)portName);
        this.close();
        AbstractBurnerWorker.setSerialPort((SerialPort)portId.open(OWNER, 2000));
        this.getSerialPort().setSerialPortParams(115200, 8, 1, 0);
        this.getSerialPort().setFlowControlMode(0);
        this.getSerialPort().addEventListener((SerialPortEventListener)this);
        this.getSerialPort().notifyOnDataAvailable(true);
        AbstractBurnerWorker.setSERIAL_IN(this.getSerialPort().getInputStream());
        AbstractBurnerWorker.setSERIAL_OUT(this.getSerialPort().getOutputStream());
        boolean bl2 = needInfoSerial = !((q)this.burner.getBurnContext().getDeviceSetting()).h() && !((q)this.burner.getBurnContext().getDeviceSetting()).s() && !((q)this.burner.getBurnContext().getDeviceSetting()).t();
        if (needInfoSerial) {
            this.infoln(this.getStartMessage());
        }
        return this.getSerialPort();
    }

    public void returnError(String error) {
        if (monitor == null) {
            return;
        }
        FastbootEvent event = monitor.getEvent();
        if (event == null || event.isUserCanceled()) {
            return;
        }
        this.warningln(error);
        String message = event.getMessage();
        message = message != null ? String.valueOf(message) + NEW_LINE + error : error;
        event.setSuccess(false);
        event.setMessage(message);
    }

    protected String getStartMessage() {
        return NEW_LINE + c.ERROR_INFO_Start_PowerOn;
    }

    @Override
    public boolean close() {
        if (SERIAL_IN != null) {
            try {
                SERIAL_IN.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        if (SERIAL_OUT != null) {
            try {
                SERIAL_OUT.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        if (serialPort != null) {
            serialPort.close();
        }
        return true;
    }

    @Override
    public boolean burn(IBurner bunner, LocalConfig localConfig, BoardConfig boardConfig) {
        return true;
    }

    @Override
    public void setProgressMonitor(IFastbootProgressMonitor monitor) {
        AbstractBurnerWorker.setMonitor(monitor);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.uimonitor = monitor;
    }

    public boolean isDebug() {
        return FastbootPreferences.isDebugOn();
    }

    public SerialPort getSerialPort() {
        return serialPort;
    }

    public static void setSerialPort(SerialPort port) {
        serialPort = port;
    }

    protected void prepareFile() {
        this.fileList = this.frameSetting.prepareFile();
    }

    public void sendBreak() throws IOException {
        this.sendBytes(BREAK);
    }

    public boolean sendTailFrame(int seq) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBTailFrame(seq);
        }
        int[] buffer = new int[5];
        int crc = 0;
        buffer[0] = 237;
        buffer[1] = seq & 0xFF;
        buffer[2] = ~seq & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 3, 1);
        buffer[3] = crc >> 8 & 0xFF;
        buffer[4] = crc & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (this.isDebug()) {
                this.println("To send tail frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + 150 + "ms data is :");
                this.outputHex(convertToByte);
            }
            int timeout = TIMEOUT_SEND_FRAME;
            if (FastbootView.isHi3231Series()) {
                timeout = 200;
            }
            if (!(sendFrame = this.sendFrame(convertToByte, timeout, 150L)) && this.isDebug()) {
                this.println("Failed to send tail Frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public boolean sendUSBTailFrame(int seq) {
        int[] buffer = new int[]{237};
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, 150L);
            if (!sendFrame && this.isDebug()) {
                this.println("Failed to send tail Frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    protected byte[] convertToByte(int[] buffer) {
        byte[] bytes = new byte[buffer.length];
        int i2 = 0;
        while (i2 < buffer.length) {
            bytes[i2] = (byte)(buffer[i2] & 0xFF);
            ++i2;
        }
        return bytes;
    }

    protected void print(String message) {
        if (monitor != null) {
            monitor.print(message);
        } else {
            System.out.print(message);
        }
        this.log(message);
    }

    private void log(String str) {
        if (monitor != null) {
            monitor.log(str);
        }
    }

    public void println(String message) {
        this.print(String.valueOf(message) + NEW_LINE);
    }

    protected void receivedln(String received) {
        AbstractBurnerWorker.received(String.valueOf(received) + NEW_LINE);
    }

    protected static void received(String received) {
        if (monitor != null) {
            monitor.error(received);
            monitor.log(received);
        } else {
            System.err.print(received);
        }
    }

    protected void receivDebugInfo(String received) {
        if (monitor != null) {
            monitor.println(received);
        } else {
            System.out.print(received);
        }
    }

    protected void warning(String warning) {
        if (monitor != null) {
            monitor.warn(warning);
        } else {
            System.out.print(warning);
        }
        this.log(warning);
    }

    public void warningln(String warning) {
        this.warning(String.valueOf(warning) + NEW_LINE);
    }

    protected void info(String info) {
        if (monitor != null) {
            monitor.info(info);
        } else {
            System.out.print(info);
        }
        this.log(info);
    }

    public void infoln(String info) {
        if (info == null) {
            return;
        }
        this.info(String.valueOf(info) + NEW_LINE);
    }

    public boolean sendFrameForStart(byte[] data, long timeout, long frameTimeout) throws IOException {
        boolean isUSB;
        boolean bl2 = isUSB = this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude;
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom) {
            return this.sendI2cFrame(data, timeout, frameTimeout);
        }
        if (isUSB) {
            return this.sendUsbFrame(data, timeout, frameTimeout);
        }
        StringBuilder temp = new StringBuilder();
        if (this.getSerialPort() != null) {
            this.getSerialPort().notifyOnDataAvailable(false);
        }
        try {
            long startTime = System.currentTimeMillis();
            String hexdata = null;
            int sendCount = 0;
            while (System.currentTimeMillis() - startTime < timeout) {
                boolean handleCancel;
                if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                    return false;
                }
                if (this.getSerialPort() != null) {
                    this.onAdataAvailable(temp);
                }
                if (temp != null && temp.length() > 0) {
                    serialReceived.append((CharSequence)temp);
                }
                AbstractBurnerWorker.deleteContent(temp);
                if (this.sendBytes(data) != data.length) {
                    return false;
                }
                if (this.isDebug()) {
                    this.println("sendBytes" + ++sendCount + ": To send command frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand() + "ms data is :");
                    this.outputHex(data);
                }
                boolean recieving = true;
                long fTime = System.currentTimeMillis();
                block11: while (recieving && !this.uimonitor.isCanceled()) {
                    int receiveBytes;
                    if (System.currentTimeMillis() - fTime > frameTimeout) {
                        recieving = false;
                    }
                    if ((receiveBytes = this.receiveBytes(temp, 1)) != 1 && temp.length() <= 0) continue;
                    char charAt = temp.charAt(0);
                    if (this.isDebug()) {
                        String hexString = Integer.toHexString(0xFF & charAt);
                        this.println("Returned:" + hexString);
                    }
                    switch (charAt & 0xFF) {
                        case 170: {
                            temp.deleteCharAt(0);
                            return true;
                        }
                        case 85: {
                            this.onAdataAvailable(temp);
                            hexdata = this.getHexdata(temp);
                            if (hexdata != null && hexdata.length() > 0) {
                                this.println("NAK Returned:" + hexdata);
                            }
                            temp.deleteCharAt(0);
                            recieving = false;
                            if (!q.b()) continue block11;
                            this.updateSerialLightToError();
                            break;
                        }
                        default: {
                            if (temp.length() <= 0) continue block11;
                            temp.deleteCharAt(0);
                            fTime = System.currentTimeMillis();
                        }
                    }
                }
            }
        }
        finally {
            if (this.getSerialPort() != null) {
                this.getSerialPort().notifyOnDataAvailable(true);
            }
        }
        return false;
    }

    public boolean sendFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        boolean isI2C;
        boolean isUSB = this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude;
        boolean bl2 = isI2C = this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.Usb2I2c;
        if (isI2C) {
            return this.sendI2cFrame(data, timeout, frameTimeout);
        }
        if (isUSB) {
            return this.sendUsbFrame(data, timeout, frameTimeout);
        }
        return this.sendOtherFrame(data, timeout, frameTimeout);
    }

    private boolean sendOtherFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        StringBuilder temp = new StringBuilder();
        this.getSerialPort().notifyOnDataAvailable(false);
        try {
            long startTime = System.currentTimeMillis();
            String hexdata = null;
            while (System.currentTimeMillis() - startTime < timeout) {
                boolean handleCancel;
                if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                    return false;
                }
                this.onAdataAvailable(temp);
                if (temp != null && temp.length() > 0) {
                    serialReceived.append((CharSequence)temp);
                }
                AbstractBurnerWorker.deleteContent(temp);
                if (this.sendBytes(data) != data.length) {
                    return false;
                }
                boolean recieving = true;
                long fTime = System.currentTimeMillis();
                block11: while (recieving && !this.uimonitor.isCanceled()) {
                    int receiveBytes;
                    if (System.currentTimeMillis() - fTime > frameTimeout) {
                        recieving = false;
                    }
                    if ((receiveBytes = this.receiveBytes(temp, 1)) != 1 && temp.length() <= 0) continue;
                    char charAt = temp.charAt(0);
                    if (this.isDebug()) {
                        String hexString = Integer.toHexString(0xFF & charAt);
                        this.println("Returned:" + hexString);
                    }
                    switch (charAt & 0xFF) {
                        case 170: {
                            temp.deleteCharAt(0);
                            return true;
                        }
                        case 85: {
                            this.onAdataAvailable(temp);
                            hexdata = this.getHexdata(temp);
                            if (hexdata != null && hexdata.length() > 0) {
                                this.println("NAK Returned:" + hexdata);
                            }
                            temp.deleteCharAt(0);
                            recieving = false;
                            if (!q.b()) continue block11;
                            this.updateSerialLightToError();
                            break;
                        }
                        default: {
                            this.onAdataAvailable(temp);
                            hexdata = this.getHexdata(temp);
                            if (hexdata != null && hexdata.length() > 0) {
                                this.println("Unknown Returned:" + hexdata);
                            }
                            if (temp.length() <= 0) continue block11;
                            temp.deleteCharAt(0);
                            fTime = System.currentTimeMillis();
                        }
                    }
                }
            }
        }
        finally {
            this.getSerialPort().notifyOnDataAvailable(true);
        }
        return false;
    }

    public boolean sendI2cFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        StringBuilder temp = new StringBuilder();
        long startTime = System.currentTimeMillis();
        String hexdata = null;
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                this.receiveBytesByI2c(temp, 10);
                return false;
            }
            AbstractBurnerWorker.deleteContent(temp);
            I2cCommand.sendI2cCmdForBootrom(data.length, data, 0, null, 50, this);
            if (this.isDebug()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block5: while (recieving && !this.uimonitor.isCanceled()) {
                String hexString;
                boolean handleCancel2;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if (this.uimonitor.isCanceled() && (handleCancel2 = this.handleCancel())) {
                    this.receiveBytesByI2c(temp, 10);
                    return false;
                }
                boolean receiveResult = this.receiveBytesByI2c(temp, 1);
                if (!receiveResult || temp.length() <= 0) continue;
                char charAt = temp.charAt(0);
                if (this.isDebug() && !(hexString = Integer.toHexString(0xFF & charAt)).equalsIgnoreCase("0")) {
                    this.println("Returned:" + hexString);
                }
                switch (charAt & 0xFF) {
                    case 170: {
                        temp.deleteCharAt(0);
                        return true;
                    }
                    case 85: {
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("NAK Returned:" + hexdata);
                        }
                        temp.deleteCharAt(0);
                        recieving = false;
                        break;
                    }
                    default: {
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("Unknown Returned:" + hexdata);
                        }
                        if (temp == null || temp.length() <= 0) continue block5;
                        if (temp.charAt(0) != '\u0000') {
                            fTime = System.currentTimeMillis();
                        }
                        temp.deleteCharAt(0);
                    }
                }
            }
        }
        return false;
    }

    public boolean sendUsbDataFrame(byte[] data, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        if (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            boolean sendDataByUsb = CallLibUSBWorker.sendDataByUsb(data, data.length);
            if (this.isDebug()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            return sendDataByUsb;
        }
        return false;
    }

    public boolean sendUsbFrame(byte[] data, long timeout, long frameTimeout) throws IOException {
        StringBuilder temp = new StringBuilder();
        String hexdata = null;
        boolean openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout);
        if (!openUsbResult) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeout) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            AbstractBurnerWorker.deleteContent(temp);
            boolean sendDataByUsb = CallLibUSBWorker.sendDataByUsb(data, data.length);
            if (!sendDataByUsb) {
                this.returnError(c.ERROR_USB_SEND_DATA_FAILED);
                return false;
            }
            if (this.isDebug()) {
                this.println("Debug: Send data is :");
                this.outputHex(data);
            }
            boolean recieving = true;
            long fTime = System.currentTimeMillis();
            block5: while (recieving && !this.uimonitor.isCanceled()) {
                String hexString;
                boolean handleCancel2;
                if (System.currentTimeMillis() - fTime > frameTimeout) {
                    recieving = false;
                }
                if (this.uimonitor.isCanceled() && (handleCancel2 = this.handleCancel())) {
                    return false;
                }
                boolean receiveResult = this.receiveBytesByUsb(temp, 2);
                if (!receiveResult || temp.length() <= 0) continue;
                char charAt = temp.charAt(0);
                if (this.isDebug() && !(hexString = Integer.toHexString(0xFF & charAt)).equalsIgnoreCase("0")) {
                    this.println("Returned:" + hexString);
                }
                switch (charAt & 0xFF) {
                    case 170: {
                        temp.deleteCharAt(0);
                        return true;
                    }
                    case 85: {
                        hexdata = this.getHexdata(temp);
                        if (hexdata != null && hexdata.length() > 0) {
                            this.println("NAK Returned:" + hexdata);
                        }
                        temp.deleteCharAt(0);
                        recieving = false;
                        break;
                    }
                    default: {
                        if (temp.length() <= 0) continue block5;
                        temp.deleteCharAt(0);
                        fTime = System.currentTimeMillis();
                    }
                }
            }
        }
        return false;
    }

    public boolean sendJtagCmd(byte[] data, long timeout) throws IOException {
        boolean handleCancel;
        if (this.uimonitor != null && this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
            return false;
        }
        AbstractBurnerWorker.deleteContent(jtagReceived);
        if (this.isDebug()) {
            this.println("Debug: Send data is :");
            this.outputHex(data);
        }
        String cmdResult = CallLibJTAGWorker.sendCmdByJtag(data, data.length, timeout);
        jtagReceived.append(cmdResult);
        return true;
    }

    private String getHexdata(StringBuilder temp) {
        if (temp.length() > 0) {
            StringBuilder sb = new StringBuilder();
            int i2 = 0;
            while (i2 < temp.length()) {
                String hexString = Integer.toHexString(0xFF & temp.charAt(i2));
                if (hexString.length() == 2) {
                    sb.append(hexString).append(",");
                } else {
                    sb.append("0").append(hexString).append(",");
                }
                ++i2;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        return null;
    }

    private void outputHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = data;
        int n2 = data.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b2 = byArray[n3];
            String hexString = Integer.toHexString(0xFF & b2);
            if (hexString.length() == 2) {
                sb.append(hexString).append(",");
            } else {
                sb.append("0").append(hexString).append(",");
            }
            ++n3;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.println(sb.toString());
    }

    public boolean handleCancel() {
        try {
            this.sendBreak();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.warningln("\nUser Cancelled!");
        if (monitor == null) {
            return true;
        }
        FastbootEvent event = monitor.getEvent();
        if (event == null) {
            return true;
        }
        event.setUserCanceled(true);
        event.setSuccess(false);
        event.setMessage(msg_UserCancelled);
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadFile(SubProgressMonitor subProgressMonitor) {
        try {
            if (q.b()) {
                this.initLightState();
            }
            if (this.fileList == null) {
                return false;
            }
            total = 0;
            i = 0;
            while (i < this.fileList.length) {
                total += this.fileList[i].getLength();
                ++i;
            }
            totalOffset = 0;
            rateLast = 0.0;
            sendDataSize = this.getSendDataSize();
            frameCount = total / sendDataSize + 10;
            subProgressMonitor.beginTask("", frameCount);
            subProgressMonitor.setTaskName("Downloading File");
            AbstractBurnerWorker.deleteContent(AbstractBurnerWorker.serialReceived);
            AbstractBurnerWorker.deleteContent(AbstractBurnerWorker.i2csReceived);
            AbstractBurnerWorker.deleteContent(AbstractBurnerWorker.usbsReceived);
            AbstractBurnerWorker.deleteContent(AbstractBurnerWorker.jtagReceived);
            if (!this.sendStartFrame(this.fileList[0])) {
                this.updateSerialLightToError();
                this.readBootromInfoNACK(AbstractBurnerWorker.serialReceived.toString());
                this.returnError(c.ERROR_INFO_Failed_To_Send_Start_Frame);
                return false;
            }
            this.updateSerialLightToRight();
            this.readBootromInfoAck(AbstractBurnerWorker.serialReceived.toString());
            if (this.getFlashType() != AbstractBurnerWorker.DDR || !FastbootView.isHi3518EV300Series()) ** GOTO lbl42
            infocmd = "usbdown ";
            try {
                if (!this.sendCommand(infocmd)) {
                    this.returnError("Failed to send command " + infocmd + ". ");
                    return false;
                }
                ** GOTO lbl42
            }
            catch (ReceiveTimeOutException e) {
                try {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
lbl42:
                // 4 sources

                subProgressMonitor.worked(1);
                offset = 0;
                leftLength = 0;
                seq = 0;
                currentLen = 0;
                realFileData = null;
                tosend = null;
                fileData = null;
                fileInfo = null;
                isDDrTrainingOver = false;
                emmcType = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
                i = 0;
                ** while (i < this.fileList.length)
            }
lbl-1000:
            // 1 sources

            {
                fileInfo = this.fileList[i];
                if (!this.sendHeadFrame(fileInfo)) {
                    this.updateSerialLightToError();
                    this.readBootromAndDDrNAck(AbstractBurnerWorker.serialReceived.toString());
                    this.returnError(c.ERROR_INFO_Failed_To_Send_Head_Frame);
                    return false;
                }
                this.updateSerialLightToRight();
                this.readBootromAndDDrAck(AbstractBurnerWorker.serialReceived.toString());
                subProgressMonitor.worked(1);
                delay = 300;
                isDDrTrainingOver = this.getDDRTrainingOver(fileInfo, emmcType, i);
                fileData = fileInfo.getData();
                realFileData = Arrays.copyOfRange(fileData, 0, fileInfo.getLength());
                leftLength = realFileData.length;
                seq = 1;
                offset = 0;
                while (leftLength > 0) {
                    currentLen = Math.min(sendDataSize, leftLength);
                    tosend = Arrays.copyOfRange(realFileData, offset, offset + currentLen);
                    if (!this.sendDataFrame(seq++, tosend)) {
                        this.updateSerialLightToError();
                        this.returnError(c.ERROR_INFO_Failed_To_Send_Data_Frame);
                        return false;
                    }
                    v0 = needUpdateLight = q.b() != false && AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
                    if (needUpdateLight) {
                        this.updateSerialLightToRight();
                    }
                    leftLength -= tosend.length;
                    offset += tosend.length;
                    AbstractBurnerWorker.received("#");
                    temp = (double)(totalOffset += tosend.length) * 100.0 / (double)total;
                    v1 = isPrint = temp - rateLast >= 10.0 && (int)temp != 100;
                    if (isPrint) {
                        this.receivedln(" ---- " + (int)temp + "%");
                        rateLast = temp;
                    }
                    subProgressMonitor.worked(1);
                }
                if (!this.sendTailFrame(seq)) {
                    if (q.b()) {
                        this.updateSerialLightToError();
                    }
                    this.returnError(c.ERROR_INFO_Failed_To_Send_Tail_Frame);
                    return false;
                }
                v2 = needUpdateLight = q.b() != false && AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
                if (needUpdateLight) {
                    this.updateSerialLightToRight();
                }
                if (isDDrTrainingOver) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        this.warningln("Error occurs while waiting DDR run.");
                        subProgressMonitor.done();
                        return false;
                    }
                    this.outDdrTrainingInfo(AbstractBurnerWorker.serialReceived.toString());
                    isDDrTrainingOver = false;
                }
                subProgressMonitor.worked(1);
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        this.warningln("Error occurs while waiting DDR run.");
                        subProgressMonitor.done();
                        return false;
                    }
                }
                ++i;
                continue;
            }
lbl120:
            // 1 sources

            this.receivedln(" ---- 100%");
            return true;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private boolean getDDRTrainingOver(FileInfo fileInfo, int emmcType, int i2) {
        if (this.burner.getBurnContext().getPlatformType() != PlatformType.CA) {
            boolean stepFileLen;
            boolean bl2 = stepFileLen = emmcType == 2 && fileInfo.getLength() == 20224 || fileInfo.getLength() == 21504 || fileInfo.getLength() == 29696;
            if (stepFileLen) {
                return true;
            }
            if (((q)this.burner.getBurnContext().getDeviceSetting()).l() && i2 == 1) {
                return true;
            }
        }
        return false;
    }

    private int getSendDataSize() {
        boolean isUSBTransWay;
        int sendDataSize = 1024;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl2 = isUSBTransWay = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        if (isUSBTransWay) {
            sendDataSize = 511;
        } else if (FastbootView.isHi3731Series()) {
            sendDataSize = 16384;
        }
        return sendDataSize;
    }

    public boolean downloadFile() {
        if (q.b()) {
            this.initLightState();
        }
        int total = 0;
        int i2 = 0;
        while (i2 < this.fileList.length) {
            total += this.fileList[i2].getLength();
            ++i2;
        }
        int totalOffset = 0;
        double rateLast = 0.0;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        if (!this.sendStartFrame(this.fileList[0])) {
            this.updateSerialLightToError();
            this.readBootromInfoNACK(serialReceived.toString());
            this.returnError(c.ERROR_INFO_Failed_To_Send_Start_Frame);
            return false;
        }
        this.updateSerialLightToRight();
        this.readBootromInfoAck(serialReceived.toString());
        int offset = 0;
        int leftLength = 0;
        int seq = 0;
        int currentLen = 0;
        byte[] realFileData = null;
        byte[] tosend = null;
        byte[] fileData = null;
        FileInfo fileInfo = null;
        int sendDataSize = this.getSendDataSize();
        int i3 = 0;
        while (i3 < this.fileList.length) {
            boolean needUpdateLight;
            fileInfo = this.fileList[i3];
            if (!this.sendHeadFrame(fileInfo)) {
                this.updateSerialLightToError();
                this.readBootromAndDDrNAck(serialReceived.toString());
                this.returnError(c.ERROR_INFO_Failed_To_Send_Head_Frame);
                return false;
            }
            this.updateSerialLightToRight();
            this.readBootromAndDDrAck(serialReceived.toString());
            fileData = fileInfo.getData();
            realFileData = Arrays.copyOfRange(fileData, 0, fileInfo.getLength());
            leftLength = realFileData.length;
            seq = 1;
            offset = 0;
            while (leftLength > 0) {
                boolean isPrint;
                boolean needUpdateLight2;
                currentLen = Math.min(sendDataSize, leftLength);
                tosend = Arrays.copyOfRange(realFileData, offset, offset + currentLen);
                if (!this.sendDataFrame(seq++, tosend)) {
                    this.updateSerialLightToError();
                    this.returnError(c.ERROR_INFO_Failed_To_Send_Data_Frame);
                    return false;
                }
                boolean bl2 = needUpdateLight2 = q.b() && lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
                if (needUpdateLight2) {
                    this.updateSerialLightToRight();
                }
                leftLength -= tosend.length;
                offset += tosend.length;
                AbstractBurnerWorker.received("#");
                double temp = (double)(totalOffset += tosend.length) * 100.0 / (double)total;
                boolean bl3 = isPrint = temp - rateLast >= 10.0 && (int)temp != 100;
                if (!isPrint) continue;
                this.receivedln(" ---- " + (int)temp + "%");
                rateLast = temp;
            }
            if (!this.sendTailFrame(seq)) {
                if (FastbootView.isHi3231Series()) break;
                this.updateSerialLightToError();
                this.returnError(c.ERROR_INFO_Failed_To_Send_Tail_Frame);
                return false;
            }
            boolean bl4 = needUpdateLight = q.b() && lightCurrentStateMap.get(Light_E.SERIAL.name()) != null && lightCurrentStateMap.get(Light_E.SERIAL.name()).intValue() == Light_State_E.abnormal.ordinal();
            if (needUpdateLight) {
                this.updateSerialLightToRight();
            }
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    this.warningln("Error occurs while waiting DDR run.");
                    return false;
                }
            }
            ++i3;
        }
        this.receivedln(" ---- 100%");
        return true;
    }

    public boolean sendDataFrame(int seq, byte[] pBuffer) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBDataFrame(seq, pBuffer);
        }
        int len = pBuffer.length;
        int dwSendLength = len + 5;
        int[] pSendBuffer = new int[dwSendLength];
        int crc = 0;
        pSendBuffer[0] = 218;
        pSendBuffer[1] = seq & 0xFF;
        pSendBuffer[2] = ~seq & 0xFF;
        int i2 = 0;
        while (i2 < len) {
            pSendBuffer[i2 + 3] = pBuffer[i2] & 0xFF;
            ++i2;
        }
        crc = AbstractBurnerWorker.calc_crc16(pSendBuffer, len + 3, 1);
        pSendBuffer[3 + len] = crc >> 8 & 0xFF;
        pSendBuffer[4 + len] = crc & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(pSendBuffer);
            if (this.isDebug()) {
                this.println("To send data frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + 150 + "ms data is :");
                this.outputHex(convertToByte);
            }
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, 150L);
            if (this.isDebug() && !sendFrame) {
                this.println("Failed to send data frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    public boolean sendUSBDataFrame(int seq, byte[] pBuffer) {
        int len = pBuffer.length;
        int dwSendLength = len + 1;
        int[] pSendBuffer = new int[dwSendLength];
        pSendBuffer[0] = 218;
        int i2 = 0;
        while (i2 < len) {
            pSendBuffer[i2 + 1] = pBuffer[i2] & 0xFF;
            ++i2;
        }
        try {
            byte[] convertToByte = this.convertToByte(pSendBuffer);
            boolean sendFrame = this.sendUsbDataFrame(convertToByte, TIMEOUT_SEND_FRAME);
            if (this.isDebug() && !sendFrame) {
                this.println("Failed to send data frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    public boolean sendStartFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        int crc = 0;
        int[] buffer = new int[14];
        int length = 0;
        int address = 0;
        if (FastbootView.isHi3731Series()) {
            length = 16384;
            address = -559064486;
        } else {
            length = fileInfo.getLength();
            address = fileInfo.getAddress();
        }
        buffer[0] = 254;
        buffer[1] = 0;
        buffer[2] = 255;
        buffer[3] = 1;
        buffer[4] = length >> 24 & 0xFF;
        buffer[5] = length >> 16 & 0xFF;
        buffer[6] = length >> 8 & 0xFF;
        buffer[7] = length & 0xFF;
        buffer[8] = address >> 24 & 0xFF;
        buffer[9] = address >> 16 & 0xFF;
        buffer[10] = address >> 8 & 0xFF;
        buffer[11] = address & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 12, 1);
        buffer[12] = crc >> 8 & 0xFF;
        buffer[13] = crc & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (this.isDebug()) {
                this.println("To send start frame, send timeout=30s, wait response timeout=13ms data is :");
                this.outputHex(convertToByte);
            }
            if (!(sendFrame = this.sendFrameForStart(convertToByte, 30000L, 13L)) && this.isDebug()) {
                this.println("Failed to send start frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    public boolean sendUSBStartFrame() {
        int length;
        int[] buffer = new int[9];
        int address = length = bf.a();
        buffer[0] = 254;
        buffer[1] = length >> 24 & 0xFF;
        buffer[2] = length >> 16 & 0xFF;
        buffer[3] = length >> 8 & 0xFF;
        buffer[4] = length & 0xFF;
        buffer[5] = address >> 24 & 0xFF;
        buffer[6] = address >> 16 & 0xFF;
        buffer[7] = address >> 8 & 0xFF;
        buffer[8] = address & 0xFF;
        try {
            boolean sendFrame;
            byte[] convertToByte = this.convertToByte(buffer);
            if (this.isDebug()) {
                this.println("To send start frame, send timeout=30s, wait response timeout=13ms data is :");
                this.outputHex(convertToByte);
            }
            if (!(sendFrame = this.sendFrameForStart(convertToByte, 30000L, 13L)) && this.isDebug()) {
                this.println("Failed to send start frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    boolean sendHeadFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBHeadFrame(fileInfo);
        }
        if (this.isDebug()) {
            this.println("Send head frame...");
        }
        int crc = 0;
        int[] buffer = new int[14];
        int length = fileInfo.getLength();
        int address = fileInfo.getAddress();
        buffer[0] = 254;
        buffer[1] = 0;
        buffer[2] = 255;
        buffer[3] = 1;
        buffer[4] = length >> 24 & 0xFF;
        buffer[5] = length >> 16 & 0xFF;
        buffer[6] = length >> 8 & 0xFF;
        buffer[7] = length & 0xFF;
        buffer[8] = address >> 24 & 0xFF;
        buffer[9] = address >> 16 & 0xFF;
        buffer[10] = address >> 8 & 0xFF;
        buffer[11] = address & 0xFF;
        crc = AbstractBurnerWorker.calc_crc16(buffer, 12, 1);
        buffer[12] = crc >> 8 & 0xFF;
        buffer[13] = crc & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            if (this.isDebug()) {
                this.println("To send head frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameHead() + "ms data is :");
                this.outputHex(convertToByte);
            }
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameHead());
            if (this.isDebug() && !sendFrame) {
                this.println("Failed to send head frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    boolean sendUSBHeadFrame(FileInfo fileInfo) {
        if (this.isDebug()) {
            this.println("Send head frame...");
        }
        int[] buffer = new int[9];
        int length = fileInfo.getLength();
        int address = fileInfo.getAddress();
        buffer[0] = 254;
        buffer[1] = length >> 24 & 0xFF;
        buffer[2] = length >> 16 & 0xFF;
        buffer[3] = length >> 8 & 0xFF;
        buffer[4] = length & 0xFF;
        buffer[5] = address >> 24 & 0xFF;
        buffer[6] = address >> 16 & 0xFF;
        buffer[7] = address >> 8 & 0xFF;
        buffer[8] = address & 0xFF;
        try {
            byte[] convertToByte = this.convertToByte(buffer);
            boolean sendFrame = this.sendFrame(convertToByte, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameHead());
            if (this.isDebug() && !sendFrame) {
                this.println("Failed to send head frame");
            }
            return sendFrame;
        }
        catch (IOException e2) {
            this.warningln(e2.getMessage());
            return false;
        }
    }

    public boolean prepareFile(String filePath) throws IOException {
        File file;
        if (this.isDebug()) {
            this.println("Preparing File " + filePath);
        }
        if (!(file = new File(filePath)).exists()) {
            this.returnError(msg_BootFileNotFound);
            return false;
        }
        this.fileList = this.frameSetting.prepareFile(file, this.getFlashType());
        return true;
    }

    public boolean prepareProgrammerFile(String filePath) throws IOException {
        File file;
        if (this.isDebug()) {
            this.println("Preparing File " + filePath);
        }
        if (!(file = new File(filePath)).exists()) {
            this.returnError(msg_BootFileNotFound);
            return false;
        }
        this.fileList = this.frameSetting.prepareProgrammerFile(file);
        return true;
    }

    public boolean sendCommand(String command) throws IOException, ReceiveTimeOutException {
        return this.sendCommand(command, 5000L);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean sendCommand(SerialCommand command) throws IOException, ReceiveTimeOutException {
        if (command instanceof TFTPCommand) {
            block16: {
                result = false;
                totalTimeout = command.getTimeout();
                receiveTimeout = (long)FastbootPreferences.getInt("hisilicon.fastboot.tftp.timeout.noresponse") * 1000L;
                retryCount = FastbootPreferences.getInt("hisilicon.fastboot.tftp.retry.count");
                if (this.isDebug()) {
                    sb = new StringBuilder();
                    sb.append("sending tftp command :" + command.getCommand() + "\t no response timeout is " + receiveTimeout + "ms");
                    sb.append(" \t total timeout is " + totalTimeout + "ms");
                    sb.append(" \t retry count is " + retryCount);
                    this.println(sb.toString());
                }
                try {
                    result = this.sendTFTPCommand(command.getCommand(), totalTimeout, receiveTimeout);
                    break block16;
                }
                catch (ReceiveTimeOutException e) {
                    loop = retryCount;
                    ** while (--loop > 0 && !result)
                }
lbl-1000:
                // 1 sources

                {
                    if (AbstractBurnerWorker.monitor.getEvent().isUserCanceled()) {
                        return false;
                    }
                    this.sendBreak();
                    this.warningln("\n" + c.ERROR_INFO_Failed_To_Execute_TFTPCommand);
                    this.warningln("Resend command...");
                    isSupportTFTPWin = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
                    v0 = needReduceWinSize = isSupportTFTPWin != false && FastbootPreferences.isOpenTftpWindowSize() != false && TFTPService.getWinSizeBlockCount() > 0 && TFTPService.getWinSizeBlockCount() > 1;
                    if (needReduceWinSize) {
                        TFTPService.setWinSizeBlockCount((int)(TFTPService.getWinSizeBlockCount() - 1));
                        this.infoln("The current Window Size value is " + (TFTPService.getWinSizeBlockCount() + 1));
                    } else {
                        TFTPService.setWinSizeBlockCount((int)1);
                    }
                    try {
                        result = this.sendTFTPCommand(command.getCommand(), totalTimeout * (long)(retryCount - loop + 1), receiveTimeout * (long)(retryCount - loop + 1));
                    }
                    catch (ReceiveTimeOutException var12_12) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (!result) {
                this.returnError(c.ERROR_INFO_Failed_To_Execute_TFTPCommand);
                if (q.b()) {
                    AbstractBurnerWorker.lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.abnormal.ordinal());
                    if (AbstractBurnerWorker.getLightView() != null) {
                        this.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), AbstractBurnerWorker.lightCurrentStateMap.get(Light_E.TFTP.name()));
                    }
                }
                throw new ReceiveTimeOutException(c.ERROR_INFO_Failed_To_Execute_TFTPCommand);
            }
            AbstractBurnerWorker.monitor.getEvent().setMessage(null);
            return result;
        }
        if (command instanceof SFCommand) {
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException var2_3) {
                // empty catch block
            }
            return this.sendCommand(command.getCommand(), command.getTimeout());
        }
        return this.sendCommand(command.getCommand(), command.getTimeout());
    }

    public boolean sendCommandNoReturnValue(String command) throws IOException, ReceiveTimeOutException {
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        if (!this.sendCmdByTrans(command, TIMEOUT_SEND_FRAME)) {
            return false;
        }
        this.infoln(String.valueOf(command) + " success!");
        return true;
    }

    protected boolean sendCommandDontCareEOT(String command, long timeout) throws IOException, ReceiveTimeOutException {
        boolean hasError;
        boolean hasEOT;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        if (!this.sendCmdByTrans(command, timeout)) {
            return false;
        }
        boolean reading = true;
        long receiveTime = System.currentTimeMillis();
        String temp = this.getCurReceived();
        int offset = 0;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - receiveTime > timeout) {
                boolean hasLoadOrUplo;
                StringBuilder sb = new StringBuilder(msg_TimeoutWhileReceiveCommandExecuteResult);
                sb.append("(").append(command);
                if (Platform.inDebugMode()) {
                    sb.append("\ttimeout=").append(timeout / 1000L).append("s");
                }
                sb.append(")");
                if (Platform.inDebugMode()) {
                    this.warningln(sb.toString());
                }
                boolean bl2 = hasLoadOrUplo = command.startsWith("load") || command.startsWith("uplo");
                if (hasLoadOrUplo) {
                    return true;
                }
                throw new ReceiveTimeOutException(sb.toString());
            }
            temp = this.getCurReceived();
            if (temp.length() > offset) {
                int length = temp.length();
                CharSequence subSequence = temp.subSequence(offset, length);
                offset += subSequence.length();
                AbstractBurnerWorker.received(subSequence.toString());
            }
            if (temp.indexOf("[EOT]") != -1) break;
        }
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            return false;
        }
        receiveTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - receiveTime < 1000L) {
            if (this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1 || temp.indexOf("[EOT](ERROR)") != -1) break;
        }
        boolean bl3 = hasEOT = temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](O") != -1 || temp.indexOf("[EOT](ERROR)") == -1 && temp.indexOf("[EOT](E") != -1;
        if (hasEOT) {
            receiveTime = System.currentTimeMillis();
            while (temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](ERROR)") == -1 && System.currentTimeMillis() - receiveTime < 1000L) {
                if (this.uimonitor.isCanceled()) {
                    this.sendBreak();
                    this.handleCancel();
                    return false;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException subSequence) {
                    // empty catch block
                }
                temp = this.getCurReceived();
            }
        }
        if ((temp = this.getCurReceived()).length() > offset) {
            int length = temp.length();
            CharSequence subSequence = temp.subSequence(offset, length);
            AbstractBurnerWorker.received(subSequence.toString());
        }
        boolean bl4 = hasError = temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1;
        return !hasError;
    }

    protected boolean sendCommand(String command, long timeout) throws IOException, ReceiveTimeOutException {
        boolean hasError;
        boolean hasEOT;
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + command);
        if (this.isDebug()) {
            this.println("\nIf your boot is not the lastest one, \nthere may be non-answer from board during executing command.\nPlease be patient for waiting.\nThe time may be :\t" + timeout / 1000L + "s.");
        }
        if (!this.sendCmdByTrans(command, timeout)) {
            return false;
        }
        boolean reading = true;
        long receiveTime = System.currentTimeMillis();
        String temp = this.getCurReceived();
        if ("usbtftp error".equals(command) || "usbtftp end".equals(command) || "usbtftp start".equals(command)) {
            reading = false;
        }
        int offset = 0;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - receiveTime > timeout) {
                boolean isLoadOrUplo;
                StringBuilder sb = new StringBuilder(msg_TimeoutWhileReceiveCommandExecuteResult);
                sb.append("(").append(command);
                if (Platform.inDebugMode()) {
                    sb.append("\ttimeout=").append(timeout / 1000L).append("s");
                }
                sb.append(")");
                if (Platform.inDebugMode()) {
                    this.warningln(sb.toString());
                }
                boolean bl2 = isLoadOrUplo = command.startsWith("load") || command.startsWith("uplo");
                if (isLoadOrUplo) {
                    return true;
                }
                if (this.getCurReceived().contains(REALLY_SCRUB)) {
                    String y2 = "y\r";
                    if (this.sendBytes(y2.getBytes(System.getProperty("file.encoding"))) != y2.length()) {
                        return false;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    break;
                }
                if (this.isDebug()) {
                    this.println("\nSend command timeout : " + sb.toString());
                }
                throw new ReceiveTimeOutException(sb.toString());
            }
            temp = this.getCurReceived();
            if (temp.length() > offset) {
                int length = temp.length();
                CharSequence subSequence = temp.subSequence(offset, length);
                offset += subSequence.length();
                AbstractBurnerWorker.received(subSequence.toString());
            }
            if (temp.indexOf("[EOT]") != -1) break;
        }
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            this.returnError(c.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        receiveTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - receiveTime < 3000L) {
            if (this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1 || temp.indexOf("[EOT](ERROR)") != -1) break;
        }
        boolean bl3 = hasEOT = temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](O") != -1 || temp.indexOf("[EOT](ERROR)") == -1 && temp.indexOf("[EOT](E") != -1;
        if (hasEOT) {
            receiveTime = System.currentTimeMillis();
            while (temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](ERROR)") == -1 && System.currentTimeMillis() - receiveTime < 1000L) {
                if (this.uimonitor.isCanceled()) {
                    this.sendBreak();
                    this.handleCancel();
                    return false;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException subSequence) {
                    // empty catch block
                }
                temp = this.getCurReceived();
            }
        }
        if ((temp = this.getCurReceived()).length() > offset) {
            int length = temp.length();
            CharSequence subSequence = temp.subSequence(offset, length);
            AbstractBurnerWorker.received(subSequence.toString());
        }
        boolean bl4 = hasError = temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1;
        if (hasError) {
            this.returnError(c.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        return true;
    }

    private boolean sendCmdByTrans(String command, long timeout) throws IOException {
        boolean isJTAG;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        boolean bl2 = isJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isUSB) {
            byte[] cmdFrame = this.convertToByte(AbstractBurnerWorker.getUSBCommandFrame(command));
            if (this.isDebug()) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("To send command frame, send timeout=");
                sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
                sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
                sBuilder.append("ms data is :");
                this.println(sBuilder.toString());
                this.outputHex(cmdFrame);
            }
            long curTimeout = TIMEOUT_SEND_FRAME;
            curTimeout = timeout < (long)TIMEOUT_SEND_FRAME ? (long)TIMEOUT_SEND_FRAME : timeout;
            boolean commandResult = this.sendUsbDataFrame(cmdFrame, curTimeout);
            if (!commandResult) {
                if (this.isDebug()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
        } else if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3716mv420b03 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3231V520) {
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] commandBytes = command.getBytes(System.getProperty("file.encoding"));
            boolean cmdResult = this.sendJtagCmd(commandBytes, timeout);
            if (!cmdResult) {
                this.println("Failed to send jtag command.");
                return false;
            }
        } else {
            boolean commandFrame;
            boolean commandHeadFrame;
            byte[] headFrame = this.convertToByte(AbstractBurnerWorker.getCommandHeadFrame(command));
            if (this.isDebug()) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("To send command head frame, send timeout=");
                sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
                sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
                sBuilder.append("ms data is :");
                this.println(sBuilder.toString());
                this.outputHex(headFrame);
            }
            if (!(commandHeadFrame = this.sendFrame(headFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
                if (this.isDebug()) {
                    this.println("Failed to send command head frame");
                }
                return false;
            }
            AbstractBurnerWorker.deleteContent(serialReceived);
            AbstractBurnerWorker.deleteContent(i2csReceived);
            AbstractBurnerWorker.deleteContent(usbsReceived);
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] cmdFrame = this.convertToByte(AbstractBurnerWorker.getCommandFrame(command));
            if (this.isDebug()) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("To send command frame, send timeout=");
                sBuilder.append(TIMEOUT_SEND_FRAME / 1000);
                sBuilder.append("s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand());
                sBuilder.append("ms data is :");
                this.println(sBuilder.toString());
                this.outputHex(cmdFrame);
            }
            if (!(commandFrame = this.sendFrame(cmdFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
                if (this.isDebug()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
        }
        return true;
    }

    public String getCurUsbCommonReceived() {
        boolean isUSB;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean bl2 = isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        if (isUSB) {
            return usbsReceived.toString();
        }
        return null;
    }

    public String getCurReceived() {
        StringBuilder temp;
        block11: {
            boolean isJTAG;
            temp = new StringBuilder();
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            boolean isI2C = transferWay == TransferWay.I2CBootrom;
            boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
            boolean bl2 = isJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
            if (isI2C) {
                try {
                    this.receiveBytesByI2c(i2csReceived, 1024);
                    if (i2csReceived.toString() != null && !i2csReceived.toString().isEmpty()) {
                        temp.append(i2csReceived.toString());
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            } else if (isUSB) {
                try {
                    this.receiveBytesByUsbIgnore(usbsReceived, 1024);
                    if (usbsReceived.toString() == null || usbsReceived.toString().isEmpty()) break block11;
                    temp.append(usbsReceived.toString());
                    if (temp.length() > 0) {
                        temp.deleteCharAt(0);
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            } else {
                if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3716mv420b03 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3231V520) {
                    return jtagReceived.toString();
                }
                return serialReceived.toString();
            }
        }
        return temp.toString();
    }

    protected boolean sendTFTPCommand(String tftpcommand, long totalTimeout, long receiveTime) throws IOException, ReceiveTimeOutException {
        TransferWay transferWay;
        boolean isJTAG;
        String losingPackageCheck = null;
        if (FastbootPreferences.isTftpIgnoreBlockAck()) {
            StringBuilder sb = new StringBuilder();
            int n2 = FastbootPreferences.getInt("hisilicon.fastboot.tftp.losingpackage.count");
            while (n2 > 0) {
                sb.append("T ");
                --n2;
            }
            losingPackageCheck = sb.toString();
        }
        if (this.isDebug()) {
            this.println("losingPackageCheck=\t'" + losingPackageCheck + "'");
        }
        AbstractBurnerWorker.deleteContent(serialReceived);
        AbstractBurnerWorker.deleteContent(i2csReceived);
        AbstractBurnerWorker.deleteContent(usbsReceived);
        AbstractBurnerWorker.deleteContent(jtagReceived);
        this.infoln("\nSend command:\t" + tftpcommand);
        if (this.isDebug()) {
            this.println("\nIf your boot is not the lastest one, \nthere may be non-answer from board during executing command.\nPlease be patient for waiting.\nThe total time may be :\t" + totalTimeout / 1000L + "s, receiveTimeout is " + receiveTime / 1000L + "s");
        }
        boolean bl2 = isJTAG = (transferWay = this.burner.getBurnContext().getTransferWay()) == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isJTAG && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3716mv420b03 && FastbootView.getJtagChipTypeByChipName() != LibJTAGByJNA.EJtagChipType.hi3231V520) {
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] commandBytes = tftpcommand.getBytes(System.getProperty("file.encoding"));
            boolean cmdResult = this.sendJtagCmd(commandBytes, totalTimeout);
            if (!cmdResult) {
                this.println("Failed to send jtag tftp command.");
                return false;
            }
        } else {
            boolean commandFrame;
            boolean commandHeadFrame;
            byte[] headFrame = this.convertToByte(AbstractBurnerWorker.getCommandHeadFrame(tftpcommand));
            if (this.isDebug()) {
                this.println("To send command head frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand() + "ms data is :");
                this.outputHex(headFrame);
            }
            if (!(commandHeadFrame = this.sendFrame(headFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
                if (this.isDebug()) {
                    this.println("Failed to send command head frame");
                }
                return false;
            }
            if (serialReceived.indexOf("[EOT](ERROR)") != -1) {
                return false;
            }
            AbstractBurnerWorker.deleteContent(serialReceived);
            AbstractBurnerWorker.deleteContent(i2csReceived);
            AbstractBurnerWorker.deleteContent(usbsReceived);
            AbstractBurnerWorker.deleteContent(jtagReceived);
            byte[] cmdFrame = this.convertToByte(AbstractBurnerWorker.getCommandFrame(tftpcommand));
            if (this.isDebug()) {
                this.println("To send command frame, send timeout=" + TIMEOUT_SEND_FRAME / 1000 + "s, wait response timeout=" + AbstractBurnerWorker.getTimeFrameCommand() + "ms data is :");
                this.outputHex(headFrame);
            }
            if (!(commandFrame = this.sendFrame(cmdFrame, TIMEOUT_SEND_FRAME, AbstractBurnerWorker.getTimeFrameCommand()))) {
                if (this.isDebug()) {
                    this.println("Failed to send command frame");
                }
                return false;
            }
        }
        boolean reading = true;
        long start = System.currentTimeMillis();
        String temp = this.getCurReceived();
        int offset = 0;
        String subSequence = null;
        while (reading) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            if (System.currentTimeMillis() - start > totalTimeout) {
                return this.checkTimeout(tftpcommand, totalTimeout);
            }
            temp = this.getCurReceived();
            if (temp.length() > offset) {
                start = System.currentTimeMillis();
                int length = temp.length();
                subSequence = temp.subSequence(offset, length).toString();
                offset += subSequence.length();
                if (subSequence.startsWith("#", 0)) {
                    AbstractBurnerWorker.received("#");
                    this.updateTftpLightToNormal();
                }
                if (subSequence.startsWith("T", 0)) {
                    this.updateTftpLightToAbnormal();
                }
                AbstractBurnerWorker.received(subSequence);
                if (subSequence.indexOf("#") != -1) {
                    start = System.currentTimeMillis();
                }
                if (temp.indexOf("ARP Retry count exceeded") != -1) {
                    totalTimeout = receiveTime;
                }
                if (temp.indexOf("######") != -1) {
                    totalTimeout = receiveTime;
                }
                if (losingPackageCheck != null && temp.indexOf(losingPackageCheck) != -1) {
                    throw new ReceiveTimeOutException(temp);
                }
            }
            if (temp.indexOf("[EOT]") != -1) break;
        }
        return this.checkSendTftpCmdReturn(temp, offset);
    }

    private boolean checkSendTftpCmdReturn(String temp, int offset) throws IOException {
        boolean result;
        if (temp.indexOf("[EOT](OK)") != -1) {
            return true;
        }
        if (temp.indexOf("[EOT](ERROR)") != -1) {
            this.returnError(c.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 1000L) {
            if (this.uimonitor.isCanceled()) {
                this.sendBreak();
                this.handleCancel();
                return false;
            }
            temp = this.getCurReceived();
            if (temp.indexOf("[EOT](OK)") != -1 || temp.indexOf("[EOT](ERROR)") != -1) break;
        }
        boolean bl2 = result = temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](O") != -1 || temp.indexOf("[EOT](ERROR)") == -1 && temp.indexOf("[EOT](E") != -1;
        if (result) {
            start = System.currentTimeMillis();
            while (temp.indexOf("[EOT](OK)") == -1 && temp.indexOf("[EOT](ERROR)") == -1 && System.currentTimeMillis() - start < 1000L) {
                if (this.uimonitor.isCanceled()) {
                    this.sendBreak();
                    this.handleCancel();
                    return false;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                temp = this.getCurReceived();
            }
        }
        if ((temp = this.getCurReceived()).length() > offset) {
            int length = temp.length();
            String subSequence = temp.subSequence(offset, length).toString();
            AbstractBurnerWorker.received(subSequence);
        }
        if (temp.indexOf("ERROR") != -1 || temp.indexOf("[EOT](E") != -1) {
            this.returnError(c.ERROR_INFO_Failed_To_Execute_Command);
            return false;
        }
        return true;
    }

    private boolean checkTimeout(String tftpcommand, long totalTimeout) throws ReceiveTimeOutException {
        boolean loadOrUplo;
        StringBuilder sb = new StringBuilder(c.ERROR_INFO_Failed_To_Execute_TFTPCommand);
        sb.append("(").append(tftpcommand);
        if (this.isDebug()) {
            sb.append("\ttimeout=").append(totalTimeout / 1000L).append("s");
        }
        sb.append(")");
        if (this.isDebug()) {
            this.println(sb.toString());
        }
        boolean bl2 = loadOrUplo = tftpcommand.startsWith("load") || tftpcommand.startsWith("uplo");
        if (loadOrUplo) {
            return true;
        }
        this.updateTftpLightToAbnormal();
        throw new ReceiveTimeOutException(sb.toString());
    }

    private void updateTftpLightToAbnormal() {
        if (q.b() && lightCurrentStateMap.get(Light_E.TFTP.name()).equals(Light_State_E.normal.ordinal())) {
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                this.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
            }
        }
    }

    private void updateTftpLightToNormal() {
        if (q.b() && !lightCurrentStateMap.get(Light_E.TFTP.name()).equals(Light_State_E.normal.ordinal())) {
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.normal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                this.updateLightColor(AbstractBurnerWorker.getLightView().getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
            }
        }
    }

    public int receiveBytes(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        if (SERIAL_IN != null && SERIAL_IN.available() > 0) {
            int read = SERIAL_IN.read(bytes, 0, length);
            int i2 = 0;
            while (i2 < read) {
                buffer.append((char)bytes[0]);
                ++i2;
            }
            return read;
        }
        return 0;
    }

    public boolean receiveBytesByI2c(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        boolean result = I2cCommand.sendI2cCmdForBootrom(0, null, length, bytes, 0, this);
        if (result) {
            int i2 = 0;
            while (i2 < bytes.length) {
                if (bytes[i2] != 0) {
                    buffer.append((char)bytes[i2]);
                }
                ++i2;
            }
        }
        return result;
    }

    public boolean receiveBytesByUsb(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        boolean result = CallLibUSBWorker.recvDataUsb(bytes, length);
        if (result) {
            int i2 = 0;
            while (i2 < bytes.length) {
                if (bytes[i2] != 0) {
                    buffer.append((char)bytes[i2]);
                }
                ++i2;
            }
        }
        return result;
    }

    public int receiveBytesByUsbIgnore(StringBuilder buffer, int length) throws IOException {
        assert (buffer != null);
        byte[] bytes = new byte[length];
        int recvLen = CallLibUSBWorker.recvDataUsbIgnore(bytes, length);
        int i2 = 0;
        while (i2 < recvLen) {
            if (bytes[i2] != 0) {
                buffer.append((char)bytes[i2]);
            }
            ++i2;
        }
        return recvLen;
    }

    public int receiveBytes(byte[] buffer, long timeout) throws IOException {
        assert (buffer != null);
        int offset = 0;
        long start = System.currentTimeMillis();
        int n2 = 0;
        int toread = buffer.length;
        while (offset < buffer.length - 1) {
            if (System.currentTimeMillis() - start > timeout) {
                return offset;
            }
            n2 = SERIAL_IN.available();
            if (n2 > 0) {
                int read = SERIAL_IN.read(buffer, offset, toread);
                offset += read;
                if ((toread -= read) == 0) {
                    return buffer.length;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return offset;
    }

    public int sendBytes(byte[] pBuffer) throws IOException {
        assert (pBuffer != null);
        if (SERIAL_OUT == null) {
            return 0;
        }
        SERIAL_OUT.write(pBuffer);
        SERIAL_OUT.flush();
        return pBuffer.length;
    }

    public int send(int ascii) throws IOException {
        if (SERIAL_OUT == null) {
            return -1;
        }
        SERIAL_OUT.write(ascii);
        SERIAL_OUT.flush();
        return ascii;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.onAdataAvailable(serialReceived);
                break;
            }
        }
    }

    public final void onAdataAvailable(StringBuilder currrent) {
        block5: {
            byte[] bytes = new byte[1024];
            try {
                while (SERIAL_IN.available() > 0) {
                    int read = SERIAL_IN.read(bytes);
                    int i2 = 0;
                    while (i2 < read) {
                        char c2 = (char)bytes[i2];
                        if (currrent != null) {
                            currrent.append(c2);
                        }
                        ++i2;
                    }
                }
            }
            catch (IOException e2) {
                if (!this.isDebug()) break block5;
                this.println("io exception occurs while receiving data :" + e2.getMessage());
            }
        }
    }

    public final void onAdataAvailableI2C(StringBuilder currrent) {
        block5: {
            byte[] bytes = new byte[1024];
            try {
                while (SERIAL_IN.available() > 0) {
                    int read = SERIAL_IN.read(bytes);
                    int i2 = 0;
                    while (i2 < read) {
                        char c2 = (char)bytes[i2];
                        if (currrent != null) {
                            currrent.append(c2);
                        }
                        ++i2;
                    }
                }
            }
            catch (IOException e2) {
                if (!this.isDebug()) break block5;
                this.println("io exception occurs while receiving data :" + e2.getMessage());
            }
        }
    }

    protected long getDDRFreeSize() throws IOException, ReceiveTimeOutException {
        INFOCommand ddrFreeCommand = INFOCommand.getDDRFree();
        if (this.sendCommandDontCareEOT(ddrFreeCommand.getCommand(), ddrFreeCommand.getTimeout())) {
            String KEY;
            String received = this.getCurReceived();
            int startIndex = received.indexOf(KEY = "size:");
            if (-1 == startIndex) {
                return 0L;
            }
            int endIndex = received.indexOf("\r\n", startIndex);
            if (-1 == endIndex) {
                return 0L;
            }
            String strDDRFreeSize = received.substring(startIndex + KEY.length(), endIndex);
            if (strDDRFreeSize.startsWith("0x")) {
                strDDRFreeSize = strDDRFreeSize.substring(strDDRFreeSize.indexOf("0x") + "0x".length());
            }
            return Long.parseLong(strDDRFreeSize, 16);
        }
        return 0L;
    }

    public boolean checkLastPartition(List<PartitionItem> parts) {
        long lastPartLen = this.getLastPartitionLength(parts);
        int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        if (partition.getLength() == -1L) {
            if (lastPartLen == -1L) {
                return false;
            }
            if (lastPartLen % 1024L != 0L) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)NLS.bind((String)c.PartitionBurner_msg_Length_must_be_NK_times_that_is_should_be_with_unit_K_or_M_in_row_lastParitionLen, (Object)1024));
                    }
                });
                return false;
            }
            if (0L == lastPartLen) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)c.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_lastPartitionLength);
                    }
                });
                return false;
            }
            if (lastPartLen < 0L) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)c.AbstractBurner_msg_the_partition_length_must_be_Less_than_zero_lastPartitionLength);
                    }
                });
                return false;
            }
            partition.setLength(lastPartLen);
        }
        return true;
    }

    public long getLastPartitionLength(final List<PartitionItem> parts) {
        this.lastLen = 0L;
        final int emmcType = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
        final int size = parts.size();
        PartitionItem partition = parts.get(size - 1);
        long partitionLength = partition.getLength();
        final long start = partition.getStart();
        if (partitionLength == -1L) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    InputDialog inputDialog = new InputDialog(Display.getDefault().getActiveShell(), c.Get_LastPartition_Length_In_MakeImage, c.Set_All_board_Length, "", null);
                    int open = inputDialog.open();
                    String inputValue = null;
                    if (open == 0) {
                        inputValue = inputDialog.getValue();
                    } else if (open == 1) {
                        AbstractBurnerWorker.this.lastLen = -1L;
                        return;
                    }
                    int nExtFormatCount = 0;
                    int index = 0;
                    while (index < size) {
                        PartitionItem par = (PartitionItem)parts.get(index);
                        FileSystem fileSystem = par.getFileSystem();
                        if (FileSystem.ext3 == fileSystem) {
                            ++nExtFormatCount;
                        }
                        ++index;
                    }
                    long inputLen = WorkerUtility.ReceiveHelper.convertToNumber(inputValue);
                    AbstractBurnerWorker.this.lastLen = 0L;
                    if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HAVE_MBR_TYPE.ordinal()) {
                        AbstractBurnerWorker.this.lastLen = inputLen - start - (long)(nExtFormatCount * 512);
                    } else {
                        AbstractBurnerWorker.this.lastLen = inputLen - start;
                    }
                }
            });
        }
        return this.lastLen;
    }

    protected void readAuxAreaForLibBootrom(String recieved) {
        if (recieved.length() > 0 && !recieved.equalsIgnoreCase("(OK)") && ((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
            if (recieved.toString().contains(HEAD_AREA_FORMAT_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_HEAD_AREA_FORMAT_ERR);
                return;
            }
            if (recieved.toString().contains(VERIFY_KEY_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_VERIFY_KEY_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(AUX_AREA_FORMAT_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_AUX_AREA_FORMAT_ERR);
                return;
            }
            if (recieved.toString().contains(VERIFY_AUX_CODE_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_VERIFY_AUX_CODE_FAILED);
                return;
            }
            if (recieved.toString().contains(VERIFY_AUX_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_VERIFY_AUX_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(VERIFY_PARAM_AREA_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_VERIFY_PARAM_AREA_FAILED);
                return;
            }
            if (recieved.toString().contains(PARAM_LEN_ERR)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_PARAM_LEN_ERR);
                return;
            }
            if (recieved.toString().contains(AUX_CODE_EXEC_FAILED)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                this.returnError(c.ERROR_INFO_AUX_CODE_EXEC_FAILED);
                return;
            }
        }
    }

    protected void readBootromInfoNACK(String temp) {
        boolean needUpdateLight;
        boolean bl2 = needUpdateLight = q.b() && temp.length() > 0;
        if (needUpdateLight) {
            if (temp.contains(BOOTROM_START)) {
                AbstractBurnerWorker.received(BOOTROM_START);
                lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
            } else {
                lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.abnormal.ordinal());
            }
            if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
                this.updateBootromForLib(temp);
            } else {
                this.updateLightNACK(temp);
            }
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.abnormal.ordinal());
            this.updateLightState();
        }
    }

    private void updateLightNACK(String temp) {
        boolean checkFlash;
        if (temp.contains(BOOTROM_FROM_NAND)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_NAND);
            this.updateBootFromLbl("Nand");
        }
        if (temp.contains(BOOTROM_FROM_EMMC)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_EMMC);
            this.updateBootFromLbl("eMMC");
        }
        if (temp.contains(BOOTROM_FROM_SD)) {
            AbstractBurnerWorker.received(BOOTROM_FROM_SD);
            this.updateBootFromLbl("SD");
        }
        boolean bl2 = checkFlash = !temp.contains(BOOTROM_FROM_NAND) && !temp.contains(BOOTROM_FROM_EMMC) && !temp.contains(BOOTROM_FROM_SD);
        if (checkFlash) {
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.abnormal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_EMMC_ERROR)) {
            AbstractBurnerWorker.received(BOOTROM_READ_EMMC_ERROR);
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_SD_ERROR)) {
            AbstractBurnerWorker.received(BOOTROM_READ_SD_ERROR);
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    private void updateBootromForLib(String temp) {
        if (temp.contains(BOOTROM_START)) {
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_MEDIA_SPI)) {
            this.updateBootFromLbl("SPI");
        }
        if (temp.contains(BOOTROM_MEDIA_NAND)) {
            this.updateBootFromLbl("NAND");
        }
        if (temp.contains(BOOTROM_MEDIA_SD)) {
            this.updateBootFromLbl("SD");
        }
        if (temp.contains(BOOTROM_MEDIA_EMMC)) {
            this.updateBootFromLbl("eMMC");
        }
        if (temp.contains(EMMC_INIT_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(EMMC_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(EMMC_NORMAL_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_INIT_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(SD_NORMAL_READ_ERR)) {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    protected void readBootromInfoAck(String temp) {
        if (q.b()) {
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
            if (temp.length() > 0) {
                if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
                    this.updateBootromForLib(temp);
                } else {
                    this.updateBootromACK(temp);
                }
                AbstractBurnerWorker.deleteContent(serialReceived);
            } else {
                lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
            }
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.normal.ordinal());
            this.updateLightState();
        }
    }

    private void updateBootromACK(String temp) {
        if (temp.contains(BOOTROM_START)) {
            this.receivedln(BOOTROM_START);
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_FROM_NAND)) {
            this.receivedln(BOOTROM_FROM_NAND);
            this.updateBootFromLbl("NAND");
        }
        if (temp.contains(BOOTROM_FROM_EMMC)) {
            this.receivedln(BOOTROM_FROM_EMMC);
            this.updateBootFromLbl("eMMC");
        }
        if (temp.contains(BOOTROM_FROM_SD)) {
            this.receivedln(BOOTROM_FROM_SD);
            this.updateBootFromLbl("SD");
        }
        if (temp.contains(BOOTROM_READ_EMMC_ERROR)) {
            this.receivedln(BOOTROM_READ_EMMC_ERROR);
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.normal.ordinal());
        }
        if (temp.contains(BOOTROM_READ_SD_ERROR)) {
            this.receivedln(BOOTROM_READ_SD_ERROR);
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.abnormal.ordinal());
        } else {
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.normal.ordinal());
        }
    }

    protected void readBootromAndDDrNAck(String temp) {
        if (q.b()) {
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                this.updateLightColor(AbstractBurnerWorker.getLightView().getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            }
            this.readDdrTrainingInfo(temp);
        }
    }

    protected void readBootromAndDDrAck(String temp) {
        if (q.b()) {
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.normal.ordinal());
            if (lightView != null) {
                this.updateLightColor(lightView.getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            }
            this.readDdrTrainingInfo(temp);
        }
    }

    protected void readDdrTrainingInfo(String temp) {
        if (temp.length() > 0 && !temp.equalsIgnoreCase("(OK)")) {
            if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
                if (temp.contains(DDR_WL_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_HWG_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_GATE_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_DDRT_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_HWRD_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_MPR_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_DATAEYE_ERR)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_DDRE)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
            } else {
                if (temp.contains(DDRTRINING_SWL)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_SGA)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_HGA)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_HRD)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_SRD)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_SWD)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDRTRINING_DDR_FAILED)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_DDRE)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
                if (temp.contains(DDR_DDRTR) && temp.contains(DDR_Err)) {
                    lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.abnormal.ordinal());
                }
            }
            if (lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()).intValue() != Light_State_E.abnormal.ordinal()) {
                lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.normal.ordinal());
            }
        } else {
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.normal.ordinal());
        }
        this.updateLightState();
    }

    protected void outDdrTrainingInfo(String temp) {
        if (temp.length() > 0 && !temp.equalsIgnoreCase("(OK)")) {
            boolean isddrSuccess = true;
            if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
                if (temp.contains(DDR_WL_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_HWG_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_GATE_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRT_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_HWRD_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_MPR_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DATAEYE_ERR)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRE)) {
                    isddrSuccess = false;
                }
            } else {
                if (temp.contains(DDRTRINING_SWL)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SGA)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_HGA)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_HRD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SRD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_SWD)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDRTRINING_DDR_FAILED)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRE)) {
                    isddrSuccess = false;
                }
                if (temp.contains(DDR_DDRTR) && temp.contains(DDR_Err)) {
                    isddrSuccess = false;
                }
            }
            if (!isddrSuccess) {
                AbstractBurnerWorker.received(temp);
            }
        }
    }

    protected void readBootInfo(String temp) {
        if (temp.length() > 0) {
            if (temp.contains(FASTBOOT_START)) {
                lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.normal.ordinal());
                lightCurrentStateMap.put(Light_E.FASTBOOT_START.name(), Light_State_E.normal.ordinal());
            }
            if (temp.contains(FASTBOOT_NO_CURRENT_START)) {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
            } else {
                lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
            }
            this.fastbootFromFlash = this.getBootFrom(temp);
            if (temp.contains(FASTBOOT_NO_NAND_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.warn.ordinal());
                if (this.fastbootFromFlash != null) {
                    if (this.fastbootFromFlash.equalsIgnoreCase("nand")) {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                    } else {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                    }
                }
            } else if (temp.contains(FASTBOOT_HAVE_NAND_FLASH_MFCV100) || temp.contains(FASTBOOT_HAVE_NAND_FLASH_OTHER)) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.normal.ordinal());
                if (this.fastbootFromFlash != null && this.fastbootFromFlash.equalsIgnoreCase("emmc")) {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                }
            } else if (temp.contains("start download process.")) {
                lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.warn.ordinal());
            }
            if (temp.contains(FASTBOOT_NO_EMMC_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.warn.ordinal());
                if (this.fastbootFromFlash != null) {
                    if (this.fastbootFromFlash.equalsIgnoreCase("emmc")) {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                    } else {
                        lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                    }
                }
            } else if (temp.contains(FASTBOOT_HAVE_EMMC_FLASH)) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.normal.ordinal());
                if (this.fastbootFromFlash != null && this.fastbootFromFlash.equalsIgnoreCase("nand")) {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.abnormal.ordinal());
                } else {
                    lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.normal.ordinal());
                }
            } else if (temp.contains("start download process.")) {
                lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.warn.ordinal());
            }
            this.updateLightState();
        }
    }

    protected void updateLightState() {
        if (AbstractBurnerWorker.getLightView() != null) {
            this.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getCpuLbl(), lightCurrentStateMap.get(Light_E.CPU.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getBootromLbl(), lightCurrentStateMap.get(Light_E.BOOTROM.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getReadEmmcLbl(), lightCurrentStateMap.get(Light_E.READ_EMMC.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getReadSDLbl(), lightCurrentStateMap.get(Light_E.READ_SD.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getDdrTrainingLbl(), lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getFastbootStartLbl(), lightCurrentStateMap.get(Light_E.FASTBOOT_START.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getFlashTypeMatchLbl(), lightCurrentStateMap.get(Light_E.FLASH_AND_IMAGE_MATCH.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getEmmcFlash(), lightCurrentStateMap.get(Light_E.FLASH_EMMC.name()));
            this.updateLightColor(AbstractBurnerWorker.getLightView().getNandFlash(), lightCurrentStateMap.get(Light_E.FLASH_NAND.name()));
        }
    }

    protected void updateSerialLightToError() {
        if (q.b()) {
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.abnormal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                this.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            }
        }
    }

    protected void updateSerialLightToRight() {
        if (q.b()) {
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.normal.ordinal());
            if (AbstractBurnerWorker.getLightView() != null) {
                this.updateLightColor(AbstractBurnerWorker.getLightView().getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            }
        }
    }

    protected void initLightState() {
        if (view != null && view instanceof LightView) {
            LightView lightView = (LightView)view;
            lightCurrentStateMap.put(Light_E.SERIAL.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.CPU.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.BOOTROM.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.READ_EMMC.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.READ_SD.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.DDR_INIT.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.DDR_TRAINING.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FASTBOOT_START.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_NAND.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_EMMC.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.FLASH_AND_IMAGE_MATCH.name(), Light_State_E.init.ordinal());
            lightCurrentStateMap.put(Light_E.TFTP.name(), Light_State_E.init.ordinal());
            this.updateLightColor(lightView.getSerialLbl(), lightCurrentStateMap.get(Light_E.SERIAL.name()));
            this.updateLightColor(lightView.getCpuLbl(), lightCurrentStateMap.get(Light_E.CPU.name()));
            this.updateLightColor(lightView.getBootromLbl(), lightCurrentStateMap.get(Light_E.BOOTROM.name()));
            this.updateLightColor(lightView.getReadEmmcLbl(), lightCurrentStateMap.get(Light_E.READ_EMMC.name()));
            this.updateLightColor(lightView.getReadSDLbl(), lightCurrentStateMap.get(Light_E.READ_SD.name()));
            this.updateLightColor(lightView.getDdrInitLbl(), lightCurrentStateMap.get(Light_E.DDR_INIT.name()));
            this.updateLightColor(lightView.getDdrTrainingLbl(), lightCurrentStateMap.get(Light_E.DDR_TRAINING.name()));
            this.updateLightColor(lightView.getFastbootStartLbl(), lightCurrentStateMap.get(Light_E.FASTBOOT_START.name()));
            this.updateLightColor(lightView.getFlashTypeMatchLbl(), lightCurrentStateMap.get(Light_E.FLASH_AND_IMAGE_MATCH.name()));
            this.updateLightColor(lightView.getEmmcFlash(), lightCurrentStateMap.get(Light_E.FLASH_EMMC.name()));
            this.updateLightColor(lightView.getNandFlash(), lightCurrentStateMap.get(Light_E.FLASH_NAND.name()));
            this.updateLightColor(lightView.getTftplbl(), lightCurrentStateMap.get(Light_E.TFTP.name()));
        }
    }

    protected void updateBootFromLbl(final String bootFromFlash) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractBurnerWorker.getLightView().getBootFromLbl().setText(String.valueOf(c.LightView_BootFrom) + " " + bootFromFlash);
                AbstractBurnerWorker.getLightView().getBootFromLbl().redraw();
                AbstractBurnerWorker.getLightView().getComposite().layout();
            }
        });
    }

    protected void updateCaTypeLbl(final String caType) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractBurnerWorker.getLightView() != null) {
                    if (AbstractBurnerWorker.getLightView().getCaTypeLbl() != null) {
                        AbstractBurnerWorker.getLightView().getCaTypeLbl().setText(String.valueOf(c.LightView_CAType) + " " + caType);
                        AbstractBurnerWorker.getLightView().getCaTypeLbl().redraw();
                    }
                    if (AbstractBurnerWorker.getLightView().getComposite() != null && !lightView.getComposite().isDisposed()) {
                        AbstractBurnerWorker.getLightView().getComposite().layout();
                    }
                }
            }
        });
    }

    protected void updateLightColor(final ImageHyperlink imageHyperlink, int lightState) {
        switch (lightState) {
            case 0: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.a("icons/white_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 1: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.a("icons/green_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 2: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.a("icons/red_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            case 3: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.a("icons/yellow_light.png"));
                        imageHyperlink.redraw();
                    }
                });
                break;
            }
            default: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        imageHyperlink.setImage(Activator.a("icons/white_light.png"));
                        imageHyperlink.redraw();
                    }
                });
            }
        }
    }

    protected boolean isPage() {
        q unknownDevice;
        String nandAlignmentType;
        return this.burner.getBurnContext().getDeviceSetting() instanceof q && (nandAlignmentType = (unknownDevice = (q)this.burner.getBurnContext().getDeviceSetting()).c()) != null && nandAlignmentType.equalsIgnoreCase("PAGE");
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public static OutputStream getSERIAL_OUT() {
        return SERIAL_OUT;
    }

    public static void setSERIAL_OUT(OutputStream sERIAL_OUT) {
        SERIAL_OUT = sERIAL_OUT;
    }

    public static InputStream getSERIAL_IN() {
        return SERIAL_IN;
    }

    public static void setSERIAL_IN(InputStream sERIAL_IN) {
        SERIAL_IN = sERIAL_IN;
    }

    public static IFastbootProgressMonitor getMonitor() {
        return monitor;
    }

    public static void setMonitor(IFastbootProgressMonitor monitor) {
        AbstractBurnerWorker.monitor = monitor;
    }

    public static LightView getLightView() {
        return lightView;
    }

    public static void setLightView(LightView lightView) {
        AbstractBurnerWorker.lightView = lightView;
    }

    public long getSpiBlockSize() {
        return this.spiBlockSize;
    }

    public void setSpiBlockSize(long spiBlockSize) {
        this.spiBlockSize = spiBlockSize;
    }

    public long getNandBlockSize() {
        return this.nandBlockSize;
    }

    public void setNandBlockSize(long nandBlockSize) {
        this.nandBlockSize = nandBlockSize;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public static IViewPart getView() {
        return view;
    }

    public static void setView(IViewPart view) {
        AbstractBurnerWorker.view = view;
    }

    public static enum Light_E {
        CPU,
        BOOTROM,
        READ_EMMC,
        READ_SD,
        DDR_INIT,
        DDR_TRAINING,
        FASTBOOT_START,
        FLASH_NAND,
        FLASH_EMMC,
        FLASH_AND_IMAGE_MATCH,
        SERIAL,
        TFTP;

    }

    public static enum Light_State_E {
        init,
        normal,
        abnormal,
        warn;

    }
}

