/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.ProductLine;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.JTAGPreferencePage;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.views.FastbootView;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CallLibJTAGWorker
extends FastbootBurnerWorker {
    private static final String PURE_JTAG = "jtag";
    private static SubProgressMonitor subMonitor;
    public static final LibJTAGByJNA.JavaCallbackCancel CANCELCALLBACK;
    public static final LibJTAGByJNA.JavaCallbackAdd JTAGPRINTINFOCALLBACK;

    static {
        CANCELCALLBACK = new LibJTAGByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        JTAGPRINTINFOCALLBACK = new LibJTAGByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(String printInfo, String debugInfo) {
                if (monitor == null) {
                    monitor = IFastbootProgressMonitor.NULL;
                }
                if (FastbootPreferences.isDebugOn() && monitor != null) {
                    if (debugInfo != null) {
                        monitor.println(debugInfo);
                    }
                    if (printInfo != null) {
                        monitor.println(printInfo);
                    }
                }
                if (printInfo != null) {
                    CallLibJTAGWorker.received(printInfo);
                }
            }
        };
    }

    public CallLibJTAGWorker(IFrameSetting frameSetting, IBurner burner, SubProgressMonitor subProgressMonitor) {
        super(frameSetting, burner);
        CallLibJTAGWorker.setSubMonitor(subProgressMonitor);
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            System.setProperty("jna.encoding", "GBK");
        } else {
            System.setProperty("jna.encoding", "UTF-8");
        }
    }

    public static boolean bootDownloadByLib(int jtagChipType, String commName, int ddrOrFlash, long[] initDdrAddr, String filePath, String dllPath, int[] errorCode, int level) {
        String jtagSmallBoradModel;
        int ft2232Chip = 0;
        ProductLine.PRODUCTLINE productLine = bi.a();
        ft2232Chip = productLine == ProductLine.PRODUCTLINE.DPT ? 2 : ((jtagSmallBoradModel = FastbootPreferences.getJtagSmallBoradModel()).equals(JTAGPreferencePage.getJTAGSMALLMODELTYPELIST()[0][0]) ? 0 : 1);
        CallLibJTAGWorker.jtag_SetFT2232Chip(ft2232Chip);
        if (jtagChipType == LibJTAGByJNA.EJtagChipType.hi3796mv200.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.hi3716mv430.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.hi3796cv300.ordinal() || jtagChipType == LibJTAGByJNA.EJtagChipType.hi3231V530.ordinal()) {
            commName = PURE_JTAG;
        }
        LibJTAGByJNA.instance.jtag_SetFrequency(level);
        int burnResult = LibJTAGByJNA.instance.jtag_BootDownload(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, dllPath, errorCode);
        return burnResult != 0;
    }

    public static void jtag_SetFrequency(int level) {
        LibJTAGByJNA.instance.jtag_SetFrequency(level);
    }

    public static String sendCmdByJtag(byte[] data, int length, long timeout) {
        if (FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3231V530) {
            return LibJTAGByJNA.instance.jtag_SendCmd_Semihosting(data, length, timeout);
        }
        return LibJTAGByJNA.instance.jtag_SendCmd(data, length, timeout);
    }

    public static boolean sendFileByJtag(String filePath, long ddrAddr) {
        return LibJTAGByJNA.instance.jtag_LoadFile(filePath, ddrAddr);
    }

    public static boolean dumpFileByJtag(String filePath, long ddrAddr, long length) {
        return LibJTAGByJNA.instance.jtag_DumpFile(filePath, ddrAddr, length);
    }

    public static boolean releaseJtag() {
        return LibJTAGByJNA.instance.jtag_Release();
    }

    public static boolean jtag_StartSignalTest() {
        return LibJTAGByJNA.instance.jtag_StartSignalTest();
    }

    public static boolean jtag_StopSignalTest() {
        return LibJTAGByJNA.instance.jtag_StopSignalTest();
    }

    public static void jtag_SetFT2232Chip(int ft2232Model) {
        LibJTAGByJNA.instance.jtag_SetFT2232Chip(ft2232Model);
    }

    public static void printDebugInfo(String debugInfo) {
        if (FastbootPreferences.isDebugOn()) {
            if (monitor != null) {
                monitor.println(debugInfo);
            } else {
                System.out.print(debugInfo);
            }
        }
    }

    public static SubProgressMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubProgressMonitor subMonitor) {
        CallLibJTAGWorker.subMonitor = subMonitor;
    }
}

