/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.jna.LibHiUsbByJNA;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class CallLibUSBWorker
extends FastbootBurnerWorker {
    private static boolean connected = false;
    private static int[] handle = new int[1];
    private static final int Hi3516CV300_VID = 4817;
    private static final int Hi3516CV300_PID = 53249;
    private static final int OPEN_SUCCESS = 0;
    private static final int DOWNLOAD_SUCCESS = 1;
    public static final int SEND_TIMEOUT = 5000;
    public static final int RECV_TIMEOUT = 5000;
    public static final int RECV_IGNORE_TIMEOUT = 1000;
    public static final int GET_CUR_RECEIVED_LEN = 1024;
    public static final int WAIT_BOOT_RUN_RECE_LEN = 512;
    private static SubProgressMonitor subMonitor;
    public static final LibHiUsbByJNA.JavaCallbackCancel callbackCancel;
    public static final LibHiUsbByJNA.JavaCallbackAdd callback;

    static {
        callbackCancel = new LibHiUsbByJNA.JavaCallbackCancel(){

            @Override
            public boolean isCancel() {
                if (subMonitor == null) {
                    return false;
                }
                return subMonitor.isCanceled();
            }
        };
        callback = new LibHiUsbByJNA.JavaCallbackAdd(){

            @Override
            public void printInfo(String printInfo, String debugInfo) {
                if (FastbootPreferences.isDebugOn() && monitor != null) {
                    monitor.print(debugInfo);
                }
                CallLibUSBWorker.received(printInfo);
                if (debugInfo != null && subMonitor != null && debugInfo.indexOf("%") != -1) {
                    int progress = 0;
                    try {
                        progress = Integer.parseInt(debugInfo.substring(0, debugInfo.indexOf("%")));
                        subMonitor.worked(progress);
                        subMonitor.notify();
                    }
                    catch (NumberFormatException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        };
    }

    public CallLibUSBWorker(IFrameSetting frameSetting, IBurner burner, SubProgressMonitor subProgressMonitor) {
        super(frameSetting, burner);
        CallLibUSBWorker.setSubMonitor(subProgressMonitor);
        System.setProperty("jna.encoding", "GBK");
    }

    public static boolean openUsb(IProgressMonitor uimonitor, long timeout) {
        new CallLibUSBWorker(null, null, null);
        LibHiUsbByJNA.instance.RegisterPrint(callback);
        LibHiUsbByJNA.instance.RegisterCancel(callbackCancel);
        long startTime = System.currentTimeMillis();
        int openResult = 1;
        while (System.currentTimeMillis() - startTime < timeout) {
            if (!connected) {
                if (uimonitor.isCanceled()) {
                    FastbootEvent event;
                    if (monitor != null && (event = monitor.getEvent()) != null) {
                        event.setUserCanceled(true);
                        event.setSuccess(false);
                        event.setMessage("User Cancelled!");
                    }
                    return false;
                }
                openResult = LibHiUsbByJNA.instance.USB_Open(handle, 4817, 53249);
                System.out.println("Open USB: " + openResult);
                if (openResult != 0) continue;
                connected = true;
                return true;
            }
            return true;
        }
        return CallLibUSBWorker.checkReturn(monitor, openResult);
    }

    public static void closeUsb() {
        if (connected) {
            LibHiUsbByJNA.instance.USB_Close(handle[0]);
            connected = false;
        }
    }

    public static boolean sendDataByUsb(byte[] pData, int nLen) {
        if (connected) {
            int sendLen = LibHiUsbByJNA.instance.USB_SendData(handle[0], pData, nLen, 5000);
            return sendLen == nLen;
        }
        return false;
    }

    public static boolean recvDataUsb(byte[] pData, int nLen) {
        if (connected) {
            int recvLen = LibHiUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 5000);
            return recvLen == nLen;
        }
        return false;
    }

    public static int recvDataUsbIgnore(byte[] pData, int nLen) {
        if (connected) {
            return LibHiUsbByJNA.instance.USB_RecvData(handle[0], pData, nLen, 1000);
        }
        return 0;
    }

    public static boolean downloadFileByUsb(IFrameSetting frameSetting, IBurner burner, SubProgressMonitor subProgressMonitor, File file, int ddrAddress) {
        String filePath = file.getPath();
        if (connected) {
            int downloadResult = LibHiUsbByJNA.instance.USB_DownloadFile(handle[0], filePath, ddrAddress);
            return downloadResult == 1;
        }
        return false;
    }

    public static void registerPrint() {
        LibHiUsbByJNA.instance.RegisterPrint(callback);
    }

    public static void registerCancel() {
        LibHiUsbByJNA.instance.RegisterCancel(callbackCancel);
    }

    public static boolean isConnected() {
        return connected;
    }

    public static boolean checkReturn(IFastbootProgressMonitor monitor, int input) {
        boolean result = false;
        LibUsbEnum returnValue = LibUsbEnum.valueOf(input);
        if (returnValue == null) {
            return result;
        }
        switch (returnValue) {
            case LIBUSB_SUCCESS: {
                result = true;
                break;
            }
            case LIBUSB_TIMEOUT: {
                monitor.getEvent().setMessage(c.ERROR_USB_OPEN_TIMEOUT);
                break;
            }
            case LIBUSB_ERROR_IO: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_IO.name()));
                break;
            }
            case LIBUSB_ERROR_INVALID_PARAM: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_INVALID_PARAM.name()));
                break;
            }
            case LIBUSB_ERROR_ACCESS: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_ACCESS.name()));
                break;
            }
            case LIBUSB_ERROR_NO_DEVICE: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NO_DEVICE.name()));
                break;
            }
            case LIBUSB_ERROR_NOT_FOUND: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NOT_FOUND.name()));
                break;
            }
            case LIBUSB_ERROR_BUSY: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_BUSY.name()));
                break;
            }
            case LIBUSB_ERROR_TIMEOUT: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_TIMEOUT.name()));
                break;
            }
            case LIBUSB_ERROR_OVERFLOW: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_OVERFLOW.name()));
                break;
            }
            case LIBUSB_ERROR_PIPE: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_PIPE.name()));
                break;
            }
            case LIBUSB_ERROR_INTERRUPTED: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_INTERRUPTED.name()));
                break;
            }
            case LIBUSB_ERROR_NO_MEM: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NO_MEM.name()));
                break;
            }
            case LIBUSB_ERROR_NOT_SUPPORTED: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_NOT_SUPPORTED.name()));
                break;
            }
            case LIBUSB_ERROR_OTHER: {
                monitor.getEvent().setMessage(NLS.bind((String)c.ERROR_USB_OPEN_FAILED, (Object)LibUsbEnum.LIBUSB_ERROR_OTHER.name()));
                break;
            }
        }
        return result;
    }

    public static <T> LibUsbEnum getEnum(int index) {
        Class<LibUsbEnum> clazz = LibUsbEnum.class;
        T[] c2 = clazz.getEnumConstants();
        return (LibUsbEnum)((Object)c2[index]);
    }

    public static SubProgressMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubProgressMonitor subMonitor) {
        CallLibUSBWorker.subMonitor = subMonitor;
    }

    public static enum LibUsbEnum {
        LIBUSB_SUCCESS(0),
        LIBUSB_TIMEOUT(1),
        LIBUSB_ERROR_IO(-1),
        LIBUSB_ERROR_INVALID_PARAM(-2),
        LIBUSB_ERROR_ACCESS(-3),
        LIBUSB_ERROR_NO_DEVICE(-4),
        LIBUSB_ERROR_NOT_FOUND(-5),
        LIBUSB_ERROR_BUSY(-6),
        LIBUSB_ERROR_TIMEOUT(-7),
        LIBUSB_ERROR_OVERFLOW(-8),
        LIBUSB_ERROR_PIPE(-9),
        LIBUSB_ERROR_INTERRUPTED(-10),
        LIBUSB_ERROR_NO_MEM(-11),
        LIBUSB_ERROR_NOT_SUPPORTED(-12),
        LIBUSB_ERROR_OTHER(-99);

        private int value = 0;

        private LibUsbEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LibUsbEnum valueOf(String string) {
            return Enum.valueOf(LibUsbEnum.class, string);
        }
    }
}

