/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.commands.CrcCommand;
import com.hisilicon.fastboot.model.AlgorithmType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class CheckSumBurnerWorker
extends PartitionBurnerWorker {
    public CheckSumBurnerWorker(IBurner burner) {
        super(burner);
        this.burner = burner;
    }

    public boolean checkSum(IProgressMonitor uiMonitor, File file, boolean call, final Text checkSumResultText, AlgorithmType checkSumType) {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Check Sum", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Check Sum");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().init(EventType.CHECK_SUM);
        if (uiMonitor.isCanceled()) {
            monitor.getEvent().setUserCanceled(true);
            return false;
        }
        uiMonitor.beginTask("Checking Sum", 100);
        if (uiMonitor.isCanceled()) {
            monitor.getEvent().setUserCanceled(true);
            return false;
        }
        if (checkSumType == null) {
            return false;
        }
        String result = "";
        try {
            if (checkSumType.equals((Object)AlgorithmType.CUMULATIVE_SUM)) {
                result = Integer.toHexString(CrcCommand.calculateCheckSum(file));
                result = this.alignByByte(result, 8);
            } else {
                result = Integer.toHexString(CrcCommand.calculateCRC16(file));
                result = this.alignByByte(result, 4);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        final String resultStr = "0x" + result;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                checkSumResultText.setText(resultStr);
            }
        });
        uiMonitor.worked(100);
        this.warning("Check Sum Results: " + resultStr + "\n");
        this.infoln("The Check Sum successfully!");
        return true;
    }

    public String alignByByte(String str, int size) {
        StringBuilder sb = new StringBuilder();
        int num = size - str.length();
        if (size - str.length() > 0) {
            int j2 = 0;
            while (j2 < num) {
                sb.append("0");
                ++j2;
            }
        }
        sb.append(str);
        return sb.toString();
    }
}

