/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.commands.EraseCommand;
import com.hisilicon.fastboot.commands.MWCommand;
import com.hisilicon.fastboot.commands.ReadCommand;
import com.hisilicon.fastboot.commands.SFCommand;
import com.hisilicon.fastboot.commands.WriteCommand;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.devices.burners.CommonBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.EmmcPartitionBurnerWorker;
import com.hisilicon.fastboot.views.FastbootView;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class CommonBurnerWorker
extends EmmcPartitionBurnerWorker {
    public CommonBurnerWorker(CommonBurner burner) {
        super(burner);
    }

    @Override
    public boolean burn(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        String versionInfo = this.getVersionInfo("Burn By Partition");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (FastbootView.isJTagTransferMode()) {
            new CallLibJTAGWorker(this.frameSetting, this.burner, new SubProgressMonitor(uimonitor, 100));
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        }
        if (q.b()) {
            this.initLightState();
        }
        this.createTimer();
        long burnStartTime = System.currentTimeMillis();
        int selectedPartCount = this.getSelectedPartCount(parts);
        this.setProgressMonitor(uimonitor);
        CommonBurnerWorker.getMonitor().getEvent().init(EventType.BURN);
        uimonitor.beginTask("Burn By Partition", 100 * selectedPartCount);
        boolean result = this.burnByTransferWay(uimonitor, parts, selectedPartCount);
        long burnTotalTime = System.currentTimeMillis() - burnStartTime;
        String burnTotalTimeStr = this.calculateBurnTotalTime(burnTotalTime);
        CommonBurnerWorker.getMonitor().getEvent().setTotalBurnTime(burnTotalTimeStr);
        this.printDebugTimeLogger(parts.get(0), burnTotalTime);
        return result;
    }

    @Override
    public boolean erase(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        this.setProgressMonitor(uimonitor);
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
        String versionInfo = this.getVersionInfo("Erase Partitions");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (FastbootView.isJTagTransferMode()) {
            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        }
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = true;
        result = this.startbootForNoneNude(uimonitor, parts, hasFlashTypes, curTransferWay);
        if (!result) {
            return result;
        }
        uimonitor.worked(100);
        uimonitor.setTaskName("Erase Partitions");
        int partsSize = parts.size();
        int index = 0;
        while (index < partsSize) {
            if (uimonitor.isCanceled()) break;
            PartitionItem part = parts.get(index);
            if (part.isChecked()) {
                CommonBurnerWorker.getMonitor().highlight(part);
                String partitionName = part.getName() == null ? "" : part.getName();
                uimonitor.subTask("Partition: " + partitionName);
                FlashType flashType = part.getFlashType();
                if (flashType == FlashType.emmc) {
                    result = this.eraseEmmcPart(subProgressMonitor, part);
                } else {
                    if (FastbootView.isJTagTransferMode()) {
                        new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
                        LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                        LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
                    }
                    result = this.eraseForNandorSpi(subProgressMonitor, partsSize, index, part);
                }
                if (!result) {
                    return result;
                }
                uimonitor.worked(100);
            }
            ++index;
        }
        return true;
    }

    @Override
    public boolean eraseAll(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean hasUfs;
        boolean hasEmmc;
        boolean hasSpi;
        ArrayList<FlashType> hasFlashTypes;
        this.setProgressMonitor(uimonitor);
        parts = ((CommonBurner)this.getBurner()).getChildren();
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
        String versionInfo = this.getVersionInfo("Erase all partitions");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (FastbootView.isJTagTransferMode()) {
            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        }
        if ((hasFlashTypes = FlashType.getCurFlashTypes(parts)).size() == 0) {
            hasFlashTypes = FlashType.getCurAllFlashTypes(parts);
        }
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = true;
        result = this.startbootForNoneNude(uimonitor, parts, null, curTransferWay);
        if (!result) {
            return result;
        }
        boolean hasNand = this.isHasFlash(hasFlashTypes, FlashType.nand);
        if (hasNand) {
            result = this.eraseNand(hasFlashTypes);
        }
        if (hasSpi = this.isHasFlash(hasFlashTypes, FlashType.spi)) {
            result = this.eraseSpi(hasFlashTypes, parts);
        }
        if (hasEmmc = this.isHasFlash(hasFlashTypes, FlashType.emmc)) {
            result = this.eraseEmmcOrUfs(uimonitor, FlashType.emmc);
        }
        if (hasUfs = this.isHasFlash(hasFlashTypes, FlashType.ufs)) {
            result = this.eraseEmmcOrUfs(uimonitor, FlashType.ufs);
        }
        if (!result) {
            this.returnError("Failed to Erase all partitions!");
            return false;
        }
        this.infoln("Erase all partitions successfully!");
        uimonitor.worked(100);
        return result;
    }

    @Override
    public boolean upload(IProgressMonitor uimonitor, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        CommonBurnerWorker.getMonitor().getEvent().init(EventType.UPLOAD);
        this.setProgressMonitor(uimonitor);
        int selected = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selected;
        }
        int totalWork = (selected + 2) * 100;
        uimonitor.beginTask("", totalWork);
        uimonitor.setTaskName("Init Board");
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, totalWork, 4);
        String versionInfo = this.getVersionInfo("Uploading Partitions");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (FastbootView.isJTagTransferMode()) {
            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        }
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean result = true;
        result = this.startbootForNoneNude(uimonitor, parts, hasFlashTypes, curTransferWay);
        if (!result) {
            return result;
        }
        uimonitor.worked(50);
        uimonitor.setTaskName("Setting Up Network");
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
            this.returnError("Failed to setup network!");
            return false;
        }
        uimonitor.setTaskName("Uploading Partitions");
        int partsSize = parts.size();
        boolean isBeginTask = false;
        int partIndex = 0;
        while (partIndex < parts.size()) {
            PartitionItem partition = parts.get(partIndex);
            if (partition.isChecked()) {
                FileSystem uploadFileSystem = partition.getFileSystem();
                String start = Long.toHexString(partition.getStart());
                String length = Long.toHexString(partition.getLength());
                FlashType flashType = partition.getFlashType();
                File file = partition.getFile();
                if (flashType == FlashType.emmc) {
                    if (isBeginTask) {
                        uimonitor.beginTask("Uploading Partitions", selected * 100);
                        isBeginTask = false;
                    }
                    result = this.uploadPartForEmmc(uimonitor, partsSize, partIndex, partition);
                } else {
                    isBeginTask = true;
                    this.setFlashType(partition.getFlashType());
                    result = this.upload(uimonitor, file, uploadFileSystem, start, length, false, ChipID.chip0);
                }
                if (!result) {
                    return result;
                }
                --selected;
            }
            ++partIndex;
        }
        uimonitor.worked(100);
        return true;
    }

    @Override
    public boolean createImage(IProgressMonitor uiMonitor, File file, List<PartitionItem> parts, boolean call) {
        return super.createImage(uiMonitor, file, parts, call);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean uploadPartForEmmc(IProgressMonitor uiMonitor, int partsSize, int partIndex, PartitionItem partition) throws IOException, ReceiveTimeOutException {
        String partitionName = partition.getName() == null ? "" : partition.getName();
        uiMonitor.subTask("Parition:" + partitionName);
        CommonBurnerWorker.getMonitor().highlight(partition);
        File file = partition.getFile();
        long start = partition.getStart();
        long length = partition.getLength();
        FlashType flashType = partition.getFlashType();
        if (length == -1L && partIndex == partsSize - 1) {
            long neMMCCapacity = this.geteMMCSpaceSize(flashType);
            if (0L == neMMCCapacity) {
                this.warningln("Failed to get eMMC capacity!");
                return false;
            }
            length = neMMCCapacity - start;
            String errorType = "All eMMC remain space ";
            if (flashType == FlashType.ufs) {
                errorType = "All ufs remain space ";
            }
            this.warningln(String.valueOf(errorType) + length + " Bytes allotted to last partition!");
        }
        long uploadAddress = start / 512L;
        long uploadLength = length / 512L;
        int partCount = (int)(length / 0x2000000L);
        if (length % 0x2000000L != 0L) {
            ++partCount;
        }
        File tmpFile = null;
        try {
            tmpFile = this.createFile(String.valueOf(file.getPath()) + ".tmp", partitionName);
            if (tmpFile == null) {
                return false;
            }
            this.switchTFTPDownloadHome(tmpFile);
            if (partCount == 1) {
                boolean result = this.sendCommand(ReadCommand.readMMC_0_Destination_(this.getHexStartAddress(), Long.toHexString(uploadAddress), Long.toHexString(uploadLength)));
                if (result) {
                    result = this.uploadByTrans(uiMonitor, length, tmpFile);
                }
                if (!result) {
                    this.returnError("Failed to upload " + partitionName + " partition!");
                    return false;
                }
                this.infoln("Partition uploaded successfully!");
            } else {
                int i2 = 0;
                while (i2 < partCount) {
                    block48: {
                        File partFile = this.createFile(String.valueOf(file.getPath()) + ".part" + i2, partitionName);
                        if (partFile == null) {
                            return false;
                        }
                        long partUploadAddress = uploadAddress + (long)i2 * 65536L;
                        long partUploadRealLength = 0L;
                        long partUploadLength = 0L;
                        if (i2 == partCount - 1) {
                            partUploadRealLength = length - (long)i2 * 0x2000000L;
                            partUploadLength = uploadLength - (long)i2 * 65536L;
                        } else {
                            partUploadRealLength = 0x2000000L;
                            partUploadLength = 65536L;
                        }
                        boolean result = this.sendCommand(ReadCommand.readMMC_0_Destination_(this.getHexStartAddress(), Long.toHexString(partUploadAddress), Long.toHexString(partUploadLength)));
                        if (result) {
                            result = this.uploadByTrans(uiMonitor, partUploadRealLength, partFile);
                        }
                        if (!result) {
                            this.returnError("Failed to upload " + partitionName + " partition!");
                            return false;
                        }
                        this.infoln("Partition part " + i2 + " uploaded successfully!");
                        BufferedInputStream bis = null;
                        RandomAccessFile raf = null;
                        try {
                            try {
                                bis = new BufferedInputStream(new FileInputStream(partFile));
                                raf = new RandomAccessFile(tmpFile, "rw");
                                raf.seek(tmpFile.length());
                                byte[] buffer = new byte[512];
                                int readSize = 0;
                                while ((readSize = bis.read(buffer, 0, buffer.length)) != -1) {
                                    raf.write(buffer, 0, readSize);
                                }
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                                try {
                                    if (raf != null) {
                                        raf.close();
                                    }
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                try {
                                    if (bis != null) {
                                        bis.close();
                                    }
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                                partFile.deleteOnExit();
                                this.deleteTempFile(partFile);
                                break block48;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (raf != null) {
                                    raf.close();
                                }
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                            try {
                                if (bis != null) {
                                    bis.close();
                                }
                            }
                            catch (IOException e6) {
                                e6.printStackTrace();
                            }
                            partFile.deleteOnExit();
                            this.deleteTempFile(partFile);
                            throw throwable;
                        }
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (IOException e7) {
                            e7.printStackTrace();
                        }
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                        }
                        catch (IOException e8) {
                            e8.printStackTrace();
                        }
                        partFile.deleteOnExit();
                        this.deleteTempFile(partFile);
                    }
                    ++i2;
                }
            }
            if (!bg.a(uiMonitor, tmpFile, file)) {
                this.returnError("Cannot operate on the destination file!");
                return false;
            }
        }
        finally {
            if (tmpFile != null) {
                tmpFile.deleteOnExit();
            }
            this.deleteTempFile(tmpFile);
        }
        this.switchTFTPDownloadHome(file);
        uiMonitor.worked(100);
        return true;
    }

    private File createFile(String path, String partitionName) throws IOException {
        File partFile = new File(path);
        if (partFile.exists() && !partFile.delete()) {
            this.returnError("Cannot operate on temp file. Uplodaing will be stoped.");
            return null;
        }
        if (!partFile.createNewFile()) {
            this.returnError("Failed to upload " + partitionName + " partition!");
            return null;
        }
        return partFile;
    }

    private boolean eraseEmmcOrUfs(IProgressMonitor uiMonitor, FlashType flashType) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        long neMMCCapacity = this.geteMMCSpaceSize(flashType);
        if (0L == neMMCCapacity) {
            this.warningln("Failed to get eMMC capacity!");
            return false;
        }
        long erasePartitionLen = neMMCCapacity / 512L * 512L;
        if (erasePartitionLen % 512L != 0L) {
            erasePartitionLen += 512L;
        }
        int length = 0x8000000;
        p properties = ((q)this.burner.getBurnContext().getDeviceSetting()).a();
        String boardType = properties.a("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("BVT")) {
            length = 0x2000000;
        }
        long count = erasePartitionLen / (long)length;
        long eraseLenSector = erasePartitionLen / 512L;
        uiMonitor.beginTask("", (int)(count * 10L) + 20);
        if (FastbootPreferences.isDiskFormatting()) {
            result = this.sendCommand(EraseCommand.eraseEmmc(Long.toHexString(0L), Long.toHexString(eraseLenSector), Long.toHexString(neMMCCapacity)));
        } else {
            long partLength = length;
            partLength /= 512L;
            IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
            String fillData = preferences.getString("hisilicon.fastboot.config.imageFill");
            long address = 0L;
            block0: while (eraseLenSector > 0L) {
                MWCommand memsetCommand;
                if (uiMonitor.isCanceled()) break;
                if (eraseLenSector >= (long)(length / 512)) {
                    memsetCommand = null;
                    if (fillData.equals("0xFF")) {
                        long writeSize = partLength * 512L;
                        if (flashType == FlashType.ufs) {
                            writeSize = partLength * 4096L;
                        }
                        memsetCommand = MWCommand.mwAddress_0xFF(this.getHexStartAddress(), Long.toHexString(writeSize));
                    } else {
                        memsetCommand = MWCommand.mwAddress_0x00(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                    }
                    result = this.sendCommand(memsetCommand);
                    uiMonitor.worked(5);
                    int i2 = 0;
                    while ((long)i2 < count) {
                        if (uiMonitor.isCanceled()) continue block0;
                        WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(partLength));
                        result = this.sendCommand(burnCommand);
                        address += partLength;
                        uiMonitor.worked(10);
                        eraseLenSector -= partLength;
                        ++i2;
                    }
                    continue;
                }
                memsetCommand = null;
                memsetCommand = fillData.equals("0xFF") ? MWCommand.mwAddress_0xFF(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L)) : MWCommand.mwAddress_0x00(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
                result = this.sendCommand(memsetCommand);
                uiMonitor.worked(5);
                WriteCommand burnCommand = WriteCommand.writeeMMC(flashType, this.getHexStartAddress(), Long.toHexString(address), Long.toHexString(eraseLenSector));
                result = this.sendCommand(burnCommand);
                address += eraseLenSector;
                uiMonitor.worked(10);
                eraseLenSector = 0L;
            }
        }
        return result;
    }

    private boolean eraseSpi(ArrayList<FlashType> hasFlashTypes, List<PartitionItem> parts) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        ArrayList<ChipID> existChipIDInParts = ChipID.getExistChipIDInParts(parts);
        if (existChipIDInParts != null) {
            for (ChipID chipID : existChipIDInParts) {
                result = this.sendCommand(SFCommand.getInstance(chipID));
                long spiSpaceSize = this.getSpiSpaceSize();
                if (spiSpaceSize == 0L || spiSpaceSize <= 0L || !result) continue;
                result = this.sendCommand(EraseCommand.erase(FlashType.spi, Long.toHexString(0L), Long.toHexString(spiSpaceSize)));
            }
        }
        return result;
    }

    private boolean eraseNand(ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        long nandSpaceSize = this.getNandSpaceSize();
        if (nandSpaceSize != 0L && nandSpaceSize > 0L) {
            EraseCommand eraseCommand = new EraseCommand("nand erase 0");
            eraseCommand.setTimeout(EraseCommand.calTimeout(String.valueOf(nandSpaceSize), FlashType.nand));
            result = this.sendCommand(eraseCommand);
        }
        return result;
    }

    private boolean eraseEmmcPart(SubProgressMonitor subProgressMonitor, PartitionItem part) throws IOException, ReceiveTimeOutException {
        long erasePartitionLen;
        boolean bRet = true;
        long startSector = part.getStart() / 512L;
        long partitionLen = part.getLength();
        int length = 0x8000000;
        p properties = ((q)this.burner.getBurnContext().getDeviceSetting()).a();
        String boardType = properties.a("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("BVT")) {
            length = 0x2000000;
        }
        if ((erasePartitionLen = partitionLen / 512L * 512L) % 512L != 0L) {
            erasePartitionLen += 512L;
        }
        long count = erasePartitionLen / (long)length;
        long eraseLenSector = erasePartitionLen / 512L;
        long partLength = length;
        partLength /= 512L;
        IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
        String fillData = preferences.getString("hisilicon.fastboot.config.imageFill");
        block0: while (eraseLenSector > 0L) {
            MWCommand memsetCommand;
            if (subProgressMonitor.isCanceled()) break;
            if (eraseLenSector >= (long)(length / 512)) {
                memsetCommand = null;
                memsetCommand = fillData.equals("0xFF") ? MWCommand.mwAddress_0xFF(this.getHexStartAddress(), Long.toHexString(partLength * 512L)) : MWCommand.mwAddress_0x00(this.getHexStartAddress(), Long.toHexString(partLength * 512L));
                bRet = this.sendCommand(memsetCommand);
                if (!bRet) {
                    return false;
                }
                int i2 = 0;
                while ((long)i2 < count) {
                    if (subProgressMonitor.isCanceled()) continue block0;
                    WriteCommand burnCommand = WriteCommand.writeeMMC(part.getFlashType(), this.getHexStartAddress(), Long.toHexString(startSector), Long.toHexString(partLength));
                    bRet = this.sendCommand(burnCommand);
                    startSector += partLength;
                    eraseLenSector -= partLength;
                    ++i2;
                }
                continue;
            }
            memsetCommand = null;
            memsetCommand = fillData.equals("0xFF") ? MWCommand.mwAddress_0xFF(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L)) : MWCommand.mwAddress_0x00(this.getHexStartAddress(), Long.toHexString(eraseLenSector * 512L));
            bRet = this.sendCommand(memsetCommand);
            if (!bRet) {
                return false;
            }
            WriteCommand burnCommand = WriteCommand.writeeMMC(part.getFlashType(), this.getHexStartAddress(), Long.toHexString(startSector), Long.toHexString(eraseLenSector));
            bRet = this.sendCommand(burnCommand);
            if (!bRet) {
                return false;
            }
            startSector += eraseLenSector;
            eraseLenSector = 0L;
        }
        return true;
    }

    private boolean burnByTransferWay(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount) throws IOException, ReceiveTimeOutException {
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        PartitionItem fastboot = parts.get(0);
        boolean result = true;
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        if (curTransferWay == TransferWay.Uart2Compress) {
            result = this.burnByUart2Compress(uimonitor, parts, hasFlashTypes, fastboot);
            if (!result) {
                return result;
            }
            String resetCommand = "reset";
            this.sendCommandNoReturnValue(resetCommand);
        } else if (curTransferWay == TransferWay.Usb2I2c || curTransferWay == TransferWay.I2CBootrom) {
            this.i2cTimeLogger = new d();
            this.flashTimeLogger = new d();
            this.resetTimeLogger = new d();
            result = this.burnByI2c(uimonitor, parts, fastboot, result, hasFlashTypes, selectedPartCount);
            if (this.isDebug()) {
                CommonBurnerWorker.getMonitor().println(this.i2cTimeLogger.a("I2C transmission time"));
                CommonBurnerWorker.getMonitor().println(this.flashTimeLogger.a("Burning Flash of time"));
                CommonBurnerWorker.getMonitor().println(this.resetTimeLogger.a("Reset time"));
            }
            if (!result) {
                return result;
            }
        } else {
            boolean isResetJtag;
            result = this.startBootForBurn(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot, curTransferWay);
            if (!result) {
                return result;
            }
            uimonitor.setTaskName("Burning Partitions");
            int partsSize = parts.size();
            this.startZipThread(uimonitor, parts, hasFlashTypes);
            int index = 1;
            while (index < partsSize) {
                PartitionItem partitionItem = parts.get(index);
                FlashType flashType = partitionItem.getFlashType();
                result = flashType == FlashType.emmc ? this.burnEachPartForEmmc(uimonitor, parts, index) : this.burnEachPartForNandOrSpi(uimonitor, parts, index);
                if (!result) {
                    return result;
                }
                ++index;
            }
            boolean bl2 = isResetJtag = !(!FastbootView.isHi3231V530Series() && !FastbootView.isHi3796MV200Series() && !FastbootView.isHi3716MV410_CA_N_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
            }
        }
        this.infoln("Partition burnt completed!");
        return result;
    }

    private boolean startBootForBurn(IProgressMonitor uimonitor, List<PartitionItem> parts, int selectedPartCount, ArrayList<FlashType> hasFlashTypes, PartitionItem fastboot, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        FlashType bootFlashType;
        if (fastboot.isChecked()) {
            uimonitor.setTaskName("Burning Fastboot Partition");
        }
        if ((bootFlashType = fastboot.getFlashType()) == FlashType.emmc) {
            int emmcType = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
            if (!this.burnbootForEmmc(curTransferWay, emmcType, fastboot, parts)) {
                return false;
            }
            if (!this.needSetupNetwork(curTransferWay)) {
                return false;
            }
        } else if (!this.burnbootForNandOrSpi(uimonitor, parts, selectedPartCount, hasFlashTypes, fastboot, curTransferWay)) {
            return false;
        }
        if (fastboot.getFile() != null) {
            this.burnBootTimeLogger.a();
        }
        return true;
    }

    private void startZipThread(IProgressMonitor uimonitor, List<PartitionItem> parts, ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        boolean hasEmmcFlash = this.isHasFlash(hasFlashTypes, FlashType.emmc);
        if (hasEmmcFlash) {
            long ddrFreeSize = this.getDDRFreeSize();
            this.useCompress = this.getTempDivisionSize(ddrFreeSize);
            this.runMakeZipThread(uimonitor, parts, this.useCompress);
        }
    }

    private boolean eraseForNandorSpi(SubProgressMonitor subProgressMonitor, int partsSize, int index, PartitionItem part) throws IOException, ReceiveTimeOutException {
        boolean bRet = true;
        String partitionName = part.getName();
        FlashType flashType = part.getFlashType();
        long partStart = part.getStart();
        long partLength = part.getLength();
        long startSector = partStart / 512L;
        if (index == partsSize - 1 && partLength == -1L && (partLength = this.getLastPartitionLen(part, partStart, partLength, flashType, startSector)) == -1L) {
            return false;
        }
        if (FlashType.spi == flashType) {
            bRet = this.sendCommand(SFCommand.getInstance(ChipID.chip0));
        }
        if (bRet) {
            bRet = this.sendCommand(EraseCommand.erase(flashType, Long.toHexString(partStart), Long.toHexString(partLength)));
        }
        if (!bRet) {
            this.returnError("Failed to Erase " + partitionName + " Partition!");
            return false;
        }
        this.infoln("Partition " + partitionName + " Erased successfully!");
        subProgressMonitor.worked(100);
        return bRet;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean startbootForNoneNude(IProgressMonitor uimonitor, List<PartitionItem> parts, ArrayList<FlashType> hasFlashTypes, TransferWay curTransferWay) throws IOException, ReceiveTimeOutException {
        PartitionItem fastboot = parts.get(0);
        FlashType bootFlashType = fastboot.getFlashType();
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (transferWay != TransferWay.USBNonNude) {
            boolean result = this.prepareToBurn(false, EventType.ERASE, hasFlashTypes);
            if (result) return true;
            return false;
        }
        boolean result = this.bootromByNonNude(uimonitor);
        if (!result) {
            return false;
        }
        if (bootFlashType != FlashType.nand) {
            if (bootFlashType != FlashType.spi) return true;
        }
        if (this.loadVersionInfo()) {
            this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            return true;
        }
        if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            this.loadBlockSizes(hasFlashTypes, ChipID.chip0, false);
            this.warningln("Warning: Failed to load version info!");
            return true;
        }
        this.returnError("Failed to load version info!");
        return false;
    }

    private boolean isHasFlash(ArrayList<FlashType> hasFlashTypes, FlashType curFlashType) {
        for (FlashType flashType : hasFlashTypes) {
            if (flashType != curFlashType) continue;
            return true;
        }
        return false;
    }

    private int getSelectedPartCount(List<PartitionItem> parts) {
        int selectedPartCount = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selectedPartCount;
        }
        return selectedPartCount;
    }

    private void createTimer() {
        this.burnBootTimeLogger = new d();
        this.tftpTimeLogger = new d();
        this.burnTimeLogger = new d();
        this.waitZipTimeLogger = new d();
        this.zipAndPageTimeLogger = new d();
        this.unZipTimeLogger = new d();
        this.spellingSparseFileLogger = new d();
        this.crcLogger = new d();
    }
}

