/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class DdrBurnerWorker
extends PartitionBurnerWorker {
    public static final String commontStart = "usbtftp start";
    public static final String commontError = "usbtftp error";
    public static final String commontEnd = "usbtftp end";
    private static final int receivedNumber = 10;

    public DdrBurnerWorker(IBurner burner) {
        super(burner);
        this.burner = burner;
    }

    public boolean burn(IProgressMonitor uiMonitor, String directory) {
        HiToolStatistics.INSTANCE.logUsage(c.FASTBOOT_MessageDialog_Title, "Ddr burn", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse(c.FASTBOOT_MessageDialog_Title);
        String versionInfo = this.getVersionInfo("Ddr burn");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().init(EventType.DDR_BURN);
        uiMonitor.beginTask("Ddr burn", 100);
        this.setProgressMonitor(uiMonitor);
        TransferWay curTransferWay = this.getBurner().getBurnContext().getTransferWay();
        if (curTransferWay == TransferWay.USBBootrom || curTransferWay == TransferWay.USBNonNude) {
            this.setFlashType(FlashType.ddr);
            while (true) {
                boolean startResult = this.waitOpenUsb(uiMonitor);
                uiMonitor.worked(20);
                if (startResult) {
                    if (uiMonitor.isCanceled()) {
                        this.sendUsbCommand(commontError);
                        break;
                    }
                    this.getCurReceived();
                    if (!this.sendUsbCommand(commontStart)) {
                        this.sendUsbCommand(commontError);
                        continue;
                    }
                    uiMonitor.worked(30);
                    String received = null;
                    int number = 0;
                    while (!uiMonitor.isCanceled()) {
                        if (number == 10) {
                            this.infoln("\nrequest information number:\t" + number);
                            break;
                        }
                        received = this.getCurUsbCommonReceived();
                        if (received == null || received.length() <= 0) {
                            this.infoln("\nrequest information is empty.\t");
                            ++number;
                            continue;
                        }
                        int index = received.indexOf("\n");
                        if (index > 0) {
                            received = received.substring(0, index);
                        }
                        received = received.trim();
                        this.infoln("\nrequest information:\t" + received);
                        if (received.toLowerCase().startsWith("usbtftp ")) {
                            String[] commons = received.split(" ");
                            if (commons.length < 3) {
                                this.warning("\nSend command format error, refer to ' usbtftp get addr file '.");
                                this.sendUsbCommand(commontError);
                                break;
                            }
                            String addressStr = commons[1];
                            String fileName = commons[2];
                            File file = new File(String.valueOf(directory) + File.separator + fileName);
                            if (!file.exists()) {
                                this.warning("\nFile does not exist:\t" + file.getPath());
                                this.sendUsbCommand(commontError);
                                break;
                            }
                            uiMonitor.setTaskName("Downloading File : " + file.getName());
                            uiMonitor.worked(50);
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(this.uimonitor, 100, 4);
                            this.uimonitor.setTaskName("Burning " + file.getName());
                            subProgressMonitor.setTaskName("Downloading File : " + file.getName());
                            this.infoln("\nSend command:\tDownloading File : " + file.getName());
                            int ddrAddress = this.getAddress(addressStr);
                            if (ddrAddress == 0) {
                                this.warning("\nMemory address Error :\t" + addressStr);
                                this.sendUsbCommand(commontError);
                                break;
                            }
                            boolean loadResult = CallLibUSBWorker.downloadFileByUsb(this.frameSetting, this.burner, subProgressMonitor, file, ddrAddress);
                            if (!loadResult) {
                                this.returnError(c.ERROR_INFO_USB_DOWNLOAD_FAILED);
                                this.sendUsbCommand(commontError);
                                break;
                            }
                            uiMonitor.worked(80);
                            if (!this.sendUsbCommand(commontEnd)) {
                                this.sendUsbCommand(commontError);
                                break;
                            }
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                            break;
                        }
                        ++number;
                    }
                }
                CallLibUSBWorker.closeUsb();
                if (uiMonitor.isCanceled()) break;
            }
        } else {
            this.warningln("\n" + c.DdrComposite_OnlyUsb);
        }
        return true;
    }

    private int getAddress(String addressStr) {
        int index;
        if (addressStr.toLowerCase().indexOf("0x") == 0) {
            addressStr = addressStr.substring(2, addressStr.length());
        }
        if ((index = addressStr.indexOf("\n")) > 0) {
            addressStr = addressStr.substring(0, index);
        }
        try {
            return (int)Long.parseLong(addressStr, 16);
        }
        catch (NumberFormatException NumberFormatException2) {
            NumberFormatException2.printStackTrace();
            return 0;
        }
    }

    private boolean sendUsbCommand(String infocmd) {
        try {
            if (!this.sendCommand(infocmd)) {
                this.returnError("Failed to send command " + infocmd + ". ");
                return false;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ReceiveTimeOutException e3) {
            e3.printStackTrace();
        }
        return true;
    }
}

