/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.commands.CrcCommand;
import com.hisilicon.fastboot.commands.EraseCommand;
import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.commands.INFOCommand;
import com.hisilicon.fastboot.commands.NetCommand;
import com.hisilicon.fastboot.commands.SFCommand;
import com.hisilicon.fastboot.commands.SerialCommand;
import com.hisilicon.fastboot.commands.TFTPCommand;
import com.hisilicon.fastboot.commands.UnZipCommand;
import com.hisilicon.fastboot.commands.WriteCommand;
import com.hisilicon.fastboot.jna.LibBootromByJNA;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.JTAG_STATUS;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IChecker;
import com.hisilicon.fastboot.model.devices.IAddressBurner;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.serial.workers.CallLibBootromWorker;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.serial.workers.Modem;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.views.FastbootView;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import gnu.io.SerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.tftp.hitool.TFTPService;
import org.soyatec.tftp.tftp4java.prefences.TFTPPreferences;

public class FastbootBurnerWorker
extends AbstractBurnerWorker
implements Modem {
    static final int TIMEOUT_XMODEM_EOT = 30000;
    static String msg_FailedToPrepareFile = "Failed to prepare File!";
    static String msg_FailedToLoadVersion = "Failed to load version info!";
    static String msg_BootBurnedSuccessfully = "Boot burned successfully.";
    private static long tempFileDivisionSize = 0L;
    protected static final String BLOCK_MARKED_BAD = "WARNING: block is marked as bad";
    protected String version;
    protected BoardConfig boardConfig;
    protected LocalConfig localConfig;
    String ubootStartLog;
    protected static final int OUTPUT_PARAM_SIZE = 1;
    protected static final int TIMEMS = 10000;
    private static final int CANCEL_CODE = 256;
    private static final int SERIAL_SEPARATE_SIZE = 0x500000;
    private static final String PARTITION_SBL = "sbl";
    protected d burnBootTimeLogger = new d();
    protected d tftpTimeLogger = new d();
    protected d burnTimeLogger = new d();
    protected d waitZipTimeLogger = new d();
    protected d zipAndPageTimeLogger = new d();
    protected d unZipTimeLogger = new d();
    protected d eraseTimeLogger = new d();
    protected d spellingSparseFileLogger = new d();
    protected d crcLogger = new d();
    protected d i2cTimeLogger = new d();
    protected d flashTimeLogger = new d();
    protected d resetTimeLogger = new d();
    protected static final int TFTP_MAX_RETURN_COUNT = 3;

    public FastbootBurnerWorker(IFrameSetting frameSetting, IBurner burner) {
        super(frameSetting);
        this.burner = burner;
        if (burner != null) {
            BurnContext burnContext = burner.getBurnContext();
            this.localConfig = burnContext.getLocalConfig();
            this.boardConfig = burnContext.getBoardConfig();
        }
    }

    public boolean burn(IProgressMonitor uimonitor, FlashType flashType, String filePath) throws IOException, ReceiveTimeOutException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Burn By Fastboot", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Burn By Fastboot");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            boolean isResetJtag;
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            if (FastbootView.isJTagTransferMode()) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
                new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
                LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
            }
            FastbootEvent event = FastbootBurnerWorker.getMonitor().getEvent();
            event.init(EventType.BURN);
            this.setFlashType(flashType);
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            File file = new File(filePath);
            if (transferWay == TransferWay.Uart2Compress) {
                uimonitor.setTaskName("Init Board");
                ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
                hasFlashTypes.add(flashType);
                boolean initBoard = this.initBoard(hasFlashTypes);
                if (!initBoard) {
                    return false;
                }
                this.getTempFileDivisionSize();
            } else {
                if (transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom) {
                    boolean result = this.burnSinglePartByI2c(uimonitor, file, "0", flashType, true, ChipID.chip0);
                    if (result) {
                        event.setSuccess(true);
                        uimonitor.done();
                        return true;
                    }
                    return false;
                }
                if (transferWay == TransferWay.USBNonNude) {
                    boolean result = false;
                    result = this.bootromByNonNude(uimonitor);
                    if (!result) {
                        return false;
                    }
                    result = this.downloadBootByUSB(uimonitor, file);
                    if (!result) {
                        return false;
                    }
                } else if (((q)this.burner.getBurnContext().getDeviceSetting()).h()) {
                    if (!this.programmerDownload(new SubProgressMonitor(uimonitor, 86, 4), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                        this.returnError("Failed to download fastboot!");
                        return false;
                    }
                } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(new SubProgressMonitor(uimonitor, 86, 2), filePath) : !this.programmerDownload(new SubProgressMonitor(uimonitor, 86, 2), filePath, ((AbstractBurner)((Object)this.burner)).getProgrammerFile(), null)) {
                    return false;
                }
            }
            if (flashType == FlashType.ddr) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    this.warningln("Error occurs while waiting DDR run.");
                    File file2 = new File(filePath);
                    this.printCrcValue(file2);
                    uimonitor.done();
                    return false;
                }
                FastbootBurnerWorker.received(this.getCurReceived());
                event.setSuccess(true);
                uimonitor.done();
                FastbootBurnerWorker.deleteContent(usbsReceived);
                return true;
            }
            String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
            if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                File partFile = this.copyComFileToHiToolPath(uimonitor, file);
                if (partFile == null) {
                    return false;
                }
                File compressFile = bh.a(uimonitor, partFile, false, true);
                if (compressFile == null) {
                    this.returnError(NLS.bind((String)c.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
                    return false;
                }
                this.downloadFileSerial(new SubProgressMonitor((IProgressMonitor)new SubProgressMonitor(uimonitor, 86, 2), 95, 4), compressFile, false);
                if (compressFile.exists()) {
                    bg.a(compressFile);
                }
                if (partFile.exists()) {
                    bg.a(partFile);
                }
                if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                }
                if (flashType == FlashType.ddr) {
                    this.sendCommandNoReturnValue("go " + unzipAddr);
                }
            }
            uimonitor.setTaskName("Loading Info");
            if (this.loadVersionInfo()) {
                FlashType loadBootMode = this.loadBootMode();
                if (flashType != loadBootMode && loadBootMode != null) {
                    this.returnError(NLS.bind((String)c.ERROR_INFO_Invalid_Mode_And_RealMode, (Object)loadBootMode.name()));
                    return false;
                }
            } else {
                this.warningln(msg_FailedToLoadVersion);
                return false;
            }
            uimonitor.worked(1);
            uimonitor.setTaskName("Burning Boot");
            long blockSize = this.getBlockSize(flashType, ChipID.chip0, true);
            if (blockSize == 0L) {
                String error = "Failed to load blocksize for " + flashType.name();
                this.returnError(error);
                return false;
            }
            long fileSize = file.length();
            long eraseLength = fileSize;
            if (eraseLength % blockSize != 0L) {
                eraseLength = (eraseLength / blockSize + 1L) * blockSize;
            }
            long writeLength = 0L;
            writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
            if (!this.bootBurn(new SubProgressMonitor(uimonitor, 12, 4), flashType, Long.toHexString(eraseLength), Long.toHexString(writeLength), ChipID.chip0)) {
                this.returnError("Failed to burn boot.");
                return false;
            }
            TransferWay curTransferWay = this.burner.getBurnContext().getTransferWay();
            boolean bl2 = isResetJtag = !(!FastbootView.isHi3231V530Series() && !FastbootView.isHi3796MV200Series() && !FastbootView.isHi3716MV410_CA_N_Series() || curTransferWay != TransferWay.JTAG && curTransferWay != TransferWay.JTAGAndNet && curTransferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                this.sendCommandNoReturnValue("reset");
            }
            event.setSuccess(true);
            this.infoln(msg_BootBurnedSuccessfully);
        }
        finally {
            File file = new File(filePath);
            this.printCrcValue(file);
            uimonitor.done();
        }
        return true;
    }

    protected boolean downloadBootByUSB(IProgressMonitor uimonitor, File file) {
        this.infoln("\nSend command:\tDownloading File : " + file.getName());
        SubProgressMonitor subProgress = new SubProgressMonitor(uimonitor, 100, 4);
        boolean result = CallLibUSBWorker.downloadFileByUsb(this.frameSetting, this.burner, subProgress, file, this.getHexStartAddressForInt());
        subProgress.worked(100);
        if (!result) {
            this.returnError(c.ERROR_INFO_USB_DOWNLOAD_FAILED);
            return false;
        }
        return true;
    }

    public boolean bootBurn(SubProgressMonitor subProgressMonitor, FlashType flashType, String eraseLength, String writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        String address = "0x0";
        String wLen = writeLength;
        if (wLen == null) {
            wLen = eraseLength;
        }
        String ddrAddress = this.getHexStartAddress();
        String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
            ddrAddress = unzipAddr;
        }
        FlashType flash = flashType;
        ArrayList<SerialCommand> commands = new ArrayList<SerialCommand>();
        if (flash == FlashType.emmc || flash == FlashType.ufs) {
            commands.clear();
            int commandType = ((q)this.burner.getBurnContext().getDeviceSetting()).c();
            int emmcType = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA || commandType == 0) {
                if (emmcType == 2) {
                    commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "0", wLen));
                } else {
                    commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "1", wLen));
                }
            } else if (emmcType == 2) {
                commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "0", wLen));
            } else if (emmcType == 3) {
                commands.add(WriteCommand.writeeMMC(flashType, ddrAddress, "1", wLen));
            } else {
                commands.add(WriteCommand.bootWriteeMMC(ddrAddress, "0", wLen));
            }
        } else {
            if (flash == FlashType.spi) {
                commands.add(SFCommand.getInstance(chipID));
            }
            commands.add(EraseCommand.erase(flash, address, eraseLength));
            commands.add(WriteCommand.write(flash, ddrAddress, address, wLen));
        }
        try {
            int total = commands.size();
            subProgressMonitor.beginTask("", total * 100);
            subProgressMonitor.setTaskName("Burning Boot");
            int i2 = 0;
            while (i2 < commands.size()) {
                SerialCommand serialCommand = (SerialCommand)commands.get(i2);
                subProgressMonitor.subTask("Execute command:" + serialCommand.getCommand());
                if (!this.sendCommand(serialCommand)) {
                    return false;
                }
                subProgressMonitor.worked(100);
                ++i2;
            }
        }
        finally {
            subProgressMonitor.done();
        }
        return true;
    }

    private boolean isJTAG() {
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        return isBootromByJTAG;
    }

    public boolean bootDownload(String filePath) throws IOException {
        boolean isBootromByJTAG;
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isSupportLibBootrom = ((q)this.burner.getBurnContext().getDeviceSetting()).h() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        boolean bl2 = isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isSupportLibBootrom) {
            return this.burnByLibBootrom(filePath);
        }
        if (isBootromByJTAG) {
            FastbootBurnerWorker.deleteContent(jtagReceived);
            FastbootView.setFastbootStart(false);
            boolean result = this.burnByJTAG(filePath);
            if (result) {
                this.infoln("Boot started successfully!");
                if (FastbootView.isHi3231V530Series()) {
                    FastbootView.setFastbootStart(true);
                }
            }
            return result;
        }
        try {
            if (filePath == null || filePath.length() == 0) {
                this.prepareFile();
            } else if (!this.prepareFile(filePath)) {
                this.returnError(msg_FailedToPrepareFile);
                return false;
            }
            if (!this.downloadFile()) {
                this.returnError(c.ERROR_INFO_Failed_To_Download_File);
                return false;
            }
            this.infoln("Boot download completed!");
            if (this.getFlashType() != DDR) {
                if (!this.waitBootRun(10000)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
            }
            return true;
        }
        finally {
            if (this.fileList != null) {
                this.fileList = null;
            }
        }
    }

    protected boolean tftpAndCheckCRC(SubProgressMonitor subProgressMonitor, File file, int retransmitCount) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        if (TFTPService.TFTPSERVICE.getServerDirectory() != null && !TFTPService.TFTPSERVICE.getServerDirectory().equals(file.getParentFile())) {
            this.switchTFTPDownloadHome(file);
        }
        if (this.tftpTimeLogger != null) {
            this.tftpTimeLogger.a(file.getName(), file.length());
        }
        if (subProgressMonitor != null) {
            subProgressMonitor.setTaskName("Download " + file.getName());
        }
        TFTPCommand downloadCommand = TFTPCommand.download(file, this.getHexStartAddress());
        result = this.sendCommand(downloadCommand);
        if (this.tftpTimeLogger != null) {
            this.tftpTimeLogger.a();
        }
        if (!result) {
            return result;
        }
        if (result) {
            boolean openTftpCrcCheck;
            boolean bl2 = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isHi3231V530Series();
            if (openTftpCrcCheck) {
                result = this.checkTFTPCrc32(subProgressMonitor, file, retransmitCount, result);
            }
        }
        return result;
    }

    private boolean checkTFTPCrc32(SubProgressMonitor subProgressMonitor, File file, int retransmitCount, boolean result) throws IOException, ReceiveTimeOutException {
        String crcReturnStr;
        boolean compareCRCResult;
        long fileCrcValue = CrcCommand.calculateCRC(file);
        if (this.crcLogger != null) {
            this.crcLogger.a(file.getName(), file.length());
        }
        if (this.sendCommand(CrcCommand.sendCRCCommand(file, this.getHexStartAddress())) && !(compareCRCResult = CrcCommand.compareFileCRC(fileCrcValue, CrcCommand.receiveCRC(crcReturnStr = this.getCurReceived())))) {
            if (retransmitCount >= 3) {
                result = false;
                return result;
            }
            boolean isSupportTFTPWin = ((q)this.burner.getBurnContext().getDeviceSetting()).d();
            if (isSupportTFTPWin) {
                if (FastbootPreferences.isOpenTftpWindowSize() && TFTPService.getWinSizeBlockCount() > 0 && TFTPService.getWinSizeBlockCount() > 1) {
                    TFTPService.setWinSizeBlockCount((int)(TFTPService.getWinSizeBlockCount() - 1));
                    this.infoln("The current Window Size value is " + (TFTPService.getWinSizeBlockCount() + 1));
                }
            } else {
                TFTPService.setWinSizeBlockCount((int)1);
            }
            this.warningln("Warn:CRC check failed, TFTP download again.");
            result = this.tftpAndCheckCRC(subProgressMonitor, file, ++retransmitCount);
            if (!result) {
                return false;
            }
        }
        if (this.crcLogger != null) {
            this.crcLogger.a();
        }
        return result;
    }

    protected boolean burnByLibBootrom(SubProgressMonitor subProgressMonitor, String filePath) {
        try {
            CallLibBootromWorker callLibBootromWorker = new CallLibBootromWorker(this.frameSetting, this.burner, subProgressMonitor);
            LibBootromByJNA.instance.RegisterPrint(callLibBootromWorker.callback);
            LibBootromByJNA.instance.RegisterCancel(callLibBootromWorker.callbackCancel);
            String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
            int notBareBurn = filePath == null || filePath.isEmpty() ? 1 : 0;
            int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
            int[] caType = new int[1];
            long[] initDdrAddr = new long[1];
            int[] errorCode = new int[1];
            if (q.b()) {
                this.initLightState();
            }
            this.infoln(this.getStartMessage());
            subProgressMonitor.worked(1);
            boolean result = CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
            SerialPort serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort());
            if (serialPort == null) {
                return false;
            }
            if (result) {
                String caTypeStr = "";
                if (caType[0] == 1) {
                    caTypeStr = "CA";
                    this.isCaChipByLibBootrom = true;
                } else {
                    caTypeStr = "noCA";
                    this.isCaChipByLibBootrom = false;
                }
                this.updateCaTypeLbl(caTypeStr);
                ((o)this.frameSetting).a(initDdrAddr[0]);
            } else if ((errorCode[0] & 0xFFFF) == 256) {
                this.handleCancel();
                return false;
            }
            subProgressMonitor.worked(100);
            boolean bl2 = result;
            return bl2;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    protected boolean burnByLibBootrom(String filePath) {
        SubProgressMonitor subMonitor = null;
        if (this.uimonitor != null) {
            subMonitor = new SubProgressMonitor(this.uimonitor, 50, 4);
        }
        CallLibBootromWorker callLibBootromWorker = new CallLibBootromWorker(this.frameSetting, this.burner, subMonitor);
        LibBootromByJNA.instance.RegisterPrint(callLibBootromWorker.callback);
        LibBootromByJNA.instance.RegisterCancel(callLibBootromWorker.callbackCancel);
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude) {
            filePath = null;
        }
        String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
        int notBareBurn = filePath == null || filePath.isEmpty() ? 1 : 0;
        int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
        int[] caType = new int[1];
        long[] initDdrAddr = new long[1];
        int[] errorCode = new int[1];
        if (q.b()) {
            this.initLightState();
        }
        this.infoln(this.getStartMessage());
        boolean result = CallLibBootromWorker.bootDownloadByLib(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
        SerialPort serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort());
        if (serialPort == null) {
            return false;
        }
        if (result) {
            String caTypeStr = "";
            if (caType[0] == 1) {
                caTypeStr = "CA";
                this.isCaChipByLibBootrom = true;
            } else {
                caTypeStr = "noCA";
                this.isCaChipByLibBootrom = false;
            }
            this.updateCaTypeLbl(caTypeStr);
            ((o)this.frameSetting).a(initDdrAddr[0]);
        } else if ((errorCode[0] & 0xFFFF) == 256) {
            this.handleCancel();
            return false;
        }
        return result;
    }

    protected boolean burnByJTAG(SubProgressMonitor subProgressMonitor, String filePath, int level) {
        try {
            SerialPort serialPort;
            String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
            int jtagChipType = FastbootView.getJtagChipTypeByChipName().ordinal();
            int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
            long[] initDdrAddr = new long[]{this.frameSetting.getThirdFileAddress()};
            int[] errorCode = new int[1];
            if (FastbootView.isHi3716MV410_CA_N_Series()) {
                this.infoln("\n" + c.ERROR_INFO_Start_JTAG);
            }
            subProgressMonitor.worked(1);
            boolean result = CallLibJTAGWorker.bootDownloadByLib(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, LibJTAGByJNA.JTAG_DLL_PATH, errorCode, level);
            if (!result) {
                this.checkJTAGReturn(errorCode);
                boolean bl2 = result;
                return bl2;
            }
            ((o)this.frameSetting).a(initDdrAddr[0]);
            if ((FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3716mv420b03 || FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3231V520) && (serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort())) == null) {
                return false;
            }
            subProgressMonitor.worked(100);
            boolean bl3 = result;
            return bl3;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private void checkJTAGReturn(int[] errorCode) {
        int error = errorCode[0] & 0xFFFF;
        if (error == 256) {
            this.handleCancel();
        } else if (error == JTAG_STATUS.OPENOCD_DEVICE_NOT_FOUND.getErrorCode()) {
            monitor.getEvent().setMessage(c.ERROR_JTAG_OPENOCD_DEVICE_NOT_FOUND);
        } else if (error == JTAG_STATUS.SERAIL_PORT_OPEN_FAILED.getErrorCode()) {
            monitor.getEvent().setMessage(c.SERAIL_PORT_OPEN_FAILED);
        } else if (error == JTAG_STATUS.SERAIL_PORT_NO_DATA.getErrorCode()) {
            monitor.getEvent().setMessage(c.SERAIL_PORT_NO_DATA);
        } else if (error == JTAG_STATUS.SERAIL_PORT_BOOT_NOT_RUN.getErrorCode()) {
            monitor.getEvent().setMessage(c.SERAIL_PORT_BOOT_NOT_RUN);
        }
    }

    protected boolean burnByJTAG(String filePath) {
        SerialPort serialPort;
        int jtagFrequency;
        boolean result;
        if (filePath != null && filePath.isEmpty()) {
            filePath = null;
        }
        String commName = this.burner.getBurnContext().getLocalConfig().getComPort();
        int jtagChipType = FastbootView.getJtagChipTypeByChipName().ordinal();
        int ddrOrFlash = this.getFlashType() != DDR ? 0 : 1;
        long[] initDdrAddr = new long[]{this.frameSetting.getThirdFileAddress()};
        int[] errorCode = new int[1];
        if (FastbootView.isHi3716MV410_CA_N_Series()) {
            this.infoln("\n" + c.ERROR_INFO_Start_JTAG);
        }
        if (!(result = CallLibJTAGWorker.bootDownloadByLib(jtagChipType, commName, ddrOrFlash, initDdrAddr, filePath, LibJTAGByJNA.JTAG_DLL_PATH, errorCode, jtagFrequency = this.burner.getBurnContext().getJtagFrequency()))) {
            this.checkJTAGReturn(errorCode);
            return result;
        }
        ((o)this.frameSetting).a(initDdrAddr[0]);
        if ((FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3716mv420b03 || FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3231V520) && (serialPort = ((AbstractBurner)((Object)this.burner)).openSerailPort(FastbootBurnerWorker.getMonitor(), this, this.burner.getBurnContext().getLocalConfig().getComPort())) == null) {
            return false;
        }
        return result;
    }

    public boolean bootDownload(SubProgressMonitor subProgressMonitor, String filePath) throws IOException {
        boolean isBootromByJTAG;
        subProgressMonitor.beginTask("", 100);
        TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
        boolean isSupportLibBootrom = ((q)this.burner.getBurnContext().getDeviceSetting()).h() && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        boolean bl2 = isBootromByJTAG = transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isSupportLibBootrom) {
            try {
                subProgressMonitor.setTaskName("Downloading Boot");
                if (!this.burnByLibBootrom(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 98, 4), filePath)) {
                    this.updateLightState();
                    return false;
                }
                this.infoln("Boot started successfully!");
                return true;
            }
            finally {
                subProgressMonitor.done();
            }
        }
        if (isBootromByJTAG) {
            FastbootBurnerWorker.deleteContent(jtagReceived);
            FastbootView.setFastbootStart(false);
            int jtagFrequency = this.burner.getBurnContext().getJtagFrequency();
            try {
                subProgressMonitor.setTaskName("Downloading Boot");
                if (!this.burnByJTAG(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 98, 4), filePath, jtagFrequency)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
                if (this.getFlashType() != DDR) {
                    FastbootView.setFastbootStart(true);
                }
                return true;
            }
            finally {
                subProgressMonitor.done();
            }
        }
        try {
            subProgressMonitor.setTaskName("Downloading Boot");
            if (filePath == null || filePath.length() == 0) {
                this.prepareFile();
            } else if (!this.prepareFile(filePath)) {
                this.returnError(msg_FailedToPrepareFile);
                return false;
            }
            if (!this.downloadFile(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 98, 4))) {
                this.returnError(c.ERROR_INFO_Failed_To_Download_File);
                return false;
            }
            this.infoln("Boot download completed!");
            if (this.getFlashType() != DDR) {
                subProgressMonitor.subTask("Waiting Boot to Run");
                if (!this.waitBootRun(10000)) {
                    return false;
                }
                this.infoln("Boot started successfully!");
            }
            return true;
        }
        finally {
            if (this.fileList != null) {
                this.fileList = null;
            }
            subProgressMonitor.done();
        }
    }

    public boolean programmerDownload(String bootFile, String programmerFile) {
        block27: {
            block30: {
                block29: {
                    block28: {
                        boolean programmerInvaild;
                        boolean bootAndProgisInVaild;
                        block24: {
                            block25: {
                                block26: {
                                    boolean programmerInvaild2;
                                    block20: {
                                        block22: {
                                            block23: {
                                                boolean programmerInvaild3;
                                                block21: {
                                                    try {
                                                        boolean bootAndProgrammerisInVaild;
                                                        if (!((q)this.burner.getBurnContext().getDeviceSetting()).h()) break block20;
                                                        boolean bl2 = bootAndProgrammerisInVaild = (bootFile == null || bootFile.isEmpty()) && (programmerFile == null || programmerFile.isEmpty()) || this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude;
                                                        if (!bootAndProgrammerisInVaild) break block21;
                                                        if (!this.bootDownload(null)) {
                                                            return false;
                                                        }
                                                    }
                                                    catch (IOException e2) {
                                                        e2.printStackTrace();
                                                        return false;
                                                    }
                                                }
                                                boolean bl3 = programmerInvaild3 = programmerFile == null || programmerFile.isEmpty();
                                                if (!programmerInvaild3) break block22;
                                                if (this.bootDownload(bootFile)) break block23;
                                                return false;
                                            }
                                            if (!this.isCaChipByLibBootrom) {
                                                return true;
                                            }
                                        }
                                        if (!this.bootDownload(programmerFile)) {
                                            return false;
                                        }
                                    }
                                    if (!this.isJTAG()) break block24;
                                    boolean bl4 = programmerInvaild2 = programmerFile == null || programmerFile.isEmpty();
                                    if (!programmerInvaild2) break block25;
                                    if (this.bootDownload(bootFile)) break block26;
                                    return false;
                                }
                                if (!this.isCaChipByLibBootrom) {
                                    return true;
                                }
                            }
                            if (!this.bootDownload(programmerFile)) {
                                return false;
                            }
                        }
                        boolean bl5 = bootAndProgisInVaild = !(bootFile != null && !bootFile.isEmpty() || programmerFile != null && !programmerFile.isEmpty());
                        if (bootAndProgisInVaild) break block27;
                        boolean bl6 = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                        if (!programmerInvaild) break block28;
                        if (!this.prepareProgrammerFile(bootFile)) {
                            return false;
                        }
                        break block29;
                    }
                    if (this.prepareProgrammerFile(programmerFile)) break block29;
                    return false;
                }
                if (this.downloadFile()) break block30;
                return false;
            }
            if (this.getFlashType() != DDR) break block27;
            return true;
        }
        if (!this.waitBootRunCA()) {
            return false;
        }
        return this.downloadBootAgain(bootFile);
    }

    private boolean downloadBootAgain(String bootFile) {
        boolean bootFileVaild;
        boolean bl2 = bootFileVaild = bootFile != null && !bootFile.isEmpty();
        if (bootFileVaild) {
            boolean needOpenNetWork;
            File bFile = new File(bootFile);
            boolean isSerialOnly = this.burner instanceof IBootBurner && !(this.burner instanceof IAddressBurner) || this.burner instanceof IChecker;
            boolean downloadResult = true;
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            boolean bl3 = needOpenNetWork = (transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet) && !isSerialOnly;
            if (needOpenNetWork) {
                block16: {
                    if (this.setupNetwork(transferWay)) break block16;
                    this.returnError("Failed to setup network!");
                    return false;
                }
                try {
                    this.switchTFTPDownloadHome(bFile);
                    if (!this.sendCommand(TFTPCommand.download(bFile, this.getHexStartAddress()))) {
                        downloadResult = false;
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException e3) {
                    e3.printStackTrace();
                    downloadResult = false;
                }
            } else if (transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial) {
                boolean result = this.sendFileByJTAG(bFile);
                if (!result) {
                    this.returnError(c.FAILED_TO_DOWNLOAD_FILE_BY_JTAG);
                    return false;
                }
            } else {
                try {
                    if (!this.downloadFileSerial(bFile)) {
                        downloadResult = false;
                    }
                }
                catch (IOException e4) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException e5) {
                    downloadResult = false;
                }
            }
            if (!downloadResult) {
                this.warningln("\nFailed to downlaod file. Please check the board status and connection, then try again.");
                return false;
            }
        }
        return true;
    }

    public boolean programmerDownload(SubProgressMonitor subProgressMonitor, String bootFile, String programmerFile, List<PartitionItem> parts) {
        block25: {
            block28: {
                block27: {
                    block26: {
                        boolean programmerInvaild;
                        boolean bootAndProgisInVaild;
                        block20: {
                            block24: {
                                block22: {
                                    block23: {
                                        boolean programmerInvaild2;
                                        block21: {
                                            subProgressMonitor.setTaskName("Downloading Boot");
                                            if (FastbootView.isJTagTransferMode()) {
                                                new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor);
                                                LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                                                LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
                                            }
                                            try {
                                                boolean bootAndProgrammerisInVaild;
                                                boolean isLibBootromOrJtag;
                                                boolean bl2 = isLibBootromOrJtag = ((q)this.burner.getBurnContext().getDeviceSetting()).h() || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAG || this.burner.getBurnContext().getTransferWay() == TransferWay.JTAGAndSerial;
                                                if (!isLibBootromOrJtag) break block20;
                                                boolean bl3 = bootAndProgrammerisInVaild = (bootFile == null || bootFile.isEmpty()) && (programmerFile == null || programmerFile.isEmpty()) || this.burner.getBurnContext().getTransferWay() == TransferWay.NetNonNude;
                                                if (!bootAndProgrammerisInVaild) break block21;
                                                if (!this.bootDownload(subProgressMonitor, null)) {
                                                    return false;
                                                }
                                            }
                                            catch (IOException e2) {
                                                e2.printStackTrace();
                                                return false;
                                            }
                                        }
                                        boolean bl4 = programmerInvaild2 = programmerFile == null || programmerFile.isEmpty();
                                        if (!programmerInvaild2) break block22;
                                        if (this.bootDownload(subProgressMonitor, bootFile)) break block23;
                                        return false;
                                    }
                                    if (!this.isCaChipByLibBootrom) {
                                        return true;
                                    }
                                }
                                boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
                                if (!needDownLoadSBL || bootFile == null || bootFile.isEmpty()) break block24;
                                if (!this.bootDownload(subProgressMonitor, bootFile)) {
                                    return false;
                                }
                            }
                            if (!this.bootDownload(subProgressMonitor, programmerFile)) {
                                return false;
                            }
                        }
                        boolean bl5 = bootAndProgisInVaild = !(bootFile != null && !bootFile.isEmpty() || programmerFile != null && !programmerFile.isEmpty());
                        if (bootAndProgisInVaild) break block25;
                        boolean bl6 = programmerInvaild = programmerFile == null || programmerFile.isEmpty();
                        if (!programmerInvaild) break block26;
                        if (!this.prepareProgrammerFile(bootFile)) {
                            return false;
                        }
                        break block27;
                    }
                    if (this.prepareProgrammerFile(programmerFile)) break block27;
                    return false;
                }
                subProgressMonitor.subTask("Downloading boot");
                if (this.downloadFile(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 40, 4))) break block28;
                return false;
            }
            if (this.getFlashType() != DDR) break block25;
            return true;
        }
        subProgressMonitor.subTask("Waiting Boot to Run");
        if (!this.waitBootRunCA()) {
            return false;
        }
        if (this.getFlashType() == DDR) {
            return true;
        }
        boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
        if (needDownLoadSBL) {
            return true;
        }
        subProgressMonitor.subTask("Preparing");
        return this.downloadBootAgain(subProgressMonitor, bootFile);
    }

    protected boolean burnSBL(IProgressMonitor uiMonitor, List<PartitionItem> parts, String programmerPath) throws IOException, ReceiveTimeOutException {
        boolean needDownLoadSBL = this.getNeedDownLoadSBL(parts);
        if (needDownLoadSBL) {
            File sblFile = this.getSBLFile(parts);
            if (programmerPath != null && !programmerPath.isEmpty()) {
                sblFile = new File(programmerPath);
            }
            if (sblFile == null) {
                return false;
            }
            boolean result = this.downloadFileSerial(new SubProgressMonitor(uiMonitor, 95, 4), sblFile, true);
            if (!result) {
                return result;
            }
            this.getSerialPort().notifyOnDataAvailable(true);
            if (!this.waitBootRun(10000)) {
                return false;
            }
            this.infoln("SBL Started successfully!");
            PartitionItem fastboot = parts.get(0);
            if (!fastboot.isChecked()) {
                return true;
            }
            File file = fastboot.getFile();
            String bootFilePath = file.getPath();
            if (!this.downloadBootAgain(new SubProgressMonitor(uiMonitor, 95, 4), bootFilePath)) {
                return false;
            }
        }
        return true;
    }

    protected boolean getNeedDownLoadSBL(List<PartitionItem> parts) {
        if (!FastbootView.isNeedDownLoadSBLSeries() || parts == null) {
            return false;
        }
        boolean hasSBL = false;
        boolean hasSBLFile = false;
        for (PartitionItem partitionItem : parts) {
            boolean vaildFile;
            String name = partitionItem.getName();
            if (name == null || !name.equalsIgnoreCase(PARTITION_SBL)) continue;
            hasSBL = true;
            File sblFile = partitionItem.getFile();
            if (sblFile == null) continue;
            boolean bl2 = vaildFile = sblFile.exists() && !sblFile.isDirectory();
            if (vaildFile) {
                hasSBLFile = true;
                break;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"HiBurn", (String)c.WARN_SBL_IS_NOT_SELECT_FILE);
            break;
        }
        return hasSBL && hasSBLFile;
    }

    private File getSBLFile(List<PartitionItem> parts) {
        for (PartitionItem partitionItem : parts) {
            String name = partitionItem.getName();
            if (!name.equalsIgnoreCase(PARTITION_SBL)) continue;
            return partitionItem.getFile();
        }
        return null;
    }

    private boolean downloadBootAgain(SubProgressMonitor subProgressMonitor, String bootFile) {
        boolean bootFileVaild;
        boolean bl2 = bootFileVaild = bootFile != null && !bootFile.isEmpty();
        if (bootFileVaild) {
            boolean needOpenNetWork;
            File bFile = new File(bootFile);
            boolean downloadResult = true;
            TransferWay transferWay = this.burner.getBurnContext().getTransferWay();
            boolean bl3 = needOpenNetWork = transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.NetNonNude;
            if (needOpenNetWork) {
                block19: {
                    if (this.setupNetwork(transferWay)) break block19;
                    this.returnError("Failed to setup network!");
                    return false;
                }
                try {
                    this.switchTFTPDownloadHome(bFile);
                    int retransmitCount = 1;
                    boolean result = this.tftpAndCheckCRC(subProgressMonitor, bFile, retransmitCount);
                    if (!result) {
                        this.returnError(c.Partition_TFTP_CRC_Failed);
                        return false;
                    }
                }
                catch (IOException e2) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException e3) {
                    downloadResult = false;
                }
            } else if (transferWay == TransferWay.JTAGAndSerial || transferWay == TransferWay.JTAG) {
                int retransmitCount = 1;
                boolean result = false;
                try {
                    result = this.jtagAndCheckCRC(subProgressMonitor, result, bFile, retransmitCount);
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                catch (ReceiveTimeOutException e5) {
                    e5.printStackTrace();
                }
                if (!result) {
                    this.returnError(c.Partition_JTAG_CRC_Failed);
                    return false;
                }
            } else {
                try {
                    if (!this.downloadFileSerial(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 20, 4), bFile, false)) {
                        downloadResult = false;
                    }
                }
                catch (IOException e6) {
                    downloadResult = false;
                }
                catch (ReceiveTimeOutException e7) {
                    downloadResult = false;
                }
            }
            if (!downloadResult) {
                this.warningln("\nFailed to downlaod file. Please check the board status and connection, then try again.");
                return false;
            }
        }
        return true;
    }

    protected boolean jtagAndCheckCRC(SubProgressMonitor subProgressMonitor, boolean result, File partfile, int retransmitCount) throws IOException, ReceiveTimeOutException {
        boolean openTftpCrcCheck;
        result = this.sendFileByJTAG(partfile);
        if (!result) {
            return false;
        }
        boolean bl2 = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isHi3231V530Series();
        if (openTftpCrcCheck) {
            result = this.checkJtagCrc32(subProgressMonitor, result, partfile, retransmitCount);
        }
        return result;
    }

    protected boolean checkJtagCrc32(SubProgressMonitor subProgressMonitor, boolean result, File partfile, int retransmitCount) throws IOException, ReceiveTimeOutException {
        String crcReturnStr;
        boolean compareCRCResult;
        long fileCrcValue = CrcCommand.calculateCRC(partfile);
        if (this.crcLogger != null) {
            this.crcLogger.a(partfile.getName(), partfile.length());
        }
        if (this.sendCommand(CrcCommand.sendCRCCommand(partfile, this.getHexStartAddress())) && !(compareCRCResult = CrcCommand.compareFileCRC(fileCrcValue, CrcCommand.receiveCRC(crcReturnStr = this.getCurReceived())))) {
            if (retransmitCount >= 3) {
                result = false;
                return result;
            }
            this.warningln("Warn:CRC check failed, JTAG download again.");
            result = this.jtagAndCheckCRC(subProgressMonitor, result, partfile, ++retransmitCount);
            if (!result) {
                return false;
            }
        }
        if (this.crcLogger != null) {
            this.crcLogger.a();
        }
        return result;
    }

    protected boolean sendFileByJTAG(File file) {
        boolean checkFile;
        boolean bl2 = checkFile = file == null || !file.exists() || file.isDirectory();
        if (checkFile) {
            return false;
        }
        this.infoln("\nSend command:\tDownloading File by JTAG: " + file.getName());
        boolean result = CallLibJTAGWorker.sendFileByJtag(file.getPath(), Long.parseLong(this.getHexStartAddress(), 16));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean waitBootRun(int timeMS) {
        startTime = System.currentTimeMillis();
        offset = 0;
        temp = null;
        subSequence = null;
        i2csBuilder = new StringBuilder();
        usbsBuilder = new StringBuilder();
        timeout = 30000L;
        if (this.burner.getBurnContext().getTransferWay() != TransferWay.USBBootrom && this.burner.getBurnContext().getTransferWay() != TransferWay.USBNonNude) ** GOTO lbl51
        CallLibUSBWorker.closeUsb();
        this.sleep(timeMS);
        openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, timeout);
        if (openUsbResult) ** GOTO lbl51
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.burner.getBurnContext().getTransferWay() == TransferWay.I2CBootrom) {
                try {
                    this.receiveBytesByI2c(i2csBuilder, 256);
                    temp = i2csBuilder.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
                try {
                    this.receiveBytesByUsbIgnore(usbsBuilder, 512);
                    temp = usbsBuilder.toString();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                temp = FastbootBurnerWorker.serialReceived.toString();
            }
            if (temp.length() > offset) {
                len = temp.length();
                subSequence = temp.subSequence(offset, len);
                offset += subSequence.length();
                if (subSequence.toString().indexOf("\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0014") == -1) {
                    FastbootBurnerWorker.received(subSequence.toString());
                } else {
                    this.receivedln(subSequence.toString());
                }
            }
            indexOf = temp.toLowerCase().indexOf("start download process.");
            if (q.b() && temp.toString().contains("*** Not upport current start mode")) {
                AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                this.updateLightState();
            }
            if (indexOf == -1) continue;
            if (q.b()) {
                this.readBootInfo(temp);
            }
            FastbootBurnerWorker.received("\n");
            return true;
lbl51:
            // 3 sources

            ** while (System.currentTimeMillis() - startTime < timeout)
        }
lbl52:
        // 1 sources

        if (q.b()) {
            FastbootBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
            this.updateLightState();
        }
        this.returnError(c.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    protected boolean waitBootRunCA() {
        long startTime = System.currentTimeMillis();
        int offset = 0;
        String temp = null;
        CharSequence subSequence = null;
        while (System.currentTimeMillis() - startTime < 10000L) {
            int indexOf;
            temp = serialReceived.toString();
            if (temp.length() > offset) {
                int len = temp.length();
                subSequence = temp.subSequence(offset, len);
                offset += subSequence.length();
                if (temp.toString().indexOf("     ") == -1) {
                    FastbootBurnerWorker.received(subSequence.toString());
                } else {
                    try {
                        this.sendBytes(new byte[]{-86});
                    }
                    catch (IOException e2) {
                        return false;
                    }
                    this.receivedln(subSequence.toString());
                }
            }
            if ((indexOf = temp.toLowerCase().indexOf("start download process.")) == -1) continue;
            this.ubootStartLog = temp;
            FastbootBurnerWorker.received("\n");
            return true;
        }
        this.returnError(c.ERROR_INFO_Failed_To_Wait_Boot_Running);
        return false;
    }

    protected boolean waitOpenUsb(IProgressMonitor uiMonitor) {
        CallLibUSBWorker.closeUsb();
        while (true) {
            this.uimonitor.subTask("Waiting Open Usb");
            boolean openUsbResult = CallLibUSBWorker.openUsb(this.uimonitor, 30000L);
            if (openUsbResult) {
                this.infoln("\nOpen Usb successfully!");
                return true;
            }
            this.infoln("\nOpen Usb Failed!");
            if (uiMonitor.isCanceled()) {
                return false;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected boolean bootromByNonNude(IProgressMonitor uimonitor) {
        if (!this.sendUSBStartFrame()) {
            this.returnError(c.ERROR_INFO_Failed_To_Send_Start_Frame);
            return false;
        }
        if (this.getFlashType() != DDR) {
            uimonitor.subTask("Waiting Boot to Run");
            if (!this.waitBootRun(10000)) {
                return false;
            }
            this.infoln("Boot started successfully!");
        }
        return true;
    }

    protected NetCommand[] buildNetCommands(TransferWay transferWay) {
        String serverIp;
        IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
        String ethactID = preferences.getString("hisilicon.fastboot.config.ethact");
        NetCommand[] commands = null;
        if (ethactID == null) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && !ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[6];
        }
        commands[0] = (serverIp = TFTPPreferences.getPRETFTPSERVERIP()) != null && !serverIp.isEmpty() ? NetCommand.setServerIP(serverIp) : NetCommand.setServerIP(this.localConfig.getServerIp());
        commands[1] = transferWay == TransferWay.UsbTransNet ? NetCommand.setClientMAC("") : NetCommand.setClientMAC(this.getBoardConfig().getMac());
        commands[2] = NetCommand.setClientIP(this.getBoardConfig().getIp());
        commands[3] = NetCommand.setClientNetMask(this.getBoardConfig().getSubnetMask());
        commands[4] = NetCommand.setClientGateway(this.getBoardConfig().getGateway());
        if (ethactID != null) {
            if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
                return commands;
            }
            if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[1])) {
                commands[5] = NetCommand.setEthact("0");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[2])) {
                commands[5] = NetCommand.setEthact("1");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[3])) {
                commands[5] = NetCommand.setEthact("2");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[4])) {
                commands[5] = NetCommand.setEthact("3");
            } else {
                return commands;
            }
        }
        return commands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        try {
            NetCommand[] commands;
            String usbTransNetCmd;
            if ((transferWay == TransferWay.UsbTransNet || this.burner.getBurnContext().isUsbToEthernet()) && !this.sendCommand(usbTransNetCmd = "usb start")) {
                this.returnError(c.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            NetCommand[] netCommandArray = commands = this.buildNetCommands(transferWay);
            int n2 = commands.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                NetCommand command = netCommandArray[n3];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n3;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return true;
    }

    public FlashType loadBootMode() throws ReceiveTimeOutException {
        try {
            if (!this.sendCommand(INFOCommand.getBootmode())) {
                return null;
            }
        }
        catch (IOException e2) {
            return null;
        }
        String strCurrentLog = this.getCurReceived().toLowerCase();
        if (strCurrentLog.indexOf("nand") > -1) {
            return FlashType.nand;
        }
        if (strCurrentLog.indexOf("spi") > -1) {
            return FlashType.spi;
        }
        if (strCurrentLog.indexOf("emmc") > -1) {
            return FlashType.emmc;
        }
        return null;
    }

    public long getBlockSize(FlashType type, ChipID chipID, boolean isFastboot) {
        block18: {
            if (FastbootView.isHi3231V530Series()) {
                if (FlashType.nand == type) {
                    this.setNandBlockSize(4096L);
                } else if (FlashType.spi == type) {
                    this.setSpiBlockSize(4096L);
                }
                return 4096L;
            }
            if (FlashType.emmc == type) {
                return 512L;
            }
            if (FlashType.nand != type && FlashType.spi != type) {
                return 0L;
            }
            try {
                if (FlashType.spi == type) {
                    this.sendCommand(SFCommand.getInstance(chipID));
                }
                if (this.sendCommand(INFOCommand.info(type))) {
                    String curReceived = this.getCurReceived();
                    long blockSize = WorkerUtility.ReceiveHelper.getBlockSize(curReceived);
                    if (FlashType.nand == type) {
                        this.setPageSize(WorkerUtility.ReceiveHelper.getPageSize(curReceived));
                        this.setNandBlockSize(blockSize);
                        if (this.isPage() && !isFastboot) {
                            return this.getPageSize();
                        }
                        return this.getNandBlockSize();
                    }
                    if (FlashType.spi == type) {
                        this.setSpiBlockSize(blockSize);
                        return this.getSpiBlockSize();
                    }
                    break block18;
                }
                if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                    long blockSize = WorkerUtility.ReceiveHelper.getBlockSize(this.ubootStartLog);
                    if (FlashType.nand == type) {
                        this.setPageSize(WorkerUtility.ReceiveHelper.getPageSize(this.ubootStartLog));
                        this.setNandBlockSize(blockSize);
                        if (this.isPage() && !isFastboot) {
                            return this.getPageSize();
                        }
                        return this.getNandBlockSize();
                    }
                    if (FlashType.spi == type) {
                        this.setSpiBlockSize(blockSize);
                        return this.getSpiBlockSize();
                    }
                    break block18;
                }
                return 0L;
            }
            catch (IOException e2) {
                return 0L;
            }
            catch (ReceiveTimeOutException e3) {
                e3.printStackTrace();
                return 0L;
            }
        }
        return 0L;
    }

    private void sleep(int timeMS) {
        if (timeMS < 1) {
            return;
        }
        try {
            Thread.sleep(timeMS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetByte(byte[] data, int offset, byte value) {
        int i2 = offset;
        while (i2 < data.length) {
            data[i2] = value;
            ++i2;
        }
    }

    protected int printBuffer(int offset) {
        int length;
        this.onAdataAvailable(serialReceived);
        if (offset < 0) {
            offset = 0;
        }
        if ((length = serialReceived.length()) > offset) {
            FastbootBurnerWorker.received(serialReceived.substring(offset, length));
        }
        return length;
    }

    protected boolean downloadFileSerial(File file) throws IOException, ReceiveTimeOutException {
        this.info("[Download File by Serial]\nfile = " + file.getAbsolutePath() + "\naddress = " + this.getHexStartAddress() + "\n");
        boolean result = false;
        FileInputStream in = null;
        byte[] content = null;
        try {
            in = new FileInputStream(file);
            content = new byte[in.available()];
            int read = in.read(content);
            if (read != content.length) {
                this.warning("File length is read.");
            }
            this.info("length = " + read + "\n\n");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        String seriadownloadCommand = "loady 0x" + this.getHexStartAddress() + "\n";
        result = this.sendCommand(seriadownloadCommand, 3000L);
        this.info("Serial Download Command = " + result + "\n");
        if (result) {
            result = this.sendXModem(content);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean downloadFileSerial(SubProgressMonitor subProgressMonitor, File file, boolean isSBL) throws IOException, ReceiveTimeOutException {
        try {
            boolean result;
            block29: {
                subProgressMonitor.beginTask("", 100);
                subProgressMonitor.subTask("Serial File Transfer");
                this.infoln("downloadFileSerial: file=" + file.getAbsolutePath());
                this.infoln("                    address=" + this.getHexStartAddress());
                result = false;
                FileInputStream in = null;
                try {
                    subProgressMonitor.setTaskName("Reading file content");
                    in = new FileInputStream(file);
                    int fileLen = in.available();
                    int count = (fileLen + 0x500000 - 1) / 0x500000;
                    int space = fileLen % 0x500000;
                    byte[] tempData = new byte[0x500000];
                    int readLength = 0;
                    int index = 1;
                    if (count == 0) {
                        tempData = new byte[fileLen];
                        int read = in.read(tempData, 0, tempData.length);
                        if (read != tempData.length) {
                            this.warning("File length is read.");
                        }
                        this.infoln("                    length=" + read);
                        result = isSBL ? this.sendSBLSubXModel(subProgressMonitor, file, in, this.getHexStartAddress(), tempData) : this.sendSubXModel(subProgressMonitor, file, in, this.getHexStartAddress(), tempData);
                        if (!result) {
                            boolean bl2 = result;
                            return bl2;
                        }
                        break block29;
                    }
                    int j2 = 0;
                    while (j2 < count) {
                        int len;
                        if (j2 == count - 1) {
                            if (space == 0) {
                                len = 0x500000;
                            } else {
                                len = space;
                                tempData = new byte[len];
                            }
                        } else {
                            len = 0x500000;
                        }
                        int read = in.read(tempData, 0, len);
                        if (read != tempData.length) {
                            this.warning("File length is read.");
                        }
                        this.infoln("Partition " + index + "         length=\t" + read);
                        result = isSBL ? this.sendSBLSubXModel(subProgressMonitor, file, in, Long.toHexString(this.getHexStartAddressForInt() + readLength), tempData) : this.sendSubXModel(subProgressMonitor, file, in, Long.toHexString(this.getHexStartAddressForInt() + readLength), tempData);
                        readLength += len;
                        ++index;
                        if (!result) {
                            boolean bl3 = result;
                            return bl3;
                        }
                        ++j2;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    subProgressMonitor.worked(2);
                }
            }
            boolean bl4 = result;
            return bl4;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private boolean sendSubXModel(SubProgressMonitor subProgressMonitor, File file, FileInputStream in, String ddrAddr, byte[] tempData) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        String seriadownloadCommand = "loady 0x" + ddrAddr + "\n";
        subProgressMonitor.subTask("Sending " + seriadownloadCommand.substring(0, seriadownloadCommand.length() - 1));
        result = this.sendCommand(seriadownloadCommand, 3000L);
        subProgressMonitor.worked(5);
        if (result) {
            FastbootBurnerWorker.deleteContent(serialReceived);
            result = this.sendXModem(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 96, 4), tempData, file.getName());
        }
        return result;
    }

    private boolean sendSBLSubXModel(SubProgressMonitor subProgressMonitor, File file, FileInputStream in, String ddrAddr, byte[] tempData) throws IOException, ReceiveTimeOutException {
        boolean result = false;
        StringBuilder seriadownloadCmd = new StringBuilder();
        seriadownloadCmd.append("loadsbl 0x");
        seriadownloadCmd.append(ddrAddr);
        seriadownloadCmd.append(" 0x");
        seriadownloadCmd.append(Long.toHexString(tempData.length));
        seriadownloadCmd.append("\n");
        subProgressMonitor.subTask("Sending " + seriadownloadCmd.toString().substring(0, seriadownloadCmd.toString().length() - 1));
        result = this.sendCommand(seriadownloadCmd.toString(), 3000L);
        subProgressMonitor.worked(5);
        if (result) {
            FastbootBurnerWorker.deleteContent(serialReceived);
            result = this.sendSBLByXModem(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 96, 4), tempData, file.getName());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int receiveXModem(SubProgressMonitor subProgressMonitor, FileOutputStream out, int length) throws IOException {
        try {
            subProgressMonitor.beginTask("", length + 2048);
            this.getSerialPort().notifyOnDataAvailable(false);
            String string = serialReceived.toString();
            FastbootBurnerWorker.received(string);
            int offset = string.length();
            byte[] content = new byte[]{};
            byte[] szDataPack = new byte[1029];
            int toSend = 0;
            subProgressMonitor.setTaskName("Receiving  data");
            int retry = 0;
            retry = 0;
            while (retry < 40) {
                int crc16;
                if (subProgressMonitor.isCanceled()) {
                    this.send(24);
                    return -1;
                }
                toSend = 67;
                if (this.sendBytes(new byte[]{(byte)toSend}) == 1 && this.receiveBytes(szDataPack, 2000L) == szDataPack.length && szDataPack[0] == 2 && szDataPack[1] == 1 && (szDataPack[2] & 0xFF) == 254 && (szDataPack[1027] & 0xFF) == ((crc16 = FastbootBurnerWorker.crc_16(Arrays.copyOfRange(szDataPack, 3, 1027))) >> 8 & 0xFF) && (szDataPack[1028] & 0xFF) == (crc16 & 0xFF)) {
                    toSend = 6;
                    offset = this.clearBuffer(offset);
                    this.send(toSend);
                    int realLength = Math.min(length, 1024);
                    if (content.length < realLength) {
                        content = Arrays.copyOf(content, realLength);
                    }
                    System.arraycopy(szDataPack, 3, content, 0, realLength);
                    out.write(Arrays.copyOfRange(szDataPack, 3, realLength + 3));
                    if (content.length == length) {
                        this.receivedln("# " + (content.length >> 10) + "K");
                    }
                    subProgressMonitor.worked(content.length);
                    break;
                }
                ++retry;
            }
            if (retry == 40) {
                toSend = 24;
                offset = this.clearBuffer(offset);
                this.send(toSend);
                int n2 = content.length;
                return n2;
            }
            int packCount = length >> 10;
            int i2 = 1;
            while (i2 < packCount) {
                if (subProgressMonitor.isCanceled()) {
                    this.send(24);
                    return -1;
                }
                if (i2 % 100 == 0) {
                    this.receivedln("# " + i2 + "K");
                } else if (i2 % 5 == 0) {
                    FastbootBurnerWorker.received("#");
                }
                retry = 0;
                while (retry < 40) {
                    block37: {
                        block38: {
                            int receivedCount;
                            block39: {
                                if (subProgressMonitor.isCanceled()) {
                                    this.send(24);
                                    return -1;
                                }
                                receivedCount = this.receiveBytes(szDataPack, 4000L);
                                if (receivedCount == 0) break block37;
                                if (szDataPack[0] != 2) break block38;
                                if ((szDataPack[1] & 0xFF) != (i2 & 0xFF)) break block39;
                                toSend = 6;
                                offset = this.clearBuffer(offset);
                                this.send(toSend);
                                break block37;
                            }
                            if (receivedCount != 1029 || (szDataPack[1] & 0xFF) != (i2 + 1 & 0xFF) || (szDataPack[2] & 0xFF) != 255 - (szDataPack[1] & 0xFF)) {
                                toSend = 21;
                                offset = this.clearBuffer(offset);
                                this.send(toSend);
                                break block37;
                            } else {
                                int crc16 = FastbootBurnerWorker.crc_16(Arrays.copyOfRange(szDataPack, 3, 1027));
                                if ((szDataPack[1027] & 0xFF) != (crc16 >> 8 & 0xFF) || (szDataPack[1028] & 0xFF) != (crc16 & 0xFF)) {
                                    toSend = 21;
                                    offset = this.clearBuffer(offset);
                                    this.send(toSend);
                                    break block37;
                                } else {
                                    toSend = 6;
                                    this.send(toSend);
                                    int realLength = Math.min(length - i2 * 1024, 1024);
                                    int size = i2 * 1024 + realLength;
                                    if (content.length < size) {
                                        content = Arrays.copyOf(content, size);
                                    }
                                    System.arraycopy(szDataPack, 3, content, i2 * 1024, realLength);
                                    out.write(Arrays.copyOfRange(szDataPack, 3, realLength + 3));
                                    subProgressMonitor.subTask("uploaded :" + content.length + "/" + length);
                                    if (content.length == length) {
                                        this.receivedln("# " + (content.length >> 10) + "K");
                                    }
                                    subProgressMonitor.worked(1024);
                                    break;
                                }
                            }
                        }
                        if ((szDataPack[0] & 0xFF) == 24) {
                            toSend = 6;
                            offset = this.clearBuffer(offset);
                            this.send(toSend);
                            int n3 = content.length;
                            return n3;
                        }
                    }
                    ++retry;
                }
                if (retry == 40) {
                    toSend = 24;
                    offset = this.clearBuffer(offset);
                    this.send(toSend);
                    int n4 = content.length;
                    return n4;
                }
                ++i2;
            }
            retry = 0;
            while (retry < 40) {
                int read = FastbootBurnerWorker.getSERIAL_IN().read();
                if (read != -1) {
                    toSend = 0xFF & read;
                    if (toSend == 4) {
                        toSend = 6;
                        this.send(toSend);
                        this.sleep(4000);
                        offset = this.clearBuffer(offset);
                        int n5 = content.length;
                        return n5;
                    }
                    if (toSend == 2) {
                        toSend = 6;
                        offset = this.clearBuffer(offset);
                        this.send(toSend);
                    } else if (toSend == 24) {
                        toSend = 6;
                        offset = this.clearBuffer(offset);
                        this.send(toSend);
                        break;
                    }
                }
                ++retry;
            }
            int n6 = content.length;
            return n6;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public boolean sendXModem(byte[] src) throws IOException {
        this.getSerialPort().notifyOnDataAvailable(false);
        String string = serialReceived.toString();
        FastbootBurnerWorker.received(string);
        int outOffset = string.length();
        if (FastbootPreferences.isDebugOn()) {
            this.println("File content length:\t" + src.length);
        }
        byte[] modemPack = new byte[1029];
        int tempChar = 0;
        int retry = 0;
        retry = 0;
        while (retry < 40) {
            this.sleep(1000);
            int read = FastbootBurnerWorker.getSERIAL_IN().read();
            if (read != -1) {
                if (read == 67) break;
                if (read == 24) {
                    outOffset = this.clearBuffer(outOffset);
                    tempChar = 6;
                    this.send(tempChar);
                    return false;
                }
            }
            ++retry;
        }
        if (retry == 40) {
            outOffset = this.clearBuffer(outOffset);
            tempChar = 24;
            this.send(tempChar);
            return false;
        }
        int contentLength = src.length;
        int packCount = contentLength / 1024;
        if (contentLength % 1024 != 0) {
            ++packCount;
        }
        this.infoln("packCount=\t" + packCount);
        int i2 = 0;
        while (i2 < packCount) {
            this.infoln("pack index=\t" + (i2 + 1));
            modemPack[0] = 2;
            modemPack[1] = (byte)(i2 + 1 & 0xFF);
            modemPack[2] = (byte)(0xFF & 255 - (modemPack[1] & 0xFF));
            int bufsz = 1024;
            if (bufsz > contentLength - i2 * 1024) {
                bufsz = contentLength - i2 * 1024;
            }
            System.arraycopy(src, i2 * 1024, modemPack, 3, bufsz);
            this.resetByte(modemPack, 3 + bufsz, (byte)26);
            byte[] copyOfRange = Arrays.copyOfRange(modemPack, 3, 1027);
            int crc_16 = FastbootBurnerWorker.crc_16(copyOfRange);
            modemPack[1027] = (byte)(crc_16 >> 8);
            modemPack[1028] = (byte)crc_16;
            retry = 0;
            while (retry < 40) {
                int read;
                outOffset = this.clearBuffer(outOffset);
                if (this.sendBytes(modemPack) == modemPack.length && (read = FastbootBurnerWorker.getSERIAL_IN().read()) != -1 && read == 6) break;
                ++retry;
            }
            if (retry == 40) {
                tempChar = 24;
                this.send(tempChar);
                outOffset = this.clearBuffer(outOffset);
                return false;
            }
            ++i2;
        }
        retry = 0;
        while (retry < 40) {
            int read;
            outOffset = this.clearBuffer(outOffset);
            tempChar = 4;
            if (this.sendBytes(new byte[]{(byte)tempChar}) == 1 && (read = FastbootBurnerWorker.getSERIAL_IN().read()) != -1 && read == 6) {
                this.infoln("Transfer is finishing, wait a moment please.");
                this.getSerialPort().notifyOnDataAvailable(true);
                long waitStart = System.currentTimeMillis();
                while (serialReceived.indexOf("[EOT](OK)") == -1) {
                    if (System.currentTimeMillis() - waitStart <= 30000L && serialReceived.indexOf("[EOT](ERROR)") == -1) continue;
                    this.getSerialPort().notifyOnDataAvailable(false);
                    return false;
                }
                this.getSerialPort().notifyOnDataAvailable(false);
                outOffset = this.clearBuffer(outOffset);
                return true;
            }
            ++retry;
        }
        outOffset = this.clearBuffer(outOffset);
        tempChar = 24;
        this.send(tempChar);
        return false;
    }

    public boolean sendXModem(SubProgressMonitor subProgressMonitor, byte[] src, String fileName) throws IOException {
        try {
            int read;
            this.getSerialPort().notifyOnDataAvailable(false);
            String string = serialReceived.toString();
            FastbootBurnerWorker.received(string);
            int outOffset = string.length();
            byte[] modemPack = new byte[1029];
            int tempChar = 0;
            int retry = 0;
            retry = 0;
            while (retry < 40) {
                this.sleep(1000);
                int read2 = FastbootBurnerWorker.getSERIAL_IN().read();
                if (read2 != -1) {
                    if (read2 == 67) break;
                    if (read2 == 24) {
                        outOffset = this.clearBuffer(outOffset);
                        tempChar = 6;
                        this.send(tempChar);
                        return false;
                    }
                }
                ++retry;
            }
            if (retry == 40) {
                outOffset = this.clearBuffer(outOffset);
                tempChar = 24;
                this.send(tempChar);
                return false;
            }
            int contentLength = src.length;
            int packCount = contentLength / 1024;
            if (contentLength % 1024 != 0) {
                ++packCount;
            }
            subProgressMonitor.beginTask("", packCount);
            subProgressMonitor.setTaskName("Transfering...");
            byte[] modemHeader = new byte[133];
            modemHeader[0] = 1;
            modemHeader[1] = 0;
            modemHeader[2] = -1;
            int fileNameLen = fileName.length();
            bc.a(modemHeader, 3, fileNameLen, fileName);
            modemHeader[fileNameLen + 3] = 0;
            String fileLenStr = Long.toString(contentLength);
            bc.a(modemHeader, fileNameLen + 4, fileLenStr.length(), fileLenStr);
            modemHeader[fileNameLen + 4 + fileLenStr.length()] = 32;
            byte[] crcStr = Arrays.copyOfRange(modemHeader, 3, 131);
            int crc_16Result = FastbootBurnerWorker.crc_16(crcStr);
            modemHeader[131] = (byte)(crc_16Result >> 8);
            modemHeader[132] = (byte)crc_16Result;
            this.sendBytes(modemHeader);
            retry = 0;
            while (retry < 40) {
                this.sleep(1000);
                read = FastbootBurnerWorker.getSERIAL_IN().read();
                if (read != -1) {
                    if (read == 67) break;
                    if (read == 24) {
                        outOffset = this.clearBuffer(outOffset);
                        tempChar = 6;
                        this.send(tempChar);
                        return false;
                    }
                }
                ++retry;
            }
            if (retry == 40) {
                outOffset = this.clearBuffer(outOffset);
                tempChar = 24;
                this.send(tempChar);
                return false;
            }
            int i2 = 0;
            while (i2 < packCount) {
                if (subProgressMonitor.isCanceled()) {
                    tempChar = 24;
                    this.send(tempChar);
                    this.send(tempChar);
                    return false;
                }
                modemPack[0] = 2;
                modemPack[1] = (byte)(i2 + 1 & 0xFF);
                modemPack[2] = (byte)(0xFF & 255 - (modemPack[1] & 0xFF));
                int bufsz = 1024;
                if (bufsz > contentLength - i2 * 1024) {
                    bufsz = contentLength - i2 * 1024;
                }
                System.arraycopy(src, i2 * 1024, modemPack, 3, bufsz);
                this.resetByte(modemPack, 3 + bufsz, (byte)26);
                byte[] copyOfRange = Arrays.copyOfRange(modemPack, 3, 1027);
                int crc_16 = FastbootBurnerWorker.crc_16(copyOfRange);
                modemPack[1027] = (byte)(crc_16 >> 8);
                modemPack[1028] = (byte)crc_16;
                retry = 0;
                while (retry < 40) {
                    int read3;
                    outOffset = this.clearBuffer(outOffset);
                    if (this.sendBytes(modemPack) == modemPack.length && (read3 = FastbootBurnerWorker.getSERIAL_IN().read()) != -1 && read3 == 6) {
                        if ((i2 + 1) % 100 == 0) {
                            this.receivedln("# " + (i2 + 1) + "K");
                        } else if ((i2 + 1) % 5 == 0) {
                            FastbootBurnerWorker.received("#");
                        }
                        int min = Math.min(i2 + 1 << 10, src.length);
                        subProgressMonitor.subTask("downloaded:" + min + "/" + src.length);
                        subProgressMonitor.internalWorked((double)i2 * 2.0 / (double)packCount);
                        break;
                    }
                    ++retry;
                }
                if (retry == 40) {
                    tempChar = 24;
                    this.send(tempChar);
                    outOffset = this.clearBuffer(outOffset);
                    return false;
                }
                ++i2;
            }
            retry = 0;
            while (retry < 40) {
                outOffset = this.clearBuffer(outOffset);
                tempChar = 4;
                if (this.sendBytes(new byte[]{(byte)tempChar}) == 1 && (read = FastbootBurnerWorker.getSERIAL_IN().read()) != -1 && read == 6) {
                    this.infoln("\nTransfer is finishing, wait a moment please.");
                    this.getSerialPort().notifyOnDataAvailable(true);
                    long waitStart = System.currentTimeMillis();
                    while (serialReceived.indexOf("[EOT](OK)") == -1) {
                        if (System.currentTimeMillis() - waitStart <= 30000L && serialReceived.indexOf("[EOT](ERROR)") == -1) continue;
                        this.getSerialPort().notifyOnDataAvailable(false);
                        return false;
                    }
                    this.getSerialPort().notifyOnDataAvailable(false);
                    outOffset = this.clearBuffer(outOffset);
                    return true;
                }
                ++retry;
            }
            outOffset = this.clearBuffer(outOffset);
            tempChar = 24;
            this.send(tempChar);
            return false;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public boolean sendSBLByXModem(SubProgressMonitor subProgressMonitor, byte[] src, String fileName) throws IOException {
        try {
            this.getSerialPort().notifyOnDataAvailable(false);
            String string = serialReceived.toString();
            FastbootBurnerWorker.received(string);
            int BUFF_SIZE = 1024;
            int outOffset = string.length();
            byte[] modemPack = new byte[1029];
            int tempChar = 0;
            int retry = 0;
            retry = 0;
            while (retry < 40) {
                this.sleep(1000);
                int read = FastbootBurnerWorker.getSERIAL_IN().read();
                if (read != -1) {
                    if (read == 67) break;
                    if (read == 24) {
                        outOffset = this.clearBuffer(outOffset);
                        tempChar = 6;
                        this.send(tempChar);
                        return false;
                    }
                }
                ++retry;
            }
            if (retry == 40) {
                outOffset = this.clearBuffer(outOffset);
                tempChar = 24;
                this.send(tempChar);
                return false;
            }
            int contentLength = src.length;
            int packCount = contentLength / BUFF_SIZE;
            if (contentLength % BUFF_SIZE != 0) {
                ++packCount;
            }
            subProgressMonitor.beginTask("", packCount);
            subProgressMonitor.setTaskName("Transfering...");
            int i2 = 0;
            while (i2 < packCount) {
                if (subProgressMonitor.isCanceled()) {
                    tempChar = 24;
                    this.send(tempChar);
                    this.send(tempChar);
                    return false;
                }
                modemPack[0] = 2;
                modemPack[1] = (byte)(i2 + 1 & 0xFF);
                modemPack[2] = (byte)(0xFF & 255 - (modemPack[1] & 0xFF));
                int bufsz = BUFF_SIZE;
                if (bufsz > contentLength - i2 * BUFF_SIZE) {
                    bufsz = contentLength - i2 * BUFF_SIZE;
                }
                System.arraycopy(src, i2 * BUFF_SIZE, modemPack, 3, bufsz);
                this.resetByte(modemPack, 3 + bufsz, (byte)26);
                byte[] copyOfRange = Arrays.copyOfRange(modemPack, 3, BUFF_SIZE + 3);
                int crc_16 = FastbootBurnerWorker.crc_16(copyOfRange);
                modemPack[BUFF_SIZE + 3] = (byte)(crc_16 >> 8);
                modemPack[BUFF_SIZE + 4] = (byte)crc_16;
                retry = 0;
                while (retry < 40) {
                    int read;
                    outOffset = this.clearBuffer(outOffset);
                    if (this.sendBytes(modemPack) == modemPack.length && (read = FastbootBurnerWorker.getSERIAL_IN().read()) != -1 && read == 6) {
                        if ((i2 + 1) % 100 == 0) {
                            this.receivedln("# " + (i2 + 1) + "K");
                        } else if ((i2 + 1) % 5 == 0) {
                            FastbootBurnerWorker.received("#");
                        }
                        int min = Math.min(i2 + 1 << 10, src.length);
                        subProgressMonitor.subTask("downloaded:" + min + "/" + src.length);
                        subProgressMonitor.internalWorked((double)i2 * 2.0 / (double)packCount);
                        break;
                    }
                    ++retry;
                }
                if (retry == 40) {
                    tempChar = 24;
                    this.send(tempChar);
                    outOffset = this.clearBuffer(outOffset);
                    return false;
                }
                ++i2;
            }
            retry = 0;
            while (retry < 40) {
                outOffset = this.clearBuffer(outOffset);
                tempChar = 4;
                if (this.sendBytes(new byte[]{(byte)tempChar}) == 1) {
                    int read = -1;
                    long wait = System.currentTimeMillis();
                    while (System.currentTimeMillis() - wait < 150L) {
                        read = FastbootBurnerWorker.getSERIAL_IN().read();
                        if (read == 6 || tempChar == 24) break;
                    }
                    if (read == 6) {
                        this.infoln("\nTransfer is finishing, wait a moment please.");
                        this.getSerialPort().notifyOnDataAvailable(true);
                        long waitStart = System.currentTimeMillis();
                        while (serialReceived.indexOf("[EOT](OK)") == -1) {
                            if (System.currentTimeMillis() - waitStart <= 30000L && serialReceived.indexOf("[EOT](ERROR)") == -1) continue;
                            this.getSerialPort().notifyOnDataAvailable(false);
                            return false;
                        }
                        this.getSerialPort().notifyOnDataAvailable(false);
                        outOffset = this.clearBuffer(outOffset);
                        return true;
                    }
                }
                ++retry;
            }
            outOffset = this.clearBuffer(outOffset);
            tempChar = 24;
            this.send(tempChar);
            return false;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public static int crc_16(byte[] data) {
        int crc = 0;
        int counter = 0;
        while (counter < data.length) {
            int d2 = data[counter] & 0xFF;
            crc = crc << 8 ^ crc16_table[(crc >> 8 ^ d2) & 0xFF];
            ++counter;
        }
        return crc & 0xFFFF;
    }

    private int clearBuffer(int offset) {
        this.onAdataAvailable(serialReceived);
        int tempLength = serialReceived.length();
        if (tempLength > offset) {
            FastbootBurnerWorker.received(serialReceived.substring(offset, tempLength));
            offset = tempLength;
        }
        return offset;
    }

    protected boolean upload(SubProgressMonitor subProgressMonitor, File file, String hexAddress, String hexLength) throws IOException, ReceiveTimeOutException {
        String command = "uploadx 0x" + hexAddress + " 0x" + hexLength + "\n";
        boolean result = this.sendCommand(command, 3000L);
        if (result) {
            int length = Integer.parseInt(hexLength, 16);
            FileOutputStream out = null;
            try {
                this.infoln("Download :\t" + file.getAbsolutePath());
                out = new FileOutputStream(file);
                FastbootBurnerWorker.deleteContent(serialReceived);
                FastbootBurnerWorker.deleteContent(i2csReceived);
                FastbootBurnerWorker.deleteContent(usbsReceived);
                int receiveXModem = this.receiveXModem(subProgressMonitor, out, length);
                boolean bl2 = receiveXModem == length;
                return bl2;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                subProgressMonitor.done();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    public boolean loadVersionInfo() {
        try {
            if (!this.sendCommand(INFOCommand.getVersion())) {
                return false;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ReceiveTimeOutException e3) {
            e3.printStackTrace();
        }
        this.version = WorkerUtility.ReceiveHelper.getVersion(this.getCurReceived());
        return this.version != null;
    }

    /*
     * Exception decompiling
     */
    protected boolean burnSinglePartByI2c(IProgressMonitor uimonitor, File file, String startAddress, FlashType flashType, boolean isNakedBurn, ChipID chipID) throws IOException, ReceiveTimeOutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void closeI2cAndDeleteTempFile(File compressFile, File comFatherFile) {
        if (compressFile != null && compressFile.exists()) {
            bg.a(compressFile);
        }
        if (comFatherFile != null && comFatherFile.exists()) {
            bg.a(comFatherFile);
        }
    }

    protected boolean checkUpgradeStatus(File file, long timeout, int i2cDelay) {
        long oldTime = System.currentTimeMillis();
        long currentTime = 0L;
        boolean burnSuccess = false;
        this.receivedln("Write data to flash...");
        while (currentTime - oldTime < timeout) {
            int status = I2cCommand.sendGetUpgradeStatus(i2cDelay);
            if (status == -1) {
                this.returnError(c.PartitionBurnerWork_I2c_Upgrade_Fail);
                if (serialReceived != null && serialReceived.length() > 0) {
                    this.receivedln(serialReceived.toString());
                }
                return false;
            }
            if (status != 0 && status == 1) {
                this.receivedln("The " + file.getName() + " burning successfully.");
                burnSuccess = true;
                break;
            }
            currentTime = System.currentTimeMillis();
        }
        if (serialReceived != null && serialReceived.length() > 0) {
            this.receivedln(serialReceived.toString());
        }
        if (!burnSuccess) {
            this.returnError(c.PartitionBurnerWork_I2c_Upgrade_Write_Flash_Timeout);
        }
        return burnSuccess;
    }

    public boolean initBoard(ArrayList<FlashType> hasFlashTypes) throws IOException, ReceiveTimeOutException {
        TransferWay transferWay;
        if (this.isDebug()) {
            this.println("InitBoard Start");
        }
        if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(null) : !this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
            return false;
        }
        this.version = null;
        boolean loadVersionInfo = this.loadVersionInfo();
        if (!loadVersionInfo || this.version == null) {
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                this.warningln("Warning: Failed to load version info!");
            } else {
                this.returnError("Failed to load version info!");
                return false;
            }
        }
        if (this.isNeedSetupNet(transferWay = this.burner.getBurnContext().getTransferWay())) {
            this.setupNetwork(transferWay);
        }
        return true;
    }

    public boolean isNeedSetupNet(TransferWay transferWay) {
        boolean result = transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.JTAGAndNet;
        return result;
    }

    protected void switchTFTPDownloadHome(File file) {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (!TFTPService.TFTPSERVICE.isStart()) {
            InetAddress address = null;
            try {
                address = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException e2) {
                e2.printStackTrace();
            }
            try {
                boolean result = TFTPService.TFTPSERVICE.start(file, address, bi.c());
                if (!result) {
                    this.warningln(c.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
            catch (SocketException e3) {
                e3.printStackTrace();
            }
        }
        if (file.isDirectory()) {
            TFTPService.TFTPSERVICE.setServerDirectory(file);
            this.infoln("\tTftp server Download Home switched to <" + file.getAbsolutePath() + ">");
        }
    }

    private void getTempFileDivisionSize() throws IOException, ReceiveTimeOutException {
        long ddrFreeSize = this.getDDRFreeSize();
        String ddrInitSize = this.getHexStartAddress();
        if (ddrInitSize.startsWith("0x")) {
            ddrInitSize = ddrInitSize.substring(ddrInitSize.indexOf("0x") + "0x".length());
        }
        long preferemcesSplitFileSize = (long)FastbootPreferences.getInt("hisilicon.fastboot.tftp.split.fileSize") * 1024L * 1024L;
        tempFileDivisionSize = ddrFreeSize == 0L ? preferemcesSplitFileSize : (ddrFreeSize / 2L > 0x2000000L ? (ddrFreeSize - Long.parseLong(ddrInitSize, 16)) / 2L : (ddrFreeSize / 2L < 0x2000000L ? ddrFreeSize : 0x2000000L));
    }

    protected File copyComFileToHiToolPath(IProgressMonitor uiMonitor, File file) {
        boolean tftpOccupied = this.burner.getBurnContext().isTftpOccupied();
        String partFilePath = null;
        String hiToolPath = null;
        if (tftpOccupied) {
            partFilePath = file.getPath();
        } else {
            hiToolPath = bi.a();
            partFilePath = String.valueOf(hiToolPath) + File.separator + file.getName();
        }
        File partFile = new File(partFilePath);
        boolean copy = bg.a(uiMonitor, file, partFile);
        if (!copy) {
            this.returnError(NLS.bind((String)c.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
            return null;
        }
        return partFile;
    }

    public void printCrcValue(File file) {
        if (!FastbootView.isHi3231Series()) {
            return;
        }
        if (file == null) {
            return;
        }
        try {
            long crcValue = CrcCommand.calculateCRC16(file);
            this.infoln("\nCRC: " + file.getName() + " " + "0x" + Long.toHexString(crcValue));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public BoardConfig getBoardConfig() {
        return this.boardConfig;
    }
}

