/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.receive.ReceiveContants;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public abstract class WorkerUtility {
    static final int XSTART = 254;
    static final int XHEAD = 254;
    static final int XDATA = 218;
    static final int XTAIL = 237;
    public static final int XCMD = 171;
    static final int XKEY = 205;
    protected static final int ACK = 170;
    protected static final int NAK = 85;
    static final int CALC_CRC_NORMAL = 1;
    static final int CALC_CRC_MULTI_CONTINUE = 2;
    static final int CALC_CRC_MULTI_END = 3;
    static final int MAX_DATA_FRAME_SIZE = 1024;
    static final int MAX_DATA_FRAME_SIZE_FOR_USB = 511;
    static final int MAX_DATA_FRAME_SIZE_FOR_S3 = 16384;
    static final int START_FRAME_ADDRESS_FOR_S3 = -559064486;
    static final FlashType DDR = FlashType.ddr;
    static final int[] crc16_table;

    static {
        int[] nArray = new int[256];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        nArray[16] = 4657;
        nArray[17] = 528;
        nArray[18] = 12915;
        nArray[19] = 8786;
        nArray[20] = 21173;
        nArray[21] = 17044;
        nArray[22] = 29431;
        nArray[23] = 25302;
        nArray[24] = 37689;
        nArray[25] = 33560;
        nArray[26] = 45947;
        nArray[27] = 41818;
        nArray[28] = 54205;
        nArray[29] = 50076;
        nArray[30] = 62463;
        nArray[31] = 58334;
        nArray[32] = 9314;
        nArray[33] = 13379;
        nArray[34] = 1056;
        nArray[35] = 5121;
        nArray[36] = 25830;
        nArray[37] = 29895;
        nArray[38] = 17572;
        nArray[39] = 21637;
        nArray[40] = 42346;
        nArray[41] = 46411;
        nArray[42] = 34088;
        nArray[43] = 38153;
        nArray[44] = 58862;
        nArray[45] = 62927;
        nArray[46] = 50604;
        nArray[47] = 54669;
        nArray[48] = 13907;
        nArray[49] = 9842;
        nArray[50] = 5649;
        nArray[51] = 1584;
        nArray[52] = 30423;
        nArray[53] = 26358;
        nArray[54] = 22165;
        nArray[55] = 18100;
        nArray[56] = 46939;
        nArray[57] = 42874;
        nArray[58] = 38681;
        nArray[59] = 34616;
        nArray[60] = 63455;
        nArray[61] = 59390;
        nArray[62] = 55197;
        nArray[63] = 51132;
        nArray[64] = 18628;
        nArray[65] = 22757;
        nArray[66] = 26758;
        nArray[67] = 30887;
        nArray[68] = 2112;
        nArray[69] = 6241;
        nArray[70] = 10242;
        nArray[71] = 14371;
        nArray[72] = 51660;
        nArray[73] = 55789;
        nArray[74] = 59790;
        nArray[75] = 63919;
        nArray[76] = 35144;
        nArray[77] = 39273;
        nArray[78] = 43274;
        nArray[79] = 47403;
        nArray[80] = 23285;
        nArray[81] = 19156;
        nArray[82] = 31415;
        nArray[83] = 27286;
        nArray[84] = 6769;
        nArray[85] = 2640;
        nArray[86] = 14899;
        nArray[87] = 10770;
        nArray[88] = 56317;
        nArray[89] = 52188;
        nArray[90] = 64447;
        nArray[91] = 60318;
        nArray[92] = 39801;
        nArray[93] = 35672;
        nArray[94] = 47931;
        nArray[95] = 43802;
        nArray[96] = 27814;
        nArray[97] = 31879;
        nArray[98] = 19684;
        nArray[99] = 23749;
        nArray[100] = 11298;
        nArray[101] = 15363;
        nArray[102] = 3168;
        nArray[103] = 7233;
        nArray[104] = 60846;
        nArray[105] = 64911;
        nArray[106] = 52716;
        nArray[107] = 56781;
        nArray[108] = 44330;
        nArray[109] = 48395;
        nArray[110] = 36200;
        nArray[111] = 40265;
        nArray[112] = 32407;
        nArray[113] = 28342;
        nArray[114] = 24277;
        nArray[115] = 20212;
        nArray[116] = 15891;
        nArray[117] = 11826;
        nArray[118] = 7761;
        nArray[119] = 3696;
        nArray[120] = 65439;
        nArray[121] = 61374;
        nArray[122] = 57309;
        nArray[123] = 53244;
        nArray[124] = 48923;
        nArray[125] = 44858;
        nArray[126] = 40793;
        nArray[127] = 36728;
        nArray[128] = 37256;
        nArray[129] = 33193;
        nArray[130] = 45514;
        nArray[131] = 41451;
        nArray[132] = 53516;
        nArray[133] = 49453;
        nArray[134] = 61774;
        nArray[135] = 57711;
        nArray[136] = 4224;
        nArray[137] = 161;
        nArray[138] = 12482;
        nArray[139] = 8419;
        nArray[140] = 20484;
        nArray[141] = 16421;
        nArray[142] = 28742;
        nArray[143] = 24679;
        nArray[144] = 33721;
        nArray[145] = 37784;
        nArray[146] = 41979;
        nArray[147] = 46042;
        nArray[148] = 49981;
        nArray[149] = 54044;
        nArray[150] = 58239;
        nArray[151] = 62302;
        nArray[152] = 689;
        nArray[153] = 4752;
        nArray[154] = 8947;
        nArray[155] = 13010;
        nArray[156] = 16949;
        nArray[157] = 21012;
        nArray[158] = 25207;
        nArray[159] = 29270;
        nArray[160] = 46570;
        nArray[161] = 42443;
        nArray[162] = 38312;
        nArray[163] = 34185;
        nArray[164] = 62830;
        nArray[165] = 58703;
        nArray[166] = 54572;
        nArray[167] = 50445;
        nArray[168] = 13538;
        nArray[169] = 9411;
        nArray[170] = 5280;
        nArray[171] = 1153;
        nArray[172] = 29798;
        nArray[173] = 25671;
        nArray[174] = 21540;
        nArray[175] = 17413;
        nArray[176] = 42971;
        nArray[177] = 47098;
        nArray[178] = 34713;
        nArray[179] = 38840;
        nArray[180] = 59231;
        nArray[181] = 63358;
        nArray[182] = 50973;
        nArray[183] = 55100;
        nArray[184] = 9939;
        nArray[185] = 14066;
        nArray[186] = 1681;
        nArray[187] = 5808;
        nArray[188] = 26199;
        nArray[189] = 30326;
        nArray[190] = 17941;
        nArray[191] = 22068;
        nArray[192] = 55628;
        nArray[193] = 51565;
        nArray[194] = 63758;
        nArray[195] = 59695;
        nArray[196] = 39368;
        nArray[197] = 35305;
        nArray[198] = 47498;
        nArray[199] = 43435;
        nArray[200] = 22596;
        nArray[201] = 18533;
        nArray[202] = 30726;
        nArray[203] = 26663;
        nArray[204] = 6336;
        nArray[205] = 2273;
        nArray[206] = 14466;
        nArray[207] = 10403;
        nArray[208] = 52093;
        nArray[209] = 56156;
        nArray[210] = 60223;
        nArray[211] = 64286;
        nArray[212] = 35833;
        nArray[213] = 39896;
        nArray[214] = 43963;
        nArray[215] = 48026;
        nArray[216] = 19061;
        nArray[217] = 23124;
        nArray[218] = 27191;
        nArray[219] = 31254;
        nArray[220] = 2801;
        nArray[221] = 6864;
        nArray[222] = 10931;
        nArray[223] = 14994;
        nArray[224] = 64814;
        nArray[225] = 60687;
        nArray[226] = 56684;
        nArray[227] = 52557;
        nArray[228] = 48554;
        nArray[229] = 44427;
        nArray[230] = 40424;
        nArray[231] = 36297;
        nArray[232] = 31782;
        nArray[233] = 27655;
        nArray[234] = 23652;
        nArray[235] = 19525;
        nArray[236] = 15522;
        nArray[237] = 11395;
        nArray[238] = 7392;
        nArray[239] = 3265;
        nArray[240] = 61215;
        nArray[241] = 65342;
        nArray[242] = 53085;
        nArray[243] = 57212;
        nArray[244] = 44955;
        nArray[245] = 49082;
        nArray[246] = 36825;
        nArray[247] = 40952;
        nArray[248] = 28183;
        nArray[249] = 32310;
        nArray[250] = 20053;
        nArray[251] = 24180;
        nArray[252] = 11923;
        nArray[253] = 16050;
        nArray[254] = 3793;
        nArray[255] = 7920;
        crc16_table = nArray;
    }

    public static int calc_crc16(int[] packet, int length, int calc_mode) {
        int crc16 = 0;
        int i2 = 0;
        while (i2 < length) {
            crc16 = (crc16 << 8 | packet[i2]) ^ crc16_table[crc16 >>> 8 & 0xFF];
            ++i2;
        }
        i2 = 0;
        while (i2 < 2) {
            crc16 = crc16 << 8 ^ crc16_table[crc16 >>> 8 & 0xFF];
            ++i2;
        }
        return crc16 & 0xFFFF;
    }

    public static FileInfo[] createFileList(int length) {
        FileInfo[] files = new FileInfo[length];
        int i2 = 0;
        while (i2 < files.length) {
            files[i2] = new FileInfo();
            ++i2;
        }
        return files;
    }

    public static int[] getCommandHeadFrame(String command) {
        int[] frame = new int[5];
        try {
            int length = command.getBytes(System.getProperty("file.encoding")).length;
            int crc = 0;
            frame[0] = 171;
            frame[1] = length >> 8;
            frame[2] = length;
            crc = WorkerUtility.calc_crc16(frame, frame.length - 2, 1);
            frame[3] = crc >> 8;
            frame[4] = crc & 0xFF;
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        return frame;
    }

    public static int[] getCommandFrame(String command) {
        byte[] bytes = null;
        try {
            bytes = command.getBytes(System.getProperty("file.encoding"));
            int[] commandFrame = new int[bytes.length + 3];
            commandFrame[0] = 205;
            int i2 = 0;
            while (i2 < bytes.length) {
                commandFrame[i2 + 1] = bytes[i2] & 0xFF;
                ++i2;
            }
            int crc = WorkerUtility.calc_crc16(commandFrame, commandFrame.length - 2, 1);
            commandFrame[bytes.length + 1] = crc >> 8;
            commandFrame[bytes.length + 2] = crc & 0xFF;
            return commandFrame;
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static int[] getUSBCommandFrame(String command) {
        byte[] bytes = null;
        try {
            bytes = command.getBytes(System.getProperty("file.encoding"));
            int length = bytes.length;
            int[] commandFrame = new int[length + 3];
            commandFrame[0] = 171;
            commandFrame[1] = length >> 8;
            commandFrame[2] = length;
            int i2 = 0;
            while (i2 < bytes.length) {
                commandFrame[i2 + 3] = bytes[i2] & 0xFF;
                ++i2;
            }
            return commandFrame;
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void deleteContent(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return;
        }
        int length = stringBuilder.length();
        if (length > 0) {
            stringBuilder.delete(0, length);
        }
    }

    public static class ReceiveHelper
    implements ReceiveContants {
        public static long convertToNumber(String strNum) {
            if (strNum == null || strNum.trim().length() == 0) {
                return -1L;
            }
            strNum = strNum.toLowerCase();
            long unit = 1L;
            int index = strNum.indexOf("g");
            if (index != -1) {
                unit = 0x40000000L;
            } else {
                index = strNum.indexOf("k");
                if (index != -1) {
                    unit = 1024L;
                } else {
                    index = strNum.indexOf("m");
                    if (index != -1) {
                        unit = 0x100000L;
                    } else {
                        index = strNum.indexOf("b");
                        if (index != -1) {
                            unit = 1L;
                        } else {
                            index = strNum.length();
                        }
                    }
                }
            }
            try {
                return Long.parseLong(strNum.substring(0, index)) * unit;
            }
            catch (NumberFormatException e2) {
                return -1L;
            }
        }

        public static String convertUnit(long num) {
            String unit = "";
            if (num == 0L) {
                return "0";
            }
            if (num % 1024L != 0L) {
                return String.valueOf(num);
            }
            unit = "K";
            if ((num /= 1024L) < 1024L) {
                return String.valueOf(num) + unit;
            }
            if (num % 1024L != 0L) {
                return String.valueOf(num) + unit;
            }
            unit = "M";
            return String.valueOf(num /= 1024L) + unit;
        }

        public static long getNandChipSize(String received) {
            int indexOf = received.indexOf("Nand(");
            if (indexOf == -1) {
                return -1L;
            }
            if ((indexOf = received.indexOf(":", indexOf)) == -1) {
                return -1L;
            }
            String substring = received.substring(indexOf);
            return ReceiveHelper.getChipSize(substring);
        }

        public static long getNandBlockSize(String received) {
            int indexOf = received.indexOf("Nand(");
            if (indexOf == -1) {
                return -1L;
            }
            if ((indexOf = received.indexOf(":", indexOf)) == -1) {
                return -1L;
            }
            String substring = received.substring(indexOf);
            return ReceiveHelper.getBlockSize(substring);
        }

        public static long getHi3231V530ChipSize(String received) {
            int indexOf = received.indexOf("Chip:");
            if (indexOf == -1) {
                return -1L;
            }
            int indexOf2 = received.indexOf(" ", indexOf);
            if (indexOf2 == -1) {
                return -1L;
            }
            String subString = received.substring(indexOf + "Chip:".length(), indexOf2);
            long convertToNumber = ReceiveHelper.convertToNumber(subString.trim());
            return convertToNumber * 1024L;
        }

        public static long getChipSize(String received) {
            String trim;
            String[] split;
            int indexOf = received.indexOf("Chip:");
            if (indexOf == -1) {
                return -1L;
            }
            int indexOf2 = received.indexOf(" ", indexOf);
            if (indexOf2 == -1) {
                return -1L;
            }
            String substring = received.substring(indexOf + "Chip:".length(), indexOf2);
            StringTokenizer stringTokenizer = new StringTokenizer(substring);
            int countTokens = stringTokenizer.countTokens();
            if (countTokens > 1 && stringTokenizer.hasMoreElements()) {
                substring = (String)stringTokenizer.nextElement();
            }
            if ((split = (trim = substring.trim().replace("*", ",")).split(",")).length < 2) {
                return -1L;
            }
            long result = 1L;
            String[] stringArray = split;
            int n2 = split.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                long convertToNumber = ReceiveHelper.convertToNumber(string.trim());
                if (convertToNumber == -1L) {
                    return -1L;
                }
                result *= convertToNumber;
                ++n3;
            }
            return result;
        }

        public static long getBlockSize(String received) {
            return ReceiveHelper.getSize(received, "Block:");
        }

        public static long getOobSize(String received) {
            return ReceiveHelper.getSize(received, "OOB:");
        }

        public static long getSize(String received, String prefix) {
            if (received == null || received.trim().length() == 0) {
                return 0L;
            }
            int startIndex = received.indexOf(prefix);
            if (startIndex == -1) {
                return 0L;
            }
            int endIndex = received.indexOf(" ", startIndex += prefix.length());
            if (endIndex == -1) {
                return 0L;
            }
            String strSize = received.substring(startIndex, endIndex).toLowerCase();
            return ReceiveHelper.convertToNumber(strSize);
        }

        public static long getPageSize(String received) {
            return ReceiveHelper.getSize(received, "Page:");
        }

        public static String getVersion(String received) {
            if (received == null || received.trim().length() == 0) {
                return null;
            }
            int startIndex = (received = received.toLowerCase()).indexOf("version");
            if (startIndex == -1) {
                return null;
            }
            int endIndex = received.indexOf("\r\n", startIndex);
            if (endIndex == -1) {
                return null;
            }
            return received.substring(startIndex, endIndex);
        }
    }
}

