/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui;

import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IErasable;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.define.IUploadable;
import com.hisilicon.fastboot.model.devices.IUIAdapter;
import com.hisilicon.fastboot.model.devices.IUIAdapterable;
import com.hisilicon.fastboot.model.devices.burners.CommonBurner;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.event.IFastbootEventListener;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.ui.IDEHelper;
import com.hisilicon.fastboot.views.FastbootView;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class BurnComposite
extends Composite
implements IUIAdapterable,
IFastbootEventListener {
    protected static final String LABEL_BURN = c.BurnComposite_Burn_Text;
    protected static final String LABEL_UPLOAD = c.BurnComposite_Upload_Text;
    protected static final String LABEL_ERASE = c.BurnComposite_Erase_Text;
    protected static final String LABEL_FALSH_TYPE = c.BurnComposite_LABEL_FALSHTYPE;
    protected static final String LABEL_FALSH_ID = c.BurnComposite_LABEL_FALSHID;
    protected static final String LABEL_BROWSE = c.BurnComposite_Browse_Text;
    protected static final String LABEL_SAVE = c.BurnComposite_Save_Text;
    protected static final String LABEL_FILE = c.BurnComposite_LABEL_FILE;
    protected static final String LABEL_CREATE_USB_PACKAGE = c.BurnComposite_Create_Usb_Package_Text;
    protected static final String LABEL_MAKE_NAND_IMAGE = c.PartitionComposite_Button_MakeNandImage;
    private IUIAdapter adapter;
    protected IBurner burner;
    protected IFastbootProgressMonitor progressMonitor;

    public BurnComposite(Composite parent, int style, IBurner burner) {
        super(parent, style);
        this.burner = burner;
        this._setLayout(this.createLayout());
        this.createContents(this);
        IFastbootProgressMonitor monitor = this.getProgressMonitor();
        monitor.addListener(this);
    }

    public BurnComposite(Composite parent, int style, IBurner burner2, TabItem tabItem2) {
        super(parent, style);
        this.burner = burner2;
        this._setLayout(this.createLayout());
        this.createContents(this);
        IFastbootProgressMonitor monitor = this.getProgressMonitor();
        monitor.addListener(this);
    }

    private void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    protected boolean isErase() {
        IBurner burner = this.getBurner();
        TransferWay transterWay = burner.getBurnContext().getTransferWay();
        if (transterWay.equals((Object)TransferWay.Usb2I2c)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"HiBurn", (String)c.I2C_UPGRADE_NOT_SUPPORT_ERASE);
            return false;
        }
        return true;
    }

    protected void startInfo() {
        if (FastbootView.isHi3716MV410_CA_N_Series() && FastbootView.isJTagTransferMode()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)c.ERROR_INFO_Start_JTAG);
        }
    }

    protected void burn() {
        IBurner burner = this.getBurner();
        if (this.checkStatus(burner.checkBeforeBurn())) {
            this.startInfo();
            IFastbootProgressMonitor monitor = this.getProgressMonitor();
            monitor.getEvent().setBurner(this.getBurner());
            burner.burn(monitor);
        } else {
            this.enableButtons();
        }
    }

    protected void enableButtons() {
    }

    protected boolean checkStatus(IStatus status) {
        boolean valid;
        if (status == Status.CANCEL_STATUS) {
            return false;
        }
        boolean bl2 = valid = status == null || status.isOK();
        if (!valid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)status.getMessage());
        }
        return valid;
    }

    protected abstract void createContents(Composite var1);

    protected abstract Layout createLayout();

    protected boolean isAlertWhenDone() {
        return FastbootPreferences.isDialogOn();
    }

    protected void erase() {
        IBurner burner = this.getBurner();
        if (burner instanceof IErasable) {
            IErasable eraseable = (IErasable)((Object)burner);
            this.startInfo();
            if (this.getBurner() instanceof EmmcBurner) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else if (this.checkStatus(eraseable.checkBeforeErase())) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else {
                this.enableButtons();
            }
        }
    }

    protected void eraseAll() {
        IBurner burner = this.getBurner();
        if (burner instanceof IErasable) {
            IErasable eraseable = (IErasable)((Object)burner);
            this.startInfo();
            if (this.getBurner() instanceof CommonBurner) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.eraseAll(monitor);
            } else if (this.getBurner() instanceof EmmcBurner) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.erase(monitor);
            } else {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(this.getBurner());
                eraseable.eraseAll(monitor);
            }
        }
    }

    public IBurner getBurner() {
        return this.burner;
    }

    public IFastbootProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = IFastbootProgressMonitor.NULL;
        }
        return this.progressMonitor;
    }

    @Override
    public void updateLength(long length) {
    }

    public final void setLayout(Layout layout) {
    }

    protected void upload() {
        IBurner burner = this.getBurner();
        if (burner instanceof IUploadable) {
            IUploadable uploadable = (IUploadable)((Object)burner);
            this.startInfo();
            IStatus checkBeforeUpload = uploadable.checkBeforeUpload();
            if (checkBeforeUpload != null && checkBeforeUpload.getSeverity() == 8) {
                this.enableButtons();
                return;
            }
            if (this.checkStatus(checkBeforeUpload)) {
                uploadable.upload(this.getProgressMonitor());
            } else {
                this.enableButtons();
            }
        }
    }

    @Override
    public void started(FastbootEvent event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IViewPart findView = activePage.findView("org.eclipse.ui.console.ConsoleView");
        if (findView != null) {
            activePage.setPartState(activePage.getReference((IWorkbenchPart)findView), 2);
        } else {
            try {
                activePage.showView("org.eclipse.ui.console.ConsoleView");
            }
            catch (PartInitException e2) {
                e2.printStackTrace();
            }
        }
        this.disableUI();
    }

    public void disableUI() {
        if (!this.isDisposed() && this.getParent() != null) {
            this.getParent().setEnabled(false);
        }
    }

    @Override
    public void finished(FastbootEvent event) {
        this.enableUI();
        if (event.getBurner() != this.getBurner()) {
            return;
        }
        if (this.isAlertWhenDone()) {
            String message = null;
            EventType type = event.getType();
            if (type == null) {
                return;
            }
            if (event.isUserCanceled()) {
                message = event.getMessage();
                if (message == null) {
                    message = "User Cancelled!";
                }
                IDEHelper.preOpenDialog();
                MessageDialog.openInformation((Shell)this.getShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)message);
                return;
            }
            if ((message = this.getMessageForAllEvent(event, message, type)) != null) {
                IDEHelper.preOpenDialog();
                final String tipsMessage = message;
                if (event.isSuccess()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)BurnComposite.this.getShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)tipsMessage);
                        }
                    });
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)BurnComposite.this.getShell(), (String)c.FASTBOOT_MessageDialog_Title, (String)tipsMessage);
                        }
                    });
                }
            }
        }
    }

    private String getMessageForAllEvent(FastbootEvent event, String message, EventType type) {
        if (type == EventType.BURN) {
            message = this.getMessaageForBurn(event);
        } else if (type == EventType.ERASE) {
            message = this.getMessageForErase(event);
        } else if (type == EventType.UPLOAD) {
            message = this.getMessageForUpload(event);
        } else if (type == EventType.CREATE_IMAGE) {
            message = this.getMessageForCreateImage(event);
        } else if (type == EventType.CREATE_USB_PACKAGE) {
            message = this.getMessageForCreateUSB(event);
        }
        return message;
    }

    private String getMessageForCreateUSB(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = c.BurnComposite_Create_Usb_Package_Success;
        } else if (message == null) {
            message = c.BurnComposite_Create_Usb_Package_Failed;
        }
        return message;
    }

    private String getMessageForCreateImage(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = c.BurnComposite_Create_Image_Success;
        }
        return message;
    }

    private String getMessageForUpload(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = c.BurnComposite_Upload_Message_Success;
        } else if (message == null) {
            message = c.BurnComposite_Upload_Message_Failed;
        }
        return message;
    }

    private String getMessageForErase(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            message = c.BurnComposite_Erase_Message_Success;
        } else if (message == null) {
            message = c.BurnComposite_Erase_Message_Failed;
        }
        return message;
    }

    private String getMessaageForBurn(FastbootEvent event) {
        String message = event.getMessage();
        if (event.isSuccess()) {
            boolean isPartition;
            String totalBurnTime = event.getTotalBurnTime();
            boolean bl2 = isPartition = event.getBurner() instanceof PartitionBurner || event.getBurner() instanceof EmmcBurner;
            if (isPartition) {
                boolean totalBurnTimeVaild;
                boolean bl3 = totalBurnTimeVaild = totalBurnTime != null && !totalBurnTime.equalsIgnoreCase("");
                message = totalBurnTimeVaild ? String.valueOf(c.BurnComposite_Burn_Message_Success_And_Time) + totalBurnTime + "." : c.BurnComposite_Burn_Message_Success;
            } else {
                message = c.BurnComposite_Burn_Message_Success;
            }
        } else if (message == null) {
            message = c.BurnComposite_Burn_Message_Failed;
        }
        return message;
    }

    public void enableUI() {
        if (!this.isDisposed() && this.getParent() != null) {
            this.getParent().setEnabled(true);
        }
    }

    @Override
    public void hightLight(List<PartitionItem> parts) {
    }

    @Override
    public IUIAdapter getUIAdapter() {
        return this.adapter;
    }

    @Override
    public void setUIAdapter(IUIAdapter adapter) {
        this.adapter = adapter;
        this.burner.getBurnContext().setUIAdapter(adapter);
    }
}

