/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IpAddressEditor
extends Composite {
    static final char CHAR_0 = '0';
    static final char CHAR_9 = '9';
    static final String STR_0 = "0";
    static final String STR_255 = "255";
    static final String DOT = ".";
    private Text part1Text;
    private Text part2Text;
    private Text part3Text;
    private Text part4Text;
    private int[] address = new int[4];
    private Color defaultBackground;

    public IpAddressEditor(Composite parent, int style) {
        super(parent, style | 0x800);
        this.createContents(this);
        this.setBackground(this.getWhiteColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this._setLayout((Layout)layout);
        this.setTabList(new Control[]{this.part1Text, this.part2Text, this.part3Text, this.part4Text});
    }

    private void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    private void buildEditor() {
        if (this.part1Text != null && !this.part1Text.isDisposed()) {
            this.part1Text.setText(Integer.toString(this.address[0]));
        }
        if (this.part2Text != null && !this.part2Text.isDisposed()) {
            this.part2Text.setText(Integer.toString(this.address[1]));
        }
        if (this.part3Text != null && !this.part3Text.isDisposed()) {
            this.part3Text.setText(Integer.toString(this.address[2]));
        }
        if (this.part4Text != null && !this.part4Text.isDisposed()) {
            this.part4Text.setText(Integer.toString(this.address[3]));
        }
    }

    private void createContents(Composite parent) {
        parent.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e2) {
            }

            public void keyPressed(KeyEvent e2) {
                if (e2.stateMask == 262144 && (e2.keyCode == 118 || e2.keyCode == 86)) {
                    Object source = e2.getSource();
                    System.out.println(source);
                    if (source instanceof String) {
                        String str = (String)source;
                        System.out.println(str);
                    }
                }
            }
        });
        this.part1Text = this.createText(parent, 0);
        this.part1Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part2Text = this.createText(parent, 1);
        this.part2Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part3Text = this.createText(parent, 2);
        this.part3Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part4Text = this.createText(parent, 3);
        this.part4Text.setLayoutData((Object)this.createLayoutData());
        this.buildEditor();
    }

    private Label createDotLabel(Composite parent) {
        Label label = new Label(parent, 0);
        if (this.defaultBackground == null) {
            this.defaultBackground = label.getBackground();
        }
        label.setBackground(this.getWhiteColor());
        label.setText(DOT);
        return label;
    }

    private GridData createLayoutData() {
        GridData layoutData = new GridData(768);
        layoutData.minimumWidth = 25;
        return layoutData;
    }

    private Text createText(Composite parent, final int index) {
        final Text text = new Text(parent, 0x1000000);
        text.setData((Object)index);
        text.setTextLimit(3);
        text.addListener(25, (Listener)new VerifyListener());
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                int newValue;
                Text widget = (Text)event.widget;
                String text = widget.getText();
                if (text.equals("")) {
                    text = IpAddressEditor.STR_0;
                }
                if ((newValue = Integer.parseInt(text)) != IpAddressEditor.this.address[index]) {
                    ((IpAddressEditor)IpAddressEditor.this).address[index] = newValue;
                    IpAddressEditor.this.dispatchEvent();
                }
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if ((event.keyCode == 46 || event.keyCode == 16777262) && index < 3) {
                    IpAddressEditor.this.getTabList()[index % 4 + 1].setFocus();
                }
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e2) {
                System.out.println("e.stateMask " + e2.stateMask);
                System.out.println("e.keyCode " + e2.keyCode);
                if (e2.stateMask == 262144 && (e2.keyCode == 67 || e2.keyCode == 99)) {
                    System.out.println("Ctrl+C");
                    IpAddressEditor.this.copyKeyPressed();
                }
                if (e2.stateMask == 262144 && (e2.keyCode == 86 || e2.keyCode == 118)) {
                    System.out.println("Ctrl+V");
                    IpAddressEditor.this.pasteKeyPressed();
                }
            }

            public void keyPressed(KeyEvent e2) {
            }
        });
        return text;
    }

    public void pasteKeyPressed() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TransferData[] transferDatas = clipboard.getAvailableTypes();
        int i2 = 0;
        while (i2 < transferDatas.length) {
            if (RTFTransfer.getInstance().isSupportedType(transferDatas[i2])) {
                System.out.println("Data is available in RTF format");
                break;
            }
            ++i2;
        }
        String plainText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        clipboard.dispose();
        if (plainText == null) {
            return;
        }
        String[] split = plainText.split("\\.");
        int length = split.length;
        if (length != 4) {
            return;
        }
        this.part1Text.setText(split[0]);
        this.part2Text.setText(split[1]);
        this.part3Text.setText(split[2]);
        this.part4Text.setText(split[3]);
        this.part1Text.setFocus();
    }

    public void copyKeyPressed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.part1Text.getText()).append(DOT);
        sb.append(this.part2Text.getText()).append(DOT);
        sb.append(this.part3Text.getText()).append(DOT);
        sb.append(this.part4Text.getText());
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String plainText = sb.toString();
        String rtfText = "{\\rtf1\\b Hello World}";
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFTransfer rftTransfer = RTFTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{plainText, rtfText}, new Transfer[]{textTransfer, rftTransfer});
        clipboard.dispose();
    }

    private void dispatchEvent() {
        Event event = new Event();
        event.widget = this;
        event.text = this.getDisplayAddress();
        this.notifyListeners(24, event);
    }

    public String getDisplayAddress() {
        return String.valueOf(this.address[0]) + DOT + this.address[1] + DOT + this.address[2] + DOT + this.address[3];
    }

    private Color getWhiteColor() {
        return this.getDisplay().getSystemColor(1);
    }

    public void setAddress(String addressStr) {
        if (addressStr != null) {
            String[] splits = addressStr.split("\\.", 0);
            int i2 = 0;
            while (i2 < splits.length) {
                if (i2 > 3) break;
                try {
                    this.address[i2] = Integer.parseInt(splits[i2].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.address.length) {
                this.address[i3] = 0;
                ++i3;
            }
        }
        this.buildEditor();
    }

    public void setEnabled(boolean enabled) {
        Control[] children;
        super.setEnabled(enabled);
        Control[] controlArray = children = this.getChildren();
        int n2 = children.length;
        int n3 = 0;
        while (n3 < n2) {
            Control control = controlArray[n3];
            control.setEnabled(enabled);
            if (control instanceof Label) {
                if (enabled) {
                    control.setBackground(this.getWhiteColor());
                } else {
                    control.setBackground(this.defaultBackground);
                }
            }
            ++n3;
        }
        if (enabled) {
            this.setBackground(this.getWhiteColor());
        } else {
            this.setBackground(this.defaultBackground);
        }
    }

    public void setLayout(Layout layout) {
    }

    static class VerifyListener
    implements Listener {
        private boolean ignore = false;

        private VerifyListener() {
        }

        public void handleEvent(Event e2) {
            if (this.ignore) {
                return;
            }
            e2.doit = false;
            String insert = e2.text;
            char[] newChars = insert.toCharArray();
            int i2 = Math.min(2, newChars.length - 1);
            while (i2 >= 0) {
                if ('0' > newChars[i2] || newChars[i2] > '9') {
                    return;
                }
                --i2;
            }
            Text widget = (Text)e2.widget;
            StringBuilder newText = new StringBuilder(widget.getText());
            if (e2.start == e2.end) {
                newText.insert(e2.start, newChars);
            } else {
                newText.replace(e2.start, e2.end, insert);
            }
            String value = newText.toString();
            if (value.length() > 3) {
                value = value.substring(0, 3);
            } else if (value.isEmpty()) {
                value = IpAddressEditor.STR_0;
            }
            int intVal = Integer.parseInt(value);
            this.ignore = true;
            value = intVal > 255 ? IpAddressEditor.STR_255 : Integer.toString(intVal);
            widget.selectAll();
            widget.insert(value);
            this.ignore = false;
        }
    }
}

