/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.IUIAdapter;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.ui.BurnComposite;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class FastbootComposite
extends BurnComposite {
    protected Button burnButton;
    private Button browseButton;
    private Combo flashTypeCombo;
    protected Combo flashCombo;
    private Text fileText;
    protected Text programmerFileText;
    protected Button programmerFileBrowseButton;

    public FastbootComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
    }

    public FastbootComposite(Composite parent, int style, IBurner burner, TabItem tabItem2) {
        super(parent, style, burner, tabItem2);
    }

    protected Button createButton(Composite buttonComp, String label) {
        Button button = new Button(buttonComp, 0);
        button.setText(label);
        GridData layoutData = new GridData(576);
        layoutData.minimumWidth = 100;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    protected List<Button> createButtons(Composite buttonComp) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.fillButtons(buttonComp, buttons);
        return buttons;
    }

    protected void createButtonsControl(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridData layoutData = new GridData(1800);
        layoutData.horizontalSpan = 3;
        buttonComp.setLayoutData((Object)layoutData);
        List<Button> buttons = this.createButtons(buttonComp);
        buttonComp.setLayout((Layout)new GridLayout(buttons.size(), true));
    }

    @Override
    protected void createContents(Composite parent) {
        this.createFlashTypeEditor(parent, null);
        this.createFileEditor(parent);
        if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((q)this.getBurner().getBurnContext().getDeviceSetting()).h()) {
            this.createProgrammerFileText(parent);
        }
        this.createButtonsControl(parent);
        this.initData();
    }

    protected void initData() {
        IBootBurner burner = this.getBurner();
        String[] flashNames = burner.getBurnContext().getDeviceSetting().getFlashSetting().getFlashNames(burner);
        this.flashTypeCombo.setItems(flashNames);
    }

    protected void createFileEditor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_FILE);
        this.fileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)layoutData);
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String filePath = FastbootComposite.this.fileText.getText();
                if (filePath.trim().length() == 0) {
                    FastbootComposite.this.fileText.setText("");
                } else {
                    FastbootComposite.this.getBurner().setFile(filePath);
                }
            }
        });
        this.fileText.setEnabled(false);
        this.browseButton = new Button(parent, 0);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filePath;
                FileDialog dialog = new FileDialog(FastbootComposite.this.getShell(), 4096);
                String text = FastbootComposite.this.fileText.getText();
                if (!text.equals("")) {
                    dialog.setFileName(text);
                }
                if ((filePath = dialog.open()) != null) {
                    FastbootComposite.this.fileText.setText(filePath);
                    FastbootComposite.this.getBurner().setFile(filePath);
                }
            }
        });
    }

    protected void updateFileEditor(Composite parent, String filePath) {
        this.fileText.setText(String.valueOf(filePath));
    }

    protected void createFlashTypeEditor(Composite parent, FlashType flashType) {
        Label label = new Label(parent, 0);
        label.setText(LABEL_FALSH_TYPE);
        this.flashTypeCombo = new Combo(parent, 8);
        GridData layoutData = new GridData(544);
        layoutData.horizontalSpan = 3;
        this.flashTypeCombo.setLayoutData((Object)layoutData);
        this.flashTypeCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootComposite.this.handleFlashTypeChanged();
            }
        });
    }

    protected void createFlashIdEditor(Composite parent) {
        Label falshLabel = new Label(parent, 0);
        falshLabel.setText(LABEL_FALSH_ID);
        this.flashCombo = new Combo(parent, 8);
        GridData layoutData = new GridData(544);
        layoutData.horizontalSpan = 3;
        this.flashCombo.setLayoutData((Object)layoutData);
        this.flashCombo.setItems(new String[]{"Tcon Flash", "Demura Flash"});
        this.flashCombo.select(0);
        this.getBurner().setFlashId(ChipID.chip0);
        this.flashCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e2) {
                int index = FastbootComposite.this.flashCombo.getSelectionIndex();
                if (index == 0) {
                    FastbootComposite.this.getBurner().setFlashId(ChipID.chip0);
                } else {
                    FastbootComposite.this.getBurner().setFlashId(ChipID.chip1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e2) {
            }
        });
    }

    protected void handleFlashTypeChanged() {
        int index = this.flashTypeCombo.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        String item = this.flashTypeCombo.getItem(index);
        IBootBurner burner = this.getBurner();
        FlashType flashType = burner.getBurnContext().getDeviceSetting().getFlashSetting().findFlashType(burner, item);
        burner.setFlashType(flashType);
    }

    protected void updateFlashType(Composite parent, FlashType flashType) {
        int i2 = 0;
        while (i2 < this.flashTypeCombo.getItemCount()) {
            String flashName = this.flashTypeCombo.getItem(i2);
            if (flashName.equalsIgnoreCase("spi nand/nand")) {
                flashName = FlashType.nand.name();
            } else if (flashName.equalsIgnoreCase("spi nor")) {
                flashName = FlashType.spi.name();
            }
            if (flashType.name().equalsIgnoreCase(flashName)) {
                this.flashTypeCombo.select(i2);
            }
            ++i2;
        }
        this.handleFlashTypeChanged();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(4, false);
    }

    @Override
    protected void disableUI() {
        IUIAdapter adapter = this.getUIAdapter();
        adapter.disableReloadButton();
        adapter.disableSerialSelection();
        if (this.isDisposed()) {
            return;
        }
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
    }

    @Override
    protected void enableButtons() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        IUIAdapter adapter = this.getUIAdapter();
        adapter.enableReloadButton();
        adapter.enableSerialSelection();
        if (this.isDisposed()) {
            return;
        }
        this.enableButtons();
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
    }

    protected void fillButtons(Composite buttonComp, List<Button> buttons) {
        this.burnButton = this.createButton(buttonComp, LABEL_BURN);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootComposite.this.burnButton.setEnabled(false);
                FastbootComposite.this.burn();
            }
        });
        buttons.add(this.burnButton);
    }

    @Override
    public IBootBurner getBurner() {
        return (IBootBurner)super.getBurner();
    }

    protected void handleBrwoseFileCA() {
        String filePath;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String text = this.programmerFileText.getText();
        if (!text.equals("")) {
            dialog.setFileName(text);
        }
        if ((filePath = dialog.open()) != null) {
            this.programmerFileText.setText(filePath);
            File bootFile = new File(filePath);
            if (bootFile.exists()) {
                ((AbstractBurner)((Object)this.getBurner())).setProgrammerFile(filePath);
            }
        }
    }

    protected void createProgrammerFileText(Composite parent) {
        Label programmerFileLabel = new Label(parent, 0);
        programmerFileLabel.setText(c.FastbootComposite_LABEL_PROGRAMER_FILE);
        this.programmerFileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.programmerFileText.setEnabled(false);
        this.programmerFileText.setLayoutData((Object)layoutData);
        this.programmerFileBrowseButton = new Button(parent, 0);
        this.programmerFileBrowseButton.setLayoutData((Object)new GridData());
        this.programmerFileBrowseButton.setText(LABEL_BROWSE);
        this.programmerFileBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootComposite.this.handleBrwoseFileCA();
            }
        });
    }
}

