/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.views;

import com.hisilicon.fastboot.Activator;
import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PCNetworkInfo;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.ProductLine;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IChecker;
import com.hisilicon.fastboot.model.define.ICheckerBoard;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IAddressBurner;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.IBurnerContext;
import com.hisilicon.fastboot.model.devices.IDeviceListener;
import com.hisilicon.fastboot.model.devices.IDeviceSetting;
import com.hisilicon.fastboot.model.devices.IMergeBurner;
import com.hisilicon.fastboot.model.devices.ISaveable;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.IUIAdapter;
import com.hisilicon.fastboot.model.devices.IUIAdapterable;
import com.hisilicon.fastboot.model.devices.burners.BadCheckBurner;
import com.hisilicon.fastboot.model.devices.burners.BoardCheckBurner;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.perspectives.FastbootPerspective;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.JTAGPreferencePage;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.ui.BurnComposite;
import com.hisilicon.fastboot.ui.IpAddressEditor;
import com.hisilicon.fastboot.ui.MacAddressEditor;
import com.hisilicon.fastboot.ui.UIAdapter;
import com.hisilicon.fastboot.ui.burners.AddressComposite;
import com.hisilicon.fastboot.ui.burners.PartitionComposite;
import com.hisilicon.fastboot.ui.dialog.ConfigDialog;
import com.hisilicon.fastboot.views.LightView;
import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.soyatec.preferences.HiBurnState;
import org.soyatec.tftp.hitool.TFTPService;

public class FastbootView
extends ViewPart
implements IDeviceListener,
IDeviceChangedListener,
ControlListener,
IPerspectiveListener4,
ISaveablePart2,
IExpansionListener {
    public static final String ID = FastbootView.class.getName();
    private static final int BUTTON_WIDTH = 70;
    private static final int LABEL_WIDTH_LOCAL_GROUP = 70;
    private static final int SERIAL_WIDTH = 115;
    private static final int SERIAL_WIDTH_LINUX = 130;
    private static final String[] HISTBUSB2JTAG_VERA_TITLE_ITEMS = new String[]{"15M", "10M", "6M", "4M", "2M", "1M"};
    private static final int[] HISTBUSB2JTAG_VERA_VALUE_ITEMS = new int[]{15000, 10000, 6000, 4000, 2000, 1000};
    private static final String[] HISTBUSB2JTAG_VERB_TITLE_ITEMS = new String[]{"6M", "4M", "2M", "1M"};
    private static final int[] HISTBUSB2JTAG_VERB_VALUE_ITEMS = new int[]{6000, 4000, 2000, 1000};
    private static final String[] HISTBUSB2JTAG_Hi3716MV420_CA_N_TITLE_ITEMS = new String[]{"4M", "2M", "1M"};
    private static final int[] HISTBUSB2JTAG_Hi3716MV420_CA_N_VALUE_ITEMS = new int[]{4000, 2000, 1000};
    private String currentChip = null;
    private static boolean isFastbootStart;
    private IUIAdapter enableAdapter = new UIAdapter(){

        @Override
        public void disableReloadButton() {
            if (FastbootView.this.reloadButton.isDisposed()) {
                return;
            }
            FastbootView.this.reloadButton.setEnabled(false);
        }

        @Override
        public void enableReloadButton() {
            if (FastbootView.this.reloadButton.isDisposed()) {
                return;
            }
            FastbootView.this.reloadButton.setEnabled(true);
        }

        @Override
        public void disableServerIPSelection() {
            if (FastbootView.this.serverIpCombo.isDisposed()) {
                return;
            }
            FastbootView.this.serverIpCombo.setEnabled(false);
        }

        @Override
        public void enableServerIPSelection() {
            if (FastbootView.this.serverIpCombo.isDisposed()) {
                return;
            }
            FastbootView.this.serverIpCombo.setEnabled(true);
        }

        @Override
        public void disableSerialSelection() {
            this.setEnable((Control)FastbootView.this.netWay, false);
            this.setEnable((Control)FastbootView.this.netWayNonNude, false);
            this.setEnable((Control)FastbootView.this.serialWay, false);
            this.setEnable((Control)FastbootView.this.usb2ethWay, false);
            this.setEnable((Control)FastbootView.this.uart2Compress, false);
            this.setEnable((Control)FastbootView.this.usb2I2c, false);
            this.setEnable((Control)FastbootView.this.serialPortCombo, false);
            this.setEnable((Control)FastbootView.this.i2cBootrom, false);
            this.setEnable((Control)FastbootView.this.usbBootrom, false);
            this.setEnable((Control)FastbootView.this.usbNonNude, false);
            this.setEnable((Control)FastbootView.this.btnJtagAndNet, false);
            this.setEnable((Control)FastbootView.this.usb2EtherNet, false);
            this.setEnable((Control)FastbootView.this.btnJtagAndSerial, false);
            this.setEnable((Control)FastbootView.this.btnJtag, false);
            this.setEnable((Control)btnJtagRate, false);
        }

        @Override
        public void enableSerialSelection() {
            TransferWay transferWay = FastbootView.getBurnContext().getTransferWay();
            if (FastbootView.isHi3231V530Series() || transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet) {
                return;
            }
            this.setEnable((Control)FastbootView.this.serialPortCombo, true);
        }

        private void setEnable(Control control, boolean enbled) {
            if (control != null && !control.isDisposed()) {
                control.setEnabled(enbled);
            }
        }

        @Override
        public void disableLocalChange() {
            this.disableSerialSelection();
            this.disableServerIPSelection();
        }

        @Override
        public void enableLocalChange() {
            this.enableSerialSelection();
            this.enableServerIPSelection();
        }

        @Override
        public void enableBoradChange() {
            FastbootView.this.enableTransferWaySelection();
            FastbootView.this.refreshTransferConfig();
        }

        @Override
        public void disableBoradChange() {
            FastbootView.this.enableTransferWaySelection();
            FastbootView.this.enableBoardConfig(false);
        }

        @Override
        public void highLight(PartitionItem part) {
            Control control;
            TabItem[] selection = FastbootView.this.tabFolder.getSelection();
            if (selection.length > 0 && (control = selection[0].getControl()) instanceof PartitionComposite) {
                PartitionComposite p2 = (PartitionComposite)control;
                p2.getProgressMonitor().highlight(part);
            }
        }
    };
    private FormToolkit toolkit;
    private IBurner currentBurn;
    private MacAddressEditor macAddressEditor;
    private IpAddressEditor ipAddressEditor;
    private Combo serialPortCombo;
    private Combo serverIpCombo;
    private Button usb2EtherNet;
    private IpAddressEditor subnetMaskEditor;
    private IpAddressEditor gatewayEditor;
    private IDeviceSetting deviceSetting = null;
    private static BurnContext burnContext;
    private TabFolder tabFolder;
    private Composite control;
    private Button reloadButton;
    private Combo devices;
    private IDeviceManager deviceManager;
    private Button netWay;
    private Button netWayNonNude;
    private Button serialWay;
    private Button usb2ethWay;
    private Button uart2Compress;
    private Button usb2I2c;
    private Button i2cBootrom;
    private Button usbBootrom;
    private Button usbNonNude;
    private Button btnJtagAndNet;
    private Button btnJtagAndSerial;
    private static Combo btnJtagRate;
    private Button btnJtag;
    private ScrolledComposite scrolledComposite;
    private Group boardGroup;
    private Group localGroup;
    private Group transferWayGroup;
    private Group JtagRateGroup;
    private Section section;
    private Composite client;

    public static boolean isFastbootStart() {
        return isFastbootStart;
    }

    public static void setFastbootStart(boolean isFastbootStart) {
        FastbootView.isFastbootStart = isFastbootStart;
    }

    public void createPartControl(Composite parent) {
        HiToolStatistics.INSTANCE.logToolStart("HiBurn");
        parent.getShell().addControlListener((ControlListener)this);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        GridData scrollableLayoutData = new GridData(1808);
        this.scrolledComposite.setLayoutData((Object)scrollableLayoutData);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinHeight(50);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        verticalBar.setIncrement(10);
        this.control = new Composite((Composite)this.scrolledComposite, 0);
        parent.addControlListener((ControlListener)this);
        this.scrolledComposite.setContent((Control)this.control);
        this.control.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        this.control.setLayout((Layout)layout);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        this.control.setLayout((Layout)layout);
        GridData layoutData = null;
        this.section = this.toolkit.createSection(this.control, 322);
        this.section.setText(c.FastbootView_PcAndBoradConfig);
        this.client = this.toolkit.createComposite((Composite)this.section, 0);
        layout = new GridLayout(4, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        this.client.setLayout((Layout)layout);
        this.section.setClient((Control)this.client);
        layoutData = new GridData(4, 1, true, false);
        this.section.setLayoutData((Object)layoutData);
        this.section.addExpansionListener((IExpansionListener)this);
        this.localGroup = this.createLocalGroup(this.client);
        this.createBoardGroup(this.client);
        this.transferWayGroup = this.createTransferWayGroup(this.client);
        if (FastbootView.isSupportJTag()) {
            this.JtagRateGroup = this.createJtagRateGroup(this.client);
        }
        this.tabFolder = this.createBurnTab(this.control);
        this.refreshAll();
        this.refreshScollBar();
        this.adapt(this.toolkit, (Control)this.control);
    }

    public void refreshScollBar(boolean expansionStateChanged, boolean expanded) {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        Point computeSize = this.control.computeSize(-1, -1);
        int width = this.boardGroup.computeSize((int)-1, (int)-1).x + this.localGroup.computeSize((int)-1, (int)-1).x + this.transferWayGroup.computeSize((int)-1, (int)-1).x + 120;
        Point size = this.scrolledComposite.getSize();
        if (expansionStateChanged) {
            computeSize.x = Math.min(width, computeSize.x);
            computeSize.y = expanded ? Math.min(computeSize.y, this.control.getBounds().height) - 20 : Math.min(computeSize.y, size.y) - 22;
        } else {
            computeSize.x = Math.min(width, computeSize.x);
            computeSize.y = Math.min(computeSize.y, this.control.getBounds().height);
        }
        this.scrolledComposite.setMinSize(computeSize);
        this.control.redraw();
    }

    public void refreshScollBar() {
        this.refreshScollBar(false, false);
    }

    private Group createTransferWayGroup(Composite client) {
        Group transferWayGroup = new Group(client, 0);
        transferWayGroup.setText(c.FastbootView_TransferWay);
        GridLayout localLayout = new GridLayout(1, false);
        transferWayGroup.setLayout((Layout)localLayout);
        transferWayGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData layoutData = new GridData(1);
        layoutData.minimumWidth = 80;
        if (burnContext != null) {
            this.serialWay = new Button((Composite)transferWayGroup, 16);
            this.serialWay.setText(c.FastbootView_TransferWay_Serial);
            this.serialWay.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection() && burnContext != null) {
                        burnContext.setTransferWay(TransferWay.Serial);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.serialWay.setLayoutData((Object)layoutData);
            this.updateNetBtn(transferWayGroup);
            this.updateNetWayNonNude(transferWayGroup);
            this.updateUsb2ethBtn(transferWayGroup);
            this.updateUart2Compress(transferWayGroup);
            this.updateUsb2I2c(transferWayGroup);
            this.updateI2cBootrom(transferWayGroup);
            this.updateUsbBootrom(transferWayGroup);
            this.updateUsbNonNude(transferWayGroup);
            this.updateJTAG(transferWayGroup);
            this.updateJTAGAndSerial(transferWayGroup);
            this.updateJTAGAndNet(transferWayGroup);
            String chipName = ((q)burnContext.getDeviceSetting()).getName();
            if (chipName != null && chipName.equalsIgnoreCase("Hi3500C")) {
                this.serialWay.setSelection(true);
                burnContext.setTransferWay(TransferWay.Serial);
                this.refreshTransferConfig();
            }
        }
        return transferWayGroup;
    }

    private Group createJtagRateGroup(Composite client) {
        Group jtagRateGroup = new Group(client, 0);
        jtagRateGroup.setText(c.FastbootView_JTAGConfig);
        GridLayout localLayout = new GridLayout(2, true);
        jtagRateGroup.setLayout((Layout)localLayout);
        jtagRateGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData layoutData = new GridData(1);
        layoutData.minimumWidth = 80;
        if (burnContext != null) {
            this.updateJtagRateBtn(jtagRateGroup);
        }
        return jtagRateGroup;
    }

    private void updateNetBtn(Group transferWayGroup) {
        boolean isSupportUsb2eth = ((q)burnContext.getDeviceSetting()).g();
        if (!isSupportUsb2eth) {
            if (this.netWay == null || this.netWay.isDisposed()) {
                this.netWay = new Button((Composite)transferWayGroup, 16);
            }
            this.netWay.setText(c.FastbootView_TransferWay_Net);
            this.netWay.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection() && burnContext != null) {
                        burnContext.setTransferWay(TransferWay.Net);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.netWay.setLayoutData((Object)new GridData(1));
        } else {
            if (this.netWay != null && !this.netWay.isDisposed()) {
                this.netWay.dispose();
                transferWayGroup.layout();
            }
            burnContext.setTransferWay(TransferWay.Serial);
        }
    }

    private void updateNetWayNonNude(Group transferWayGroup) {
        boolean isSupportNETNonNude = ((q)burnContext.getDeviceSetting()).p();
        if (isSupportNETNonNude) {
            if (this.netWayNonNude == null || this.netWayNonNude.isDisposed()) {
                this.netWayNonNude = new Button((Composite)transferWayGroup, 16);
            }
            this.netWayNonNude.setText(c.FastbootView_TransferWay_NetNonNude);
            this.netWayNonNude.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.NetNonNude);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.netWayNonNude.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.netWayNonNude != null && !this.netWayNonNude.isDisposed()) {
            this.netWayNonNude.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateUsb2ethBtn(Group transferWayGroup) {
        boolean isSupportUsb2eth = ((q)burnContext.getDeviceSetting()).c();
        if (isSupportUsb2eth) {
            boolean needSelete;
            if (this.usb2ethWay == null || this.usb2ethWay.isDisposed()) {
                this.usb2ethWay = new Button((Composite)transferWayGroup, 16);
            }
            this.usb2ethWay.setText(c.FastbootView_TransferWay_UsbTransNet);
            this.usb2ethWay.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.UsbTransNet);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.usb2ethWay.setLayoutData((Object)new GridData(1));
            String chipName = ((q)burnContext.getDeviceSetting()).getName();
            boolean bl2 = needSelete = chipName != null && !chipName.equalsIgnoreCase("Hi3716MV310") && !chipName.equalsIgnoreCase("Hi3716MV310-CA") && !chipName.equalsIgnoreCase("Hi3798MV200") && !chipName.equalsIgnoreCase("Hi3798MV200H") && !chipName.equalsIgnoreCase("Hi3798MV300") && !chipName.equalsIgnoreCase("Hi3716DV110");
            if (needSelete) {
                this.usb2ethWay.setSelection(true);
                burnContext.setTransferWay(TransferWay.UsbTransNet);
            }
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.usb2ethWay != null && !this.usb2ethWay.isDisposed()) {
            this.usb2ethWay.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateUart2Compress(Group transferWayGroup) {
        boolean isSupportUart2Compress = ((q)burnContext.getDeviceSetting()).e();
        if (isSupportUart2Compress) {
            if (this.uart2Compress == null || this.uart2Compress.isDisposed()) {
                this.uart2Compress = new Button((Composite)transferWayGroup, 16);
            } else {
                this.uart2Compress.setSelection(false);
            }
            this.uart2Compress.setText(c.FastbootView_TransferWay_Uart2Compress);
            this.uart2Compress.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.Uart2Compress);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.uart2Compress.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.uart2Compress != null && !this.uart2Compress.isDisposed()) {
            this.uart2Compress.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateUsb2I2c(Group transferWayGroup) {
        boolean isSupportUsb2I2c = ((q)burnContext.getDeviceSetting()).f();
        if (isSupportUsb2I2c) {
            if (this.usb2I2c == null || this.usb2I2c.isDisposed()) {
                this.usb2I2c = new Button((Composite)transferWayGroup, 16);
            } else {
                this.usb2I2c.setSelection(false);
            }
            this.usb2I2c.setText(c.FastbootView_TransferWay_Usb2I2c);
            this.usb2I2c.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.Usb2I2c);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.usb2I2c.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.usb2I2c != null && !this.usb2I2c.isDisposed()) {
            this.usb2I2c.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateI2cBootrom(Group transferWayGroup) {
        boolean isSupportI2cbootrom = ((q)burnContext.getDeviceSetting()).m();
        if (isSupportI2cbootrom) {
            if (this.i2cBootrom == null || this.i2cBootrom.isDisposed()) {
                this.i2cBootrom = new Button((Composite)transferWayGroup, 16);
            } else {
                this.i2cBootrom.setSelection(false);
            }
            this.i2cBootrom.setText(c.FastbootView_TransferWay_I2cBootrom);
            this.i2cBootrom.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.I2CBootrom);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.i2cBootrom.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.i2cBootrom != null && !this.i2cBootrom.isDisposed()) {
            this.i2cBootrom.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateUsbBootrom(Group transferWayGroup) {
        boolean isSupportUsbBootrom = ((q)burnContext.getDeviceSetting()).n();
        if (isSupportUsbBootrom) {
            if (this.usbBootrom == null || this.usbBootrom.isDisposed()) {
                this.usbBootrom = new Button((Composite)transferWayGroup, 16);
            }
            this.usbBootrom.setText(c.FastbootView_TransferWay_UsbBootrom);
            this.usbBootrom.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.USBBootrom);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.usbBootrom.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
            this.usbBootrom.setSelection(true);
            burnContext.setTransferWay(TransferWay.USBBootrom);
        } else if (this.usbBootrom != null && !this.usbBootrom.isDisposed()) {
            this.usbBootrom.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateUsbNonNude(Group transferWayGroup) {
        boolean isSupportUsbNonNude = ((q)burnContext.getDeviceSetting()).o();
        if (isSupportUsbNonNude) {
            if (this.usbNonNude == null || this.usbNonNude.isDisposed()) {
                this.usbNonNude = new Button((Composite)transferWayGroup, 16);
            }
            this.usbNonNude.setText(c.FastbootView_TransferWay_UsbNonNude);
            this.usbNonNude.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.USBNonNude);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.usbNonNude.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
        } else if (this.checkControlVaild((Control)this.usbNonNude)) {
            this.usbNonNude.dispose();
            transferWayGroup.layout();
        }
    }

    public static void setJtagRate() {
        if (btnJtagRate == null || btnJtagRate.isDisposed()) {
            return;
        }
        ProductLine.PRODUCTLINE productLine = bi.a();
        String jtagSmallBoradModel = FastbootPreferences.getJtagSmallBoradModel();
        String[] jtagRateItems = HISTBUSB2JTAG_VERA_TITLE_ITEMS;
        if (jtagSmallBoradModel.equals(JTAGPreferencePage.getJTAGSMALLMODELTYPELIST()[0][0]) && productLine == ProductLine.PRODUCTLINE.STB) {
            jtagRateItems = HISTBUSB2JTAG_VERB_TITLE_ITEMS;
        }
        if (FastbootView.isHi3716MV420_CA_N_Series()) {
            jtagRateItems = HISTBUSB2JTAG_Hi3716MV420_CA_N_TITLE_ITEMS;
        }
        btnJtagRate.setItems(jtagRateItems);
        btnJtagRate.select(0);
        burnContext.setJtagFrequency(FastbootView.getJtagFrequencyValueByIndex(0));
        btnJtagRate.layout();
    }

    private void updateJtagRateBtn(Group jtagRateGroup) {
        if (FastbootView.isSupportJTag()) {
            if (btnJtagRate == null || btnJtagRate.isDisposed()) {
                Label btnJtagRateLabel = new Label((Composite)jtagRateGroup, 0);
                btnJtagRateLabel.setText(c.FastbootView_Frequency);
                btnJtagRate = new Combo((Composite)jtagRateGroup, 2056);
            }
            FastbootView.setJtagRate();
            btnJtagRate.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    burnContext.setJtagFrequency(FastbootView.getJtagFrequencyValueByIndex(btnJtagRate.getSelectionIndex()));
                }
            });
            btnJtagRate.setLayoutData((Object)new GridData(1));
            jtagRateGroup.layout();
        } else if (this.checkControlVaild((Control)btnJtagRate)) {
            btnJtagRate.dispose();
            jtagRateGroup.layout();
        }
    }

    private static int getJtagFrequencyValueByIndex(int selectRate) {
        ProductLine.PRODUCTLINE productLine = bi.a();
        String jtagSmallBoradModel = FastbootPreferences.getJtagSmallBoradModel();
        int[] jtagRateItemsValue = HISTBUSB2JTAG_VERA_VALUE_ITEMS;
        if (jtagSmallBoradModel.equals(JTAGPreferencePage.getJTAGSMALLMODELTYPELIST()[0][0]) && productLine == ProductLine.PRODUCTLINE.STB) {
            jtagRateItemsValue = HISTBUSB2JTAG_VERB_VALUE_ITEMS;
        }
        if (FastbootView.isHi3716MV420_CA_N_Series()) {
            jtagRateItemsValue = HISTBUSB2JTAG_Hi3716MV420_CA_N_VALUE_ITEMS;
        }
        return jtagRateItemsValue[selectRate];
    }

    private void updateJTAGAndSerial(Group transferWayGroup) {
        boolean isSupportJTAGAndSerial = ((q)burnContext.getDeviceSetting()).r();
        if (isSupportJTAGAndSerial) {
            if (this.btnJtagAndSerial == null || this.btnJtagAndSerial.isDisposed()) {
                this.btnJtagAndSerial = new Button((Composite)transferWayGroup, 16);
            }
            this.btnJtagAndSerial.setText(c.FastbootView_TransferWay_JTAGANDSerial);
            this.btnJtagAndSerial.setToolTipText(c.FastbootView_TransferWay_JTAGKEEPTHEPOWERON);
            this.btnJtagAndSerial.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.JTAGAndSerial);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.btnJtagAndSerial.setLayoutData((Object)new GridData(1));
            transferWayGroup.layout();
            if (this.checkControlVaild((Control)this.serialWay)) {
                this.serialWay.setVisible(true);
            }
            if ((this.checkControlVaild((Control)this.netWay) || this.checkControlVaild((Control)this.netWayNonNude)) && (LibJTAGByJNA.EJtagChipType.hi3796mv200 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3716mv430 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3796cv300 == FastbootView.getJtagChipTypeByChipName())) {
                this.btnJtagAndSerial.setSelection(false);
            }
        } else if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
            this.btnJtagAndSerial.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateJTAGAndNet(Group transferWayGroup) {
        boolean isSupportJTAGAndNet = ((q)burnContext.getDeviceSetting()).s();
        if (isSupportJTAGAndNet) {
            boolean selection;
            if (this.btnJtagAndNet == null || this.btnJtagAndNet.isDisposed()) {
                this.btnJtagAndNet = new Button((Composite)transferWayGroup, 16);
            }
            if (FastbootView.getJtagChipTypeByChipName() == LibJTAGByJNA.EJtagChipType.hi3716mv420b03) {
                this.btnJtagAndNet.setText(c.FastbootView_TransferWay_JTAGMV420B03);
            } else {
                this.btnJtagAndNet.setText(c.FastbootView_TransferWay_JTAGANDNET);
            }
            this.btnJtagAndNet.setToolTipText(c.FastbootView_TransferWay_JTAGKEEPTHEPOWERON);
            this.btnJtagAndNet.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.JTAGAndNet);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.btnJtagAndNet.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
            if (this.btnJtagAndSerial != null && !this.btnJtagAndSerial.isDisposed() && (selection = this.btnJtagAndSerial.getSelection())) {
                this.btnJtagAndSerial.setSelection(false);
            }
            this.btnJtagAndNet.setSelection(true);
            burnContext.setTransferWay(TransferWay.JTAGAndNet);
            if (this.checkControlVaild((Control)this.serialWay)) {
                this.serialWay.setSelection(false);
                if (LibJTAGByJNA.EJtagChipType.hi3716mv420b03 == FastbootView.getJtagChipTypeByChipName() || FastbootView.isHi3231V530Series()) {
                    this.serialWay.setVisible(false);
                } else {
                    this.serialWay.setVisible(true);
                }
            }
            if (this.checkControlVaild((Control)this.netWay) && (LibJTAGByJNA.EJtagChipType.hi3796mv200 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3716mv430 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3796cv300 == FastbootView.getJtagChipTypeByChipName())) {
                this.btnJtagAndNet.setSelection(false);
                this.netWay.setSelection(true);
                burnContext.setTransferWay(TransferWay.Net);
            }
            if (this.checkControlVaild((Control)this.netWayNonNude) && (LibJTAGByJNA.EJtagChipType.hi3796mv200 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3716mv430 == FastbootView.getJtagChipTypeByChipName() || LibJTAGByJNA.EJtagChipType.hi3796cv300 == FastbootView.getJtagChipTypeByChipName())) {
                this.btnJtagAndNet.setSelection(false);
                this.netWayNonNude.setSelection(true);
                burnContext.setTransferWay(TransferWay.NetNonNude);
            }
        } else if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
            this.btnJtagAndNet.dispose();
            transferWayGroup.layout();
        }
    }

    private void updateJTAG(Group transferWayGroup) {
        boolean isSupportJTAG = ((q)burnContext.getDeviceSetting()).t();
        if (isSupportJTAG) {
            if (this.btnJtag == null || this.btnJtag.isDisposed()) {
                this.btnJtag = new Button((Composite)transferWayGroup, 16);
            }
            this.btnJtag.setText(c.FastbootView_TransferWay_JTAG);
            this.btnJtag.setToolTipText(c.FastbootView_TransferWay_JTAGKEEPTHEPOWERON);
            this.btnJtag.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (((Button)event.widget).getSelection()) {
                        burnContext.setTransferWay(TransferWay.JTAG);
                    }
                    FastbootView.this.refreshTransferConfig();
                }
            });
            this.btnJtag.setLayoutData((Object)new GridData(1));
            this.refreshTransferConfig();
            transferWayGroup.layout();
            this.btnJtag.setSelection(true);
            burnContext.setTransferWay(TransferWay.JTAG);
            if (FastbootView.isHi3231V530Series()) {
                this.serialPortCombo.setEnabled(false);
                this.serialWay.setVisible(false);
            } else if (this.checkControlVaild((Control)this.serialWay)) {
                this.serialWay.setSelection(false);
                this.serialWay.setVisible(true);
            }
            if (this.checkControlVaild((Control)this.netWay)) {
                this.btnJtag.setSelection(false);
                this.netWay.setSelection(true);
                burnContext.setTransferWay(TransferWay.Net);
            }
            if (this.checkControlVaild((Control)this.netWayNonNude)) {
                this.btnJtag.setSelection(false);
                this.netWayNonNude.setSelection(true);
                burnContext.setTransferWay(TransferWay.NetNonNude);
            }
        } else if (this.checkControlVaild((Control)this.btnJtag)) {
            this.btnJtag.dispose();
            transferWayGroup.layout();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        long currentTimeMillis = System.currentTimeMillis();
        BundleContext bundleContext = Activator.a().getBundle().getBundleContext();
        ServiceReference sreference = bundleContext.getServiceReference(IDeviceManager.class);
        if (sreference == null) {
            this.deviceChanged(new q("Hi3798CV100"));
            return;
        }
        this.deviceManager = (IDeviceManager)bundleContext.getService(sreference);
        this.deviceManager.addDeviceChangedListener((IDeviceChangedListener)this);
        String currentDevice = this.deviceManager.getCurrentDevice();
        if (currentDevice == null || currentDevice.trim().length() == 0) {
            return;
        }
        this.deviceChanged(this.deviceManager.findChipByName(currentDevice));
        this.getViewSite().getPage().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        if (Platform.inDebugMode()) {
            System.out.println("------init() Time=\t" + (System.currentTimeMillis() - currentTimeMillis) + "ms");
        }
    }

    private void adapt(FormToolkit toolkit, Control control) {
        toolkit.adapt(control, false, false);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n2 = children.length;
            int n3 = 0;
            while (n3 < n2) {
                Control child = controlArray[n3];
                this.adapt(toolkit, child);
                ++n3;
            }
        }
    }

    protected void createBoardGroup(Composite client) {
        this.boardGroup = new Group(client, 0);
        this.boardGroup.setText(c.FastbootView_BoardConfig);
        GridLayout localLayout = new GridLayout(5, false);
        this.boardGroup.setLayout((Layout)localLayout);
        GridData localGD = new GridData(1, 4, false, true);
        this.boardGroup.setLayoutData((Object)localGD);
        Label label = this.toolkit.createLabel((Composite)this.boardGroup, c.FastbootView_IPAddress);
        GridData layoutData = new GridData();
        label.setLayoutData((Object)layoutData);
        this.ipAddressEditor = new IpAddressEditor((Composite)this.boardGroup, 2048);
        GridData griddata = new GridData(1, 1, false, false);
        this.ipAddressEditor.setLayoutData(griddata);
        this.ipAddressEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.updateModelIpAddress(FastbootView.this.ipAddressEditor);
            }
        });
        label = this.toolkit.createLabel((Composite)this.boardGroup, c.FastbootView_SubnetMask);
        layoutData = new GridData(3, 1, true, false);
        layoutData.horizontalIndent = 20;
        label.setLayoutData((Object)layoutData);
        this.subnetMaskEditor = new IpAddressEditor((Composite)this.boardGroup, 2048);
        griddata = new GridData(1, 1, false, false);
        this.subnetMaskEditor.setLayoutData(griddata);
        this.subnetMaskEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.updateModelSubnetMaskAddress(FastbootView.this.subnetMaskEditor);
            }
        });
        Button loadButton = new Button((Composite)this.boardGroup, 8);
        loadButton.setText(c.FastbootView_Load);
        loadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.handLoadCongig();
            }
        });
        griddata = new GridData();
        griddata.widthHint = 70;
        loadButton.setLayoutData((Object)griddata);
        label = this.toolkit.createLabel((Composite)this.boardGroup, c.FastbootView_Gateway);
        layoutData = new GridData();
        label.setLayoutData((Object)layoutData);
        this.gatewayEditor = new IpAddressEditor((Composite)this.boardGroup, 2048);
        griddata = new GridData(1, 1, false, false);
        this.gatewayEditor.setLayoutData(griddata);
        this.gatewayEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.updateModelGatewayAddress(FastbootView.this.gatewayEditor);
            }
        });
        label = this.toolkit.createLabel((Composite)this.boardGroup, c.FastbootView_MacAddress);
        layoutData = new GridData(3, 1, true, false);
        label.setLayoutData((Object)layoutData);
        layoutData.horizontalIndent = 20;
        this.macAddressEditor = new MacAddressEditor((Composite)this.boardGroup, 2048);
        griddata = new GridData();
        this.macAddressEditor.setLayoutData(griddata);
        this.macAddressEditor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.updateModelMacAddress(FastbootView.this.macAddressEditor);
            }
        });
        Button saveButton = new Button((Composite)this.boardGroup, 8);
        saveButton.setText(c.FastbootView_Save);
        saveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.handSaveCongig();
            }
        });
        griddata = new GridData();
        griddata.widthHint = 70;
        saveButton.setLayoutData((Object)griddata);
        this.updateUsb2EtherNet();
    }

    private void updateUsb2EtherNet() {
        if (FastbootView.isHi3796MV200Series()) {
            if (this.usb2EtherNet == null || this.usb2EtherNet.isDisposed()) {
                this.usb2EtherNet = new Button((Composite)this.boardGroup, 32);
                this.usb2EtherNet.setText(c.FastbootView_Usb2EtherNet);
                this.usb2EtherNet.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        FastbootView.this.handUsb2EtherNet(FastbootView.this.usb2EtherNet.getSelection());
                    }
                });
                TFTPService.setUsb2EtherNet((boolean)this.usb2EtherNet.getSelection());
                GridData layoutData = new GridData();
                this.usb2EtherNet.setLayoutData((Object)layoutData);
                this.boardGroup.layout();
            } else {
                this.handUsb2EtherNet(this.usb2EtherNet.getSelection());
            }
        } else if (this.usb2EtherNet != null && !this.usb2EtherNet.isDisposed()) {
            TFTPService.setUsb2EtherNet((boolean)false);
            this.usb2EtherNet.dispose();
            this.boardGroup.layout();
        }
    }

    private void handUsb2EtherNet(boolean selection) {
        if (burnContext == null) {
            return;
        }
        burnContext.setUsbToEthernet(selection);
        TFTPService.setUsb2EtherNet((boolean)selection);
    }

    protected void updateModelMacAddress(MacAddressEditor macText) {
        String displayText = macText.getDisplayText();
        FastbootView.getBurnContext().getBoardConfig().setMac(displayText);
        FastbootPreferences.CONFIG.setClientMac(displayText);
    }

    protected void updateModelGatewayAddress(IpAddressEditor gateway) {
        FastbootView.getBurnContext().getBoardConfig().setGateway(gateway.getDisplayAddress());
        FastbootPreferences.CONFIG.setClientGateway(gateway.getDisplayAddress());
    }

    protected void updateModelSubnetMaskAddress(IpAddressEditor editor) {
        FastbootView.getBurnContext().getBoardConfig().setSubnetMask(editor.getDisplayAddress());
        FastbootPreferences.CONFIG.setClientNetmask(editor.getDisplayAddress());
    }

    protected void updateModelIpAddress(IpAddressEditor editor) {
        FastbootView.getBurnContext().getBoardConfig().setIp(editor.getDisplayAddress());
        FastbootPreferences.CONFIG.setClientIP(editor.getDisplayAddress());
    }

    protected void handLoadCongig() {
        ConfigDialog dialog = new ConfigDialog(Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            BoardConfig boardConfig = dialog.getBoardConfig();
            if (boardConfig == null) {
                return;
            }
            this.macAddressEditor.setText(boardConfig.getMac());
            this.subnetMaskEditor.setAddress(boardConfig.getSubnetMask());
            this.ipAddressEditor.setAddress(boardConfig.getIp());
            this.gatewayEditor.setAddress(boardConfig.getGateway());
            this.updateModelMacAddress(this.macAddressEditor);
            this.updateModelIpAddress(this.ipAddressEditor);
            this.updateModelSubnetMaskAddress(this.subnetMaskEditor);
            this.updateModelGatewayAddress(this.gatewayEditor);
        }
    }

    protected void handSaveCongig() {
        if (burnContext == null) {
            return;
        }
        String string = burnContext.getBoardConfig().toString();
        String wholeCongfig = FastbootPreferences.CONFIG.getClientWholeConfig();
        if (wholeCongfig.contains(string)) {
            return;
        }
        FastbootPreferences.CONFIG.setClientWholeConfig(String.valueOf(wholeCongfig) + ";" + string);
    }

    protected TabFolder createBurnTab(Composite control) {
        TabFolder tabFolder = new TabFolder(control, 0);
        if (burnContext != null) {
            IBurner[] burners;
            IBurnerContext burnerContext = burnContext.getDeviceSetting().getBurnerContext();
            IBurner[] iBurnerArray = burners = burnerContext.getBurners();
            int n2 = burners.length;
            int n3 = 0;
            while (n3 < n2) {
                IBurner iBurner = iBurnerArray[n3];
                if (!(iBurner instanceof BadCheckBurner) || iBurner.getBurnContext().getPlatformType() != PlatformType.CA) {
                    TabItem tabItem = new TabItem(tabFolder, 0);
                    ITab tab = iBurner.getTab();
                    tabItem.setText(tab.getTitle());
                    tab.bindTabItem(tabItem);
                    Composite tabControl = tab.createControl((Composite)tabFolder, 0, iBurner);
                    if (tabControl instanceof AddressComposite) {
                        tabFolder.addSelectionListener((SelectionListener)((AddressComposite)tabControl));
                    }
                    tabItem.setControl((Control)tabControl);
                    if (tabControl instanceof IUIAdapterable) {
                        ((IUIAdapterable)tabControl).setUIAdapter(this.enableAdapter);
                    }
                }
                ++n3;
            }
            if (burners.length > 0) {
                this.currentBurn = burners[0];
            }
        }
        tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FastbootView.this.handleTabSwitched(event);
            }
        });
        tabFolder.setFocus();
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 4;
        tabFolder.setLayoutData((Object)layoutData);
        return tabFolder;
    }

    protected void handleTabSwitched(Event event) {
        IViewPart view;
        TabItem[] selection = this.tabFolder.getSelection();
        BurnComposite control = (BurnComposite)selection[0].getControl();
        this.currentBurn = control.getBurner();
        if (q.b() && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID) != null && (view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(LightView.ID)) != null) {
            LightView lightView = (LightView)view;
            if (this.currentBurn instanceof BoardCheckBurner) {
                lightView.getTftplbl().setVisible(false);
            } else {
                lightView.getTftplbl().setVisible(true);
            }
        }
        this.updateUIEnableAndSelections();
        control.setFocus();
    }

    private void updateUIEnableAndSelections() {
        boolean isSerial;
        boolean bl2 = isSerial = this.isSerialSupportOnly() && (this.uart2Compress == null || this.uart2Compress.isDisposed());
        if (isSerial) {
            this.serialWay.setEnabled(false);
            if (this.checkControlVaild((Control)this.netWay)) {
                this.netWay.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.netWayNonNude)) {
                this.netWayNonNude.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usb2ethWay)) {
                this.usb2ethWay.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.uart2Compress)) {
                this.uart2Compress.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usb2I2c)) {
                this.usb2I2c.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.i2cBootrom)) {
                this.i2cBootrom.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usbBootrom)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                if (this.checkControlVaild((Control)this.netWayNonNude)) {
                    this.netWayNonNude.setEnabled(true);
                }
                this.usbBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbNonNude)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                if (this.checkControlVaild((Control)this.netWayNonNude)) {
                    this.netWayNonNude.setEnabled(true);
                }
                this.usbNonNude.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                if (this.checkControlVaild((Control)this.netWayNonNude)) {
                    this.netWayNonNude.setEnabled(true);
                }
                this.btnJtagAndNet.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                if (this.checkControlVaild((Control)this.netWayNonNude)) {
                    this.netWayNonNude.setEnabled(true);
                }
                this.btnJtagAndSerial.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtag)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                if (this.checkControlVaild((Control)this.netWayNonNude)) {
                    this.netWayNonNude.setEnabled(true);
                }
                this.btnJtag.setEnabled(true);
            }
        } else {
            this.serialWay.setEnabled(true);
            if (this.checkControlVaild((Control)this.netWay)) {
                this.netWay.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.netWayNonNude)) {
                this.netWayNonNude.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usb2ethWay)) {
                this.usb2ethWay.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.uart2Compress)) {
                this.uart2Compress.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usb2I2c)) {
                this.usb2I2c.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.i2cBootrom)) {
                this.i2cBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbBootrom)) {
                this.usbBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbNonNude)) {
                this.usbNonNude.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
                this.btnJtagAndNet.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
                this.btnJtagAndSerial.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtag)) {
                this.btnJtag.setEnabled(true);
            }
            if (this.checkControlVaild((Control)btnJtagRate)) {
                btnJtagRate.setEnabled(true);
            }
        }
        this.refreshBoardConfigEnable();
    }

    private boolean checkControlVaild(Control control) {
        return control != null && !control.isDisposed();
    }

    private IFastbootProgressMonitor getProgressMonitor() {
        IFastbootProgressMonitor progressMonitor = null;
        if (progressMonitor == null) {
            progressMonitor = IFastbootProgressMonitor.NULL;
        }
        return progressMonitor;
    }

    protected Group createLocalGroup(Composite client) {
        Group localGroup = new Group(client, 0);
        localGroup.setText(c.FastbootView_LocalPCConfig);
        GridLayout localLayout = new GridLayout(3, false);
        localGroup.setLayout((Layout)localLayout);
        GridData localGD = new GridData(1, 4, false, true);
        localGD.minimumWidth = 200;
        localGroup.setLayoutData((Object)localGD);
        Label label = this.toolkit.createLabel((Composite)localGroup, c.FastbootView_SerialPort);
        GridData gdData = new GridData();
        gdData.widthHint = 70;
        label.setLayoutData((Object)gdData);
        this.serialPortCombo = new Combo((Composite)localGroup, 2056);
        GridData griddata = new GridData();
        griddata.grabExcessVerticalSpace = false;
        griddata.horizontalAlignment = 1;
        griddata.minimumWidth = 100;
        griddata.horizontalSpan = 2;
        bi.a(griddata, 115, 130);
        this.serialPortCombo.setLayoutData((Object)griddata);
        this.serialPortCombo.setItems(bl.a());
        this.serialPortCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = FastbootView.this.serialPortCombo.getSelectionIndex();
                if (index == -1) {
                    FastbootView.this.serialPortCombo.select(0);
                    index = 0;
                }
                String item = FastbootView.this.serialPortCombo.getItem(index);
                FastbootView.getBurnContext().getLocalConfig().setComPort(item);
                FastbootPreferences.CONFIG.setSerial(item);
                FastbootView.this.getProgressMonitor().infoln("Current Serial port selection: " + item);
            }
        });
        this.toolkit.adapt((Composite)this.serialPortCombo);
        label = this.toolkit.createLabel((Composite)localGroup, c.FastbootView_ServerIP);
        griddata = new GridData();
        griddata.widthHint = 70;
        label.setLayoutData((Object)griddata);
        this.serverIpCombo = new Combo((Composite)localGroup, 8);
        this.serverIpCombo.setItems(bk.a());
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = true;
        griddata.grabExcessVerticalSpace = false;
        griddata.horizontalAlignment = 1;
        griddata.horizontalSpan = 1;
        bi.a(griddata, 115, 130);
        this.serverIpCombo.setLayoutData((Object)griddata);
        this.serverIpCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                List<PCNetworkInfo> pcNetworkInfoList;
                int index = FastbootView.this.serverIpCombo.getSelectionIndex();
                String item = FastbootView.this.serverIpCombo.getItem(index);
                FastbootView.getBurnContext().getLocalConfig().setServerIp(item);
                FastbootPreferences.CONFIG.setServerIP(item);
                String defaultIpAddress = "0.0.0.0";
                String defaultGatewayAddress = "0.0.0.0";
                if (item.lastIndexOf(".") > 0) {
                    defaultIpAddress = String.valueOf(item.substring(0, item.lastIndexOf("."))) + ".0";
                    defaultGatewayAddress = String.valueOf(item.substring(0, item.lastIndexOf("."))) + ".1";
                }
                if ((pcNetworkInfoList = bk.b()) == null || pcNetworkInfoList.size() <= 0) {
                    pcNetworkInfoList = bk.a();
                }
                boolean isEquals = false;
                if (pcNetworkInfoList != null) {
                    int i2 = 0;
                    while (i2 < pcNetworkInfoList.size()) {
                        PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i2);
                        String localIp = pcNetworkInfo.getIp();
                        String localGateway = pcNetworkInfo.getGateway();
                        String subnetMask = pcNetworkInfo.getSubnetMask();
                        if (item.equalsIgnoreCase(localIp)) {
                            isEquals = true;
                            FastbootView.this.ipAddressEditor.setAddress(defaultIpAddress);
                            FastbootView.this.subnetMaskEditor.setAddress(subnetMask);
                            FastbootView.this.gatewayEditor.setAddress(localGateway);
                            FastbootView.getBurnContext().getBoardConfig().setIp(defaultIpAddress);
                            FastbootView.getBurnContext().getBoardConfig().setGateway(localGateway);
                            FastbootView.getBurnContext().getBoardConfig().setSubnetMask(subnetMask);
                            FastbootPreferences.CONFIG.setClientIP(defaultIpAddress);
                            FastbootPreferences.CONFIG.setClientGateway(localGateway);
                            FastbootPreferences.CONFIG.setClientNetmask(subnetMask);
                        }
                        ++i2;
                    }
                }
                if (!isEquals) {
                    FastbootView.this.ipAddressEditor.setAddress(defaultIpAddress);
                    FastbootView.this.gatewayEditor.setAddress(defaultGatewayAddress);
                    FastbootView.getBurnContext().getBoardConfig().setIp(defaultIpAddress);
                    FastbootView.getBurnContext().getBoardConfig().setGateway(defaultGatewayAddress);
                    FastbootPreferences.CONFIG.setClientIP(defaultIpAddress);
                    FastbootPreferences.CONFIG.setClientGateway(defaultGatewayAddress);
                }
            }
        });
        this.toolkit.adapt((Composite)this.serverIpCombo);
        this.reloadButton = this.toolkit.createButton((Composite)localGroup, c.FastbootView_Reload, 8);
        this.reloadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (FastbootView.this.serverIpCombo != null && !FastbootView.this.serverIpCombo.isDisposed() && FastbootView.this.serverIpCombo.isEnabled()) {
                    FastbootView.this.handleReloadServerIP();
                }
                if (FastbootView.this.serialPortCombo != null && !FastbootView.this.serialPortCombo.isDisposed()) {
                    int lastSelectIndex = FastbootView.this.serialPortCombo.getSelectionIndex();
                    FastbootView.this.serialPortCombo.setItems(bl.a());
                    if (lastSelectIndex < 0 || lastSelectIndex >= FastbootView.this.serialPortCombo.getItemCount()) {
                        lastSelectIndex = 0;
                    }
                    FastbootView.this.serialPortCombo.select(lastSelectIndex);
                    String item = FastbootView.this.serialPortCombo.getItem(lastSelectIndex);
                    FastbootView.getBurnContext().getLocalConfig().setComPort(item);
                    FastbootPreferences.CONFIG.setSerial(item);
                    FastbootView.this.getProgressMonitor().infoln("Current Serial port selection: " + item);
                }
            }
        });
        griddata = new GridData();
        griddata.widthHint = 70;
        this.reloadButton.setLayoutData((Object)griddata);
        return localGroup;
    }

    protected void handleReloadServerIP() {
        String[] serverIps = bk.a();
        this.serverIpCombo.setItems(serverIps);
        if (serverIps.length > 0) {
            this.serverIpCombo.select(0);
            FastbootView.getBurnContext().getLocalConfig().setServerIp(serverIps[0]);
            FastbootPreferences.CONFIG.setServerIP(serverIps[0]);
        }
    }

    private void enableTransferWaySelection() {
        if (this.serialWay == null || this.serialWay.isDisposed()) {
            return;
        }
        this.updateUIEnableAndSelections();
    }

    private void enableBoardConfig(boolean enabled) {
        TransferWay transferWay;
        if (this.macAddressEditor == null || this.macAddressEditor.isDisposed()) {
            return;
        }
        this.macAddressEditor.setEnabled(enabled);
        this.ipAddressEditor.setEnabled(enabled);
        this.subnetMaskEditor.setEnabled(enabled);
        this.gatewayEditor.setEnabled(enabled);
        this.serverIpCombo.setEnabled(enabled);
        if (this.usb2EtherNet != null && !this.usb2EtherNet.isDisposed()) {
            this.usb2EtherNet.setEnabled(enabled);
        }
        if (!(FastbootView.isSupportJTAGSerial() || (transferWay = FastbootView.getBurnContext().getTransferWay()) != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet)) {
            this.serialPortCombo.setEnabled(false);
        }
    }

    public static BurnContext getBurnContext() {
        return burnContext;
    }

    private void refreshAll() {
        if (burnContext != null) {
            if (this.netWay != null && !this.netWay.isDisposed()) {
                this.netWay.setSelection(burnContext.getTransferWay() == TransferWay.Net);
            }
            this.serialWay.setSelection(burnContext.getTransferWay() == TransferWay.Serial);
            if (this.usb2ethWay != null && !this.usb2ethWay.isDisposed()) {
                this.usb2ethWay.setSelection(burnContext.getTransferWay() == TransferWay.UsbTransNet);
            }
        }
        this.refreshLocalConfig();
        this.refreshTransferConfig();
        this.refreshBoardConfig();
    }

    private void refreshTransferConfig() {
        if (!this.serialPortCombo.isDisposed() && !FastbootView.isHi3231V530Series()) {
            this.serialPortCombo.setEnabled(!(this.usbBootrom != null && !this.usbBootrom.isDisposed() && this.usbBootrom.getSelection() || this.usbNonNude != null && !this.usbNonNude.isDisposed() && this.usbNonNude.getSelection()));
        }
        if (burnContext == null) {
            return;
        }
        this.refreshBoardConfigEnable();
    }

    private boolean isSerialSupportOnly() {
        return this.currentBurn instanceof IBootBurner && !(this.currentBurn instanceof IAddressBurner) || this.currentBurn instanceof IChecker || this.currentBurn instanceof ICheckerBoard || this.currentBurn instanceof IMergeBurner;
    }

    private void refreshBoardConfigEnable() {
        boolean enabled = !this.isSerialSupportOnly();
        TransferWay transferWay = FastbootView.getBurnContext().getTransferWay();
        boolean needSetupNetWork = transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet;
        this.enableBoardConfig(enabled && needSetupNetWork);
    }

    private void refreshBoardConfig() {
        if (burnContext == null) {
            return;
        }
        BoardConfig boardConfig = burnContext.getBoardConfig();
        if (boardConfig == null) {
            return;
        }
        if (this.macAddressEditor != null && !this.macAddressEditor.isDisposed()) {
            String mac = boardConfig.getMac();
            this.macAddressEditor.setText(mac == null ? "" : mac);
        }
        if (this.ipAddressEditor != null && !this.ipAddressEditor.isDisposed()) {
            this.ipAddressEditor.setAddress(boardConfig.getIp());
        }
        if (this.subnetMaskEditor != null && !this.subnetMaskEditor.isDisposed()) {
            this.subnetMaskEditor.setAddress(boardConfig.getSubnetMask());
        }
        if (this.gatewayEditor != null && !this.gatewayEditor.isDisposed()) {
            this.gatewayEditor.setAddress(boardConfig.getGateway());
        }
    }

    private void refreshLocalConfig() {
        int index;
        if (burnContext == null) {
            return;
        }
        LocalConfig localConfig = burnContext.getLocalConfig();
        if (localConfig == null) {
            return;
        }
        if (this.serialPortCombo != null && !this.serialPortCombo.isDisposed()) {
            String serialPort = localConfig.getComPort();
            if (serialPort == null || serialPort.trim().length() == 0) {
                if (this.serialPortCombo.getItemCount() > 0) {
                    this.serialPortCombo.select(0);
                    localConfig.setComPort(this.serialPortCombo.getText());
                }
            } else {
                index = this.serialPortCombo.indexOf(serialPort);
                if (index > -1 && this.serialPortCombo.getItemCount() > index) {
                    this.serialPortCombo.select(index);
                }
            }
        }
        if (this.serverIpCombo != null && !this.serverIpCombo.isDisposed()) {
            String serverIp = localConfig.getServerIp();
            if (serverIp != null) {
                index = this.serverIpCombo.indexOf(serverIp);
                if (index > -1 && index < this.serverIpCombo.getItemCount()) {
                    this.serverIpCombo.select(index);
                    FastbootPreferences.CONFIG.setServerIP(serverIp);
                }
            } else if (this.serverIpCombo.getItemCount() > 0) {
                this.serverIpCombo.select(0);
                localConfig.setServerIp(this.serverIpCombo.getItem(0));
            }
        }
    }

    public void setFocus() {
        this.control.setFocus();
    }

    public int handleSave(boolean canCancel) {
        int promptToSave = 3;
        HashSet<ISaveable> saveables = Activator.a().a();
        for (ISaveable iSaveable : saveables) {
            promptToSave = iSaveable.promptToSave(canCancel);
            if (promptToSave != 2) continue;
            return 2;
        }
        this.firePropertyChange(257);
        return promptToSave;
    }

    public void dispose() {
        boolean isJtag;
        TransferWay transferWay;
        IWorkbenchWindow workbenchWindow;
        if (this.deviceManager != null) {
            this.deviceManager.removeDeviceChangedListener((IDeviceChangedListener)this);
        }
        if ((workbenchWindow = this.getViewSite().getPage().getWorkbenchWindow()) != null) {
            workbenchWindow.removePerspectiveListener((IPerspectiveListener)this);
            workbenchWindow.getShell().removeControlListener((ControlListener)this);
        }
        boolean isI2C = (transferWay = FastbootView.getBurnContext().getTransferWay()) == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        boolean bl2 = isJtag = transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial;
        if (isI2C) {
            I2cCommand.I2cCloseChannel();
        } else if (isUsb) {
            CallLibUSBWorker.closeUsb();
        } else if (isJtag) {
            CallLibJTAGWorker.releaseJtag();
        }
        HiToolStatistics.INSTANCE.logToolFinish("HiBurn");
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public int promptToSaveOnClose() {
        FastbootEvent event = Activator.a().a();
        if (event != null) {
            return 2;
        }
        return 3;
    }

    @Override
    public void deviceChanged(IDeviceSetting device) {
        if (device == this.deviceSetting) {
            return;
        }
        IPreferenceStore store = FastbootPreferences.getPreferenceStore();
        store.setValue("hisilicon.fastboot.jtag.small.borad.model", JTAGPreferencePage.getJtagSmallModelTypeList()[0][0]);
        this.handleSave(false);
        HiBurnState.INSTANCE.promptToSave(false);
        boolean inDebugMode = Platform.inDebugMode();
        if (inDebugMode) {
            System.out.println("==============" + FastbootView.class.getSimpleName() + ".deviceChanged(IDeviceSetting)============");
            System.out.println(device.getName());
        }
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            Control[] tabList = this.tabFolder.getTabList();
            int i2 = 0;
            while (i2 < tabList.length) {
                tabList[i2].dispose();
                ++i2;
            }
            this.tabFolder.dispose();
        }
        this.deviceSetting = device;
        if (device == null) {
            return;
        }
        FastbootView.setBurnContext(this.deviceSetting.getBurnContext());
        if (this.control == null) {
            return;
        }
        this.tabFolder = this.createBurnTab(this.control);
        this.control.layout();
        this.control.getParent().layout();
        if (this.devices != null) {
            this.devices.setText(this.deviceSetting.getName());
        }
        if (burnContext != null) {
            if (this.netWay != null && !this.netWay.isDisposed()) {
                this.netWay.setSelection(burnContext.getTransferWay() == TransferWay.Net);
            }
            this.serialWay.setSelection(burnContext.getTransferWay() == TransferWay.Serial);
            this.updateNetBtn(this.transferWayGroup);
            this.updateNetWayNonNude(this.transferWayGroup);
            this.updateUsb2ethBtn(this.transferWayGroup);
            this.updateUart2Compress(this.transferWayGroup);
            this.updateI2cBootrom(this.transferWayGroup);
            this.updateUsb2I2c(this.transferWayGroup);
            this.updateUsbBootrom(this.transferWayGroup);
            this.updateUsbNonNude(this.transferWayGroup);
            this.updateJTAG(this.transferWayGroup);
            this.updateJTAGAndSerial(this.transferWayGroup);
            this.updateJTAGAndNet(this.transferWayGroup);
            if (!(FastbootView.isHi3231V530Series() || this.checkControlVaild((Control)this.btnJtagAndNet) && this.checkControlVaild((Control)this.btnJtagAndSerial) || !this.checkControlVaild((Control)this.serialWay))) {
                this.serialWay.setVisible(true);
            }
            if (this.checkControlVaild((Control)this.usb2ethWay)) {
                this.usb2ethWay.setSelection(burnContext.getTransferWay() == TransferWay.UsbTransNet);
            } else if (this.checkControlVaild((Control)this.usbBootrom)) {
                this.usbBootrom.setSelection(burnContext.getTransferWay() == TransferWay.USBBootrom);
            } else if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
                this.btnJtagAndNet.setSelection(burnContext.getTransferWay() == TransferWay.JTAGAndNet);
            } else if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
                this.btnJtagAndSerial.setSelection(burnContext.getTransferWay() == TransferWay.JTAGAndSerial);
            } else if (this.checkControlVaild((Control)this.btnJtag)) {
                this.btnJtag.setSelection(burnContext.getTransferWay() == TransferWay.JTAG);
            } else if (this.checkControlVaild((Control)this.serialWay)) {
                this.serialWay.setSelection(burnContext.getTransferWay() == TransferWay.Serial);
            } else {
                burnContext.setTransferWay(TransferWay.Net);
                if (this.netWay != null && !this.netWay.isDisposed()) {
                    this.netWay.setSelection(burnContext.getTransferWay() == TransferWay.Net);
                }
            }
            this.section.setExpanded(true);
        } else if (this.usb2ethWay != null) {
            this.usb2ethWay.setVisible(false);
        }
        this.updateUIStateForDeviceChanged();
    }

    private void updateUIJtagDeviceChanged() {
        if (FastbootView.isSupportJTag()) {
            if (this.JtagRateGroup == null || this.JtagRateGroup.isDisposed()) {
                this.JtagRateGroup = this.createJtagRateGroup(this.client);
                this.client.layout();
            } else {
                this.JtagRateGroup.dispose();
                this.JtagRateGroup = this.createJtagRateGroup(this.client);
                this.client.layout();
            }
        } else if (this.JtagRateGroup != null && !this.JtagRateGroup.isDisposed()) {
            this.JtagRateGroup.dispose();
            this.client.layout();
        }
        this.updateUsb2EtherNet();
    }

    private void updateUIStateForDeviceChanged() {
        boolean isUart2Compress;
        boolean gateWay;
        this.updateUIJtagDeviceChanged();
        boolean bl2 = gateWay = this.gatewayEditor == null || this.gatewayEditor.isDisposed();
        if (gateWay) {
            return;
        }
        boolean bl3 = isUart2Compress = this.isSerialSupportOnly() && (this.uart2Compress == null || this.uart2Compress.isDisposed());
        if (isUart2Compress) {
            this.serialWay.setEnabled(false);
            if (this.checkControlVaild((Control)this.netWay)) {
                this.netWay.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.netWayNonNude)) {
                this.netWayNonNude.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usb2ethWay)) {
                this.usb2ethWay.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.uart2Compress)) {
                this.uart2Compress.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usb2I2c)) {
                this.usb2I2c.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.i2cBootrom)) {
                this.i2cBootrom.setEnabled(false);
            }
            if (this.checkControlVaild((Control)this.usbBootrom)) {
                boolean isNetWay;
                this.serialWay.setEnabled(true);
                boolean bl4 = isNetWay = this.netWay != null && !this.netWay.isDisposed();
                if (isNetWay) {
                    this.netWay.setEnabled(true);
                }
                this.usbBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbNonNude)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                this.usbNonNude.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                this.btnJtagAndNet.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                this.btnJtagAndSerial.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtag)) {
                this.serialWay.setEnabled(true);
                if (this.checkControlVaild((Control)this.netWay)) {
                    this.netWay.setEnabled(true);
                }
                this.btnJtag.setEnabled(true);
                btnJtagRate.setEnabled(true);
            }
        } else {
            if (this.checkControlVaild((Control)this.netWay)) {
                this.netWay.setEnabled(true);
            }
            this.serialWay.setEnabled(true);
            if (this.checkControlVaild((Control)this.usb2ethWay)) {
                this.usb2ethWay.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.uart2Compress)) {
                this.uart2Compress.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usb2I2c)) {
                this.usb2I2c.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.i2cBootrom)) {
                this.i2cBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbBootrom)) {
                this.usbBootrom.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.usbNonNude)) {
                this.usbNonNude.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndNet)) {
                this.btnJtagAndNet.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtagAndSerial)) {
                this.btnJtagAndSerial.setEnabled(true);
            }
            if (this.checkControlVaild((Control)this.btnJtag)) {
                this.btnJtag.setEnabled(true);
            }
            if (this.checkControlVaild((Control)btnJtagRate)) {
                btnJtagRate.setEnabled(true);
            }
        }
        this.refreshBoardConfigEnable();
        TransferWay transferWay = burnContext.getTransferWay();
        this.serialWay.setSelection(transferWay == TransferWay.Serial);
        if (this.checkControlVaild((Control)this.uart2Compress)) {
            this.serialWay.setSelection(true);
            burnContext.setTransferWay(TransferWay.Serial);
        }
        if (this.checkControlVaild((Control)this.netWay)) {
            this.netWay.setSelection(transferWay == TransferWay.Net);
        }
        if (this.checkControlVaild((Control)this.usb2ethWay)) {
            this.usb2ethWay.setSelection(transferWay == TransferWay.UsbTransNet);
        }
        LocalConfig localConfig = burnContext.getLocalConfig();
        localConfig.setComPort(this.serialPortCombo.getText());
        localConfig.setServerIp(this.serverIpCombo.getText());
        BoardConfig boardConfig = burnContext.getBoardConfig();
        boardConfig.setIp(this.ipAddressEditor.getDisplayAddress());
        boardConfig.setMac(this.macAddressEditor.getDisplayText());
        boardConfig.setSubnetMask(this.subnetMaskEditor.getDisplayAddress());
        boardConfig.setGateway(this.gatewayEditor.getDisplayAddress());
    }

    public void deviceChanged(String deviceName) {
        if (Platform.inDebugMode()) {
            System.out.println("==============" + FastbootView.class.getSimpleName() + ".deviceChanged(" + deviceName + ")==============");
        }
        if (deviceName == null || deviceName.trim().length() == 0) {
            return;
        }
        q ud = new q(deviceName);
        if (!ud.a()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)c.FASTBOOT_ERROR_Title, (String)c.FastbootView_Unsupported_Device);
        }
        q.a(deviceName);
        if (q.b()) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = iWorkbench.getActiveWorkbenchWindow();
            FastbootView.showConsole(window);
        } else {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = iWorkbench.getActiveWorkbenchWindow();
            FastbootView.hideConsole(window);
        }
        this.deviceChanged(ud);
    }

    public static void hideConsole(IWorkbenchWindow window) {
        IWorkbenchPage page;
        if (window == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            window = workbench.getActiveWorkbenchWindow();
        }
        if (window != null && (page = window.getActivePage()) != null) {
            final IViewPart console = page.findView("com.hisilicon.fastboot.views.LightView");
            window.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    page.hideView(console);
                }
            });
        }
    }

    public static void showConsole(IWorkbenchWindow window) {
        IPerspectiveDescriptor perspective;
        boolean isNeedShow;
        IWorkbenchPage page;
        if (window == null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            window = workbench.getActiveWorkbenchWindow();
        }
        if (window != null && (page = window.getActivePage()) != null && (isNeedShow = (perspective = page.getPerspective()).getId().equals(FastbootPerspective.FASTBOOT_PERSPECTIVE_ID))) {
            window.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        page.showView(LightView.ID);
                    }
                    catch (PartInitException e2) {
                        e2.printStackTrace();
                    }
                }
            });
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (FastbootPerspective.class.getName().equals(perspective.getId())) {
            String currentDevice;
            FastbootConsoleFactory.displayConsole();
            if (this.deviceManager == null || this.control == null) {
                return;
            }
            if (Platform.inDebugMode()) {
                System.out.println("=============" + FastbootView.class.getSimpleName() + ".perspectiveActivated()" + "=============");
            }
            if (this.currentChip.equals(currentDevice = this.deviceManager.getCurrentDevice())) {
                return;
            }
            this.currentChip = currentDevice;
            this.deviceChanged(this.deviceManager.findChipByName(this.currentChip));
        }
    }

    public void deviceChanged(Chip chip) {
        boolean inDebugMode = Platform.inDebugMode();
        if (inDebugMode) {
            System.out.println("==========" + FastbootView.class.getSimpleName() + ".deviceChanged(Chip)==============");
        }
        if (chip == null) {
            return;
        }
        if (inDebugMode) {
            System.out.println("currentChip =" + this.currentChip + "\tnewChip=" + chip.getName());
        }
        if (this.currentChip != null && this.currentChip.equals(chip.getName())) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        try {
            this.currentChip = chip.getName();
            if (Platform.inDevelopmentMode()) {
                this.deviceChanged(chip.getName());
            } else {
                ArrayList toolList = chip.getToolList();
                for (Tool tool : toolList) {
                    List containingPlugin = tool.getContainingPlugin();
                    if (inDebugMode) {
                        System.out.println("tool id=" + tool.getId() + "\tcontainingPlugin=\t" + containingPlugin + "\t current time =\t" + (System.currentTimeMillis() - currentTimeMillis) + "ms");
                    }
                    if (containingPlugin == null) continue;
                    for (String string : containingPlugin) {
                        String[] split;
                        if (!string.equals(Activator.a().getBundle().getSymbolicName())) continue;
                        String param = tool.getParam();
                        if (inDebugMode) {
                            System.out.println("Param\t=\t'" + param + "'");
                        }
                        if (param == null) {
                            this.deviceChanged(chip.getName());
                            return;
                        }
                        String[] stringArray = split = param.split(",");
                        int n2 = split.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String p2 = stringArray[n3];
                            String[] keyvalue = p2.split("=");
                            if (inDebugMode) {
                                System.out.println("Param\t=\t'" + p2 + "'\t" + "keyValues=\t'" + Arrays.asList(keyvalue) + "'");
                            }
                            if (keyvalue.length == 2 && "type".equalsIgnoreCase(keyvalue[0].trim())) {
                                this.deviceChanged(keyvalue[1]);
                                return;
                            }
                            ++n3;
                        }
                        this.deviceChanged(chip.getName());
                        return;
                    }
                }
            }
        }
        finally {
            if (Platform.inDebugMode()) {
                System.out.println("---HiBurn---deviceChanged(Chip) Time=\t" + (System.currentTimeMillis() - currentTimeMillis) + "ms");
            }
        }
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (perspective.getId().equals(FastbootPerspective.class.getName())) {
            HiBurnState.INSTANCE.promptToSave(false);
        }
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (perspective.getId().equals(FastbootPerspective.class.getName())) {
            this.handleSave(false);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void expansionStateChanging(ExpansionEvent e2) {
    }

    public void expansionStateChanged(ExpansionEvent e2) {
        this.refreshScollBar(true, e2.getState());
    }

    public void controlMoved(ControlEvent e2) {
    }

    public void controlResized(ControlEvent e2) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FastbootView.this.refreshScollBar();
            }
        });
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public static boolean isHi3251Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3251V500") || chipName.equalsIgnoreCase("Hi3251V510");
    }

    public static boolean isHi3731Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.startsWith("Hi3731");
    }

    public static boolean isNeedDownLoadSBLSeries() {
        boolean supportSBLChip;
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        boolean bl2 = supportSBLChip = chipName.equalsIgnoreCase("Hi3798MV200") || chipName.equalsIgnoreCase("Hi3798CV200") || chipName.equalsIgnoreCase("Hi3798MV200H") || chipName.equalsIgnoreCase("Hi3798MV300") || chipName.equalsIgnoreCase("Hi3798MV300H") || chipName.equalsIgnoreCase("Hi3798MV310") || chipName.equalsIgnoreCase("Hi3716DV110") || chipName.equalsIgnoreCase("Hi3716DV110H");
        return supportSBLChip;
    }

    public static LibJTAGByJNA.EJtagChipType getJtagChipTypeByChipName() {
        String chipName = bi.b();
        if (chipName == null) {
            return LibJTAGByJNA.EJtagChipType.hi3796mv200;
        }
        boolean is420b03 = chipName.equalsIgnoreCase("Hi3716MV410_CA_N") || chipName.equalsIgnoreCase("Hi3716MV420_CA_N");
        boolean is430 = chipName.equalsIgnoreCase("Hi3716MV430");
        boolean is520 = chipName.equalsIgnoreCase("Hi3231V520");
        boolean is530 = chipName.equalsIgnoreCase("Hi3231V530");
        boolean is300 = chipName.equalsIgnoreCase("Hi3796CV300");
        if (is420b03) {
            return LibJTAGByJNA.EJtagChipType.hi3716mv420b03;
        }
        if (is430) {
            return LibJTAGByJNA.EJtagChipType.hi3716mv430;
        }
        if (is520) {
            return LibJTAGByJNA.EJtagChipType.hi3231V520;
        }
        if (is530) {
            return LibJTAGByJNA.EJtagChipType.hi3231V530;
        }
        if (is300) {
            return LibJTAGByJNA.EJtagChipType.hi3796cv300;
        }
        return LibJTAGByJNA.EJtagChipType.hi3796mv200;
    }

    public static boolean isHi3518EV300Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3518EV300");
    }

    public static boolean isHi3231V530Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3231V530");
    }

    public static boolean isHi3796MV200Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3796MV200") || chipName.equalsIgnoreCase("Hi3716MV450") || chipName.equalsIgnoreCase("Hi3796AV200") || chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3796CV300");
    }

    public static boolean isHi3716MV420_CA_N_Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV420_CA_N");
    }

    public static boolean isHi3716MV430_CA_N_Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3796CV300");
    }

    public static boolean isSupportJTAGSerial() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV420_CA_N") || chipName.equalsIgnoreCase("Hi3716MV410_CA_N") || chipName.equalsIgnoreCase("Hi3231V530");
    }

    public static boolean isHi3716MV410_CA_N_Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV410_CA_N") || chipName.equalsIgnoreCase("Hi3716MV420_CA_N") || chipName.equalsIgnoreCase("Hi3796MV200") || chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3796CV300");
    }

    public static boolean isSupportJTag() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV410_CA_N") || chipName.equalsIgnoreCase("Hi3716MV420_CA_N") || chipName.equalsIgnoreCase("Hi3796MV200") || chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3796CV300") || chipName.equalsIgnoreCase("Hi3796AV200") || chipName.equalsIgnoreCase("Hi3716MV450") || chipName.equalsIgnoreCase("Hi3231V520") || chipName.equalsIgnoreCase("Hi3231V530");
    }

    public static boolean isJTagTransferMode() {
        TransferWay transferWay = FastbootView.getBurnContext().getTransferWay();
        return transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial;
    }

    public static boolean isHi3231Series() {
        String chipName = bi.b();
        if (chipName == null) {
            return false;
        }
        return chipName.startsWith("Hi3231");
    }

    public static boolean isSupportUfsSeries() {
        return ((q)burnContext.getDeviceSetting()).v();
    }

    public static void setBurnContext(BurnContext burnContext) {
        FastbootView.burnContext = burnContext;
    }
}

