/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.textcanvas;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class StyleMap {
    private static final String BLACK = "black";
    private static final String WHITE = "white";
    private static final String WHITE_FOREGROUND = "white_foreground";
    private static final String GRAY = "gray";
    private static final String MAGENTA = "magenta";
    private static final String CYAN = "cyan";
    private static final String YELLOW = "yellow";
    private static final String BLUE = "blue";
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String PREFIX = "org.eclipse.tm.internal.";
    private static final String fDefaultFontName = "terminal.views.view.font.definition";
    String fFontName = "terminal.views.view.font.definition";
    Map fColorMapForeground = new HashMap();
    Map fColorMapBackground = new HashMap();
    Map fColorMapIntense = new HashMap();
    Map fFontMap = new HashMap();
    private Point fCharSize;
    private final Style fDefaultStyle;
    private boolean fInvertColors;
    private boolean fProportional;
    private final int[] fOffsets = new int[256];

    StyleMap() {
        this.initColors();
        this.fDefaultStyle = Style.getStyle((StyleColor)StyleColor.getStyleColor((String)BLACK), (StyleColor)StyleColor.getStyleColor((String)WHITE));
        this.updateFont();
    }

    private void initColors() {
        this.initForegroundColors();
        this.initBackgroundColors();
        this.initIntenseColors();
    }

    private void initForegroundColors() {
        if (this.fInvertColors) {
            this.setColor(this.fColorMapForeground, WHITE, 0, 0, 0);
            this.setColor(this.fColorMapForeground, WHITE_FOREGROUND, 50, 50, 50);
            this.setColor(this.fColorMapForeground, BLACK, 229, 229, 229);
        } else {
            this.setColor(this.fColorMapForeground, WHITE, 255, 255, 255);
            this.setColor(this.fColorMapForeground, WHITE_FOREGROUND, 229, 229, 229);
            this.setColor(this.fColorMapForeground, BLACK, 50, 50, 50);
        }
        this.setColor(this.fColorMapForeground, RED, 205, 0, 0);
        this.setColor(this.fColorMapForeground, GREEN, 0, 205, 0);
        this.setColor(this.fColorMapForeground, BLUE, 0, 0, 238);
        this.setColor(this.fColorMapForeground, YELLOW, 205, 205, 0);
        this.setColor(this.fColorMapForeground, CYAN, 0, 205, 205);
        this.setColor(this.fColorMapForeground, MAGENTA, 205, 0, 205);
        this.setColor(this.fColorMapForeground, GRAY, 229, 229, 229);
    }

    private void initBackgroundColors() {
        if (this.fInvertColors) {
            this.setColor(this.fColorMapBackground, WHITE, 0, 0, 0);
            this.setColor(this.fColorMapBackground, WHITE_FOREGROUND, 50, 50, 50);
            this.setColor(this.fColorMapBackground, BLACK, 255, 255, 255);
        } else {
            this.setColor(this.fColorMapBackground, WHITE, 255, 255, 255);
            this.setColor(this.fColorMapBackground, WHITE_FOREGROUND, 229, 229, 229);
            this.setColor(this.fColorMapBackground, BLACK, 0, 0, 0);
        }
        this.setColor(this.fColorMapBackground, RED, 205, 0, 0);
        this.setColor(this.fColorMapBackground, GREEN, 0, 205, 0);
        this.setColor(this.fColorMapBackground, BLUE, 0, 0, 238);
        this.setColor(this.fColorMapBackground, YELLOW, 205, 205, 0);
        this.setColor(this.fColorMapBackground, CYAN, 0, 205, 205);
        this.setColor(this.fColorMapBackground, MAGENTA, 205, 0, 205);
        this.setColor(this.fColorMapBackground, GRAY, 229, 229, 229);
    }

    private void initIntenseColors() {
        if (this.fInvertColors) {
            this.setColor(this.fColorMapIntense, WHITE, 127, 127, 127);
            this.setColor(this.fColorMapIntense, WHITE_FOREGROUND, 0, 0, 0);
            this.setColor(this.fColorMapIntense, BLACK, 255, 255, 255);
        } else {
            this.setColor(this.fColorMapIntense, WHITE, 255, 255, 255);
            this.setColor(this.fColorMapIntense, WHITE_FOREGROUND, 255, 255, 255);
            this.setColor(this.fColorMapIntense, BLACK, 0, 0, 0);
        }
        this.setColor(this.fColorMapIntense, RED, 255, 0, 0);
        this.setColor(this.fColorMapIntense, GREEN, 0, 255, 0);
        this.setColor(this.fColorMapIntense, BLUE, 92, 92, 255);
        this.setColor(this.fColorMapIntense, YELLOW, 255, 255, 0);
        this.setColor(this.fColorMapIntense, CYAN, 0, 255, 255);
        this.setColor(this.fColorMapIntense, MAGENTA, 255, 0, 255);
        this.setColor(this.fColorMapIntense, GRAY, 255, 255, 255);
    }

    private void setColor(Map colorMap, String name, int r, int g, int b) {
        String colorName = PREFIX + r + "-" + g + "-" + b;
        Color color = JFaceResources.getColorRegistry().get(colorName);
        if (color == null) {
            JFaceResources.getColorRegistry().put(colorName, new RGB(r, g, b));
            color = JFaceResources.getColorRegistry().get(colorName);
        }
        colorMap.put(StyleColor.getStyleColor((String)name), color);
        colorMap.put(StyleColor.getStyleColor((String)name.toUpperCase()), color);
    }

    public Color getForegrondColor(Style style) {
        Map map;
        Map map2 = map = (style = this.defaultIfNull(style)).isBold() ? this.fColorMapIntense : this.fColorMapForeground;
        if (style.isReverse()) {
            return this.getColor(map, style.getBackground());
        }
        return this.getColor(map, style.getForground());
    }

    public Color getBackgroundColor(Style style) {
        if ((style = this.defaultIfNull(style)).isReverse()) {
            return this.getColor(this.fColorMapBackground, style.getForground());
        }
        return this.getColor(this.fColorMapBackground, style.getBackground());
    }

    Color getColor(Map map, StyleColor color) {
        Color c = (Color)map.get(color);
        if (c == null) {
            c = Display.getCurrent().getSystemColor(15);
        }
        return c;
    }

    private Style defaultIfNull(Style style) {
        if (style == null) {
            style = this.fDefaultStyle;
        }
        return style;
    }

    public void setInvertedColors(boolean invert) {
        if (invert == this.fInvertColors) {
            return;
        }
        this.fInvertColors = invert;
        this.initColors();
    }

    public Font getFont(Style style) {
        if ((style = this.defaultIfNull(style)).isBold()) {
            return JFaceResources.getFontRegistry().getBold(this.fFontName);
        }
        if (style.isUnderline()) {
            return JFaceResources.getFontRegistry().getItalic(this.fFontName);
        }
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public Font getFont() {
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public int getFontWidth() {
        return this.fCharSize.x;
    }

    public int getFontHeight() {
        return this.fCharSize.y;
    }

    public void updateFont() {
        Display display = Display.getCurrent();
        GC gc = new GC((Drawable)display);
        this.fFontName = JFaceResources.getFontRegistry().hasValueFor(fDefaultFontName) ? fDefaultFontName : (JFaceResources.getFontRegistry().hasValueFor("REMOTE_COMMANDS_VIEW_FONT") ? "REMOTE_COMMANDS_VIEW_FONT" : "org.eclipse.jface.textfont");
        gc.setFont(this.getFont());
        this.fCharSize = gc.textExtent("W");
        this.fProportional = false;
        char c = ' ';
        while (c <= '~') {
            if (this.measureChar(gc, c, true)) {
                this.fProportional = true;
            }
            c = (char)(c + '\u0001');
        }
        c = '\u00a0';
        while (c <= '\u00fe') {
            this.measureChar(gc, c, false);
            c = (char)(c + '\u0001');
        }
        if (this.fProportional) {
            this.fCharSize.x -= 2;
        }
        int i = 0;
        while (i < this.fOffsets.length) {
            this.fOffsets[i] = (this.fCharSize.x - this.fOffsets[i]) / 2;
            ++i;
        }
        if (!this.fProportional) {
            gc.setFont(this.getFont(this.fDefaultStyle.setBold(true)));
            Point charSizeBold = gc.textExtent("W");
            if (this.fCharSize.x != charSizeBold.x) {
                this.fProportional = true;
            }
        }
        gc.dispose();
    }

    private boolean measureChar(GC gc, char c, boolean updateMax) {
        boolean proportional = false;
        Point ext = gc.textExtent(String.valueOf(c));
        if (ext.x > 0 && ext.y > 0 && (this.fCharSize.x != ext.x || this.fCharSize.y != ext.y)) {
            proportional = true;
            if (updateMax) {
                this.fCharSize.x = Math.max(this.fCharSize.x, ext.x);
                this.fCharSize.y = Math.max(this.fCharSize.y, ext.y);
            }
        }
        this.fOffsets[c] = ext.x;
        return proportional;
    }

    public boolean isFontProportional() {
        return this.fProportional;
    }

    public int getCharOffset(char c) {
        if (c >= this.fOffsets.length) {
            return 0;
        }
        return this.fOffsets[c];
    }
}

