/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.view;

import com.hisilicon.terminal.actions.TerminalAction;
import com.hisilicon.terminal.actions.TerminalActionConnect;
import com.hisilicon.terminal.actions.TerminalActionDisconnect;
import com.hisilicon.terminal.actions.TerminalActionNewTerminal;
import com.hisilicon.terminal.actions.TerminalActionRemove;
import com.hisilicon.terminal.actions.TerminalActionScrollLock;
import com.hisilicon.terminal.actions.TerminalActionSelectionDropDown;
import com.hisilicon.terminal.actions.TerminalActionSettings;
import com.hisilicon.terminal.actions.TerminalActionToggleCommandInputField;
import com.hisilicon.terminal.actions.TerminalControlLogAction;
import com.hisilicon.terminal.control.HisiVT100TerminalControl;
import com.hisilicon.terminal.view.ITerminalView;
import com.hisilicon.terminal.view.ITerminalViewConnection;
import com.hisilicon.terminal.view.ITerminalViewConnectionManager;
import com.hisilicon.terminal.view.PageBook;
import com.hisilicon.terminal.view.SettingStorePrefixDecorator;
import com.hisilicon.terminal.view.SettingsStore;
import com.hisilicon.terminal.view.TerminalSettingsDlg;
import com.hisilicon.terminal.view.TerminalViewConnection;
import com.hisilicon.terminal.view.TerminalViewConnectionManager;
import com.hisilicon.terminal.view.TerminalViewControlDecorator;
import com.hisilicon.terminal.view.TerminalViewPlugin;
import com.hisilicon.terminal.view.ViewMessages;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCut;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionSelectAll;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.LayeredSettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.PreferenceSettingStore;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ITerminalView,
ITerminalViewConnectionManager.ITerminalViewConnectionListener {
    private static final String IP_LOCALHOST = "localhost";
    private static final String IP_127_0_0_1 = "127.0.0.1";
    private static final String TM_TERMINAL_TELNET_CONNECTOR = "org.eclipse.tm.internal.terminal.telnet.TelnetConnector";
    private static Map<String, ITerminalViewControl> telnetConns = new HashMap<String, ITerminalViewControl>();
    private static final String PREF_CONNECTORS = "Connectors.";
    private static final String STORE_CONNECTION_TYPE = "ConnectionType";
    private static final String STORE_SETTING_SUMMARY = "SettingSummary";
    private static final String STORE_TITLE = "Title";
    public static final String FONT_DEFINITION = "terminal.views.view.font.definition";
    protected ITerminalViewControl fCtlTerminal;
    TerminalViewControlDecorator fCtlDecorator = new TerminalViewControlDecorator();
    protected TerminalAction fActionTerminalNewTerminal;
    protected TerminalAction fActionTerminalConnect;
    private TerminalAction fActionTerminalScrollLock;
    protected TerminalAction fActionTerminalDisconnect;
    protected TerminalAction fActionTerminalSettings;
    protected TerminalActionCopy fActionEditCopy;
    protected TerminalActionCut fActionEditCut;
    protected TerminalActionPaste fActionEditPaste;
    protected TerminalActionClearAll fActionEditClearAll;
    protected TerminalActionSelectAll fActionEditSelectAll;
    protected TerminalAction fActionToggleCommandInputField;
    protected TerminalPropertyChangeHandler fPropertyChangeHandler;
    protected Action fActionTerminalDropDown;
    protected Action fActionTerminalRemove;
    protected TerminalControlLogAction fExportLog;
    protected boolean fMenuAboutToShow;
    private SettingsStore fStore;
    private final ITerminalViewConnectionManager fMultiConnectionManager = new TerminalViewConnectionManager();
    private final IPropertyChangeListener fPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("TerminalPrefLimitOutput") || event.getProperty().equals("TerminalPrefBufferLines") || event.getProperty().equals("TerminalPrefInvertColors")) {
                TerminalView.this.updatePreferences();
            }
        }
    };
    private PageBook fPageBook;

    public TerminalView() {
        Logger.log((String)"===============================================================");
        this.fMultiConnectionManager.addListener(this);
    }

    String findUniqueTitle(String title) {
        IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
        String id = this.getViewSite().getId();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < pages.length) {
            IViewReference[] views = pages[i].getViewReferences();
            int j = 0;
            while (j < views.length) {
                String name;
                IViewReference view = views[j];
                if (id.equals(view.getId()) && (name = view.getTitle()) != null) {
                    names.add(view.getPartName());
                }
                ++j;
            }
            ++i;
        }
        i = 1;
        String uniqueTitle = title;
        while (names.contains(uniqueTitle)) {
            uniqueTitle = String.valueOf(title) + " " + i++;
        }
        return uniqueTitle;
    }

    private void updatePreferences() {
        Preferences preferences = TerminalViewPlugin.getDefault().getPluginPreferences();
        int bufferLineLimit = preferences.getInt("TerminalPrefBufferLines");
        boolean invert = preferences.getBoolean("TerminalPrefInvertColors");
        ITerminalViewConnection[] conn = this.fMultiConnectionManager.getConnections();
        int i = 0;
        while (i < conn.length) {
            conn[i].getCtlTerminal().setBufferLineLimit(bufferLineLimit);
            conn[i].getCtlTerminal().setInvertedColors(invert);
            ++i;
        }
    }

    @Override
    public void onTerminalNewTerminal() {
        Logger.log((String)"creating new Terminal instance.");
        this.setupControls();
        if (this.newConnection(ViewMessages.NEW_TERMINAL_CONNECTION) == null) {
            this.fMultiConnectionManager.removeActive();
        }
    }

    @Override
    public void onTerminalNewView() {
        try {
            ITerminalConnector c;
            IViewPart newTerminalView = this.getSite().getPage().showView("com.hisilicon.terminal.prototype.view.TerminalView", "SecondaryTerminal" + System.currentTimeMillis(), 1);
            if (newTerminalView instanceof ITerminalView && (c = ((TerminalView)newTerminalView).newConnection(ViewMessages.NEW_TERMINAL_VIEW)) == null) {
                this.getSite().getPage().hideView(newTerminalView);
            }
        }
        catch (PartInitException ex) {
            Logger.logException((Exception)((Object)ex));
        }
    }

    @Override
    public void onTerminalConnect() {
        if (this.fCtlTerminal.getState() != TerminalState.CLOSED) {
            return;
        }
        if (this.fCtlTerminal.getTerminalConnector() == null) {
            this.setConnector(this.showSettingsDialog(ViewMessages.TERMINALSETTINGS));
        }
        this.fCtlTerminal.connectTerminal();
        this.addTerminalConnector();
    }

    public void updateStatus() {
        this.updateTerminalConnect();
        this.updateTerminalDisconnect();
        this.updateTerminalSettings();
        this.fActionToggleCommandInputField.setChecked(this.hasCommandInputField());
        this.fActionTerminalScrollLock.setChecked(this.isScrollLock());
        this.updateSummary();
    }

    public void updateTerminalConnect() {
        boolean bEnabled = this.fCtlTerminal.getState() == TerminalState.CLOSED;
        this.fActionTerminalConnect.setEnabled(bEnabled);
        this.fExportLog.updateTerminalConnect(this.fCtlTerminal);
    }

    private boolean isConnecting() {
        return this.fCtlTerminal.getState() == TerminalState.CONNECTING;
    }

    @Override
    public void onTerminalDisconnect() {
        this.fCtlTerminal.disconnectTerminal();
        this.removeTerminalConnector();
    }

    public void updateTerminalDisconnect() {
        boolean bEnabled = this.isConnecting() || this.fCtlTerminal.isConnected();
        this.fActionTerminalDisconnect.setEnabled(bEnabled);
    }

    @Override
    public void onTerminalSettings() {
        this.newConnection(null);
    }

    private ITerminalConnector newConnection(String title) {
        ITerminalConnector c = this.showSettingsDialog(title);
        if (c != null) {
            this.setConnector(c);
            this.onTerminalConnect();
        }
        return c;
    }

    private ITerminalConnector showSettingsDialog(String title) {
        ITerminalConnector[] connectors = this.fCtlTerminal.getConnectors();
        if (this.fCtlTerminal.getState() != TerminalState.CLOSED) {
            connectors = new ITerminalConnector[]{};
        }
        ITerminalConnector c = this.loadSettings((ISettingsStore)new LayeredSettingsStore((ISettingsStore)this.fStore, (ISettingsStore)this.getPreferenceSettingsStore()), connectors);
        if (this.fCtlTerminal.getTerminalConnector() != null) {
            c = this.fCtlTerminal.getTerminalConnector();
        }
        TerminalSettingsDlg dlgTerminalSettings = new TerminalSettingsDlg(this.getViewSite().getShell(), connectors, c);
        dlgTerminalSettings.setTerminalTitle(this.getActiveConnection().getPartName());
        if (title != null) {
            dlgTerminalSettings.setTitle(title);
        }
        Logger.log((String)"opening Settings dialog.");
        if (dlgTerminalSettings.open() == 1) {
            Logger.log((String)"Settings dialog cancelled.");
            return null;
        }
        Logger.log((String)"Settings dialog OK'ed.");
        this.saveSettings(this.fStore, dlgTerminalSettings.getConnector());
        this.saveSettings((ISettingsStore)this.getPreferenceSettingsStore(), dlgTerminalSettings.getConnector());
        this.setViewTitle(dlgTerminalSettings.getTerminalTitle());
        return dlgTerminalSettings.getConnector();
    }

    private void setConnector(ITerminalConnector connector) {
        this.fCtlTerminal.setConnector(connector);
    }

    public void updateTerminalSettings() {
    }

    private void setViewTitle(String title) {
        this.setPartName(title);
        this.getActiveConnection().setPartName(title);
    }

    private void setViewSummary(String summary) {
        this.setContentDescription(summary);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(summary);
        this.setTitleToolTip(String.valueOf(this.getPartName()) + ": " + summary);
    }

    public void updateSummary() {
        this.setViewSummary(this.getActiveConnection().getFullSummary());
    }

    @Override
    public void onTerminalFontChanged() {
        Font font = JFaceResources.getFont((String)FONT_DEFINITION);
        ITerminalViewConnection[] conn = this.fMultiConnectionManager.getConnections();
        int i = 0;
        while (i < conn.length) {
            conn[i].getCtlTerminal().setFont(font);
            ++i;
        }
    }

    public void createPartControl(Composite wndParent) {
        ITerminalViewConnection[] conn;
        this.fPageBook = new PageBook(wndParent, 0);
        SettingStorePrefixDecorator s = new SettingStorePrefixDecorator(this.fStore, "connectionManager");
        this.fMultiConnectionManager.loadState(s, new ITerminalViewConnectionManager.ITerminalViewConnectionFactory(){

            @Override
            public ITerminalViewConnection create() {
                return TerminalView.this.makeViewConnection();
            }
        });
        if (this.fMultiConnectionManager.size() == 0) {
            conn = this.makeViewConnection();
            this.fMultiConnectionManager.addConnection((ITerminalViewConnection)conn);
            this.fMultiConnectionManager.setActiveConnection((ITerminalViewConnection)conn);
            this.fPageBook.showPage(this.fCtlTerminal.getRootControl());
        }
        this.setTerminalControl(this.fMultiConnectionManager.getActiveConnection().getCtlTerminal());
        this.setViewTitle(this.findUniqueTitle(ViewMessages.PROP_TITLE));
        this.setupActions();
        this.setupLocalToolBars();
        conn = this.fMultiConnectionManager.getConnections();
        int i = 0;
        while (i < conn.length) {
            this.setupContextMenus(conn[i].getCtlTerminal().getControl());
            ++i;
        }
        this.setupListeners(wndParent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wndParent, "org.eclipse.tm.terminal.view.terminal_page");
        this.legacyLoadState();
        this.legacySetTitle();
        this.updatePreferences();
        this.refresh();
        this.onTerminalFontChanged();
    }

    public void dispose() {
        Logger.log((String)"entered.");
        TerminalViewPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPreferenceListener);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fPropertyChangeHandler);
        ITerminalViewConnection[] conn = this.fMultiConnectionManager.getConnections();
        int i = 0;
        while (i < conn.length) {
            conn[i].getCtlTerminal().disposeTerminal();
            ++i;
        }
        super.dispose();
    }

    public void setFocus() {
        this.fCtlTerminal.setFocus();
    }

    protected void setupControls() {
        ITerminalViewConnection conn = this.makeViewConnection();
        this.fMultiConnectionManager.addConnection(conn);
        this.fMultiConnectionManager.setActiveConnection(conn);
        this.setupContextMenus(this.fCtlTerminal.getControl());
        this.updatePreferences();
    }

    private ITerminalViewConnection makeViewConnection() {
        ITerminalConnector[] connectors = this.makeConnectors();
        TerminalListener listener = new TerminalListener();
        HisiVT100TerminalControl ctrl = new HisiVT100TerminalControl(listener, this.fPageBook, connectors);
        this.setTerminalControl(ctrl);
        TerminalViewConnection conn = new TerminalViewConnection(this.fCtlTerminal);
        listener.setConnection(conn);
        conn.setPartName(this.getPartName());
        ITerminalConnector connector = this.loadSettings(this.fStore, connectors);
        ctrl.setConnector(connector);
        TerminalViewPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPreferenceListener);
        return conn;
    }

    private ITerminalConnector loadSettings(ISettingsStore store, ITerminalConnector[] connectors) {
        ITerminalConnector connector = null;
        String connectionType = store.get(STORE_CONNECTION_TYPE);
        int i = 0;
        while (i < connectors.length) {
            connectors[i].load(this.getStore(store, connectors[i]));
            if (connectors[i].getId().equals(connectionType)) {
                connector = connectors[i];
            }
            ++i;
        }
        return connector;
    }

    protected ITerminalConnector[] makeConnectors() {
        ITerminalConnector[] connectors = TerminalConnectorExtension.makeTerminalConnectors();
        return connectors;
    }

    private PreferenceSettingStore getPreferenceSettingsStore() {
        return new PreferenceSettingStore(TerminalViewPlugin.getDefault().getPluginPreferences(), PREF_CONNECTORS);
    }

    private void saveSettings(ISettingsStore store, ITerminalConnector connector) {
        if (connector != null) {
            connector.save(this.getStore(store, connector));
            store.put(STORE_CONNECTION_TYPE, connector.getId());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fStore = new SettingsStore(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.fStore.put(STORE_TITLE, this.getPartName());
        this.fMultiConnectionManager.saveState(new SettingStorePrefixDecorator(this.fStore, "connectionManager"));
        this.fStore.saveState(memento);
    }

    private ISettingsStore getStore(ISettingsStore store, ITerminalConnector connector) {
        return new SettingStorePrefixDecorator(store, String.valueOf(connector.getId()) + ".");
    }

    protected void setupActions() {
        this.fActionTerminalDropDown = new TerminalActionSelectionDropDown(this.fMultiConnectionManager);
        this.fActionTerminalRemove = new TerminalActionRemove(this.fMultiConnectionManager);
        this.fExportLog = new TerminalControlLogAction((ITerminalView)this, this.fCtlTerminal);
        this.fActionTerminalNewTerminal = new TerminalActionNewTerminal(this);
        this.fActionTerminalScrollLock = new TerminalActionScrollLock(this);
        this.fActionTerminalConnect = new TerminalActionConnect(this);
        this.fActionTerminalDisconnect = new TerminalActionDisconnect(this);
        this.fActionTerminalSettings = new TerminalActionSettings(this);
        this.fActionEditCopy = new TerminalActionCopy((ITerminalViewControl)this.fCtlDecorator);
        this.fActionEditCut = new TerminalActionCut((ITerminalViewControl)this.fCtlDecorator);
        this.fActionEditPaste = new TerminalActionPaste((ITerminalViewControl)this.fCtlDecorator);
        this.fActionEditClearAll = new TerminalActionClearAll((ITerminalViewControl)this.fCtlDecorator);
        this.fActionEditSelectAll = new TerminalActionSelectAll((ITerminalViewControl)this.fCtlDecorator);
        this.fActionToggleCommandInputField = new TerminalActionToggleCommandInputField(this);
    }

    protected void setupLocalToolBars() {
        IToolBarManager toolBarMgr = this.getViewSite().getActionBars().getToolBarManager();
        toolBarMgr.add((IAction)this.fActionTerminalConnect);
        toolBarMgr.add((IAction)this.fActionTerminalDisconnect);
        toolBarMgr.add((IAction)this.fActionTerminalSettings);
        toolBarMgr.add((IAction)this.fActionToggleCommandInputField);
        toolBarMgr.add((IAction)this.fActionTerminalScrollLock);
        toolBarMgr.add((IContributionItem)new Separator("fixedGroup"));
        toolBarMgr.add((IAction)this.fActionTerminalDropDown);
        toolBarMgr.add((IAction)this.fActionTerminalNewTerminal);
        toolBarMgr.add((IAction)this.fExportLog);
        toolBarMgr.add((IAction)this.fActionTerminalRemove);
    }

    protected void setupContextMenus(Control ctlText) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(ctlText);
        this.loadContextMenus((IMenuManager)menuMgr);
        TerminalContextMenuHandler contextMenuHandler = new TerminalContextMenuHandler();
        ctlText.setMenu(menu);
        menuMgr.addMenuListener((IMenuListener)contextMenuHandler);
        menu.addMenuListener((MenuListener)contextMenuHandler);
    }

    protected void loadContextMenus(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.fActionEditCopy);
        menuMgr.add((IAction)this.fActionEditPaste);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionEditClearAll);
        menuMgr.add((IAction)this.fActionEditSelectAll);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionToggleCommandInputField);
        menuMgr.add((IAction)this.fActionTerminalScrollLock);
        menuMgr.add((IContributionItem)new Separator("Additions"));
    }

    protected void setupListeners(Composite wndParent) {
        this.fPropertyChangeHandler = new TerminalPropertyChangeHandler();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fPropertyChangeHandler);
    }

    @Override
    public boolean hasCommandInputField() {
        return this.getActiveConnection().hasCommandInputField();
    }

    @Override
    public void setCommandInputField(boolean on) {
        this.getActiveConnection().setCommandInputField(on);
    }

    @Override
    public boolean isScrollLock() {
        return this.fCtlTerminal.isScrollLock();
    }

    @Override
    public void setScrollLock(boolean on) {
        this.fCtlTerminal.setScrollLock(on);
    }

    private ITerminalViewConnection getActiveConnection() {
        return this.fMultiConnectionManager.getActiveConnection();
    }

    private void setTerminalControl(ITerminalViewControl ctrl) {
        this.fCtlTerminal = ctrl;
        this.fCtlDecorator.setViewContoler(ctrl);
    }

    @Override
    public void connectionsChanged() {
        ITerminalViewControl ctrl;
        if (this.getActiveConnection() != null && this.fCtlTerminal != (ctrl = this.getActiveConnection().getCtlTerminal())) {
            this.setTerminalControl(ctrl);
            this.refresh();
        }
    }

    private void refresh() {
        this.fPageBook.showPage(this.fCtlTerminal.getRootControl());
        this.updateStatus();
        this.setPartName(this.getActiveConnection().getPartName());
    }

    private void legacyLoadState() {
        String summary = this.fStore.get(STORE_SETTING_SUMMARY);
        if (summary != null) {
            this.getActiveConnection().setSummary(summary);
            this.fStore.put(STORE_SETTING_SUMMARY, null);
        }
    }

    private void legacySetTitle() {
        String title = this.fStore.get(STORE_TITLE);
        if (title != null && title.length() > 0) {
            this.setViewTitle(title);
            this.fStore.put(STORE_TITLE, null);
        }
    }

    public void addTerminalConnector() {
        ITerminalConnector connector;
        if (this.fCtlTerminal.isConnected() && (connector = this.fCtlTerminal.getTerminalConnector()) != null && connector.getId().equals(TM_TERMINAL_TELNET_CONNECTOR)) {
            String connection = connector.getSettingsSummary();
            if (!TerminalView.getTelnetConns().containsKey(connection) && connection.startsWith(IP_127_0_0_1)) {
                connection = connection.replace(IP_127_0_0_1, IP_LOCALHOST);
            }
            TerminalView.getTelnetConns().put(connection, this.fCtlTerminal);
        }
    }

    public void removeTerminalConnector() {
        ITerminalConnector connector = this.fCtlTerminal.getTerminalConnector();
        if (connector != null && connector.getId().equals(TM_TERMINAL_TELNET_CONNECTOR) && TerminalView.getTelnetConns().containsKey(connector.getSettingsSummary())) {
            TerminalView.getTelnetConns().remove(connector.getSettingsSummary());
        }
    }

    public static boolean sendCommand(ITerminalConnector connector, String cmd) {
        OutputStream writer = connector.getTerminalToRemoteStream();
        try {
            if (writer != null) {
                writer.write(cmd.getBytes());
                writer.write("\r\n".getBytes());
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static Map<String, ITerminalViewControl> getTelnetConns() {
        return telnetConns;
    }

    @Override
    public void onTerminalStartLogging(File logFile) {
        if (this.fCtlTerminal instanceof HisiVT100TerminalControl) {
            HisiVT100TerminalControl hisi = (HisiVT100TerminalControl)this.fCtlTerminal;
            hisi.startLogging(logFile);
        }
    }

    @Override
    public void onTerminalStopLogging() {
        if (this.fCtlTerminal instanceof HisiVT100TerminalControl) {
            HisiVT100TerminalControl hisi = (HisiVT100TerminalControl)this.fCtlTerminal;
            hisi.stopLogging();
        }
    }

    protected class TerminalContextMenuHandler
    implements MenuListener,
    IMenuListener {
        protected TerminalContextMenuHandler() {
        }

        public void menuHidden(MenuEvent event) {
            TerminalView.this.fMenuAboutToShow = false;
            TerminalView.this.fActionEditCopy.updateAction(TerminalView.this.fMenuAboutToShow);
        }

        public void menuShown(MenuEvent e) {
        }

        public void menuAboutToShow(IMenuManager menuMgr) {
            TerminalView.this.fMenuAboutToShow = true;
            TerminalView.this.fActionEditCopy.updateAction(TerminalView.this.fMenuAboutToShow);
            TerminalView.this.fActionEditCut.updateAction(TerminalView.this.fMenuAboutToShow);
            TerminalView.this.fActionEditSelectAll.updateAction(TerminalView.this.fMenuAboutToShow);
            TerminalView.this.fActionEditPaste.updateAction(TerminalView.this.fMenuAboutToShow);
            TerminalView.this.fActionEditClearAll.updateAction(TerminalView.this.fMenuAboutToShow);
        }
    }

    class TerminalListener
    implements ITerminalListener {
        volatile ITerminalViewConnection fConnection;

        TerminalListener() {
        }

        void setConnection(ITerminalViewConnection connection) {
            this.fConnection = connection;
        }

        public void setState(final TerminalState state) {
            this.runInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    TerminalListener.this.fConnection.setState(state);
                    if (TerminalListener.this.fConnection == TerminalView.this.fMultiConnectionManager.getActiveConnection()) {
                        TerminalView.this.updateStatus();
                    }
                }
            });
        }

        public void setTerminalTitle(final String title) {
            this.runInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    TerminalListener.this.fConnection.setTerminalTitle(title);
                    if (TerminalListener.this.fConnection == TerminalView.this.fMultiConnectionManager.getActiveConnection()) {
                        TerminalView.this.updateSummary();
                    }
                }
            });
        }

        private void runInDisplayThread(Runnable runnable) {
            if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
                runnable.run();
            } else if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
            }
        }
    }

    protected class TerminalPropertyChangeHandler
    implements IPropertyChangeListener {
        protected TerminalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(TerminalView.FONT_DEFINITION)) {
                TerminalView.this.onTerminalFontChanged();
            }
        }
    }
}

