/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.ui.config.telnet;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IpAddressEditor
extends Composite {
    static final char CHAR_0 = '0';
    static final char CHAR_9 = '9';
    static final String STR_0 = "0";
    static final String STR_255 = "255";
    static final String DOT = ".";
    private Text part1Text;
    private Text part2Text;
    private Text part3Text;
    private Text part4Text;
    private int[] address = new int[4];
    private Color defaultBackground;

    public IpAddressEditor(Composite parent, int style) {
        super(parent, style | 0x800);
        this.createContents(this);
        this.setBackground(this.getWhiteColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        this._setLayout((Layout)layout);
        this.setTabList(new Control[]{this.part1Text, this.part2Text, this.part3Text, this.part4Text});
    }

    private void _setLayout(Layout layout) {
        super.setLayout(layout);
    }

    private void buildEditor() {
        if (this.part1Text != null && !this.part1Text.isDisposed()) {
            this.part1Text.setText(Integer.toString(this.address[0]));
        }
        if (this.part2Text != null && !this.part2Text.isDisposed()) {
            this.part2Text.setText(Integer.toString(this.address[1]));
        }
        if (this.part3Text != null && !this.part3Text.isDisposed()) {
            this.part3Text.setText(Integer.toString(this.address[2]));
        }
        if (this.part4Text != null && !this.part4Text.isDisposed()) {
            this.part4Text.setText(Integer.toString(this.address[3]));
        }
    }

    private void createContents(Composite parent) {
        this.part1Text = this.createText(parent, 0);
        this.part1Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part2Text = this.createText(parent, 1);
        this.part2Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part3Text = this.createText(parent, 2);
        this.part3Text.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.part4Text = this.createText(parent, 3);
        this.part4Text.setLayoutData((Object)this.createLayoutData());
        this.buildEditor();
    }

    private Label createDotLabel(Composite parent) {
        Label label = new Label(parent, 0);
        if (this.defaultBackground == null) {
            this.defaultBackground = label.getBackground();
        }
        label.setBackground(this.getWhiteColor());
        label.setText(DOT);
        return label;
    }

    private GridData createLayoutData() {
        GridData layoutData = new GridData(768);
        layoutData.minimumWidth = 25;
        return layoutData;
    }

    private Text createText(Composite parent, final int index) {
        final Text text = new Text(parent, 0x1000000);
        text.setData((Object)index);
        text.setTextLimit(3);
        text.addListener(25, (Listener)new VerifyListener());
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                int newValue;
                Text widget = (Text)event.widget;
                String text = widget.getText();
                if (text.equals("")) {
                    text = IpAddressEditor.STR_0;
                }
                if ((newValue = Integer.parseInt(text)) != IpAddressEditor.this.address[index]) {
                    ((IpAddressEditor)IpAddressEditor.this).address[index] = newValue;
                    IpAddressEditor.this.dispatchEvent();
                }
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if ((event.keyCode == 46 || event.keyCode == 16777262) && index < 3) {
                    IpAddressEditor.this.getTabList()[index % 4 + 1].setFocus();
                }
            }
        });
        return text;
    }

    private void dispatchEvent() {
        Event event = new Event();
        event.widget = this;
        event.text = this.getDisplayAddress();
        this.notifyListeners(24, event);
    }

    public int[] getAddress() {
        return (int[])this.address.clone();
    }

    public String getDisplayAddress() {
        return String.valueOf(this.address[0]) + DOT + this.address[1] + DOT + this.address[2] + DOT + this.address[3];
    }

    private Color getWhiteColor() {
        return this.getDisplay().getSystemColor(1);
    }

    public void setAddress(String addressStr) {
        if (addressStr != null) {
            String[] splits = addressStr.split("\\.", 0);
            int i = 0;
            while (i < splits.length) {
                if (i > 3) break;
                try {
                    this.address[i] = Integer.parseInt(splits[i].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.address.length) {
                this.address[i] = 0;
                ++i;
            }
        }
        this.buildEditor();
    }

    public void setEnabled(boolean enabled) {
        Control[] children;
        super.setEnabled(enabled);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Label) {
                if (enabled) {
                    control.setBackground(this.getWhiteColor());
                } else {
                    control.setBackground(this.defaultBackground);
                }
            }
            ++n2;
        }
        if (enabled) {
            this.setBackground(this.getWhiteColor());
        } else {
            this.setBackground(this.defaultBackground);
        }
    }

    public void setLayout(Layout layout) {
    }

    private static class VerifyListener
    implements Listener {
        private boolean ignore = false;

        private VerifyListener() {
        }

        public void handleEvent(Event e) {
            if (this.ignore) {
                return;
            }
            e.doit = false;
            String insert = e.text;
            char[] newChars = insert.toCharArray();
            int i = Math.min(2, newChars.length - 1);
            while (i >= 0) {
                if ('0' > newChars[i] || newChars[i] > '9') {
                    return;
                }
                --i;
            }
            Text widget = (Text)e.widget;
            StringBuilder newText = new StringBuilder(widget.getText());
            if (e.start == e.end) {
                newText.insert(e.start, newChars);
            } else {
                newText.replace(e.start, e.end, insert);
            }
            String value = newText.toString();
            if (value.length() > 3) {
                value = value.substring(0, 3);
            } else if (value.isEmpty()) {
                value = IpAddressEditor.STR_0;
            }
            int intVal = Integer.parseInt(value);
            this.ignore = true;
            value = intVal > 255 ? IpAddressEditor.STR_255 : Integer.toString(intVal);
            widget.selectAll();
            widget.insert(value);
            this.ignore = false;
        }
    }
}

