/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.core.internal;

import com.vendor.platform.api.ILog2;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class ErrorLog
implements ILog2 {
    private static Map<Plugin, ErrorLog> map = new HashMap<Plugin, ErrorLog>();
    private ILog logger = null;
    private String pluginID = null;

    private ErrorLog(Plugin plugin) {
        try {
            this.logger = plugin.getLog();
            this.pluginID = plugin.getBundle().getSymbolicName();
        }
        catch (Exception exception) {}
    }

    public static ILog2 getInstance(Plugin plugin) {
        ILog2 errorLog = map.get(plugin);
        if (errorLog == null) {
            errorLog = new ErrorLog(plugin);
        }
        return errorLog;
    }

    public void logCancel(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(8, this.pluginID, message));
        }
    }

    public void logError(String message, Throwable exception) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(4, this.pluginID, 0, message, exception));
        }
    }

    public void logInfo(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(1, this.pluginID, message));
        }
    }

    public void logOk(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(0, this.pluginID, message));
        }
    }

    public void logWarning(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(2, this.pluginID, message));
        }
    }
}

