/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.core.internal;

import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.internal.ErrorLog;
import com.vendor.platform.core.internal.StringConstants;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;

public class P2Utils {
    private static String DEFAULT_PREFERENCES_DIRNAME = StringConstants.decode("856865407720982734707");
    private static String BUCKMINSTER = StringConstants.decode("80343454941683828890297714");
    private static String ECLIPSE_P2_PROFILE = StringConstants.decode("8832172937528445164687600416771833374272613");

    public static void updateProfile() {
        try {
            PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
            IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
            IProvisioningAgent agent = agentProvider.createAgent(null);
            String profileId = bucky.getBundle().getBundleContext().getProperty(ECLIPSE_P2_PROFILE);
            if (profileId == null) {
                profileId = BUCKMINSTER;
                System.setProperty(ECLIPSE_P2_PROFILE, profileId);
            }
            P2Utils.updateProfile(agent, profileId);
        }
        catch (Exception e) {
            ErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    private static void updateProfile(IProvisioningAgent agent, String profileId) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile(profileId);
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)EngineActivator.getContext(), (String)Location.class.getName(), (String)Location.INSTALL_FILTER);
        if (installLocation == null) {
            return;
        }
        File location = new File(installLocation.getURL().getPath());
        String propCache = profile.getProperty("org.eclipse.equinox.p2.cache");
        try {
            if (propCache != null && propCache.equalsIgnoreCase(location.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (profile instanceof Profile && profileRegistry instanceof SimpleProfileRegistry) {
            SimpleProfileRegistry reg = (SimpleProfileRegistry)profileRegistry;
            Profile p = (Profile)profile;
            File profileDataDirectory = reg.getProfileDataDirectory(profileId);
            FileUtils.deleteAll((File)new File(profileDataDirectory, DEFAULT_PREFERENCES_DIRNAME));
            reg.lockProfile(p);
            try {
                p.setProperty("org.eclipse.equinox.p2.installFolder", location.getCanonicalPath());
                p.setProperty("org.eclipse.equinox.p2.cache", location.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            p.setProperty("org.eclipse.equinox.p2.roaming", "true");
            reg.updateProfile(p);
            reg.unlockProfile((IProfile)p);
        }
    }

    public static IProfile getProfile() throws Exception {
        PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
        IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        String profileId = bucky.getBundle().getBundleContext().getProperty(ECLIPSE_P2_PROFILE);
        if (profileId == null) {
            profileId = BUCKMINSTER;
            System.setProperty(ECLIPSE_P2_PROFILE, profileId);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = profileRegistry.getProfile(profileId);
        return profile;
    }

    public static String getIntallDestination() {
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)PlatformCoreActivator.getBundleContext(), (String)Location.class.getName(), (String)Location.INSTALL_FILTER);
        if (installLocation == null) {
            return null;
        }
        File location = new File(installLocation.getURL().getPath());
        try {
            return location.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

