/*
 * Decompiled with CFR 0.152.
 */
package org.vendor.connector.api.i2c;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.vendor.connector.api.IConnection;
import org.vendor.connector.api.IConnectionManager;
import org.vendor.connector.api.Messages;
import org.vendor.connector.api.i2c.I2cUtils;
import org.vendor.connector.api.i2c.II2cSettings;
import org.vendor.connector.api.i2c.jni.II2cDllByJNA;

public class I2cConnection
implements IConnection<II2cSettings>,
Runnable {
    static int timeout = 1000;
    private boolean connected;
    private static final int DEFAULT_CHANNEL_ID = 0;
    private static int baudRate;
    private static int deviceAddress;
    private String name;
    private II2cSettings i2cSettings;
    private boolean autoReceive = false;

    public I2cConnection(II2cSettings i2cSettings) throws IOException {
        this.init(i2cSettings);
        new Thread(this).start();
    }

    private void init(II2cSettings i2cSettings) {
        this.setSettings(i2cSettings);
    }

    public static I2cConnection createConnection(II2cSettings ii2cSettings) throws IOException {
        I2cConnection i2cConnector = new I2cConnection(ii2cSettings);
        String baudRateStr = ii2cSettings.getfBaudRate();
        String deviceAddressStr = ii2cSettings.getfDeviceAddress();
        baudRate = I2cUtils.getbaudRateValue(baudRateStr);
        deviceAddress = I2cUtils.convertStringToInt(deviceAddressStr);
        try {
            int openResult = II2cDllByJNA.instance.I2C_OpenChannel(0, baudRate);
            i2cConnector.connected = I2cUtils.checkI2cReturn(openResult);
        }
        catch (Exception e) {
            i2cConnector.connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
            e.printStackTrace();
        }
        catch (Error e) {
            i2cConnector.connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
            e.printStackTrace();
        }
        return i2cConnector;
    }

    @Override
    public void close() {
        this.setConnectionManager(null);
        this.connected = false;
        try {
            int closeResult = II2cDllByJNA.instance.I2C_CloseChannel(0);
            I2cUtils.checkI2cReturn(closeResult);
        }
        catch (Exception exception) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
        }
        catch (Error e) {
            this.connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
    }

    @Override
    public boolean isAutoReceive() {
        return this.autoReceive;
    }

    @Override
    public void setAutoReceive(boolean autoReceive) {
        this.autoReceive = autoReceive;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public II2cSettings getSettings() {
        return this.i2cSettings;
    }

    @Override
    public void setSettings(II2cSettings settings) {
        this.i2cSettings = settings;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean updateSettings(II2cSettings settings) {
        return false;
    }

    @Override
    public void setConnectionManager(IConnectionManager connectionManager) {
    }

    @Override
    public void send(String data) throws IOException {
    }

    @Override
    public void send(char data) throws IOException {
    }

    public boolean sendI2cCmd(int sizetowrite, byte[] inputbuffer, int sizetoread, byte[] outputbuffer) throws IOException {
        int setCmdResult = -1;
        int sendCount = 1;
        try {
            while (setCmdResult != 0 && sendCount < 10) {
                setCmdResult = II2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, sizetowrite, inputbuffer, sizetoread, outputbuffer);
                System.out.println("setCmdResult: " + setCmdResult);
                ++sendCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
            return false;
        }
        catch (Error e) {
            this.connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_I2C);
                }
            });
            e.printStackTrace();
        }
        return I2cUtils.checkI2cReturn(setCmdResult);
    }

    @Override
    public OutputStream getRemoteOutputStream() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public InputStream getRemoteInputStream() {
        return null;
    }

    public static int getBaudRate() {
        return baudRate;
    }

    public static int getDeviceAddress() {
        return deviceAddress;
    }

    @Override
    public void addOutputStream(OutputStream out) {
    }

    @Override
    public void removeOutputStream(OutputStream out) {
    }
}

