/*
 * Decompiled with CFR 0.152.
 */
package org.vendor.connector.api.i2c;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.vendor.connector.api.Messages;
import org.vendor.connector.api.i2c.jni.FT_STATUS;

public class I2cUtils {
    public static int getbaudRateValue(String baudRateStr) {
        int baudRate = 0;
        if (baudRateStr.contains("k")) {
            baudRateStr = baudRateStr.substring(0, baudRateStr.indexOf("k"));
            baudRate = Integer.parseInt(baudRateStr) * 1000;
        } else if (baudRateStr.contains("K")) {
            baudRateStr = baudRateStr.substring(0, baudRateStr.indexOf("K"));
            baudRate = Integer.parseInt(baudRateStr) * 1000;
        } else {
            baudRate = Integer.parseInt(baudRateStr);
        }
        return baudRate;
    }

    public static int convertStringToInt(String str) {
        block4: {
            try {
                if (!str.trim().isEmpty()) break block4;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.parseInt(str.substring(2), 16);
            }
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return Integer.parseInt(str.substring(2), 16);
        }
        return Integer.parseInt(str, 10);
    }

    public static String getInstallPath() {
        String path = null;
        path = Platform.getInstallLocation().getURL().getPath();
        if (path.startsWith("//")) {
            return path;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static <T> FT_STATUS getEnum(int index) {
        Class<FT_STATUS> clazz = FT_STATUS.class;
        T[] c = clazz.getEnumConstants();
        return (FT_STATUS)((Object)c[index]);
    }

    public static boolean checkI2cReturn(int input) {
        FT_STATUS returnValue = I2cUtils.getEnum(input);
        boolean result = false;
        switch (returnValue) {
            case FT_OK: {
                result = true;
                break;
            }
            case FT_INVALID_HANDLE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_HANDLE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_FOUND: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_FOUND);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED);
                    }
                });
                break;
            }
            case FT_IO_ERROR: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_IO_ERROR);
                    }
                });
                break;
            }
            case FT_INSUFFICIENT_RESOURCES: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INSUFFICIENT_RESOURCES);
                    }
                });
                break;
            }
            case FT_INVALID_PARAMETER: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_PARAMETER);
                    }
                });
                break;
            }
            case FT_INVALID_BAUD_RATE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_BAUD_RATE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_ERASE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED_FOR_ERASE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_WRITE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED_FOR_WRITE);
                    }
                });
                break;
            }
            case FT_FAILED_TO_WRITE_DEVICE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_FAILED_TO_WRITE_DEVICE);
                    }
                });
                break;
            }
            case FT_EEPROM_READ_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_READ_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_WRITE_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_WRITE_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_ERASE_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_ERASE_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_NOT_PRESENT: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_NOT_PRESENT);
                    }
                });
                break;
            }
            case FT_EEPROM_NOT_PROGRAMMED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_NOT_PROGRAMMED);
                    }
                });
                break;
            }
            case FT_INVALID_ARGS: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_ARGS);
                    }
                });
                break;
            }
            case FT_NOT_SUPPORTED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_NOT_SUPPORTED);
                    }
                });
                break;
            }
            case FT_OTHER_ERROR: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_OTHER_ERROR);
                    }
                });
                break;
            }
            case FT_DEVICE_LIST_NOT_READY: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_LIST_NOT_READY);
                    }
                });
                break;
            }
        }
        return result;
    }
}

