/*
 * Decompiled with CFR 0.152.
 */
package org.vendor.tftp.common;

import org.vendor.tftp.common.TFTPOptions;

public class OptionAck {
    public static final int IX_OPCODE = 0;
    public static final int OPCODE = 6;
    public static final int TIMEOUT = 5;
    private int blockNr;
    private TFTPOptions options;

    public int getBlockNr() {
        this.blockNr = this.options.getBlkSize() % this.options.getBlkSize() > 0 ? this.options.gettSize() / this.options.getBlkSize() : this.options.gettSize() / this.options.getBlkSize() + 1;
        return this.blockNr;
    }

    public OptionAck(TFTPOptions options) {
        this.options = options;
    }

    private int getLength() {
        int blockSize;
        int tsize;
        int length = 4;
        if (this.options == null) {
            return length;
        }
        int timeout = this.options.getTimeOut();
        if (timeout > 0) {
            length += "timeout".length() + String.valueOf(timeout).length() + 2;
        }
        if ((tsize = this.options.gettSize()) > 0) {
            length += "tsize".length() + String.valueOf(tsize).length() + 2;
        }
        if ((blockSize = this.options.getBlkSize()) > 0) {
            length += "blksize".length() + String.valueOf(blockSize).length() + 2;
        }
        return length;
    }

    public byte[] getAcknowledgementData() {
        byte[] data = new byte[]{0, 4, (byte)((this.getBlockNr() & 0xFFFF) >> 8), (byte)(this.getBlockNr() & 0xFF)};
        return data;
    }

    public byte[] getBytes() {
        int blksize;
        int tsize;
        byte[] tftpP = new byte[this.getLength()];
        tftpP[0] = 0;
        tftpP[1] = 6;
        int IX_OPTION = 2;
        int timeout = this.options.getTimeOut();
        if (timeout > 0) {
            int length = "timeout".length();
            System.arraycopy("timeout".getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
            String timeoutValue = String.valueOf(timeout);
            length = timeoutValue.length();
            System.arraycopy(timeoutValue.getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
        }
        if ((tsize = this.options.gettSize()) > 0) {
            int length = "tsize".length();
            System.arraycopy("tsize".getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
            String tsizeValue = String.valueOf(tsize);
            length = tsizeValue.length();
            System.arraycopy(tsizeValue.getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
        }
        if ((blksize = this.options.getBlkSize()) > 0) {
            int length = "blksize".length();
            System.arraycopy("blksize".getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
            String tsizeValue = String.valueOf(blksize);
            length = tsizeValue.length();
            System.arraycopy(tsizeValue.getBytes(), 0, tftpP, IX_OPTION, length);
            IX_OPTION += length;
            tftpP[IX_OPTION++] = 0;
        }
        int IX_BLOCKNR = IX_OPTION;
        tftpP[IX_BLOCKNR] = (byte)(this.getBlockNr() >> 8 & 0xFF);
        tftpP[IX_BLOCKNR + 1] = (byte)(this.getBlockNr() & 0xFF);
        return tftpP;
    }
}

