/*
 * Decompiled with CFR 0.152.
 */
package org.vendor.tftp.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.net.io.FromNetASCIIOutputStream;
import org.apache.commons.net.io.ToNetASCIIInputStream;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRequestPacket;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.vendor.tftp.common.OptionAck;
import org.vendor.tftp.common.TFTPCommon;
import org.vendor.tftp.common.TFTPOptions;
import org.vendor.tftp.prefences.TFTPPreferences;
import org.vendor.tftp.tool.TFTPService;
import org.vendor.tftp.tool.TftpInfo;

public class TFTPTransfer
implements Runnable {
    public static final int BLK_SIZE = 512;
    private Logger logger = LogManager.getLogger(TFTPTransfer.class);
    int timeout = TFTPPreferences.getTimeout();
    private int TFTP_MAXRETRIES = 50;
    private TFTPPacket tftpPacket;
    private int socketTimeout;
    private int maxTimeoutRetries;
    private File serverDirectory;
    private HashSet<TFTPTransfer> transfers;
    TFTPCommon transferTftp = null;

    public TFTPTransfer(TFTPPacket tftpPacket, int socketTimeout, int maxTimeoutRetries, File serverDirectory, HashSet<TFTPTransfer> transfers) {
        this.socketTimeout = socketTimeout;
        this.tftpPacket = tftpPacket;
        this.serverDirectory = serverDirectory;
        this.transfers = transfers;
    }

    public void shutdown() {
        try {
            this.transferTftp.close();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            try {
                this.logger.info("TFTPTransfer run...");
                this.transferTftp = new TFTPCommon();
                this.transferTftp.beginBufferedOps();
                this.transferTftp.setDefaultTimeout(this.socketTimeout);
                this.transferTftp.open();
                this.logger.info("TFTPTransfer open");
                this.logger.info("tftpTimeout:" + this.timeout);
                this.logger.info("winsize block count:" + TFTPService.getWinSizeBlockCount());
                if (this.tftpPacket instanceof TFTPReadRequestPacket) {
                    this.logger.info("TFTPTransfer handle Read");
                    this.handleRead((TFTPReadRequestPacket)this.tftpPacket);
                } else if (this.tftpPacket instanceof TFTPWriteRequestPacket) {
                    this.logger.info("TFTPTransfer handle Write");
                    this.handleWrite((TFTPWriteRequestPacket)this.tftpPacket);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.transferTftp != null && this.transferTftp.isOpen()) {
                    this.logger.info("transferTftp close.");
                    this.transferTftp.endBufferedOps();
                    this.transferTftp.close();
                }
                HashSet<TFTPTransfer> hashSet = this.transfers;
                synchronized (hashSet) {
                    this.transfers.remove(this);
                    break block25;
                }
            }
            catch (TFTPPacketException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    if (this.transferTftp != null && this.transferTftp.isOpen()) {
                        this.logger.info("transferTftp close.");
                        this.transferTftp.endBufferedOps();
                        this.transferTftp.close();
                    }
                    HashSet<TFTPTransfer> hashSet = this.transfers;
                    synchronized (hashSet) {
                        this.transfers.remove(this);
                    }
                    throw throwable;
                }
                if (this.transferTftp != null && this.transferTftp.isOpen()) {
                    this.logger.info("transferTftp close.");
                    this.transferTftp.endBufferedOps();
                    this.transferTftp.close();
                }
                HashSet<TFTPTransfer> hashSet = this.transfers;
                synchronized (hashSet) {
                    this.transfers.remove(this);
                    break block25;
                }
            }
            if (this.transferTftp != null && this.transferTftp.isOpen()) {
                this.logger.info("transferTftp close.");
                this.transferTftp.endBufferedOps();
                this.transferTftp.close();
            }
            HashSet<TFTPTransfer> hashSet = this.transfers;
            synchronized (hashSet) {
                this.transfers.remove(this);
            }
        }
        this.logger.info("TFTPTransfer end.");
    }

    private void handleRead(TFTPReadRequestPacket trrp) {
        this.logger.info("blksize:512");
        this.logger.info("timeout:" + this.timeout);
        InputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(this.buildSafeFile(this.serverDirectory, trrp.getFilename(), false)));
                int fileLen = bis.available();
                if (trrp.getMode() == 0) {
                    bis = new ToNetASCIIInputStream(bis);
                }
                try {
                    this.logger.info("send Option Oack.");
                    this.sendOptionOack(bis.available(), trrp.getAddress(), trrp.getPort(), 512, this.timeout, 0);
                    this.sendFileToClientByWindowSize(trrp, 512, bis, fileLen);
                    this.logger.info("send data end.");
                }
                catch (TFTPPacketException tftpPacketException) {
                    this.logger.error("timeout:" + tftpPacketException.getMessage());
                }
            }
            catch (FileNotFoundException e) {
                try {
                    this.transferTftp.bufferedSend((TFTPPacket)new TFTPErrorPacket(trrp.getAddress(), trrp.getPort(), 1, e.getMessage()));
                }
                catch (IOException ioException) {
                    this.logger.error("timeout:" + ioException.getMessage());
                }
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e2) {
                    this.logger.error("timeout:" + e2.getMessage());
                }
                this.logger.error("handle Read file :" + trrp.getFilename() + " close.");
                return;
            }
            catch (IOException ioException) {
                this.logger.error("timeout:" + ioException.getMessage());
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("timeout:" + e.getMessage());
                }
                this.logger.error("handle Read file :" + trrp.getFilename() + " close.");
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                this.logger.error("timeout:" + e.getMessage());
            }
            this.logger.error("handle Read file :" + trrp.getFilename() + " close.");
        }
    }

    private void checkTFTPAckPacket(List<TFTPDataPacket> winSizeBufferDataList, int expectBlockNumber) throws IOException {
        int receiveNumber = 0;
        int retransmits = 0;
        TFTPPacket tftpPacket = null;
        while (true) {
            try {
                tftpPacket = this.transferTftp.bufferedReceive();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (SocketException e) {
                this.logger.error(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            catch (TFTPPacketException e) {
                this.logger.error(e.getMessage());
            }
            if (tftpPacket != null) {
                if (tftpPacket instanceof TFTPAckPacket) {
                    TFTPAckPacket ack = (TFTPAckPacket)tftpPacket;
                    if (ack.getBlockNumber() == 0 && expectBlockNumber == 0) {
                        if (winSizeBufferDataList == null) break;
                        ++TftpInfo.curAckIndex;
                        break;
                    }
                    if (expectBlockNumber == ack.getBlockNumber()) {
                        ++TftpInfo.curAckIndex;
                        int length = winSizeBufferDataList.get(0).getDataLength();
                        TftpInfo.totalBytes += length;
                        winSizeBufferDataList.remove(0);
                        break;
                    }
                    ++receiveNumber;
                } else if (tftpPacket instanceof TFTPDataPacket) break;
            }
            if (tftpPacket != null && receiveNumber <= true) continue;
            this.logger.info("checkTFTPAckPacket");
            this.logger.info("expectBlockNumber" + expectBlockNumber);
            if (winSizeBufferDataList != null && winSizeBufferDataList.size() > 0) {
                for (TFTPDataPacket sentData : winSizeBufferDataList) {
                    this.transferTftp.bufferedSend((TFTPPacket)sentData);
                    this.logger.info("send data blockNumber:" + sentData.getBlockNumber());
                }
                receiveNumber = 0;
            }
            if (retransmits++ > this.TFTP_MAXRETRIES) {
                throw new IOException(String.valueOf(TFTPTransfer.getClient(this.transferTftp)) + " Maximum retransmit count exceeded");
            }
            this.logger.info("retransmits:" + retransmits);
        }
    }

    public static String getClient(TFTP tftpSock) {
        String client = "";
        InetAddress addr = tftpSock.getLocalAddress();
        int port = tftpSock.getLocalPort();
        if (addr != null) {
            client = String.valueOf(client) + addr.getHostAddress();
        }
        if (port != 0) {
            client = String.valueOf(client) + ":";
            client = String.valueOf(client) + port;
        }
        return client;
    }

    private void sendFileToClientByWindowSize(TFTPReadRequestPacket trrp, int blksize, InputStream bis, int fileLen) throws SocketException, IOException, InterruptedIOException, TFTPPacketException {
        TftpInfo.curAckIndex = 1;
        TftpInfo.packetSize = blksize;
        TftpInfo.winSize = TFTPService.isUsb2EtherNet() ? 1 : TFTPService.getWinSizeBlockCount();
        TftpInfo.totalBytes = 0;
        TftpInfo.lastToSend = 1;
        TftpInfo.timeOut = 0;
        TftpInfo.bytesByCountMap.clear();
        ArrayList<TFTPDataPacket> winSizeBufferDataList = new ArrayList<TFTPDataPacket>();
        TftpInfo.lastBlockOfFile = fileLen / TftpInfo.packetSize;
        ++TftpInfo.lastBlockOfFile;
        if (fileLen / TftpInfo.packetSize > 0) {
            ++TftpInfo.lastBlockOfFile;
        }
        this.logger.error("lastBlockOfFile" + TftpInfo.lastBlockOfFile);
        byte[] data = null;
        int read = 0;
        do {
            this.updateSocketTimeout();
            while (TftpInfo.lastToSend <= Math.min(TftpInfo.curAckIndex + TftpInfo.winSize - 1, TftpInfo.lastBlockOfFile)) {
                if (TftpInfo.totalBytes + TftpInfo.packetSize > fileLen) {
                    int remainLen = fileLen - TftpInfo.totalBytes;
                    data = new byte[remainLen];
                } else {
                    data = new byte[TftpInfo.packetSize];
                }
                read = bis.read(data);
                TftpInfo.bytesByCountMap.put(TftpInfo.lastToSend, read);
                if (read < 0) {
                    read = 0;
                }
                int blockNumber = TftpInfo.lastToSend % 65536;
                TFTPDataPacket sentData = new TFTPDataPacket(trrp.getAddress(), trrp.getPort(), blockNumber, data, 0, read);
                this.transferTftp.bufferedSend((TFTPPacket)sentData);
                winSizeBufferDataList.add(sentData);
                ++TftpInfo.lastToSend;
            }
            int expectBlockNumber = TftpInfo.curAckIndex % 65536;
            this.checkTFTPAckPacket(winSizeBufferDataList, expectBlockNumber);
        } while (TftpInfo.lastToSend <= TftpInfo.lastBlockOfFile);
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void updateSocketTimeout() throws SocketException {
        int tftpTimeOut = 0;
        switch (TftpInfo.timeOut) {
            case 0: {
                tftpTimeOut = (this.getTimeout() + 3) / 4 * 1000;
                break;
            }
            case 1: {
                tftpTimeOut = (this.getTimeout() + 1) / 2 * 1000;
                break;
            }
            default: {
                tftpTimeOut = this.getTimeout() * 1000;
            }
        }
        this.transferTftp.setDefaultTimeout(tftpTimeOut);
        this.transferTftp.setSoTimeout(tftpTimeOut);
    }

    private void sendOptionOack(int tSize, InetAddress address, int port, int blksize, int timeout, int expectBlockNumber) throws IOException, TFTPPacketException {
        TFTPOptions options = new TFTPOptions();
        options.setTimeOut(timeout);
        options.setBlkSize(blksize);
        options.settSize(tSize);
        this.logger.info("option acknowledgement.");
        this.logger.info("timeout:" + timeout);
        this.logger.info("blksize:" + blksize);
        this.logger.info("tSize:" + tSize);
        OptionAck oack = new OptionAck(options);
        byte[] AcknowledgementData = oack.getAcknowledgementData();
        DatagramPacket dategramPacket = new DatagramPacket(AcknowledgementData, AcknowledgementData.length, address, port);
        TFTPPacket tftpPacket = TFTPDataPacket.newTFTPPacket((DatagramPacket)dategramPacket);
        dategramPacket.setData(oack.getBytes());
        this.logger.info("Creating dategramPacket Packets.");
        this.logger.info("AcknowledgementData:" + AcknowledgementData.length);
        this.logger.info("InetAddress:" + address.getHostAddress());
        this.logger.info("expectBlockNumber:" + expectBlockNumber);
        this.logger.info("send OACK option information.");
        this.transferTftp.sendTftpPacket(tftpPacket, dategramPacket);
        if (expectBlockNumber == 0) {
            this.checkTFTPAckPacket(this.transferTftp, tftpPacket, dategramPacket, expectBlockNumber);
        }
    }

    private void checkTFTPAckPacket(TFTPCommon tftp, TFTPPacket tftpPacket, DatagramPacket dategramPacket, int expectBlockNumber) throws IOException {
        int receiveNumber = 0;
        int retransmits = 0;
        TFTPPacket tftpAckPacket = null;
        while (true) {
            try {
                tftpAckPacket = this.transferTftp.bufferedReceive();
            }
            catch (InterruptedIOException e) {
                this.logger.error(e.getMessage());
            }
            catch (SocketException e) {
                this.logger.error(e.getMessage());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            catch (TFTPPacketException e) {
                this.logger.error(e.getMessage());
            }
            if (tftpAckPacket != null) {
                if (tftpAckPacket instanceof TFTPAckPacket) {
                    TFTPAckPacket ack = (TFTPAckPacket)tftpAckPacket;
                    if (expectBlockNumber == ack.getBlockNumber()) break;
                    ++receiveNumber;
                } else if (tftpAckPacket instanceof TFTPDataPacket) break;
            }
            if (tftpAckPacket != null && receiveNumber <= true) continue;
            this.logger.info("checkTFTPAckPacket");
            tftp.sendTftpPacket(tftpPacket, dategramPacket);
            receiveNumber = 0;
            if (retransmits++ > this.TFTP_MAXRETRIES) {
                throw new IOException(String.valueOf(TFTPTransfer.getClient(this.transferTftp)) + " Maximum retransmit count exceeded");
            }
            this.logger.info("retransmits: " + retransmits);
        }
    }

    private void handleWrite(TFTPWriteRequestPacket twrp) throws IOException, TFTPPacketException {
        block23: {
            this.sendOptionOack(0, twrp.getAddress(), twrp.getPort(), 512, this.timeout, 1);
            try (OutputStream bos = null;){
                TFTPAckPacket lastSentAck;
                TFTPPacket dataPacket;
                int lastBlock = 0;
                String fileName = twrp.getFilename();
                try {
                    File temp = this.buildSafeFile(this.serverDirectory, fileName, true);
                    bos = new BufferedOutputStream(new FileOutputStream(temp));
                    if (twrp.getMode() == 0) {
                        bos = new FromNetASCIIOutputStream(bos);
                    }
                }
                catch (IOException e) {
                    this.transferTftp.bufferedSend((TFTPPacket)new TFTPErrorPacket(twrp.getAddress(), twrp.getPort(), 0, e.getMessage()));
                    if (bos != null) {
                        bos.close();
                    }
                    return;
                }
                while (true) {
                    dataPacket = null;
                    int timeoutCount = 0;
                    while (dataPacket == null || !dataPacket.getAddress().equals(twrp.getAddress()) || dataPacket.getPort() != twrp.getPort()) {
                        if (dataPacket != null) {
                            this.transferTftp.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                        }
                        try {
                            dataPacket = this.transferTftp.bufferedReceive();
                        }
                        catch (SocketTimeoutException e) {
                            if (timeoutCount >= this.maxTimeoutRetries) {
                                throw e;
                            }
                            TFTPAckPacket lastSentAck2 = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 1);
                            this.transferTftp.bufferedSend((TFTPPacket)lastSentAck2);
                            ++timeoutCount;
                        }
                    }
                    if (dataPacket != null && dataPacket instanceof TFTPWriteRequestPacket) {
                        TFTPAckPacket lastSentAck3 = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 0);
                        this.transferTftp.bufferedSend((TFTPPacket)lastSentAck3);
                        continue;
                    }
                    if (dataPacket == null) break block23;
                    if (!(dataPacket instanceof TFTPDataPacket)) {
                        break block23;
                    }
                    int block = ((TFTPDataPacket)dataPacket).getBlockNumber();
                    byte[] data = ((TFTPDataPacket)dataPacket).getData();
                    int dataLength = ((TFTPDataPacket)dataPacket).getDataLength();
                    int dataOffset = ((TFTPDataPacket)dataPacket).getDataOffset();
                    if (block > lastBlock || lastBlock == 65535 && block == 0) {
                        bos.write(data, dataOffset, dataLength);
                        lastBlock = block;
                    }
                    lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), block);
                    this.transferTftp.bufferedSend((TFTPPacket)lastSentAck);
                    if (dataLength < 512) break;
                }
                bos.close();
                int i = 0;
                while (i < this.maxTimeoutRetries) {
                    try {
                        dataPacket = this.transferTftp.bufferedReceive();
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        break;
                    }
                    if (!(dataPacket == null || dataPacket.getAddress().equals(twrp.getAddress()) && dataPacket.getPort() == twrp.getPort())) {
                        this.transferTftp.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                    } else {
                        this.transferTftp.bufferedSend((TFTPPacket)lastSentAck);
                    }
                    ++i;
                }
            }
        }
    }

    private File buildSafeFile(File serverDirectory, String fileName, boolean createSubDirs) throws IOException {
        File temp = new File(serverDirectory, fileName);
        temp = temp.getCanonicalFile();
        if (createSubDirs) {
            this.createDirectory(temp.getParentFile());
        }
        return temp;
    }

    private void createDirectory(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null) {
            if (!parent.exists()) {
                this.createDirectory(parent);
            }
            if (parent.isDirectory()) {
                if (file.isDirectory()) {
                    return;
                }
                boolean result = file.mkdir();
                if (!result) {
                    throw new IOException("Couldn't create requested directory");
                }
            } else {
                throw new IOException("Invalid directory path - file in the way of requested folder");
            }
        }
    }
}

