/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.api.statistics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.ui.WorkbenchEncoding;

public class ToolStatistics {
    private static final String STAT_FILE_EXT = ".std";
    private static final String TEXT_BRK_LEFT = "[";
    private static final String TEXT_BRK_RIGHT = "]";
    private static final String TEXT_BRK_SPACE = " ";
    private static final String TEXT_ENDLINE = "\r\n";
    private static final String TEXT_SEPARATOR = "|";
    private static final String TEXT_NO_PARAMS = "NULL";
    private static final String TEXT_USE_START = "USE_START";
    private static final String TEXT_USE_STILL = "USE_STILL";
    private static final String TEXT_USE_FINISH = "USE_FINISH";
    public static final ToolStatistics INSTANCE = new ToolStatistics();

    private ToolStatistics() {
    }

    protected synchronized void appendFile(String toolName, String statText) {
        if (toolName == null || toolName.isEmpty()) {
            return;
        }
        String dirPath = "";
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(TEXT_BRK_LEFT);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append(df.format(new Date()));
        sb.append(TEXT_BRK_RIGHT);
        sb.append(TEXT_BRK_SPACE);
        sb.append(statText);
        sb.append(TEXT_ENDLINE);
        char[] textChars = sb.toString().toCharArray();
        String filePath = String.valueOf(dirPath) + toolName + STAT_FILE_EXT;
        File file = new File(filePath);
        FileOutputStream stream = null;
        BufferedWriter writer = null;
        try {
            try {
                stream = new FileOutputStream(file, true);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                writer.write(textChars);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void logToolStart(String toolName) {
        this.appendFile(toolName, TEXT_USE_START);
    }

    public void logToolInUse(String toolName) {
        this.appendFile(toolName, TEXT_USE_STILL);
    }

    public void logToolFinish(String toolName) {
        this.appendFile(toolName, TEXT_USE_FINISH);
    }

    public void logUsage(String toolName, String function, String params) {
        StringBuilder sb = new StringBuilder();
        sb.append(function);
        sb.append(TEXT_SEPARATOR);
        if (params == null || params.isEmpty()) {
            sb.append(TEXT_NO_PARAMS);
        } else {
            sb.append(params);
        }
        this.appendFile(toolName, sb.toString());
    }
}

